/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Heartbeat;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.catalina.tribes.membership.MembershipProviderBase;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipService;
import org.apache.catalina.tribes.membership.cloud.StreamProvider;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class CloudMembershipProvider
extends MembershipProviderBase
implements Heartbeat,
ChannelListener {
    private static final Log log = LogFactory.getLog(CloudMembershipProvider.class);
    protected static final StringManager sm = StringManager.getManager(CloudMembershipProvider.class);
    protected static final String CUSTOM_ENV_PREFIX = "OPENSHIFT_KUBE_PING_";
    protected String url;
    protected StreamProvider streamProvider;
    protected int connectionTimeout;
    protected int readTimeout;
    protected Instant startTime;
    protected MessageDigest md5;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected String localIp;
    protected int port;
    protected long expirationTime = 5000L;

    public CloudMembershipProvider() {
        try {
            this.md5 = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected static String getEnv(String ... stringArray) {
        String string;
        String string2 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n && (string2 = AccessController.doPrivileged(() -> CloudMembershipProvider.lambda$getEnv$0(string = stringArray2[i]))) == null; ++i) {
        }
        return string2;
    }

    protected String getNamespace() {
        String string = CloudMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_NAMESPACE", "KUBERNETES_NAMESPACE");
        if (string == null || string.length() == 0) {
            log.warn((Object)sm.getString("kubernetesMembershipProvider.noNamespace"));
            string = "tomcat";
        }
        return string;
    }

    @Override
    public void init(Properties properties) throws IOException {
        this.startTime = Instant.now();
        CloudMembershipService cloudMembershipService = (CloudMembershipService)this.service;
        this.connectionTimeout = cloudMembershipService.getConnectTimeout();
        this.readTimeout = cloudMembershipService.getReadTimeout();
        this.expirationTime = cloudMembershipService.getExpirationTime();
        this.localIp = InetAddress.getLocalHost().getHostAddress();
        this.port = Integer.parseInt(properties.getProperty("tcpListenPort"));
    }

    @Override
    public void start(int n) throws Exception {
        if (this.membership == null) {
            this.membership = new Membership(this.service.getLocalMember(true));
        }
        this.service.getChannel().addChannelListener(this);
    }

    @Override
    public boolean stop(int n) throws Exception {
        return true;
    }

    @Override
    public void heartbeat() {
        Member[] memberArray;
        Member[] memberArray2 = memberArray = this.fetchMembers();
        int n = memberArray2.length;
        for (int i = 0; i < n; ++i) {
            Member member = memberArray2[i];
            this.updateMember(member, true);
        }
        for (Member member : memberArray2 = this.membership.expire(this.expirationTime)) {
            this.updateMember(member, false);
        }
    }

    protected abstract Member[] fetchMembers();

    protected void updateMember(Member member, boolean bl) {
        Object object;
        if (bl && !this.membership.memberAlive(member)) {
            return;
        }
        if (log.isDebugEnabled()) {
            object = bl ? "Member added: " + member : "Member disappeared: " + member;
            log.debug(object);
        }
        object = () -> {
            String string = Thread.currentThread().getName();
            try {
                String string2 = bl ? "CloudMembership-memberAdded" : "CloudMembership-memberDisappeared";
                Thread.currentThread().setName(string2);
                if (bl) {
                    this.membershipListener.memberAdded(member);
                } else {
                    this.membershipListener.memberDisappeared(member);
                }
            }
            finally {
                Thread.currentThread().setName(string);
            }
        };
        this.executor.execute((Runnable)object);
    }

    @Override
    public void messageReceived(Serializable serializable, Member member) {
    }

    @Override
    public boolean accept(Serializable serializable, Member member) {
        return false;
    }

    private static /* synthetic */ String lambda$getEnv$0(String string) {
        return System.getenv(string);
    }
}

