// Generated from libavfilter/opencl/pad.cl
const char *ff_opencl_source_pad =
"#line 1 \"libavfilter/opencl/pad.cl\"\n"
"/*\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE |\n"
"                          CLK_FILTER_NEAREST;\n"
"\n"
"__kernel void pad (\n"
"    __read_only  image2d_t src,\n"
"    __write_only image2d_t dst,\n"
"    float4 color,\n"
"    int2 xy)\n"
"{\n"
"    int2 size_src = get_image_dim(src);\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    int2 src_pos = (int2)(get_global_id(0) - xy.x, get_global_id(1) - xy.y);\n"
"    float4 pixel = loc.x >= size_src.x + xy.x ||\n"
"                   loc.y >= size_src.y + xy.y ||\n"
"                   loc.x < xy.x ||\n"
"                   loc.y < xy.y ? color : read_imagef(src, sampler, src_pos);\n"
"    write_imagef(dst, loc, pixel);\n"
"}\n"
;
