/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.interceptors;

import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.impl.interceptors.PICurrent;
import com.sun.corba.se.impl.interceptors.SlotTable;
import com.sun.corba.se.impl.logging.InterceptorsSystemException;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.legacy.connection.Connection;
import com.sun.corba.se.spi.legacy.interceptor.RequestInfoExt;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.servicecontext.ServiceContexts;
import com.sun.corba.se.spi.servicecontext.UnknownServiceContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextHelper;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;
import sun.corba.OutputStreamFactory;
import sun.corba.SharedSecrets;

public abstract class RequestInfoImpl
extends LocalObject
implements RequestInfo,
RequestInfoExt {
    protected ORB myORB;
    protected InterceptorsSystemException wrapper;
    protected OMGSystemException stdWrapper;
    protected int flowStackIndex = 0;
    protected int startingPointCall;
    protected int intermediatePointCall;
    protected int endingPointCall;
    protected short replyStatus = (short)-1;
    protected static final short UNINITIALIZED = -1;
    protected int currentExecutionPoint;
    protected static final int EXECUTION_POINT_STARTING = 0;
    protected static final int EXECUTION_POINT_INTERMEDIATE = 1;
    protected static final int EXECUTION_POINT_ENDING = 2;
    protected boolean alreadyExecuted;
    protected Connection connection;
    protected ServiceContexts serviceContexts;
    protected ForwardRequest forwardRequest;
    protected IOR forwardRequestIOR;
    protected SlotTable slotTable;
    protected Exception exception;
    protected static final int MID_REQUEST_ID = 0;
    protected static final int MID_OPERATION = 1;
    protected static final int MID_ARGUMENTS = 2;
    protected static final int MID_EXCEPTIONS = 3;
    protected static final int MID_CONTEXTS = 4;
    protected static final int MID_OPERATION_CONTEXT = 5;
    protected static final int MID_RESULT = 6;
    protected static final int MID_RESPONSE_EXPECTED = 7;
    protected static final int MID_SYNC_SCOPE = 8;
    protected static final int MID_REPLY_STATUS = 9;
    protected static final int MID_FORWARD_REFERENCE = 10;
    protected static final int MID_GET_SLOT = 11;
    protected static final int MID_GET_REQUEST_SERVICE_CONTEXT = 12;
    protected static final int MID_GET_REPLY_SERVICE_CONTEXT = 13;
    protected static final int MID_RI_LAST = 13;

    void reset() {
        this.flowStackIndex = 0;
        this.startingPointCall = 0;
        this.intermediatePointCall = 0;
        this.endingPointCall = 0;
        this.setReplyStatus((short)-1);
        this.currentExecutionPoint = 0;
        this.alreadyExecuted = false;
        this.connection = null;
        this.serviceContexts = null;
        this.forwardRequest = null;
        this.forwardRequestIOR = null;
        this.exception = null;
    }

    public RequestInfoImpl(ORB myORB) {
        this.myORB = myORB;
        this.wrapper = InterceptorsSystemException.get(myORB, "rpc.protocol");
        this.stdWrapper = OMGSystemException.get(myORB, "rpc.protocol");
        PICurrent current = (PICurrent)myORB.getPIHandler().getPICurrent();
        this.slotTable = current.getSlotTable();
    }

    @Override
    public abstract int request_id();

    @Override
    public abstract String operation();

    @Override
    public abstract Parameter[] arguments();

    @Override
    public abstract TypeCode[] exceptions();

    @Override
    public abstract String[] contexts();

    @Override
    public abstract String[] operation_context();

    @Override
    public abstract Any result();

    @Override
    public abstract boolean response_expected();

    @Override
    public short sync_scope() {
        this.checkAccess(8);
        return 1;
    }

    @Override
    public short reply_status() {
        this.checkAccess(9);
        return this.replyStatus;
    }

    @Override
    public abstract Object forward_reference();

    @Override
    public Any get_slot(int id) throws InvalidSlot {
        return this.slotTable.get_slot(id);
    }

    @Override
    public abstract ServiceContext get_request_service_context(int var1);

    @Override
    public abstract ServiceContext get_reply_service_context(int var1);

    @Override
    public Connection connection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertApplicationException(ApplicationException appException, Any result) throws UNKNOWN {
        try {
            RepositoryId repId = RepositoryId.cache.getId(appException.getId());
            String className = repId.getClassName();
            String helperClassName = className + "Helper";
            Class<?> helperClass = SharedSecrets.getJavaCorbaAccess().loadClass(helperClassName);
            Class[] readParams = new Class[]{org.omg.CORBA.portable.InputStream.class};
            Method readMethod = helperClass.getMethod("read", readParams);
            org.omg.CORBA.portable.InputStream ueInputStream = appException.getInputStream();
            ueInputStream.mark(0);
            UserException userException = null;
            try {
                java.lang.Object[] readArguments = new java.lang.Object[]{ueInputStream};
                userException = (UserException)readMethod.invoke(null, readArguments);
            }
            finally {
                try {
                    ueInputStream.reset();
                }
                catch (IOException e) {
                    throw this.wrapper.markAndResetFailed(e);
                }
            }
            this.insertUserException(userException, result);
        }
        catch (ClassNotFoundException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (NoSuchMethodException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (SecurityException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (IllegalAccessException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (IllegalArgumentException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (InvocationTargetException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
    }

    private void insertUserException(UserException userException, Any result) throws UNKNOWN {
        try {
            if (userException != null) {
                Class<?> exceptionClass = userException.getClass();
                String className = exceptionClass.getName();
                String helperClassName = className + "Helper";
                Class<?> helperClass = SharedSecrets.getJavaCorbaAccess().loadClass(helperClassName);
                Class[] insertMethodParams = new Class[]{Any.class, exceptionClass};
                Method insertMethod = helperClass.getMethod("insert", insertMethodParams);
                java.lang.Object[] insertMethodArguments = new java.lang.Object[]{result, userException};
                insertMethod.invoke(null, insertMethodArguments);
            }
        }
        catch (ClassNotFoundException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (NoSuchMethodException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (SecurityException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (IllegalAccessException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (IllegalArgumentException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
        catch (InvocationTargetException e) {
            throw this.stdWrapper.unknownUserException(CompletionStatus.COMPLETED_MAYBE, e);
        }
    }

    protected Parameter[] nvListToParameterArray(NVList parNVList) {
        int count = parNVList.count();
        Parameter[] plist = new Parameter[count];
        try {
            for (int i = 0; i < count; ++i) {
                Parameter p;
                plist[i] = p = new Parameter();
                NamedValue nv = parNVList.item(i);
                plist[i].argument = nv.value();
                plist[i].mode = ParameterMode.from_int(nv.flags() - 1);
            }
        }
        catch (Exception e) {
            throw this.wrapper.exceptionInArguments(e);
        }
        return plist;
    }

    protected Any exceptionToAny(Exception exception) {
        Any result = this.myORB.create_any();
        if (exception == null) {
            throw this.wrapper.exceptionWasNull2();
        }
        if (exception instanceof SystemException) {
            ORBUtility.insertSystemException((SystemException)exception, result);
        } else if (exception instanceof ApplicationException) {
            try {
                ApplicationException appException = (ApplicationException)exception;
                this.insertApplicationException(appException, result);
            }
            catch (UNKNOWN e) {
                ORBUtility.insertSystemException(e, result);
            }
        } else if (exception instanceof UserException) {
            try {
                UserException userException = (UserException)exception;
                this.insertUserException(userException, result);
            }
            catch (UNKNOWN e) {
                ORBUtility.insertSystemException(e, result);
            }
        }
        return result;
    }

    protected ServiceContext getServiceContext(HashMap cachedServiceContexts, ServiceContexts serviceContexts, int id) {
        ServiceContext result = null;
        Integer integerId = new Integer(id);
        result = (ServiceContext)cachedServiceContexts.get(integerId);
        if (result == null) {
            com.sun.corba.se.spi.servicecontext.ServiceContext context = serviceContexts.get(id);
            if (context == null) {
                throw this.stdWrapper.invalidServiceContextId();
            }
            EncapsOutputStream out = OutputStreamFactory.newEncapsOutputStream(this.myORB);
            context.write(out, GIOPVersion.V1_2);
            org.omg.CORBA.portable.InputStream inputStream = out.create_input_stream();
            result = ServiceContextHelper.read(inputStream);
            cachedServiceContexts.put(integerId, result);
        }
        return result;
    }

    protected void addServiceContext(HashMap cachedServiceContexts, ServiceContexts serviceContexts, ServiceContext service_context, boolean replace) {
        int id = 0;
        EncapsOutputStream outputStream = OutputStreamFactory.newEncapsOutputStream(this.myORB);
        org.omg.CORBA.portable.InputStream inputStream = null;
        UnknownServiceContext coreServiceContext = null;
        ServiceContextHelper.write(outputStream, service_context);
        inputStream = outputStream.create_input_stream();
        coreServiceContext = new UnknownServiceContext(inputStream.read_long(), (InputStream)inputStream);
        id = coreServiceContext.getId();
        if (serviceContexts.get(id) != null) {
            if (replace) {
                serviceContexts.delete(id);
            } else {
                throw this.stdWrapper.serviceContextAddFailed(new Integer(id));
            }
        }
        serviceContexts.put(coreServiceContext);
        cachedServiceContexts.put(new Integer(id), service_context);
    }

    protected void setFlowStackIndex(int num) {
        this.flowStackIndex = num;
    }

    protected int getFlowStackIndex() {
        return this.flowStackIndex;
    }

    protected void setEndingPointCall(int call) {
        this.endingPointCall = call;
    }

    protected int getEndingPointCall() {
        return this.endingPointCall;
    }

    protected void setIntermediatePointCall(int call) {
        this.intermediatePointCall = call;
    }

    protected int getIntermediatePointCall() {
        return this.intermediatePointCall;
    }

    protected void setStartingPointCall(int call) {
        this.startingPointCall = call;
    }

    protected int getStartingPointCall() {
        return this.startingPointCall;
    }

    protected boolean getAlreadyExecuted() {
        return this.alreadyExecuted;
    }

    protected void setAlreadyExecuted(boolean alreadyExecuted) {
        this.alreadyExecuted = alreadyExecuted;
    }

    protected void setReplyStatus(short replyStatus) {
        this.replyStatus = replyStatus;
    }

    protected short getReplyStatus() {
        return this.replyStatus;
    }

    protected void setForwardRequest(ForwardRequest forwardRequest) {
        this.forwardRequest = forwardRequest;
        this.forwardRequestIOR = null;
    }

    protected void setForwardRequest(IOR ior) {
        this.forwardRequestIOR = ior;
        this.forwardRequest = null;
    }

    protected ForwardRequest getForwardRequestException() {
        if (this.forwardRequest == null && this.forwardRequestIOR != null) {
            Object obj = this.iorToObject(this.forwardRequestIOR);
            this.forwardRequest = new ForwardRequest(obj);
        }
        return this.forwardRequest;
    }

    protected IOR getForwardRequestIOR() {
        if (this.forwardRequestIOR == null && this.forwardRequest != null) {
            this.forwardRequestIOR = ORBUtility.getIOR(this.forwardRequest.forward);
        }
        return this.forwardRequestIOR;
    }

    protected void setException(Exception exception) {
        this.exception = exception;
    }

    Exception getException() {
        return this.exception;
    }

    protected void setCurrentExecutionPoint(int executionPoint) {
        this.currentExecutionPoint = executionPoint;
    }

    protected abstract void checkAccess(int var1) throws BAD_INV_ORDER;

    void setSlotTable(SlotTable slotTable) {
        this.slotTable = slotTable;
    }

    protected Object iorToObject(IOR ior) {
        return ORBUtility.makeObjectReference(ior);
    }
}

