/* timer-face.c generated by valac 0.56.3, the Vala compiler
 * generated from timer-face.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Bilal Elmoussaoui <bilal.elmoussaoui@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;
typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())
typedef enum  {
	CLOCKS_BUTTON_MODE_NEW,
	CLOCKS_BUTTON_MODE_NONE
} ClocksButtonMode;

#define CLOCKS_TYPE_BUTTON_MODE (clocks_button_mode_get_type ())

#define CLOCKS_TIMER_TYPE_FACE (clocks_timer_face_get_type ())
#define CLOCKS_TIMER_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace))
#define CLOCKS_TIMER_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))
#define CLOCKS_TIMER_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))

typedef struct _ClocksTimerFace ClocksTimerFace;
typedef struct _ClocksTimerFaceClass ClocksTimerFaceClass;
typedef struct _ClocksTimerFacePrivate ClocksTimerFacePrivate;

#define CLOCKS_TIMER_TYPE_SETUP (clocks_timer_setup_get_type ())
#define CLOCKS_TIMER_SETUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_SETUP, ClocksTimerSetup))
#define CLOCKS_TIMER_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_SETUP, ClocksTimerSetupClass))
#define CLOCKS_TIMER_IS_SETUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_SETUP))
#define CLOCKS_TIMER_IS_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_SETUP))
#define CLOCKS_TIMER_SETUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_SETUP, ClocksTimerSetupClass))

typedef struct _ClocksTimerSetup ClocksTimerSetup;
typedef struct _ClocksTimerSetupClass ClocksTimerSetupClass;

#define CLOCKS_TYPE_CONTENT_STORE (clocks_content_store_get_type ())
#define CLOCKS_CONTENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStore))
#define CLOCKS_CONTENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStoreClass))
#define CLOCKS_IS_CONTENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_STORE))
#define CLOCKS_IS_CONTENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_STORE))
#define CLOCKS_CONTENT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStoreClass))

typedef struct _ClocksContentStore ClocksContentStore;
typedef struct _ClocksContentStoreClass ClocksContentStoreClass;

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
enum  {
	CLOCKS_TIMER_FACE_0_PROPERTY,
	CLOCKS_TIMER_FACE_PANEL_ID_PROPERTY,
	CLOCKS_TIMER_FACE_BUTTON_MODE_PROPERTY,
	CLOCKS_TIMER_FACE_IS_RUNNING_PROPERTY,
	CLOCKS_TIMER_FACE_NEW_LABEL_PROPERTY,
	CLOCKS_TIMER_FACE_NUM_PROPERTIES
};
static GParamSpec* clocks_timer_face_properties[CLOCKS_TIMER_FACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;
typedef void (*ClocksContentStoreForeachFunc) (ClocksContentItem* item, gpointer user_data);

#define CLOCKS_TIMER_TYPE_ITEM (clocks_timer_item_get_type ())
#define CLOCKS_TIMER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem))
#define CLOCKS_TIMER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItemClass))
#define CLOCKS_TIMER_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_ITEM))
#define CLOCKS_TIMER_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_ITEM))
#define CLOCKS_TIMER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItemClass))

typedef struct _ClocksTimerItem ClocksTimerItem;
typedef struct _ClocksTimerItemClass ClocksTimerItemClass;
typedef enum  {
	CLOCKS_TIMER_ITEM_STATE_STOPPED,
	CLOCKS_TIMER_ITEM_STATE_RUNNING,
	CLOCKS_TIMER_ITEM_STATE_PAUSED
} ClocksTimerItemState;

#define CLOCKS_TIMER_ITEM_TYPE_STATE (clocks_timer_item_state_get_type ())

#define CLOCKS_TIMER_TYPE_SETUP_DIALOG (clocks_timer_setup_dialog_get_type ())
#define CLOCKS_TIMER_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_SETUP_DIALOG, ClocksTimerSetupDialog))
#define CLOCKS_TIMER_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_SETUP_DIALOG, ClocksTimerSetupDialogClass))
#define CLOCKS_TIMER_IS_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_SETUP_DIALOG))
#define CLOCKS_TIMER_IS_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_SETUP_DIALOG))
#define CLOCKS_TIMER_SETUP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_SETUP_DIALOG, ClocksTimerSetupDialogClass))

typedef struct _ClocksTimerSetupDialog ClocksTimerSetupDialog;
typedef struct _ClocksTimerSetupDialogClass ClocksTimerSetupDialogClass;
typedef struct _ClocksTimerSetupDialogPrivate ClocksTimerSetupDialogPrivate;
typedef ClocksContentItem* (*ClocksContentStoreDeserializeItemFunc) (GVariant* v, gpointer user_data);
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

#define CLOCKS_TYPE_APPLICATION (clocks_application_get_type ())
#define CLOCKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplication))
#define CLOCKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))
#define CLOCKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))

typedef struct _ClocksApplication ClocksApplication;
typedef struct _ClocksApplicationClass ClocksApplicationClass;
typedef struct _Block7Data Block7Data;

#define CLOCKS_TIMER_TYPE_ROW (clocks_timer_row_get_type ())
#define CLOCKS_TIMER_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_ROW, ClocksTimerRow))
#define CLOCKS_TIMER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_ROW, ClocksTimerRowClass))
#define CLOCKS_TIMER_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_ROW))
#define CLOCKS_TIMER_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_ROW))
#define CLOCKS_TIMER_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_ROW, ClocksTimerRowClass))

typedef struct _ClocksTimerRow ClocksTimerRow;
typedef struct _ClocksTimerRowClass ClocksTimerRowClass;
enum  {
	CLOCKS_TIMER_FACE_RING_SIGNAL,
	CLOCKS_TIMER_FACE_NUM_SIGNALS
};
static guint clocks_timer_face_signals[CLOCKS_TIMER_FACE_NUM_SIGNALS] = {0};

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
	ClocksButtonMode (*get_button_mode) (ClocksClock* self);
	void (*set_button_mode) (ClocksClock* self, ClocksButtonMode value);
	const gchar* (*get_new_label) (ClocksClock* self);
};

struct _ClocksTimerFace {
	AdwBin parent_instance;
	ClocksTimerFacePrivate * priv;
};

struct _ClocksTimerFaceClass {
	AdwBinClass parent_class;
	void (*ring) (ClocksTimerFace* self);
};

struct _ClocksTimerFacePrivate {
	ClocksTimerSetup* timer_setup;
	GtkListBox* timers_list;
	GtkBox* no_timer_container;
	GtkButton* start_button;
	GtkStack* stack;
	ClocksPanelId _panel_id;
	ClocksButtonMode _button_mode;
	gboolean _is_running;
	gchar* _new_label;
	ClocksContentStore* timers;
	GSettings* settings;
	ClocksUtilsBell* bell;
	GNotification* notification;
};

struct _Block5Data {
	int _ref_count_;
	ClocksTimerFace* self;
	gint total_items;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksTimerSetupDialog {
	GtkDialog parent_instance;
	ClocksTimerSetupDialogPrivate * priv;
	ClocksTimerSetup* timer_setup;
};

struct _ClocksTimerSetupDialogClass {
	GtkDialogClass parent_class;
};

struct _Block6Data {
	int _ref_count_;
	ClocksTimerFace* self;
	gboolean res;
};

struct _Block7Data {
	int _ref_count_;
	ClocksTimerFace* self;
	GObject* timer;
};

static gint ClocksTimerFace_private_offset;
static gpointer clocks_timer_face_parent_class = NULL;
static ClocksClockIface * clocks_timer_face_clocks_clock_parent_iface = NULL;

VALA_EXTERN GType clocks_panel_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksClock, g_object_unref)
VALA_EXTERN GType clocks_timer_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerFace, g_object_unref)
VALA_EXTERN GType clocks_timer_setup_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerSetup, g_object_unref)
VALA_EXTERN GType clocks_content_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentStore, g_object_unref)
VALA_EXTERN GType clocks_utils_bell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsBell, g_object_unref)
static gint clocks_timer_face_get_total_active_timers (ClocksTimerFace* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN void clocks_content_store_foreach (ClocksContentStore* self,
                                   ClocksContentStoreForeachFunc func,
                                   gpointer func_target);
static void __lambda31_ (Block5Data* _data5_,
                  ClocksContentItem* timer);
VALA_EXTERN GType clocks_timer_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerItem, g_object_unref)
VALA_EXTERN GType clocks_timer_item_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClocksTimerItemState clocks_timer_item_get_state (ClocksTimerItem* self);
static void ___lambda31__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                     gpointer self);
static void clocks_timer_face_remove_timer (ClocksTimerFace* self,
                                     ClocksTimerItem* item);
VALA_EXTERN void clocks_content_store_remove (ClocksContentStore* self,
                                  ClocksContentItem* item);
static void clocks_timer_face_real_activate_new (ClocksClock* base);
VALA_EXTERN GType clocks_timer_setup_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerSetupDialog, g_object_unref)
VALA_EXTERN ClocksTimerSetupDialog* clocks_timer_setup_dialog_new (GtkWindow* parent);
VALA_EXTERN ClocksTimerSetupDialog* clocks_timer_setup_dialog_construct (GType object_type,
                                                             GtkWindow* parent);
static void __lambda33_ (ClocksTimerFace* self,
                  GtkDialog* dialog,
                  gint response);
VALA_EXTERN ClocksTimerItem* clocks_timer_setup_get_timer (ClocksTimerSetup* self);
VALA_EXTERN void clocks_content_store_add (ClocksContentStore* self,
                               ClocksContentItem* item);
static void ___lambda33__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void clocks_timer_face_load (ClocksTimerFace* self);
VALA_EXTERN void clocks_content_store_deserialize (ClocksContentStore* self,
                                       GVariant* variant,
                                       ClocksContentStoreDeserializeItemFunc deserialize_item,
                                       gpointer deserialize_item_target);
VALA_EXTERN ClocksTimerItem* clocks_timer_item_deserialize (GVariant* time_variant);
static ClocksContentItem* _clocks_timer_item_deserialize_clocks_content_store_deserialize_item_func (GVariant* v,
                                                                                              gpointer self);
static void clocks_timer_face_save (ClocksTimerFace* self);
VALA_EXTERN GVariant* clocks_content_store_serialize (ClocksContentStore* self);
static gboolean clocks_timer_face_real_grab_focus (GtkWidget* base);
static gboolean clocks_timer_face_real_escape_pressed (ClocksClock* base);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda34_ (Block6Data* _data6_,
                  ClocksContentItem* item);
static void ___lambda34__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                     gpointer self);
VALA_EXTERN ClocksTimerFace* clocks_timer_face_new (void);
VALA_EXTERN ClocksTimerFace* clocks_timer_face_construct (GType object_type);
VALA_EXTERN gboolean clocks_timer_face_get_is_running (ClocksTimerFace* self);
VALA_EXTERN void clocks_timer_face_set_is_running (ClocksTimerFace* self,
                                       gboolean value);
static void clocks_timer_face_real_ring (ClocksTimerFace* self);
VALA_EXTERN GType clocks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksApplication, g_object_unref)
VALA_EXTERN void clocks_application_send_notification (ClocksApplication* self,
                                           const gchar* notification_id,
                                           GNotification* notification);
VALA_EXTERN void clocks_utils_bell_ring_once (ClocksUtilsBell* self);
static GObject * clocks_timer_face_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN void clocks_clock_set_panel_id (ClocksClock* self,
                                ClocksPanelId value);
VALA_EXTERN ClocksTimerSetup* clocks_timer_setup_new (void);
VALA_EXTERN ClocksTimerSetup* clocks_timer_setup_construct (GType object_type);
VALA_EXTERN ClocksContentStore* clocks_content_store_new (void);
VALA_EXTERN ClocksContentStore* clocks_content_store_construct (GType object_type);
static GtkWidget* _clocks_timer_face___lambda35_ (ClocksTimerFace* self,
                                           GObject* timer);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
VALA_EXTERN GType clocks_timer_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerRow, g_object_unref)
VALA_EXTERN ClocksTimerRow* clocks_timer_row_new (ClocksTimerItem* item);
VALA_EXTERN ClocksTimerRow* clocks_timer_row_construct (GType object_type,
                                            ClocksTimerItem* item);
static void __lambda42_ (Block7Data* _data7_);
static void ___lambda42__clocks_timer_row_deleted (ClocksTimerRow* _sender,
                                            gpointer self);
static void __lambda43_ (ClocksTimerFace* self);
static void ___lambda43__clocks_timer_row_edited (ClocksTimerRow* _sender,
                                           gpointer self);
static void __lambda44_ (ClocksTimerFace* self);
static void ___lambda44__clocks_timer_item_ring (ClocksTimerItem* _sender,
                                          gpointer self);
static void __lambda45_ (ClocksTimerFace* self);
static void ___lambda45__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static GtkWidget* __clocks_timer_face___lambda35__gtk_list_box_create_widget_func (GObject* item,
                                                                            gpointer self);
static void _clocks_timer_face___lambda46_ (ClocksTimerFace* self,
                                     guint added,
                                     guint removed,
                                     guint position);
VALA_EXTERN void clocks_clock_set_button_mode (ClocksClock* self,
                                   ClocksButtonMode value);
static void __clocks_timer_face___lambda46__g_list_model_items_changed (GListModel* _sender,
                                                                 guint position,
                                                                 guint removed,
                                                                 guint added,
                                                                 gpointer self);
VALA_EXTERN ClocksUtilsBell* clocks_utils_bell_new (const gchar* soundid);
VALA_EXTERN ClocksUtilsBell* clocks_utils_bell_construct (GType object_type,
                                              const gchar* soundid);
static void _clocks_timer_face___lambda47_ (ClocksTimerFace* self,
                                     gint duration);
static void __clocks_timer_face___lambda47__clocks_timer_setup_duration_changed (ClocksTimerSetup* _sender,
                                                                          gint seconds,
                                                                          gpointer self);
static void _clocks_timer_face___lambda48_ (ClocksTimerFace* self);
static void __clocks_timer_face___lambda48__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self);
VALA_EXTERN void clocks_clock_activate_new (ClocksClock* self);
VALA_EXTERN gboolean clocks_clock_escape_pressed (ClocksClock* self);
VALA_EXTERN ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
VALA_EXTERN ClocksButtonMode clocks_clock_get_button_mode (ClocksClock* self);
VALA_EXTERN const gchar* clocks_clock_get_new_label (ClocksClock* self);
static void clocks_timer_face_finalize (GObject * obj);
static GType clocks_timer_face_get_type_once (void);
static void _vala_clocks_timer_face_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_clocks_timer_face_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
clocks_timer_face_get_instance_private (ClocksTimerFace* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksTimerFace_private_offset);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ClocksTimerFace* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda31_ (Block5Data* _data5_,
             ClocksContentItem* timer)
{
	ClocksTimerFace* self;
	ClocksTimerItemState _tmp0_;
	ClocksTimerItemState _tmp1_;
	self = _data5_->self;
	g_return_if_fail (timer != NULL);
	_tmp0_ = clocks_timer_item_get_state (G_TYPE_CHECK_INSTANCE_CAST (timer, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem));
	_tmp1_ = _tmp0_;
	if (_tmp1_ == CLOCKS_TIMER_ITEM_STATE_RUNNING) {
		_data5_->total_items += 1;
	}
}

static void
___lambda31__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                gpointer self)
{
	__lambda31_ (self, item);
}

static gint
clocks_timer_face_get_total_active_timers (ClocksTimerFace* self)
{
	Block5Data* _data5_;
	ClocksContentStore* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->total_items = 0;
	_tmp0_ = self->priv->timers;
	clocks_content_store_foreach (_tmp0_, ___lambda31__clocks_content_store_foreach_func, _data5_);
	result = _data5_->total_items;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static void
clocks_timer_face_remove_timer (ClocksTimerFace* self,
                                ClocksTimerItem* item)
{
	ClocksContentStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->timers;
	clocks_content_store_remove (_tmp0_, (ClocksContentItem*) item);
}

static void
__lambda33_ (ClocksTimerFace* self,
             GtkDialog* dialog,
             gint response)
{
	g_return_if_fail (dialog != NULL);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		ClocksTimerItem* timer = NULL;
		ClocksTimerSetup* _tmp0_;
		ClocksTimerItem* _tmp1_;
		ClocksContentStore* _tmp2_;
		ClocksTimerItem* _tmp3_;
		ClocksTimerItem* _tmp4_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (dialog, CLOCKS_TIMER_TYPE_SETUP_DIALOG, ClocksTimerSetupDialog)->timer_setup;
		_tmp1_ = clocks_timer_setup_get_timer (_tmp0_);
		timer = _tmp1_;
		_tmp2_ = self->priv->timers;
		_tmp3_ = timer;
		clocks_content_store_add (_tmp2_, (ClocksContentItem*) _tmp3_);
		_tmp4_ = timer;
		g_signal_emit_by_name (_tmp4_, "start");
		_g_object_unref0 (timer);
	}
	gtk_window_destroy ((GtkWindow*) dialog);
}

static void
___lambda33__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda33_ ((ClocksTimerFace*) self, _sender, response_id);
}

static void
clocks_timer_face_real_activate_new (ClocksClock* base)
{
	ClocksTimerFace * self;
	ClocksTimerSetupDialog* dialog = NULL;
	GtkRoot* _tmp0_;
	ClocksTimerSetupDialog* _tmp1_;
	self = (ClocksTimerFace*) base;
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = clocks_timer_setup_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	g_signal_connect_object ((GtkDialog*) dialog, "response", (GCallback) ___lambda33__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

static ClocksContentItem*
_clocks_timer_item_deserialize_clocks_content_store_deserialize_item_func (GVariant* v,
                                                                           gpointer self)
{
	ClocksContentItem* result;
	result = clocks_timer_item_deserialize (v);
	return result;
}

static void
clocks_timer_face_load (ClocksTimerFace* self)
{
	ClocksContentStore* _tmp0_;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timers;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "timers");
	_tmp3_ = _tmp2_;
	clocks_content_store_deserialize (_tmp0_, _tmp3_, _clocks_timer_item_deserialize_clocks_content_store_deserialize_item_func, NULL);
	_g_variant_unref0 (_tmp3_);
}

static void
clocks_timer_face_save (ClocksTimerFace* self)
{
	GSettings* _tmp0_;
	ClocksContentStore* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->timers;
	_tmp2_ = clocks_content_store_serialize (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_value (_tmp0_, "timers", _tmp3_);
	_g_variant_unref0 (_tmp3_);
}

static gboolean
clocks_timer_face_real_grab_focus (GtkWidget* base)
{
	ClocksTimerFace * self;
	ClocksContentStore* _tmp0_;
	gboolean result;
	self = (ClocksTimerFace*) base;
	_tmp0_ = self->priv->timers;
	if (g_list_model_get_n_items ((GListModel*) _tmp0_) == ((guint) 0)) {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->start_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ClocksTimerFace* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda34_ (Block6Data* _data6_,
             ClocksContentItem* item)
{
	ClocksTimerFace* self;
	ClocksTimerItem* timer = NULL;
	ClocksTimerItem* _tmp0_;
	ClocksTimerItem* _tmp1_;
	ClocksTimerItemState _tmp2_;
	ClocksTimerItemState _tmp3_;
	self = _data6_->self;
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem));
	timer = _tmp0_;
	_tmp1_ = timer;
	_tmp2_ = clocks_timer_item_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == CLOCKS_TIMER_ITEM_STATE_RUNNING) {
		ClocksTimerItem* _tmp4_;
		_tmp4_ = timer;
		g_signal_emit_by_name (_tmp4_, "pause");
		_data6_->res = TRUE;
	}
	_g_object_unref0 (timer);
}

static void
___lambda34__clocks_content_store_foreach_func (ClocksContentItem* item,
                                                gpointer self)
{
	__lambda34_ (self, item);
}

static gboolean
clocks_timer_face_real_escape_pressed (ClocksClock* base)
{
	ClocksTimerFace * self;
	Block6Data* _data6_;
	ClocksContentStore* _tmp0_;
	gboolean result;
	self = (ClocksTimerFace*) base;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->res = FALSE;
	_tmp0_ = self->priv->timers;
	clocks_content_store_foreach (_tmp0_, ___lambda34__clocks_content_store_foreach_func, _data6_);
	result = _data6_->res;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}

ClocksTimerFace*
clocks_timer_face_construct (GType object_type)
{
	ClocksTimerFace * self = NULL;
	self = (ClocksTimerFace*) g_object_new (object_type, NULL);
	return self;
}

ClocksTimerFace*
clocks_timer_face_new (void)
{
	return clocks_timer_face_construct (CLOCKS_TIMER_TYPE_FACE);
}

static ClocksPanelId
clocks_timer_face_real_get_panel_id (ClocksClock* base)
{
	ClocksPanelId result;
	ClocksTimerFace* self;
	self = (ClocksTimerFace*) base;
	result = self->priv->_panel_id;
	return result;
}

static void
clocks_timer_face_real_set_panel_id (ClocksClock* base,
                                     ClocksPanelId value)
{
	ClocksTimerFace* self;
	ClocksPanelId old_value;
	self = (ClocksTimerFace*) base;
	old_value = clocks_timer_face_real_get_panel_id (base);
	if (old_value != value) {
		self->priv->_panel_id = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_timer_face_properties[CLOCKS_TIMER_FACE_PANEL_ID_PROPERTY]);
	}
}

static ClocksButtonMode
clocks_timer_face_real_get_button_mode (ClocksClock* base)
{
	ClocksButtonMode result;
	ClocksTimerFace* self;
	self = (ClocksTimerFace*) base;
	result = self->priv->_button_mode;
	return result;
}

static void
clocks_timer_face_real_set_button_mode (ClocksClock* base,
                                        ClocksButtonMode value)
{
	ClocksTimerFace* self;
	ClocksButtonMode old_value;
	self = (ClocksTimerFace*) base;
	old_value = clocks_timer_face_real_get_button_mode (base);
	if (old_value != value) {
		self->priv->_button_mode = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_timer_face_properties[CLOCKS_TIMER_FACE_BUTTON_MODE_PROPERTY]);
	}
}

gboolean
clocks_timer_face_get_is_running (ClocksTimerFace* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_running;
	return result;
}

void
clocks_timer_face_set_is_running (ClocksTimerFace* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_timer_face_get_is_running (self);
	if (old_value != value) {
		self->priv->_is_running = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_timer_face_properties[CLOCKS_TIMER_FACE_IS_RUNNING_PROPERTY]);
	}
}

static const gchar*
clocks_timer_face_real_get_new_label (ClocksClock* base)
{
	const gchar* result;
	ClocksTimerFace* self;
	const gchar* _tmp0_;
	self = (ClocksTimerFace*) base;
	_tmp0_ = self->priv->_new_label;
	result = _tmp0_;
	return result;
}

static void
clocks_timer_face_real_ring (ClocksTimerFace* self)
{
	ClocksApplication* app = NULL;
	GApplication* _tmp0_;
	ClocksApplication* _tmp1_;
	GNotification* _tmp2_;
	ClocksUtilsBell* _tmp3_;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_TYPE_APPLICATION, ClocksApplication));
	app = _tmp1_;
	_tmp2_ = self->priv->notification;
	clocks_application_send_notification (app, "timer-is-up", _tmp2_);
	_tmp3_ = self->priv->bell;
	clocks_utils_bell_ring_once (_tmp3_);
	_g_object_unref0 (app);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ClocksTimerFace* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->timer);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda42_ (Block7Data* _data7_)
{
	ClocksTimerFace* self;
	self = _data7_->self;
	clocks_timer_face_remove_timer (self, G_TYPE_CHECK_INSTANCE_CAST (_data7_->timer, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem));
}

static void
___lambda42__clocks_timer_row_deleted (ClocksTimerRow* _sender,
                                       gpointer self)
{
	__lambda42_ (self);
}

static void
__lambda43_ (ClocksTimerFace* self)
{
	clocks_timer_face_save (self);
}

static void
___lambda43__clocks_timer_row_edited (ClocksTimerRow* _sender,
                                      gpointer self)
{
	__lambda43_ ((ClocksTimerFace*) self);
}

static void
__lambda44_ (ClocksTimerFace* self)
{
	g_signal_emit (self, clocks_timer_face_signals[CLOCKS_TIMER_FACE_RING_SIGNAL], 0);
}

static void
___lambda44__clocks_timer_item_ring (ClocksTimerItem* _sender,
                                     gpointer self)
{
	__lambda44_ ((ClocksTimerFace*) self);
}

static void
__lambda45_ (ClocksTimerFace* self)
{
	clocks_timer_face_set_is_running (self, clocks_timer_face_get_total_active_timers (self) != 0);
}

static void
___lambda45__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda45_ ((ClocksTimerFace*) self);
}

static GtkWidget*
_clocks_timer_face___lambda35_ (ClocksTimerFace* self,
                                GObject* timer)
{
	Block7Data* _data7_;
	GObject* _tmp0_;
	ClocksTimerRow* row = NULL;
	ClocksTimerRow* _tmp1_;
	ClocksTimerRow* _tmp2_;
	ClocksTimerRow* _tmp3_;
	GtkWidget* result;
	g_return_val_if_fail (timer != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (timer);
	_g_object_unref0 (_data7_->timer);
	_data7_->timer = _tmp0_;
	_tmp1_ = clocks_timer_row_new (G_TYPE_CHECK_INSTANCE_CAST (_data7_->timer, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem));
	g_object_ref_sink (_tmp1_);
	row = _tmp1_;
	_tmp2_ = row;
	g_signal_connect_data (_tmp2_, "deleted", (GCallback) ___lambda42__clocks_timer_row_deleted, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp3_ = row;
	g_signal_connect_object (_tmp3_, "edited", (GCallback) ___lambda43__clocks_timer_row_edited, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_data7_->timer, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem), "ring", (GCallback) ___lambda44__clocks_timer_item_ring, self, 0);
	g_signal_connect_object ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (_data7_->timer, CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem), "notify::state", (GCallback) ___lambda45__g_object_notify, self, 0);
	result = (GtkWidget*) row;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

static GtkWidget*
__clocks_timer_face___lambda35__gtk_list_box_create_widget_func (GObject* item,
                                                                 gpointer self)
{
	GtkWidget* result;
	result = _clocks_timer_face___lambda35_ ((ClocksTimerFace*) self, item);
	return result;
}

static void
_clocks_timer_face___lambda46_ (ClocksTimerFace* self,
                                guint added,
                                guint removed,
                                guint position)
{
	ClocksContentStore* _tmp0_;
	_tmp0_ = self->priv->timers;
	if (g_list_model_get_n_items ((GListModel*) _tmp0_) > ((guint) 0)) {
		GtkStack* _tmp1_;
		_tmp1_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp1_, "timers");
		clocks_clock_set_button_mode ((ClocksClock*) self, CLOCKS_BUTTON_MODE_NEW);
	} else {
		GtkStack* _tmp2_;
		_tmp2_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp2_, "empty");
		clocks_clock_set_button_mode ((ClocksClock*) self, CLOCKS_BUTTON_MODE_NONE);
	}
	clocks_timer_face_save (self);
}

static void
__clocks_timer_face___lambda46__g_list_model_items_changed (GListModel* _sender,
                                                            guint position,
                                                            guint removed,
                                                            guint added,
                                                            gpointer self)
{
	_clocks_timer_face___lambda46_ ((ClocksTimerFace*) self, position, removed, added);
}

static void
_clocks_timer_face___lambda47_ (ClocksTimerFace* self,
                                gint duration)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->start_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, duration != 0);
}

static void
__clocks_timer_face___lambda47__clocks_timer_setup_duration_changed (ClocksTimerSetup* _sender,
                                                                     gint seconds,
                                                                     gpointer self)
{
	_clocks_timer_face___lambda47_ ((ClocksTimerFace*) self, seconds);
}

static void
_clocks_timer_face___lambda48_ (ClocksTimerFace* self)
{
	ClocksTimerItem* timer = NULL;
	ClocksTimerSetup* _tmp0_;
	ClocksTimerItem* _tmp1_;
	ClocksContentStore* _tmp2_;
	ClocksTimerItem* _tmp3_;
	ClocksTimerItem* _tmp4_;
	_tmp0_ = self->priv->timer_setup;
	_tmp1_ = clocks_timer_setup_get_timer (_tmp0_);
	timer = _tmp1_;
	_tmp2_ = self->priv->timers;
	_tmp3_ = timer;
	clocks_content_store_add (_tmp2_, (ClocksContentItem*) _tmp3_);
	_tmp4_ = timer;
	g_signal_emit_by_name (_tmp4_, "start");
	_g_object_unref0 (timer);
}

static void
__clocks_timer_face___lambda48__gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self)
{
	_clocks_timer_face___lambda48_ ((ClocksTimerFace*) self);
}

static GObject *
clocks_timer_face_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClocksTimerFace * self;
	ClocksTimerSetup* _tmp0_;
	GSettings* _tmp1_;
	ClocksContentStore* _tmp2_;
	GtkListBox* _tmp3_;
	ClocksContentStore* _tmp4_;
	ClocksContentStore* _tmp5_;
	ClocksUtilsBell* _tmp6_;
	GNotification* _tmp7_;
	GNotification* _tmp8_;
	GNotification* _tmp9_;
	GtkWidget* no_timer_container_first_child = NULL;
	GtkBox* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkBox* _tmp13_;
	ClocksTimerSetup* _tmp14_;
	GtkWidget* _tmp15_;
	GtkStack* _tmp16_;
	GtkButton* _tmp17_;
	ClocksTimerSetup* _tmp18_;
	GtkButton* _tmp19_;
	parent_class = G_OBJECT_CLASS (clocks_timer_face_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace);
	clocks_clock_set_panel_id ((ClocksClock*) self, CLOCKS_PANEL_ID_TIMER);
	_tmp0_ = clocks_timer_setup_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->timer_setup);
	self->priv->timer_setup = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = clocks_content_store_new ();
	_g_object_unref0 (self->priv->timers);
	self->priv->timers = _tmp2_;
	_tmp3_ = self->priv->timers_list;
	_tmp4_ = self->priv->timers;
	gtk_list_box_bind_model (_tmp3_, (GListModel*) _tmp4_, __clocks_timer_face___lambda35__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp5_ = self->priv->timers;
	g_signal_connect_object ((GListModel*) _tmp5_, "items-changed", (GCallback) __clocks_timer_face___lambda46__g_list_model_items_changed, self, 0);
	_tmp6_ = clocks_utils_bell_new ("complete");
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp6_;
	_tmp7_ = g_notification_new (_ ("Time is up!"));
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = _tmp7_;
	_tmp8_ = self->priv->notification;
	g_notification_set_body (_tmp8_, _ ("Timer countdown finished"));
	_tmp9_ = self->priv->notification;
	g_notification_set_priority (_tmp9_, G_NOTIFICATION_PRIORITY_HIGH);
	_tmp10_ = self->priv->no_timer_container;
	_tmp11_ = gtk_widget_get_first_child ((GtkWidget*) _tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	no_timer_container_first_child = _tmp12_;
	_tmp13_ = self->priv->no_timer_container;
	_tmp14_ = self->priv->timer_setup;
	_tmp15_ = no_timer_container_first_child;
	gtk_box_insert_child_after (_tmp13_, (GtkWidget*) _tmp14_, _tmp15_);
	_tmp16_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp16_, "empty");
	_tmp17_ = self->priv->start_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, FALSE);
	_tmp18_ = self->priv->timer_setup;
	g_signal_connect_object (_tmp18_, "duration-changed", (GCallback) __clocks_timer_face___lambda47__clocks_timer_setup_duration_changed, self, 0);
	_tmp19_ = self->priv->start_button;
	g_signal_connect_object (_tmp19_, "clicked", (GCallback) __clocks_timer_face___lambda48__gtk_button_clicked, self, 0);
	clocks_timer_face_load (self);
	_g_object_unref0 (no_timer_container_first_child);
	return obj;
}

static void
clocks_timer_face_class_init (ClocksTimerFaceClass * klass,
                              gpointer klass_data)
{
	clocks_timer_face_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksTimerFace_private_offset);
	((GtkWidgetClass *) klass)->grab_focus = (gboolean (*) (GtkWidget*)) clocks_timer_face_real_grab_focus;
	((ClocksTimerFaceClass *) klass)->ring = clocks_timer_face_real_ring;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_timer_face_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_timer_face_set_property;
	G_OBJECT_CLASS (klass)->constructor = clocks_timer_face_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_timer_face_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_FACE_PANEL_ID_PROPERTY, clocks_timer_face_properties[CLOCKS_TIMER_FACE_PANEL_ID_PROPERTY] = g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_FACE_BUTTON_MODE_PROPERTY, clocks_timer_face_properties[CLOCKS_TIMER_FACE_BUTTON_MODE_PROPERTY] = g_param_spec_enum ("button-mode", "button-mode", "button-mode", CLOCKS_TYPE_BUTTON_MODE, CLOCKS_BUTTON_MODE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_FACE_IS_RUNNING_PROPERTY, clocks_timer_face_properties[CLOCKS_TIMER_FACE_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_FACE_NEW_LABEL_PROPERTY, clocks_timer_face_properties[CLOCKS_TIMER_FACE_NEW_LABEL_PROPERTY] = g_param_spec_string ("new-label", "new-label", "new-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/timer-face.ui");
	clocks_timer_face_signals[CLOCKS_TIMER_FACE_RING_SIGNAL] = g_signal_new ("ring", CLOCKS_TIMER_TYPE_FACE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksTimerFaceClass, ring), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timers_list", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, timers_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "no_timer_container", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, no_timer_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_button", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, start_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, stack));
}

static void
clocks_timer_face_clocks_clock_interface_init (ClocksClockIface * iface,
                                               gpointer iface_data)
{
	clocks_timer_face_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_new = (void (*) (ClocksClock*)) clocks_timer_face_real_activate_new;
	iface->escape_pressed = (gboolean (*) (ClocksClock*)) clocks_timer_face_real_escape_pressed;
	iface->get_panel_id = clocks_timer_face_real_get_panel_id;
	iface->set_panel_id = clocks_timer_face_real_set_panel_id;
	iface->get_button_mode = clocks_timer_face_real_get_button_mode;
	iface->set_button_mode = clocks_timer_face_real_set_button_mode;
	iface->get_new_label = clocks_timer_face_real_get_new_label;
}

static void
clocks_timer_face_instance_init (ClocksTimerFace * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = clocks_timer_face_get_instance_private (self);
	self->priv->_button_mode = CLOCKS_BUTTON_MODE_NONE;
	self->priv->_is_running = FALSE;
	_tmp0_ = g_strdup (_ ("New Timer"));
	self->priv->_new_label = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_timer_face_finalize (GObject * obj)
{
	ClocksTimerFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace);
	_g_object_unref0 (self->priv->timer_setup);
	_g_free0 (self->priv->_new_label);
	_g_object_unref0 (self->priv->timers);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->bell);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (clocks_timer_face_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_timer_face_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksTimerFaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_timer_face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksTimerFace), 0, (GInstanceInitFunc) clocks_timer_face_instance_init, NULL };
	static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_timer_face_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_timer_face_type_id;
	clocks_timer_face_type_id = g_type_register_static (adw_bin_get_type (), "ClocksTimerFace", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_timer_face_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
	ClocksTimerFace_private_offset = g_type_add_instance_private (clocks_timer_face_type_id, sizeof (ClocksTimerFacePrivate));
	return clocks_timer_face_type_id;
}

GType
clocks_timer_face_get_type (void)
{
	static volatile gsize clocks_timer_face_type_id__once = 0;
	if (g_once_init_enter (&clocks_timer_face_type_id__once)) {
		GType clocks_timer_face_type_id;
		clocks_timer_face_type_id = clocks_timer_face_get_type_once ();
		g_once_init_leave (&clocks_timer_face_type_id__once, clocks_timer_face_type_id);
	}
	return clocks_timer_face_type_id__once;
}

static void
_vala_clocks_timer_face_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ClocksTimerFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace);
	switch (property_id) {
		case CLOCKS_TIMER_FACE_PANEL_ID_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		case CLOCKS_TIMER_FACE_BUTTON_MODE_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_button_mode ((ClocksClock*) self));
		break;
		case CLOCKS_TIMER_FACE_IS_RUNNING_PROPERTY:
		g_value_set_boolean (value, clocks_timer_face_get_is_running (self));
		break;
		case CLOCKS_TIMER_FACE_NEW_LABEL_PROPERTY:
		g_value_set_string (value, clocks_clock_get_new_label ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_timer_face_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ClocksTimerFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace);
	switch (property_id) {
		case CLOCKS_TIMER_FACE_PANEL_ID_PROPERTY:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		case CLOCKS_TIMER_FACE_BUTTON_MODE_PROPERTY:
		clocks_clock_set_button_mode ((ClocksClock*) self, g_value_get_enum (value));
		break;
		case CLOCKS_TIMER_FACE_IS_RUNNING_PROPERTY:
		clocks_timer_face_set_is_running (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

