/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ti extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "\u1300\u122d\u1218\u1295";
        final String metaValue_la = "\u120b\u1272\u1295";
        final Object[][] data = new Object[][] {
            { "sbp", "\u1233\u1295\u1309" },
            { "ksh", "\u12ae\u120d\u123d" },
            { "nyn", "\u1295\u12eb\u1295\u12ae\u120d" },
            { "luo", "\u1209\u12a6" },
            { "Zsym", "\u121d\u120d\u12ad\u1273\u1275" },
            { "fil", "\u134a\u120a\u1352\u1295\u129b" },
            { "hmn", "\u1205\u121e\u1295\u130d" },
            { "Zsye", "\u12a2\u121e\u1302" },
            { "ccp", "\u127b\u12ad\u121b" },
            { "luy", "\u1209\u12ed\u12eb" },
            { "bas", "\u1263\u1233" },
            { "teo", "\u1270\u1236" },
            { "AC", "\u12f0\u1234\u1275 \u12a3\u1230\u1295\u1235\u12ee\u1295" },
            { "AD", "\u12a3\u1295\u12f6\u122b" },
            { "AE", "\u1215\u1261\u122b\u1275 \u12a2\u121b\u122b\u1275 \u12d3\u1228\u1265" },
            { "nl_BE", "\u134d\u120b\u121a\u123d" },
            { "AF", "\u12a3\u134d\u130b\u1292\u1235\u1273\u1295" },
            { "af", "\u12a3\u134d\u122a\u12ab\u1295\u1235" },
            { "AG", "\u12a3\u1295\u1272\u1313\u1295 \u1263\u122d\u1261\u12f3\u1295" },
            { "AI", "\u12a3\u1295\u1312\u120b" },
            { "ak", "\u12a3\u12ab\u1295" },
            { "AL", "\u12a3\u120d\u1263\u1295\u12eb" },
            { "AM", "\u12a3\u122d\u121c\u1295\u12eb" },
            { "am", "\u12a3\u121d\u1213\u122d\u129b" },
            { "AO", "\u12a3\u1295\u130e\u120b" },
            { "AQ", "\u12a3\u1295\u1273\u122d\u12ad\u1272\u12ab" },
            { "AR", "\u12a3\u122d\u1300\u1295\u1272\u1293" },
            { "ar", "\u12d3\u1228\u1265" },
            { "AS", "\u12a3\u1218\u122a\u12ab\u12ca\u1275 \u1233\u121e\u12a3" },
            { "as", "\u12a3\u1233\u121c\u12dd\u129b" },
            { "AT", "\u12a6\u1235\u1275\u122d\u12eb" },
            { "AU", "\u12a3\u12cd\u1235\u1275\u122b\u120d\u12eb" },
            { "AW", "\u12a3\u1229\u1263" },
            { "en_US", "\u12a5\u1295\u130d\u120a\u12dd\u129b (\u1215\u1261\u122b\u1275 \u1218\u1295\u130d\u1235\u1273\u1275)" },
            { "AX", "\u12f0\u1234\u1273\u1275 \u12a3\u120b\u1295\u12f5" },
            { "AZ", "\u12a3\u12d8\u122d\u1263\u1303\u1295" },
            { "az", "\u12a3\u12d8\u122d\u1263\u1303\u1295\u129b" },
            { "BA", "\u1266\u12dd\u1295\u12eb\u1295 \u1204\u122d\u12d8\u130e\u126a\u1293\u1295" },
            { "BB", "\u1263\u122d\u1263\u12f6\u1235" },
            { "ceb", "\u1230\u1265\u12cb\u1296" },
            { "BD", "\u1263\u1295\u130d\u120b\u12f0\u123d" },
            { "BE", "\u1264\u120d\u1305\u12e9\u121d" },
            { "be", "\u1264\u120b\u1229\u1235\u129b" },
            { "BF", "\u1261\u122d\u12aa\u1293 \u134b\u1236" },
            { "BG", "\u1261\u120d\u130b\u122d\u12eb" },
            { "bg", "\u1261\u120d\u130b\u122d\u129b" },
            { "BH", "\u1263\u1215\u122c\u1295" },
            { "BI", "\u1265\u1229\u1295\u12f2" },
            { "BJ", "\u1264\u1292\u1295" },
            { "BL", "\u1245\u12f1\u1235 \u1263\u122d\u1270\u1208\u121a" },
            { "BM", "\u1260\u122d\u1219\u12f3" },
            { "bm", "\u1263\u121d\u1263\u122b" },
            { "BN", "\u1265\u1229\u1290\u12ed" },
            { "bn", "\u1260\u1295\u130b\u120a" },
            { "BO", "\u1266\u120a\u126d\u12eb" },
            { "bo", "\u1272\u1260\u1273\u1295\u129b" },
            { "BQ", "\u12ab\u122a\u1265\u12eb\u1295 \u1294\u12d8\u122d\u120b\u1295\u12f5" },
            { "BR", "\u1265\u122b\u12da\u120d" },
            { "br", "\u1265\u1228\u1276\u1295\u129b" },
            { "BS", "\u1263\u1203\u121b\u1235" },
            { "bs", "\u1266\u12dd\u1295\u129b" },
            { "xog", "\u1236\u130b" },
            { "BT", "\u1261\u1273\u1295" },
            { "BV", "\u12f0\u1234\u1275 \u1261\u1268\u1275" },
            { "BW", "\u1266\u1275\u1235\u12cb\u1293" },
            { "BY", "\u1264\u120b\u1229\u1235" },
            { "seh", "\u1230\u1293" },
            { "BZ", "\u1260\u120a\u12dd" },
            { "CA", "\u12ab\u1293\u12f3" },
            { "ca", "\u12ab\u1273\u120b\u1295" },
            { "CC", "\u12f0\u1234\u1273\u1275 \u12ae\u12ae\u1235" },
            { "mzn", "\u121b\u12db\u1295\u12f0\u122b\u1292" },
            { "ses", "\u12ae\u12ed\u122b\u1266\u122e \u1230\u1292" },
            { "CD", "\u12f0\u121e\u12ad\u122b\u1235\u12eb\u12ca\u1275 \u122a\u1353\u1265\u120a\u12ad \u12ae\u1295\u130e" },
            { "ce", "\u1278\u1278\u1295\u12ed\u1293" },
            { "CF", "\u122a\u1353\u1265\u120a\u12ad \u121b\u12a5\u12a8\u120b\u12ed \u12a3\u134d\u122a\u1243" },
            { "CG", "\u12ae\u1295\u130e" },
            { "CH", "\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f5" },
            { "CI", "\u12ae\u1275 \u12f2\u126d\u12cb\u122d" },
            { "CK", "\u12f0\u1234\u1273\u1275 \u12a9\u12ad" },
            { "CL", "\u127a\u120c" },
            { "CM", "\u12ab\u121c\u1229\u1295" },
            { "CN", "\u127b\u12ed\u1293" },
            { "CO", "\u12ae\u120e\u121d\u1265\u12eb" },
            { "co", "\u12ae\u122d\u1235\u129b" },
            { "CP", "\u12f0\u1234\u1275 \u12ad\u120a\u1350\u122d\u1276\u1295" },
            { "CR", "\u12ae\u1235\u1273 \u122a\u12ab" },
            { "cs", "\u1278\u12ad\u129b" },
            { "CU", "\u12a9\u1263" },
            { "cu", "\u1264\u1270-\u12ad\u122d\u1235\u1275\u12eb\u1295 \u1235\u120b\u126d\u129b" },
            { "CV", "\u12ac\u1355 \u1268\u122d\u12f0" },
            { "CW", "\u12a9\u122b\u1233\u12cd" },
            { "CX", "\u12f0\u1234\u1275 \u12ad\u122a\u1235\u121b\u1235" },
            { "CY", "\u1246\u1335\u122e\u1235" },
            { "cy", "\u12cc\u120d\u1235\u129b" },
            { "CZ", "\u1278\u12ad\u12eb" },
            { "da", "\u12f3\u1292\u123d" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "cgg", "\u127a\u130b" },
            { "DG", "\u12f5\u12e8\u130e \u130b\u122d\u1235\u12eb" },
            { "DJ", "\u1305\u1261\u1272" },
            { "DK", "\u12f0\u1295\u121b\u122d\u12ad" },
            { "DM", "\u12f6\u121a\u1292\u12ab" },
            { "DO", "\u12f6\u121a\u1292\u12ab\u12ca\u1275 \u122a\u1353\u1265\u120a\u12ad" },
            { "bem", "\u1264\u121d\u1263" },
            { "DZ", "\u12a3\u120d\u1300\u122d\u12eb" },
            { "dz", "\u12f5\u12de\u1295\u130d\u12ab" },
            { "bez", "\u1260\u1293" },
            { "EA", "\u1234\u12cd\u1273\u1295 \u1218\u120a\u120b\u1295" },
            { "EC", "\u12a4\u12b3\u12f6\u122d" },
            { "dje", "\u12db\u122d\u121b" },
            { "EE", "\u12a4\u1235\u1276\u1295\u12eb" },
            { "ee", "\u12a2\u12cd" },
            { "EG", "\u130d\u1265\u133a" },
            { "EH", "\u121d\u12d5\u122b\u1263\u12ca \u1230\u1203\u122b" },
            { "ro_MD", "\u121e\u120d\u12f6\u1268\u129b" },
            { "el", "\u130d\u122a\u12bd\u129b" },
            { "en", "\u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "eo", "\u12a4\u1235\u1350\u122b\u1295\u1276" },
            { "chr", "\u1278\u122e\u12aa" },
            { "ER", "\u12a4\u122d\u1275\u122b" },
            { "ES", "\u1235\u1333\u129b" },
            { "es", "\u1235\u1333\u1295\u129b" },
            { "ET", "\u12a2\u1275\u12ee\u1335\u12eb" },
            { "et", "\u12a4\u1235\u1276\u1295\u129b" },
            { "EU", "\u12a4\u12cd\u122e\u1333\u12ca \u1215\u1265\u1228\u1275" },
            { "eu", "\u1263\u1235\u12ad\u129b" },
            { "EZ", "\u12de\u1263 \u12e9\u122e" },
            { "shi", "\u1273\u1278\u120d\u1202\u1275" },
            { "hsb", "\u120b\u12d5\u1208\u12cb\u12ed \u1236\u122d\u1265\u129b" },
            { "fa", "\u134b\u122d\u1235\u129b" },
            { "ff", "\u1349\u120b" },
            { "FI", "\u134a\u1295\u120b\u1295\u12f5" },
            { "fi", "\u134a\u1295\u120b\u1295\u12f5\u129b" },
            { "FJ", "\u134a\u1302" },
            { "FK", "\u12f0\u1234\u1273\u1275 \u134e\u12ad\u120b\u1295\u12f5" },
            { "FM", "\u121b\u12ed\u12ad\u122e\u1290\u12e5\u12eb" },
            { "yue", "\u12ab\u1295\u1276\u1295\u129b" },
            { "FO", "\u12f0\u1234\u1273\u1275 \u134b\u122e" },
            { "fo", "\u134b\u122e\u12a5\u12ed\u1293" },
            { "FR", "\u1348\u1228\u1295\u1233" },
            { "fr", "\u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "fy", "\u121d\u12d5\u122b\u1263\u12ca \u134d\u122a\u1235\u129b" },
            { "GA", "\u130b\u1266\u1295" },
            { "ga", "\u12a3\u12e8\u122d\u120b\u1295\u12f5\u129b" },
            { "GB", "\u1265\u122a\u1323\u1295\u12eb" },
            { "pcm", "\u1352\u1302\u1295 \u1293\u12ed\u1300\u122d\u12eb" },
            { "GD", "\u130d\u1228\u1293\u12f3" },
            { "gd", "\u1235\u12ae\u1275\u120b\u1295\u12f3\u12ca \u130b\u12a4\u120a\u12ad\u129b" },
            { "GE", "\u1306\u122d\u1305\u12eb" },
            { "GF", "\u1348\u1228\u1295\u1233\u12ca\u1275 \u130a\u12eb\u1293" },
            { "GG", "\u1308\u122d\u1295\u12da" },
            { "GH", "\u130b\u1293" },
            { "GI", "\u1302\u1265\u122b\u120d\u1273\u122d" },
            { "GL", "\u130d\u122a\u1295\u120b\u1295\u12f5" },
            { "gl", "\u130b\u120a\u123d\u12eb\u1295" },
            { "GM", "\u130b\u121d\u1265\u12eb" },
            { "GN", "\u130a\u1292" },
            { "gn", "\u1313\u122b\u1292" },
            { "GP", "\u1313\u12f0\u1209\u1355" },
            { "GQ", "\u12a2\u12b3\u1276\u122d\u12eb\u120d \u130a\u1292" },
            { "und", "\u12d8\u12ed\u1270\u1348\u120d\u1320 \u124b\u1295\u124b" },
            { "GR", "\u130d\u122a\u12bd" },
            { "GS", "\u12f0\u1234\u1273\u1275 \u12f0\u1261\u1265 \u1306\u122d\u1305\u12eb\u1295 \u12f0\u1261\u1265 \u1233\u1295\u12f5\u12ca\u127d\u1295" },
            { "GT", "\u1313\u1272\u121b\u120b" },
            { "GU", "\u1313\u121d" },
            { "gu", "\u1309\u1303\u122b\u1272" },
            { "gv", "\u121b\u1295\u12ad\u1235" },
            { "GW", "\u130a\u1292-\u1262\u1233\u12cd" },
            { "rhg", "\u122e\u1202\u1295\u130d\u12eb" },
            { "tlh", "\u12ad\u120a\u1295\u130e\u1295" },
            { "GY", "\u1309\u12eb\u1293" },
            { "ha", "\u1203\u12cd\u1233" },
            { "ckb", "\u1236\u122b\u1292 \u12a9\u122d\u12f2\u123d" },
            { "zxx", "\u124b\u1295\u124b\u12ca \u1275\u1215\u12dd\u1276 \u12e8\u1208\u1295" },
            { "he", "\u12a5\u1265\u122b\u12ed\u1235\u1322" },
            { "hi", "\u1202\u1295\u12f2" },
            { "HK", "\u134d\u1209\u12ed \u121d\u121d\u1215\u12f3\u122b\u12ca \u12de\u1263 \u1206\u1295\u130d \u12ae\u1295\u130d (\u127b\u12ed\u1293)" },
            { "HM", "\u12f0\u1234\u1273\u1275 \u1204\u122d\u12f5\u1295 \u121b\u12ad\u12f6\u1293\u120d\u12f5\u1295" },
            { "HN", "\u1206\u1295\u12f1\u122b\u1235" },
            { "HR", "\u12ad\u122e\u12a4\u123d\u12eb" },
            { "hr", "\u12ad\u122e\u12a4\u123d\u12eb\u1295" },
            { "agq", "\u12a3\u1308\u121d" },
            { "gsw", "\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f3\u12ca \u1300\u122d\u1218\u1295" },
            { "HT", "\u1203\u12ed\u1272" },
            { "ht", "\u12ad\u122d\u12ee\u120d \u1203\u12ed\u1275\u129b" },
            { "HU", "\u1203\u1295\u130b\u122a" },
            { "hu", "\u1203\u1295\u130b\u122d\u129b" },
            { "hy", "\u12a3\u122d\u121c\u1295\u129b" },
            { "frc", "\u12ab\u1301\u1295 \u1348\u1228\u1295\u1233\u12ed" },
            { "ia", "\u12a2\u1295\u1270\u122d\u120a\u1295\u1313" },
            { "IC", "\u12f0\u1234\u1273\u1275 \u12ab\u1293\u122a" },
            { "ID", "\u12a2\u1295\u12f6\u1290\u12e5\u12eb" },
            { "id", "\u12a2\u1295\u12f6\u1290\u12e5\u129b" },
            { "IE", "\u12a3\u12e8\u122d\u120b\u1295\u12f5" },
            { "ig", "\u12a2\u130d\u1266" },
            { "naq", "\u1293\u121b" },
            { "ii", "\u1232\u127d\u12cb\u1295 \u12ea" },
            { "IL", "\u12a5\u1235\u122b\u12a4\u120d" },
            { "IM", "\u12a3\u12ed\u120d \u12a6\u134d \u121b\u1295" },
            { "IN", "\u1205\u1295\u12f2" },
            { "IO", "\u1265\u122a\u1323\u1295\u12eb\u12ca \u1205\u1295\u12f3\u12ca \u12cd\u1245\u12eb\u1296\u1235 \u130d\u12dd\u12a3\u1275" },
            { "IQ", "\u12d2\u122b\u1255" },
            { "IR", "\u12a2\u122b\u1295" },
            { "IS", "\u12a3\u12ed\u1235\u120b\u1295\u12f5" },
            { "is", "\u12a3\u12ed\u1235\u120b\u1295\u12f5\u129b" },
            { "IT", "\u12a2\u1323\u120d\u12eb" },
            { "it", "\u1325\u120d\u12eb\u1295" },
            { "ja", "\u1303\u1353\u1295\u129b" },
            { "JE", "\u1300\u122d\u12da" },
            { "doi", "\u12f6\u130d\u122a" },
            { "JM", "\u1303\u121b\u12ed\u12ab" },
            { "JO", "\u12ee\u122d\u12f3\u1296\u1235" },
            { "JP", "\u1303\u1353\u1295" },
            { "jv", "\u1303\u126b\u1295\u129b" },
            { "guz", "\u1309\u1232" },
            { "mai", "\u121b\u12ed\u1272\u120a" },
            { "smn", "\u1233\u121a \u12a2\u1293\u122a" },
            { "ka", "\u1306\u122d\u1305\u12eb\u1295\u129b" },
            { "KE", "\u12ac\u1295\u12eb" },
            { "419", "\u120b\u1272\u1295 \u12a3\u1218\u122a\u12ab" },
            { "KG", "\u12aa\u122d\u130a\u12dd\u1235\u1273\u1295" },
            { "KH", "\u12ab\u121d\u1266\u12f5\u12eb" },
            { "KI", "\u12aa\u122a\u1263\u1272" },
            { "ki", "\u12aa\u12a9\u12e9" },
            { "mas", "\u121b\u1233\u12ed" },
            { "kk", "\u12ab\u12db\u12ad" },
            { "kl", "\u130d\u122a\u1295\u120b\u1295\u12f5\u129b" },
            { "KM", "\u12ae\u121e\u122e\u1235" },
            { "km", "\u12ad\u1218\u122d" },
            { "KN", "\u1245\u12f1\u1235 \u12aa\u1275\u1235\u1295 \u1294\u126a\u1235\u1295" },
            { "kn", "\u12ab\u1295\u1293\u12f3" },
            { "ko", "\u12ae\u122d\u12ed\u129b" },
            { "KP", "\u1230\u121c\u1295 \u12ae\u122d\u12eb" },
            { "KR", "\u12f0\u1261\u1265 \u12ae\u122d\u12eb" },
            { "ks", "\u12ab\u123d\u121a\u122a" },
            { "ku", "\u12a9\u122d\u12f2\u123d" },
            { "KW", "\u12a9\u12cc\u1275" },
            { "kw", "\u12ae\u122d\u1295\u129b" },
            { "KY", "\u12f0\u1234\u1273\u1275 \u12ab\u12ed\u121b\u1295" },
            { "ky", "\u12aa\u122d\u130a\u12dd\u129b" },
            { "KZ", "\u12ab\u12db\u12aa\u1235\u1273\u1295" },
            { "la", metaValue_la },
            { "LA", "\u120b\u12a6\u1235" },
            { "LB", "\u120a\u1263\u1296\u1235" },
            { "lb", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d\u129b" },
            { "LC", "\u1245\u12f5\u1235\u1272 \u1209\u1235\u12eb" },
            { "lg", "\u130b\u1295\u12f3" },
            { "nds", "\u1275\u1211\u1275 \u1300\u122d\u1218\u1295" },
            { "LI", "\u120a\u12bd\u1270\u1295\u123d\u1273\u12ed\u1295" },
            { "LK", "\u1235\u122a \u120b\u1295\u12ab" },
            { "ln", "\u120a\u1295\u130b\u120b" },
            { "fur", "\u134d\u122d\u12e9\u120d\u129b" },
            { "lo", "\u120b\u12a6" },
            { "LR", "\u120b\u12ed\u1260\u122d\u12eb" },
            { "LS", "\u120c\u1236\u1276" },
            { "LT", "\u120a\u1275\u12cc\u1295\u12eb" },
            { "lt", "\u120a\u1275\u12cc\u1295\u129b" },
            { "LU", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d" },
            { "lu", "\u1209\u1263-\u12ab\u1273\u1295\u130b" },
            { "LV", "\u120b\u1275\u126d\u12eb" },
            { "lv", "\u120b\u1275\u126d\u129b" },
            { "LY", "\u120a\u1265\u12eb" },
            { "ListCompositionPattern", "{0}\u1363 {1}" },
            { "vun", "\u1269\u1295\u1306" },
            { "lag", "\u120b\u1295\u130a" },
            { "MA", "\u121e\u122e\u12ae" },
            { "MC", "\u121e\u1293\u12ae" },
            { "MD", "\u121e\u120d\u12f6\u126b" },
            { "ME", "\u121e\u1295\u1270\u1294\u130d\u122e" },
            { "MF", "\u1245\u12f1\u1235 \u121b\u122d\u1272\u1295" },
            { "MG", "\u121b\u12f3\u130b\u1235\u12ab\u122d" },
            { "mg", "\u121b\u120b\u130b\u1232" },
            { "MH", "\u12f0\u1234\u1273\u1275 \u121b\u122d\u123b\u120d" },
            { "mi", "\u121b\u12a6\u122a" },
            { "MK", "\u1230\u121c\u1295 \u1218\u1244\u12f6\u1295\u12eb" },
            { "mk", "\u1218\u1244\u12f6\u1295\u129b" },
            { "ML", "\u121b\u120a" },
            { "ml", "\u121b\u120b\u12eb\u120b\u121d" },
            { "MM", "\u121a\u12eb\u1295\u121b\u122d (\u1260\u122d\u121b)" },
            { "MN", "\u121e\u1295\u130e\u120d\u12eb" },
            { "mn", "\u121e\u1295\u130e\u120d\u129b" },
            { "MO", "\u134d\u1209\u12ed \u121d\u121d\u1215\u12f3\u122b\u12ca \u12de\u1263 \u121b\u12ab\u12cd (\u127b\u12ed\u1293)" },
            { "MP", "\u12f0\u1234\u1273\u1275 \u1230\u121c\u1293\u12ca \u121b\u122d\u12eb\u1293" },
            { "MQ", "\u121b\u122d\u1272\u1292\u12ad" },
            { "MR", "\u121b\u12cd\u122a\u1273\u1295\u12eb" },
            { "mr", "\u121b\u122b\u1272" },
            { "MS", "\u121e\u1295\u1275\u1230\u122b\u1275" },
            { "ms", "\u121b\u120b\u12ed\u129b" },
            { "MT", "\u121b\u120d\u1273" },
            { "mt", "\u121b\u120d\u1275\u129b" },
            { "MU", "\u121b\u12cd\u122a\u1238\u1235" },
            { "MV", "\u121b\u120d\u12f2\u126d\u1235" },
            { "MW", "\u121b\u120b\u12ca" },
            { "MX", "\u121c\u12ad\u1232\u12ae" },
            { "MY", "\u121b\u1208\u12e5\u12eb" },
            { "my", "\u1260\u122d\u121d\u129b" },
            { "MZ", "\u121e\u12db\u121d\u1262\u12ad" },
            { "dsb", "\u1273\u1215\u1270\u12cb\u12ed \u1236\u122d\u1265\u129b" },
            { "NA", "\u1293\u121a\u1265\u12eb" },
            { "202", "\u1295\u12a1\u1235 \u1230\u1203\u122b\u12ca \u12a3\u134d\u122a\u1243" },
            { "nb", "\u1296\u122d\u12c8\u12eb\u12ca \u1266\u12ad\u121b\u120d" },
            { "NC", "\u1292\u12cd \u12ab\u1208\u12f6\u1295\u12eb" },
            { "nd", "\u1230\u121c\u1295 \u1295\u12f0\u1260\u1208" },
            { "NE", "\u1292\u1300\u122d" },
            { "ne", "\u1294\u1353\u120a" },
            { "NF", "\u12f0\u1234\u1275 \u1296\u122d\u134e\u120d\u12ad" },
            { "NG", "\u1293\u12ed\u1300\u122d\u12eb" },
            { "NI", "\u1292\u12ab\u122b\u1313" },
            { "NL", "\u1294\u12d8\u122d\u120b\u1295\u12f5" },
            { "nl", "\u12f3\u127d" },
            { "nn", "\u1296\u122d\u12c8\u12eb\u12ca \u1293\u12ed\u1296\u122d\u1235\u12ad" },
            { "NO", "\u1296\u122d\u12c8\u12ed" },
            { "no", "\u1296\u122d\u12c8\u12ed\u129b" },
            { "NP", "\u1294\u1353\u120d" },
            { "NR", "\u1293\u12cd\u1229" },
            { "NU", "\u1292\u12e9" },
            { "nv", "\u1293\u126b\u1206" },
            { "rof", "\u122e\u121d\u1266" },
            { "ny", "\u1295\u12eb\u1295\u1303" },
            { "NZ", "\u1292\u12cd \u12da\u120b\u1295\u12f5" },
            { "kab", "\u12ab\u1262\u120d\u129b" },
            { "oc", "\u12a6\u12ad\u1232\u1273\u1295\u129b" },
            { "kam", "\u12ab\u121d\u1263" },
            { "mer", "\u1218\u1229" },
            { "OM", "\u12d6\u121b\u1295" },
            { "om", "\u12a6\u122e\u121e" },
            { "or", "\u12a6\u12f5\u12eb" },
            { "os", "\u12a6\u1230\u1275\u129b" },
            { "mfe", "\u12ad\u122d\u12ee\u120d \u121b\u12cd\u122a\u123d\u12ed\u1293" },
            { "PA", "\u1353\u1293\u121b" },
            { "pa", "\u1351\u1295\u1303\u1262" },
            { "dua", "\u12f5\u12cb\u120b" },
            { "PE", "\u1354\u1229" },
            { "PF", "\u1348\u1228\u1295\u1233\u12ed \u1356\u120a\u1290\u12e5\u12eb" },
            { "PG", "\u1353\u1355\u12cb \u1292\u12cd \u130a\u1292" },
            { "PH", "\u134a\u120a\u1352\u1295\u1235" },
            { "PK", "\u1353\u12aa\u1235\u1273\u1295" },
            { "PL", "\u1356\u120b\u1295\u12f5" },
            { "pl", "\u1356\u120a\u123d" },
            { "ewo", "\u12a4\u12ce\u1295\u12f6" },
            { "PM", "\u1245\u12f1\u1235 \u1355\u12e8\u122d\u1295 \u121a\u12a8\u120e\u1295\u1295" },
            { "PN", "\u12f0\u1234\u1273\u1275 \u1352\u1275\u12ab\u122d\u1295" },
            { "PR", "\u1356\u122d\u1276 \u122a\u12ae" },
            { "PS", "\u130d\u12dd\u12a3\u1273\u1275 \u134d\u120d\u1235\u1324\u121d" },
            { "ps", "\u1353\u123d\u1276" },
            { "PT", "\u1356\u122d\u1271\u130b\u120d" },
            { "pt", "\u1356\u122d\u1271\u130a\u12dd\u129b" },
            { "PW", "\u1353\u120b\u12cd" },
            { "PY", "\u1353\u122b\u1313\u12ed" },
            { "mgh", "\u121b\u12ad\u12cb-\u121c\u1276" },
            { "key.cf", "\u1245\u122d\u133a \u1263\u1324\u122b" },
            { "QA", "\u1250\u1320\u122d" },
            { "key.ca", "\u12d3\u12cd\u12f0-\u12a3\u12cb\u122d\u1215" },
            { "mgo", "\u1218\u1273" },
            { "QO", "\u12ab\u1265 \u12a6\u123d\u12eb\u1295\u12eb \u122d\u1212\u1256\u121d \u130d\u12dd\u12a3\u1273\u1275" },
            { "qu", "\u1240\u127d\u12cb" },
            { "brx", "\u1266\u12f6" },
            { "kde", "\u121b\u12ae\u1295\u12f0" },
            { "001", "\u12d3\u1208\u121d" },
            { "Ethi", "\u134a\u12f0\u120d" },
            { "002", "\u12a3\u134d\u122a\u1243" },
            { "003", "\u1230\u121c\u1295 \u12a3\u1218\u122a\u12ab" },
            { "RE", "\u122d\u12e9\u1295\u12e8\u1295" },
            { "005", "\u12f0\u1261\u1265 \u12a3\u1218\u122a\u12ab" },
            { "009", "\u12a6\u123d\u12eb\u1295\u12eb" },
            { "rm", "\u122e\u121b\u1295\u123d" },
            { "rn", "\u12aa\u1229\u1295\u12f2" },
            { "key.cu", "\u1263\u1324\u122b" },
            { "RO", "\u1229\u121b\u1295\u12eb" },
            { "ro", "\u1229\u121b\u1295\u129b" },
            { "RS", "\u1230\u122d\u1265\u12eb" },
            { "RU", "\u1229\u1235\u12eb" },
            { "ru", "\u1229\u1235\u129b" },
            { "RW", "\u122d\u12cb\u1295\u12f3" },
            { "rw", "\u12aa\u1295\u12eb\u122d\u12cb\u1295\u12f3" },
            { "kea", "\u12ad\u122d\u12ee\u120d \u12ac\u1355 \u1268\u122d\u12f5\u129b" },
            { "SA", "\u1235\u12d1\u12f2 \u12d3\u1228\u1265" },
            { "sa", "\u1233\u1295\u1235\u12ad\u122a\u1275" },
            { "SB", "\u12f0\u1234\u1273\u1275 \u1230\u120e\u121e\u1295" },
            { "twq", "\u1273\u1233\u12cb\u1245" },
            { "011", "\u121d\u12d5\u122b\u1263\u12ca \u12a3\u134d\u122a\u1243" },
            { "SC", "\u1232\u1238\u120d\u1235" },
            { "SD", "\u1231\u12f3\u1295" },
            { "sd", "\u1232\u1295\u12f5\u1202" },
            { "013", "\u121b\u12a5\u12a8\u120b\u12ed \u12a3\u1218\u122a\u12ab" },
            { "SE", "\u123d\u12c8\u12f0\u1295" },
            { "se", "\u1230\u121c\u1293\u12ca \u1233\u121a" },
            { "014", "\u121d\u1265\u122b\u1253\u12ca \u12a3\u134d\u122a\u1243" },
            { "015", "\u1230\u121c\u1293\u12ca \u12a3\u134d\u122a\u1243" },
            { "SG", "\u1232\u1295\u130b\u1356\u122d" },
            { "sg", "\u1233\u1295\u130e" },
            { "SH", "\u1245\u12f5\u1235\u1272 \u1204\u1208\u1293" },
            { "sh", "\u1230\u122d\u1266-\u12ad\u122e\u12a4\u123d\u12eb\u1295" },
            { "017", "\u121b\u12a5\u12a8\u120b\u12ed \u12a3\u134d\u122a\u1243" },
            { "SI", "\u1235\u120e\u126c\u1295\u12eb" },
            { "si", "\u1232\u1295\u1203\u120b" },
            { "018", "\u12f0\u1261\u1263\u12ca \u12a3\u134d\u122a\u1243" },
            { "SJ", "\u1235\u126b\u120d\u1263\u122d\u12f5\u1295 \u1303\u1295 \u121b\u12e8\u1295\u1295" },
            { "019", "\u12a3\u1218\u122a\u12ab\u1273\u1275" },
            { "SK", "\u1235\u120e\u126b\u12ad\u12eb" },
            { "sk", "\u1235\u120e\u126b\u12ad\u129b" },
            { "SL", "\u1234\u122b \u120d\u12ee\u1295" },
            { "sl", "\u1235\u120e\u126c\u1295\u129b" },
            { "SM", "\u1233\u1295 \u121b\u122a\u1296" },
            { "sm", "\u1233\u121e\u12a5\u129b" },
            { "SN", "\u1230\u1290\u130b\u120d" },
            { "sn", "\u123e\u1293" },
            { "SO", "\u1236\u121b\u120d\u12eb" },
            { "so", "\u1236\u121b\u120a" },
            { "sq", "\u12a3\u120d\u1263\u1295\u129b" },
            { "SR", "\u1231\u122a\u1293\u121d" },
            { "sr", "\u1230\u122d\u1265\u129b" },
            { "ListKeyTypePattern", "{0}\u1366 {1}" },
            { "SS", "\u12f0\u1261\u1265 \u1231\u12f3\u1295" },
            { "ST", "\u1233\u12a6 \u1276\u1218\u1295 \u1355\u122a\u1295\u1232\u1350\u1295" },
            { "st", "\u12f0\u1261\u1263\u12ca \u1236\u1276" },
            { "su", "\u1231\u1295\u12f3\u1295\u129b" },
            { "SV", "\u12a4\u120d \u1233\u120d\u126b\u12f6\u122d" },
            { "sv", "\u1235\u12ca\u12f5\u1295\u129b" },
            { "sw", "\u1235\u12cb\u1202\u120a" },
            { "SX", "\u1232\u1295\u1275 \u121b\u122d\u1270\u1295" },
            { "SY", "\u1236\u122d\u12eb" },
            { "SZ", "\u12a4\u1235\u12cb\u1272\u1292" },
            { "TA", "\u1275\u122a\u1235\u1273\u1295 \u12f3 \u12a9\u1295\u12eb" },
            { "ta", "\u1273\u121a\u120d" },
            { "asa", "\u12a3\u1231" },
            { "021", "\u1230\u121c\u1293\u12ca \u12a3\u1218\u122a\u12ab" },
            { "142", "\u12a4\u1235\u12eb" },
            { "TC", "\u12f0\u1234\u1273\u1275 \u1271\u122d\u12ab\u1275\u1295 \u12ab\u12ed\u12ae\u1235\u1295" },
            { "yav", "\u12eb\u1295\u130d\u1260\u1295" },
            { "143", "\u121b\u12a5\u12a8\u120b\u12ed \u12a4\u1235\u12eb" },
            { "TD", "\u132b\u12f5" },
            { "te", "\u1270\u1209\u1309" },
            { "145", "\u121d\u12d5\u122b\u1263\u12ca \u12a4\u1235\u12eb" },
            { "TF", "\u1348\u1228\u1295\u1233\u12ca \u12f0\u1261\u1263\u12ca \u130d\u12dd\u12a3\u1273\u1275" },
            { "TG", "\u1276\u130e" },
            { "tg", "\u1273\u1302\u12ad\u129b" },
            { "TH", "\u1273\u12ed\u120b\u1295\u12f5" },
            { "th", "\u1273\u12ed\u129b" },
            { "ti", "\u1275\u130d\u122d\u129b" },
            { "TJ", "\u1273\u1302\u12aa\u1235\u1273\u1295" },
            { "029", "\u12ab\u122a\u1265\u12eb\u1295" },
            { "TK", "\u1276\u12a8\u120b\u12cd" },
            { "tk", "\u1271\u122d\u12ad\u1218\u1295\u129b" },
            { "TL", "\u1272\u121e\u122d-\u1208\u1235\u1270" },
            { "TM", "\u1271\u122d\u12ad\u1218\u1292\u1235\u1273\u1295" },
            { "TN", "\u1271\u1292\u12dd\u12eb" },
            { "TO", "\u1276\u1295\u130b" },
            { "to", "\u1276\u1295\u130b\u1295\u129b" },
            { "dyo", "\u1306\u120b-\u134e\u1292\u12ed" },
            { "TR", "\u1271\u122d\u12aa" },
            { "tr", "\u1271\u122d\u12ad\u129b" },
            { "TT", "\u1275\u122a\u1292\u12f3\u12f5\u1295 \u1276\u1263\u130e\u1295" },
            { "tt", "\u1273\u1273\u122d" },
            { "TV", "\u1271\u126b\u1209" },
            { "TW", "\u1273\u12ed\u12cb\u1295" },
            { "tw", "\u1275\u12ca" },
            { "ast", "\u12a3\u1235\u1271\u122d\u12eb\u1295" },
            { "TZ", "\u1273\u1295\u12db\u1295\u12eb" },
            { "nmg", "\u12ad\u12cb\u1235\u12ee" },
            { "150", "\u12a4\u12cd\u122e\u1333" },
            { "UA", "\u12e9\u12ad\u122c\u1295" },
            { "lij", "\u120a\u1309\u122d\u129b" },
            { "030", "\u121d\u1265\u122b\u1253\u12ca \u12a4\u1235\u12eb" },
            { "151", "\u121d\u1265\u122b\u1253\u12ca \u12a4\u12cd\u122e\u1333" },
            { "154", "\u1230\u121c\u1293\u12ca \u12a4\u12cd\u122e\u1333" },
            { "sw_CD", "\u1235\u12cb\u1202\u120a (\u12ae\u1295\u130e)" },
            { "034", "\u12f0\u1261\u1263\u12ca \u12a4\u1235\u12eb" },
            { "155", "\u121d\u12d5\u122b\u1263\u12ca \u12a4\u12cd\u122e\u1333" },
            { "035", "\u12f0\u1261\u1263\u12ca \u121d\u1265\u122b\u1255 \u12a4\u1235\u12eb" },
            { "UG", "\u12a1\u130b\u1295\u12f3" },
            { "ug", "\u12a1\u12ed\u1309\u122d" },
            { "kgp", "\u12ab\u12ed\u1295\u130b\u1295\u130d" },
            { "039", "\u12f0\u1261\u1263\u12ca \u12a4\u12cd\u122e\u1333" },
            { "uk", "\u12e9\u12ad\u1228\u12ed\u1295\u129b" },
            { "UM", "\u12ab\u1265 \u12a3\u1218\u122a\u12ab \u122d\u1212\u1250\u1295 \u1295\u12a3\u123d\u1271 \u12f0\u1234\u1273\u1275" },
            { "UN", "\u1215\u1261\u122b\u1275 \u1203\u1308\u122b\u1275" },
            { "ur", "\u12a1\u122d\u12f1" },
            { "US", "\u12a3\u1218\u122a\u12ab" },
            { "haw", "\u1203\u12cb\u12ed\u129b" },
            { "%%1959ACAD", "\u12a3\u12ab\u12f3\u121d\u12eb\u12ca" },
            { "UY", "\u12a1\u122b\u1313\u12ed" },
            { "prg", "\u1355\u1229\u1235\u129b" },
            { "UZ", "\u12a1\u12dd\u1260\u12aa\u1235\u1273\u1295" },
            { "uz", "\u12a1\u12dd\u1260\u12ad\u129b" },
            { "tzm", "\u121b\u12a5\u12a8\u120b\u12ed \u12a3\u1275\u120b\u1235 \u1273\u121b\u12db\u12ed\u1275" },
            { "nnh", "\u1295\u130c\u121d\u1261\u1295" },
            { "VA", "\u12a8\u1270\u121b \u126b\u1272\u12ab\u1295" },
            { "nds_NL", "\u1275\u1211\u1275 \u1233\u12ad\u1230\u1295" },
            { "VC", "\u1245\u12f1\u1235 \u126a\u1295\u1230\u1295\u1275\u1295 \u130d\u1228\u1290\u12f2\u1290\u12dd\u1295" },
            { "VE", "\u126c\u1294\u12dd\u12cc\u120b" },
            { "VG", "\u12f0\u1234\u1273\u1275 \u12f0\u1293\u130d\u120d \u1265\u122a\u1323\u1295\u12eb" },
            { "VI", "\u12f0\u1234\u1273\u1275 \u12f0\u1293\u130d\u120d \u12a3\u1218\u122a\u12ab" },
            { "vi", "\u126c\u1275\u1293\u121d\u129b" },
            { "khq", "\u12ae\u12ed\u122b \u127a\u1292" },
            { "VN", "\u126c\u1275\u1293\u121d" },
            { "vo", "\u126e\u120b\u1351\u12ad" },
            { "VU", "\u126b\u1295\u12cb\u1271" },
            { "rwk", "\u122d\u12cb" },
            { "053", "\u12a3\u12cd\u1235\u1275\u122b\u120c\u12e5\u12eb" },
            { "054", "\u1218\u120b\u1290\u12e5\u12eb" },
            { "WF", "\u12cb\u120a\u1235\u1295 \u1349\u1271\u1293\u1295" },
            { "057", "\u12de\u1263 \u121b\u12ed\u12ad\u122e\u1290\u12e5\u12eb" },
            { "jgo", "\u1295\u130e\u121d\u1263" },
            { "lkt", "\u120b\u12ae\u1273" },
            { "wo", "\u12ce\u120e\u134d" },
            { "wae", "\u12cb\u120d\u1230\u122d" },
            { "zgh", "\u121e\u122e\u12ab\u12ca \u121d\u12f1\u1265 \u1273\u121b\u12db\u12ed\u1275" },
            { "ar_001", "\u12d8\u1218\u1293\u12ca \u121d\u12f1\u1265 \u12d3\u1228\u1265" },
            { "WS", "\u1233\u121e\u12a3" },
            { "XA", "\u1293\u12ed \u1213\u1236\u1275 \u120b\u1205\u1303\u1273\u1275" },
            { "mni", "\u121b\u1292\u1351\u122a" },
            { "XB", "\u1293\u12ed \u1213\u1236\u1275 \u12ad\u120d\u1270 \u12a3\u1295\u1348\u1273\u12ca" },
            { "Latn", metaValue_la },
            { "061", "\u1356\u120a\u1290\u12e5\u12eb" },
            { "xh", "\u12ae\u1233" },
            { "XK", "\u12ae\u1236\u126e" },
            { "Zxxx", "\u12d8\u12ed\u1270\u133b\u1215\u1348" },
            { "kkj", "\u12ab\u12ae" },
            { "YE", "\u12e8\u1218\u1295" },
            { "yi", "\u12ed\u1201\u12f5\u129b" },
            { "yo", "\u12ee\u1229\u1263" },
            { "YT", "\u121b\u12ee\u1275" },
            { "vai", "\u126b\u12ed" },
            { "ZA", "\u12f0\u1261\u1265 \u12a3\u134d\u122a\u1243" },
            { "kln", "\u12ab\u1208\u1295\u1302\u1295" },
            { "zh", "\u127b\u12ed\u1295\u129b" },
            { "ZM", "\u12db\u121d\u1265\u12eb" },
            { "zu", "\u12d9\u1209" },
            { "ZW", "\u12da\u121d\u1263\u1265\u12cc" },
            { "ZZ", "\u12d8\u12ed\u1270\u1348\u120d\u1320 \u12de\u1263" },
            { "lou", "\u12ad\u122d\u12ee\u120d \u1209\u12ca\u12dd\u12eb\u1293" },
            { "ebu", "\u12a4\u121d\u1261" },
            { "jmc", "\u121b\u12ac\u121d" },
            { "zh_Hans", "\u1240\u120a\u120d \u127b\u12ed\u1295\u129b" },
            { "kok", "\u12ae\u1295\u12ab\u1292" },
            { "nus", "\u1295\u12cc\u122d" },
            { "dav", "\u1273\u12ed\u1273" },
            { "lrc", "\u1230\u121c\u1293\u12ca \u1209\u122a" },
            { "zh_Hant", "\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b" },
            { "mua", "\u1219\u1295\u12f3\u1295\u130d" },
            { "mul", "\u12dd\u1270\u1348\u120b\u1208\u12e9 \u124b\u1295\u124b\u1273\u1275" },
            { "sah", "\u1233\u12bb" },
            { "saq", "\u1233\u121d\u1261\u1229" },
            { "fa_AF", "\u12f3\u122a" },
            { "sat", "\u1233\u1295\u1273\u120a" },
            { "key.nu", "\u1241\u133d\u122d\u1273\u1275" },
            { "ksb", "\u123b\u121d\u1263\u120b" },
            { "ksf", "\u1263\u134d\u12eb" },
        };
        return data;
    }
}
