/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.ro;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ro extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Ora Africii Centrale",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Ora standard din Moscova",
               "MST",
               "Ora de var\u0103 din Moscova",
               "MST",
               "Ora din Moscova",
               "MT",
            };
        final String[] Japan = new String[] {
               "Ora standard a Japoniei",
               "JST",
               "Ora de var\u0103 a Japoniei",
               "JDT",
               "Ora Japoniei",
               "JT",
            };
        final String[] Hovd = new String[] {
               "Ora standard din Hovd",
               "HST",
               "Ora de var\u0103 din Hovd",
               "HST",
               "Ora din Hovd",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Ora standard din Magadan",
               "MST",
               "Ora de var\u0103 din Magadan",
               "MST",
               "Ora din Magadan",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standard a Australiei Central Occidentale",
               "ACWST",
               "Ora de var\u0103 a Australiei Central Occidentale",
               "ACWDT",
               "Ora Australiei Central Occidentale",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Ora standard a Europei Centrale",
               "CEST",
               "Ora de var\u0103 a Europei Centrale",
               "CEST",
               "Ora Europei Centrale",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Ora standard din Sahalin",
               "SST",
               "Ora de var\u0103 din Sahalin",
               "SST",
               "Ora din Sahalin",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "Ora standard a Paraguay",
               "PST",
               "Ora de var\u0103 a Paraguay",
               "PST",
               "Ora Paraguay",
               "PT",
            };
        final String[] America_Eastern = new String[] {
               "Ora standard oriental\u0103",
               "EST",
               "Ora de var\u0103 oriental\u0103",
               "EDT",
               "Ora oriental\u0103",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standard Lord Howe",
               "LHST",
               "Ora de var\u0103 Lord Howe",
               "LHDT",
               "Ora Lord Howe",
               "LHT",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora Oceanului Indian",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Ora standard din Yakutsk",
               "YST",
               "Ora de var\u0103 din Yakutsk",
               "YST",
               "Ora din Yakutsk",
               "YT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora Africii Orientale",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Ora Timorului de Est",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standard a Europei de Est",
               "EEST",
               "Ora de var\u0103 a Europei de Est",
               "EEST",
               "Ora Europei de Est",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Ora standard din Newfoundland",
               "NST",
               "Ora de var\u0103 din Newfoundland",
               "NDT",
               "Ora din Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Ora Afganistanului",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Argentina_Western = new String[] {
               "Ora Argentinei Occidentale",
               "WAST",
               "Ora de var\u0103 vestic\u0103 din Argentina",
               "WAST",
               "Ora regiunii vestice din Argentina",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Ora standard \u00een zona Atlantic",
               "AST",
               "Ora de var\u0103 \u00een zona Atlantic",
               "ADT",
               "Ora Atlantic",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "Ora Boliviei",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standard Pierre \u0219i Miquelon",
               "PMST",
               "Ora de var\u0103 Pierre \u0219i Miquelon",
               "PMDT",
               "Ora Pierre \u0219i Miquelon",
               "PMT",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standard din Ekaterinburg",
               "YST",
               "Ora de var\u0103 din Ekaterinburg",
               "YST",
               "Ora din Ekaterinburg",
               "YT",
            };
        final String[] Israel = new String[] {
               "Ora standard a Israelului",
               "IST",
               "Ora de var\u0103 a Israelului",
               "IDT",
               "Ora Israelului",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora regiunii centrale din Indonezia",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora Africii Meridionale",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Ora Syowa",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Omsk = new String[] {
               "Ora standard din Omsk",
               "OST",
               "Ora de var\u0103 din Omsk",
               "OST",
               "Ora din Omsk",
               "OT",
            };
        final String[] Uruguay = new String[] {
               "Ora standard a statului Uruguay",
               "UST",
               "Ora de var\u0103 a statului Uruguay",
               "UST",
               "Ora statului Uruguay",
               "UT",
            };
        final String[] Mongolia = new String[] {
               "Ora standard din Ulan Bator",
               "UBST",
               "Ora de var\u0103 din Ulan Bator",
               "UBST",
               "Ora Ulan Bator",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Ora standard central\u0103",
               "CST",
               "Ora de var\u0103 central\u0103",
               "CDT",
               "Ora Central\u0103",
               "CT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standard din Novosibirsk",
               "NST",
               "Ora de var\u0103 din Novosibirsk",
               "NST",
               "Ora din Novosibirsk",
               "NT",
            };
        final String[] Bhutan = new String[] {
               "Ora Bhutanului",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "Ora Surinamului",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standard din Krasnoiarsk",
               "KST",
               "Ora de var\u0103 din Krasnoiarsk",
               "KST",
               "Ora din Krasnoiarsk",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora vestic\u0103 din Kazahstan",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Amazon = new String[] {
               "Ora standard Amazon",
               "AST",
               "Ora de var\u0103 Amazon",
               "AST",
               "Ora Amazon",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora estic\u0103 din Kazahstan",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Vostok = new String[] {
               "Ora Vostok",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Ora standard Argentinei",
               "AST",
               "Ora de var\u0103 a Argentinei",
               "AST",
               "Ora Argentinei",
               "AT",
            };
        final String[] Macquarie = new String[] {
               "Ora din Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "Ora Venezuelei",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standard a insulelor Aleutine \u015fi a Hawaiului",
               "HAST",
               "Ora de var\u0103 a insulelor Aleutine \u015fi a Hawaiului",
               "HADT",
               "Ora insulelor Aleutine \u015fi a Hawaiului",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Ora standard a Australiei Centrale",
               "ACST",
               "Ora de var\u0103 a Australiei Centrale",
               "ACDT",
               "Ora Australiei Centrale",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Ora standard \u00een zona Pacific",
               "PST",
               "Ora de var\u0103 \u00een zona Pacific",
               "PDT",
               "Ora zonei Pacific",
               "PT",
            };
        final String[] Europe_Western = new String[] {
               "Ora standard a Europei Occidentale",
               "WEST",
               "Ora de var\u0103 a Europei Occidentale",
               "WEST",
               "Ora Europei Occidentale",
               "WET",
            };
        final String[] Guyana = new String[] {
               "Ora Guianei",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Rothera = new String[] {
               "Ora Rothera",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standard a Azerbaidjanului",
               "AST",
               "Ora de var\u0103 a Azerbaidjanului",
               "AST",
               "Ora Azerbaidjanului",
               "AT",
            };
        final String[] Mawson = new String[] {
               "Ora Mawson",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "Ora Davis",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "Ora standard a Cubei",
               "CST",
               "Ora de var\u0103 a Cubei",
               "CDT",
               "Ora Cubei",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Ora standard Africii Occidentale",
               "WAST",
               "Ora de var\u0103 a Africii Occidentale",
               "WAST",
               "Ora Africii Occidentale",
               "WAT",
            };
        final String[] Volgograd = new String[] {
               "Ora standard din Volgograd",
               "VST",
               "Ora de var\u0103 din Volgograd",
               "VST",
               "Ora din Volgograd",
               "VT",
            };
        final String[] Brunei = new String[] {
               "Ora Brunei Darussalam",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora Dumont-d'Urville",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Bangladesh = new String[] {
               "Ora standard din Bangladesh",
               "BST",
               "Ora de var\u0103 din Bangladesh",
               "BST",
               "Ora din Bangladesh",
               "BT",
            };
        final String[] Peru = new String[] {
               "Ora standard din Peru",
               "PST",
               "Ora de var\u0103 din Peru",
               "PST",
               "Ora din Peru",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "Ora standard a Groenlandei occidentale",
               "WGST",
               "Ora de var\u0103 a Groenlandei occidentale",
               "WGST",
               "Ora Groenlandei occidentale",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ora Ecuadorului",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ora standard a Groenlandei orientale",
               "EGST",
               "Ora de var\u0103 a Groenlandei orientale",
               "EGST",
               "Ora Groenlandei orientale",
               "EGT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora regiunii estice din Indonezia",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Ora standard a Coreei",
               "KST",
               "Ora de var\u0103 a Coreei",
               "KDT",
               "Ora Coreei",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Ora standard a Australiei Occidentale",
               "AWST",
               "Ora de var\u0103 a Australiei Occidentale",
               "AWDT",
               "Ora Australiei Occidentale",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora regiunii vestice din Indonezia",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standard a Australiei Orientale",
               "AEST",
               "Ora de var\u0103 a Australiei Orientale",
               "AEDT",
               "Ora Australiei Orientale",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "Ora Guianei Franceze",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "Ora standard a Columbiei",
               "CST",
               "Ora de var\u0103 a Columbiei",
               "CST",
               "Ora Columbiei",
               "CT",
            };
        final String[] Chile = new String[] {
               "Ora standard din Chile",
               "CST",
               "Ora de var\u0103 din Chile",
               "CST",
               "Ora din Chile",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "Ora standard \u00een zona montan\u0103",
               "MST",
               "Ora de var\u0103 \u00een zona montan\u0103",
               "MDT",
               "Ora zonei montane",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Ora standard arab\u0103",
               "AST",
               "Ora de var\u0103 arab\u0103",
               "ADT",
               "Ora arab\u0103",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Ora standard Alaska",
               "AKST",
               "Ora de var\u0103 Alaska",
               "AKDT",
               "Ora Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Ora standard din Vladivostok",
               "VST",
               "Ora de var\u0103 din Vladivostok",
               "VST",
               "Ora din Vladivostok",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "Ora standard din Irkutsk",
               "IST",
               "Ora de var\u0103 din Irkutsk",
               "IST",
               "Ora din Irkutsk",
               "IT",
            };
        final String[] Georgia = new String[] {
               "Ora standard a Georgiei",
               "GST",
               "Ora de var\u0103 a Georgiei",
               "GST",
               "Ora Georgiei",
               "GT",
            };
        final String[] Noronha = new String[] {
               "Ora standard din Fernando de Noronha",
               "FNST",
               "Ora de var\u0103 din Fernando de Noronha",
               "FNST",
               "Ora din Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Ora standard din Choibalsan",
               "CST",
               "Ora de var\u0103 din Choibalsan",
               "CST",
               "Ora din Choibalsan",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Ora standard a Brasiliei",
               "BST",
               "Ora de var\u0103 a Brasiliei",
               "BST",
               "Ora Brasiliei",
               "BT",
            };
        final String[] China = new String[] {
               "Ora standard a Chinei",
               "CST",
               "Ora de var\u0103 a Chinei",
               "CDT",
               "Ora Chinei",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Ora standard Armeniei",
               "AST",
               "Ora de var\u0103 a Armeniei",
               "AST",
               "Ora Armeniei",
               "AT",
            };
        final String[] India = new String[] {
               "Ora standard a Indiei",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "Antarctica/Syowa", Syowa },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "America/Manaus", Amazon },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
