/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.core.actions.HTMLViewAction;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.ui.Bundle;
import org.openide.awt.CheckForUpdatesProvider;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ProductInformationPanel
extends JPanel
implements HyperlinkListener {
    URL url;
    Icon about;
    private static final String CHECK_FOR_UPDATES_ACTION = "check-for-updates";
    private static final int FONT_SIZE = ProductInformationPanel.getFontSize();
    private JTextPane copyright;
    private JTextPane description;
    private JLabel imageLabel;

    public ProductInformationPanel() {
        this.initComponents();
        this.imageLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.description.setText(Bundle.LBL_description(ProductInformationPanel.getProductVersionValue(), ProductInformationPanel.getJavaValue(), ProductInformationPanel.getVMValue(), ProductInformationPanel.getOperatingSystemValue(), ProductInformationPanel.getEncodingValue(), ProductInformationPanel.getSystemLocaleValue(), this.getUserDirValue(), Places.getCacheDirectory().getAbsolutePath(), "", FONT_SIZE, ProductInformationPanel.getJavaRuntime()));
        this.description.setCursor(Cursor.getPredefinedCursor(3));
        this.description.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        RequestProcessor.getDefault().post(() -> {
            String string = ProductInformationPanel.getUpdates();
            SwingUtilities.invokeLater(() -> {
                this.description.setText(Bundle.LBL_description(ProductInformationPanel.getProductVersionValue(), ProductInformationPanel.getJavaValue(), ProductInformationPanel.getVMValue(), ProductInformationPanel.getOperatingSystemValue(), ProductInformationPanel.getEncodingValue(), ProductInformationPanel.getSystemLocaleValue(), this.getUserDirValue(), Places.getCacheDirectory().getAbsolutePath(), string, FONT_SIZE, ProductInformationPanel.getJavaRuntime()));
                this.description.setCursor(null);
                this.description.revalidate();
                this.description.setCaretPosition(0);
            });
        });
        this.description.setCaretPosition(0);
        this.description.addHyperlinkListener(this);
        this.copyright.addHyperlinkListener(this);
        this.copyright.setBackground(this.getBackground());
        this.copyright.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.about = ImageUtilities.image2Icon((Image)Splash.loadContent((boolean)true));
        this.imageLabel.setIcon(this.about);
        this.imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    ProductInformationPanel.this.url = new URL(NbBundle.getMessage(ProductInformationPanel.class, (String)"URL_ON_IMG"));
                    ProductInformationPanel.this.showUrl();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
        this.description.addHyperlinkListener(hyperlinkEvent -> {
            if (HyperlinkEvent.EventType.ENTERED == hyperlinkEvent.getEventType()) {
                if (CHECK_FOR_UPDATES_ACTION.equals(hyperlinkEvent.getDescription())) {
                    this.description.setToolTipText(Bundle.check_for_updates());
                } else if (hyperlinkEvent.getURL() != null) {
                    this.description.setToolTipText(hyperlinkEvent.getURL().toExternalForm());
                }
            } else if (HyperlinkEvent.EventType.EXITED == hyperlinkEvent.getEventType()) {
                this.description.setToolTipText(null);
            } else if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
                if (CHECK_FOR_UPDATES_ACTION.equals(hyperlinkEvent.getDescription())) {
                    ProductInformationPanel.checkForUpdates();
                } else {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(hyperlinkEvent.getURL());
                }
            }
        });
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.copyright = new JTextPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.description = new JTextPane();
        JPanel jPanel2 = new JPanel();
        this.imageLabel = new JLabel();
        jPanel.setLayout(new GridBagLayout());
        jButton.setMnemonic(NbBundle.getMessage(ProductInformationPanel.class, (String)"MNE_Close").charAt(0));
        jButton.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_Close"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProductInformationPanel.this.closeButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        jScrollPane.setBorder(null);
        this.copyright.setEditable(false);
        this.copyright.setBorder(null);
        this.copyright.setContentType("text/html");
        this.copyright.setText(ProductInformationPanel.getCopyrightText());
        this.copyright.setMinimumSize(new Dimension(50, 0));
        this.copyright.setCaretPosition(0);
        this.copyright.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProductInformationPanel.this.copyrightMouseClicked(mouseEvent);
            }
        });
        jScrollPane.setViewportView(this.copyright);
        jScrollPane2.setHorizontalScrollBarPolicy(32);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        this.description.setEditable(false);
        this.description.setContentType("text/html");
        this.description.setText("<div style=\"font-size: 12pt; font-family: Verdana, 'Verdana CE',  Arial, 'Arial CE', 'Lucida Grande CE', lucida, 'Helvetica CE', sans-serif;\">\n    <b>Product Version:</b> {0}<br> <b>Java:</b> {1}; {2}<br> <b>System:</b> {3}; {4}; {5}<br><b>Userdir:</b> {6}</div>");
        jScrollPane2.setViewportView(this.description);
        jPanel2.setLayout(new BorderLayout());
        this.imageLabel.setHorizontalAlignment(0);
        jPanel2.add((Component)this.imageLabel, "Center");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel2, GroupLayout.Alignment.LEADING, -1, 190, Short.MAX_VALUE).addComponent(jScrollPane2, GroupLayout.Alignment.LEADING, -1, 190, Short.MAX_VALUE).addComponent(jScrollPane, -1, 190, Short.MAX_VALUE).addComponent(jPanel, GroupLayout.Alignment.LEADING, -1, 190, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(jPanel2, -1, 79, Short.MAX_VALUE).addGap(14, 14, 14).addComponent(jScrollPane, -1, 70, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jScrollPane2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel, -2, -1, -2).addContainerGap()));
    }

    private void copyrightMouseClicked(MouseEvent mouseEvent) {
        this.showUrl();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void closeDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        window.setVisible(false);
        window.dispose();
    }

    private void showUrl() {
        if (this.url != null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(HTMLViewAction.class, (String)"CTL_OpeningBrowser"));
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.url);
        }
    }

    public static String getProductVersionValue() {
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
    }

    public static String getOperatingSystemValue() {
        return NbBundle.getMessage(ProductInformationPanel.class, (String)"Format_OperatingSystem_Value", (Object)System.getProperty("os.name", "unknown"), (Object)System.getProperty("os.version", "unknown"), (Object)System.getProperty("os.arch", "unknown"));
    }

    public static String getJavaValue() {
        return System.getProperty("java.version", "unknown");
    }

    public static String getVMValue() {
        return System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "");
    }

    public static String getJavaRuntime() {
        return System.getProperty("java.runtime.name", "unknown") + " " + System.getProperty("java.runtime.version", "");
    }

    public static String getSystemLocaleValue() {
        String string;
        return Locale.getDefault().toString() + ((string = NbBundle.getBranding()) == null ? "" : " (" + string + ")");
    }

    private String getUserDirValue() {
        return System.getProperty("netbeans.user");
    }

    public static String getEncodingValue() {
        return System.getProperty("file.encoding", "unknown");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (HyperlinkEvent.EventType.ENTERED == hyperlinkEvent.getEventType()) {
            this.url = hyperlinkEvent.getURL();
        } else if (HyperlinkEvent.EventType.EXITED == hyperlinkEvent.getEventType()) {
            this.url = null;
        }
    }

    private static String getCopyrightText() {
        FileObject[] fileObjectArray;
        String string = NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_Copyright", (Object)FONT_SIZE);
        FileObject fileObject = FileUtil.getConfigFile((String)"About/Licenses");
        if (fileObject != null && (fileObjectArray = fileObject.getChildren()).length > 0) {
            boolean bl = false;
            StringWriter stringWriter = new StringWriter();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string2 = ProductInformationPanel.loadLicenseText(fileObjectArray[i]);
                if (string2 == null) continue;
                stringWriter.write("<br>" + NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_AddOnCopyright", (Object)string2, (Object)FONT_SIZE));
                bl = true;
            }
            if (bl) {
                string = string + stringWriter.toString();
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadLicenseText(FileObject fileObject) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));){
            String string = bufferedReader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String getUpdates() {
        assert (!EventQueue.isDispatchThread()) : "Don't call it from event dispatch thread.";
        CheckForUpdatesProvider checkForUpdatesProvider = (CheckForUpdatesProvider)Lookup.getDefault().lookup(CheckForUpdatesProvider.class);
        if (checkForUpdatesProvider == null) {
            return "";
        }
        String string = checkForUpdatesProvider.getContentDescription();
        String string2 = string = string != null ? string : "";
        if (checkForUpdatesProvider.notifyAvailableUpdates(false)) {
            return Bundle.updates_found(string.isEmpty() ? string : Bundle.to_version(string));
        }
        return string.isEmpty() ? string : Bundle.updates_not_found(string);
    }

    private static void checkForUpdates() {
        assert (EventQueue.isDispatchThread()) : "Call it from event dispatch thread only.";
        CheckForUpdatesProvider checkForUpdatesProvider = (CheckForUpdatesProvider)Lookup.getDefault().lookup(CheckForUpdatesProvider.class);
        if (checkForUpdatesProvider != null) {
            checkForUpdatesProvider.openCheckForUpdatesWizard(true);
        }
    }

    private static int getFontSize() {
        Integer n = (Integer)UIManager.get("customFontSize");
        if (n != null) {
            return n;
        }
        return 12;
    }
}

