/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class AutoConnectAction
extends SingleDataSourceAction<JmxApplication>
implements Presenter.Popup {
    private static AutoConnectAction INSTANCE;
    private boolean currentAutoConnect;

    public static synchronized AutoConnectAction instance() {
        if (INSTANCE == null) {
            INSTANCE = new AutoConnectAction();
        }
        return INSTANCE;
    }

    protected void actionPerformed(final JmxApplication app, ActionEvent actionEvent) {
        final boolean autoConnect = this.currentAutoConnect;
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                if (autoConnect) {
                    app.disableHeartbeat();
                } else {
                    app.enableHeartbeat();
                }
            }
        });
    }

    protected boolean isEnabled(JmxApplication app) {
        return true;
    }

    public JMenuItem getPopupPresenter() {
        JmxApplication app = (JmxApplication)ActionUtils.getSelectedDataSource((Class)this.getScope());
        this.currentAutoConnect = !app.isHeartbeatDisabled();
        JCheckBoxMenuItem presenter = new JCheckBoxMenuItem((Action)((Object)this));
        Mnemonics.setLocalizedText((AbstractButton)presenter, (String)NbBundle.getMessage(AutoConnectAction.class, (String)"LBL_AutoConnect"));
        presenter.setSelected(this.currentAutoConnect);
        return presenter;
    }

    private AutoConnectAction() {
        super(JmxApplication.class);
    }
}

