/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.HostDependentDownloadableContribution;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import processing.app.Platform;

public class ContributedTool {
    private String name;
    private String version;
    private ArrayList<HostDependentDownloadableContribution> systems = new ArrayList();
    private boolean installed;
    private File installedFolder;
    private boolean builtIn;
    private ContributedPackage contributedPackage;

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public List<HostDependentDownloadableContribution> getSystems() {
        return this.systems;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public File getInstalledFolder() {
        return this.installedFolder;
    }

    public void setInstalledFolder(File installedFolder) {
        this.installedFolder = installedFolder;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
    }

    public ContributedPackage getPackage() {
        return this.contributedPackage;
    }

    public void setPackage(ContributedPackage pack) {
        this.contributedPackage = pack;
    }

    public String getPackager() {
        return this.contributedPackage.getName();
    }

    public DownloadableContribution getDownloadableContribution(Platform platform) {
        for (HostDependentDownloadableContribution c : this.getSystems()) {
            if (!c.isCompatible(platform)) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Platform platform) {
        String res = "Tool name : " + this.getName() + " " + this.getVersion() + "\n";
        for (HostDependentDownloadableContribution sys : this.getSystems()) {
            res = res + "     sys";
            if (platform != null) {
                res = res + (sys.isCompatible(platform) ? "*" : " ");
            }
            res = res + " : " + sys + "\n";
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContributedTool)) {
            return false;
        }
        ContributedTool obj1 = (ContributedTool)obj;
        return this.getName().equals(obj1.getName()) && this.getVersion().equals(obj1.getVersion());
    }
}

