/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.utils.network;

import cc.arduino.net.CustomProxySelector;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import java.util.function.Consumer;
import javax.script.ScriptException;
import org.apache.commons.codec.binary.Base64;
import processing.app.PreferencesData;

public class HttpConnectionManager {
    private static final String userAgent;
    private static final int connectTimeout;
    private static final int maxRedirectNumber;
    private final URL requestURL;
    private final String id;

    public HttpConnectionManager(URL requestURL) {
        this.requestURL = requestURL;
        if (requestURL.getHost().endsWith("arduino.cc")) {
            String idString = PreferencesData.get("update.id", "0");
            this.id = Long.toString(Long.parseLong(idString));
        } else {
            this.id = null;
        }
    }

    public HttpURLConnection makeConnection(Consumer<HttpURLConnection> beforeConnection) throws IOException, NoSuchMethodException, ScriptException, URISyntaxException {
        return this.makeConnection(this.requestURL, 0, beforeConnection);
    }

    public HttpURLConnection makeConnection() throws IOException, NoSuchMethodException, ScriptException, URISyntaxException {
        return this.makeConnection(this.requestURL, 0, c -> {});
    }

    private HttpURLConnection makeConnection(URL requestURL, int movedTimes, Consumer<HttpURLConnection> beforeConnection) throws IOException, URISyntaxException, ScriptException, NoSuchMethodException {
        if (movedTimes > maxRedirectNumber) {
            throw new IOException("Too many redirect " + requestURL);
        }
        Proxy proxy = new CustomProxySelector(PreferencesData.getMap()).getProxyFor(requestURL.toURI());
        String requestId = UUID.randomUUID().toString().toUpperCase().replace("-", "").substring(0, 16);
        HttpURLConnection connection = (HttpURLConnection)requestURL.openConnection(proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-agent", userAgent);
        connection.setRequestProperty("X-Request-ID", requestId);
        if (this.id != null) {
            connection.setRequestProperty("X-ID", this.id);
        }
        if (requestURL.getUserInfo() != null) {
            String auth = "Basic " + new String(new Base64().encode(requestURL.getUserInfo().getBytes()));
            connection.setRequestProperty("Authorization", auth);
        }
        int initialSize = 0;
        connection.setRequestProperty("Range", "bytes=" + initialSize + "-");
        connection.setConnectTimeout(connectTimeout);
        beforeConnection.accept(connection);
        connection.connect();
        int resp = connection.getResponseCode();
        if (resp == 301 || resp == 302) {
            URL newUrl = new URL(connection.getHeaderField("Location"));
            return this.makeConnection(newUrl, movedTimes + 1, beforeConnection);
        }
        return connection;
    }

    static {
        String defaultUserAgent = String.format("ArduinoIDE/%s (%s; %s; %s; %s) Java/%s (%s)", "1.8.19", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("user.language"), System.getProperty("java.version"), System.getProperty("java.vendor"));
        userAgent = PreferencesData.get("http.user_agent", defaultUserAgent);
        int connectTimeoutFromConfig = 5000;
        try {
            connectTimeoutFromConfig = PreferencesData.getInteger("http.connection_timeout_ms", 5000);
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing http.connection_timeout_ms config: " + e.getMessage());
        }
        connectTimeout = connectTimeoutFromConfig;
        int maxRedirectNumberConfig = 20;
        try {
            maxRedirectNumberConfig = PreferencesData.getInteger("http.max_redirect_number", 20);
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing http.max_redirect_number config: " + e.getMessage());
        }
        maxRedirectNumber = maxRedirectNumberConfig;
    }
}

