/*
 * Decompiled with CFR 0.152.
 */
package com.thizzer.jtouchbar.javafx;

import com.thizzer.jtouchbar.JTouchBar;
import com.thizzer.jtouchbar.JTouchBarJNI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javafx.stage.Window;

public class JTouchBarJavaFX {
    public static void show(JTouchBar jTouchbar, Window window) {
        long viewPointer = JTouchBarJavaFX.getViewPointer(window);
        JTouchBarJNI.setTouchBar0(viewPointer, jTouchbar);
    }

    public static void hide(Window window) {
        if (window == null) {
            return;
        }
        long viewPointer = JTouchBarJavaFX.getViewPointer(window);
        JTouchBarJNI.setTouchBar0(viewPointer, null);
    }

    private static long getViewPointer(Window window) throws RuntimeException {
        if (window == null) {
            return 0L;
        }
        try {
            return JTouchBarJavaFX.getJavaFXViewPointer0(window);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static native long getJavaFXViewPointer0(Window var0);

    private static void loadLibraryFromJar(String path) throws UnsatisfiedLinkError {
        try (InputStream inputStream2 = JTouchBarJNI.class.getResourceAsStream(path);){
            File tempLib = File.createTempFile(path, "");
            byte[] buffer = new byte[1024];
            int read = -1;
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempLib);){
                while ((read = inputStream2.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, read);
                }
            }
            System.load(tempLib.getAbsolutePath());
        }
        catch (Exception e) {
            throw new UnsatisfiedLinkError("Unable to open " + path + " from jar file.");
        }
    }

    static {
        try {
            System.loadLibrary("JTouchBarJavaFX");
        }
        catch (UnsatisfiedLinkError e) {
            JTouchBarJavaFX.loadLibraryFromJar("/lib/libJTouchBarJavaFX.dylib");
        }
    }
}

