/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.function.Predicate;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.LimitOptions;

final class DatabaseObjectFilter<D extends DatabaseObject>
implements Predicate<D> {
    private final InclusionRule databaseObjectInclusionRule;
    private final InclusionRule schemaInclusionRule;

    DatabaseObjectFilter(LimitOptions options, DatabaseObjectRuleForInclusion databaseObjectRuleForInclusion) {
        this.schemaInclusionRule = options != null ? options.get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion) : new IncludeAll();
        this.databaseObjectInclusionRule = databaseObjectRuleForInclusion != null ? options.get(databaseObjectRuleForInclusion) : new IncludeAll();
    }

    @Override
    public boolean test(D databaseObject) {
        if (databaseObject == null) {
            return false;
        }
        boolean include = true;
        if (include && this.schemaInclusionRule != null) {
            include = this.schemaInclusionRule.test(databaseObject.getSchema().getFullName());
        }
        if (include && this.databaseObjectInclusionRule != null) {
            include = this.databaseObjectInclusionRule.test(databaseObject.getFullName());
        }
        return include;
    }
}

