SELECT
  CURRENT_DATABASE()::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_CATALOG,
  NC.NSPNAME::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_SCHEMA,
  C.RELNAME::INFORMATION_SCHEMA.SQL_IDENTIFIER AS TABLE_NAME,
  C.*
FROM
  PG_CATALOG.PG_CLASS C
  INNER JOIN PG_CATALOG.PG_NAMESPACE NC
    ON C.RELOWNER = NC.NSPOWNER
WHERE
  C.RELKIND IN ('r', 'v')
