//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.8
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Admin_h__
#define __IceGrid_Admin_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Ice/Identity.h>
#include <Ice/BuiltinSequences.h>
#include <Ice/Properties.h>
#include <Ice/SliceChecksumDict.h>
#include <Glacier2/Session.h>
#include <IceGrid/Exception.h>
#include <IceGrid/Descriptor.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 8
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class Admin;
class AdminPrx;
class FileIterator;
class FileIteratorPrx;
class RegistryObserver;
class RegistryObserverPrx;
class NodeObserver;
class NodeObserverPrx;
class ApplicationObserver;
class ApplicationObserverPrx;
class AdapterObserver;
class AdapterObserverPrx;
class ObjectObserver;
class ObjectObserverPrx;
class AdminSession;
class AdminSessionPrx;

}

namespace IceGrid
{

/**
 * An enumeration representing the state of the server.
 */
enum class ServerState : unsigned char
{
    /**
     * The server is not running.
     */
    Inactive,
    /**
     * The server is being activated and will change to the active
     * state when the registered server object adapters are activated
     * or to the activation timed out state if the activation timeout
     * expires.
     */
    Activating,
    /**
     * The activation timed out state indicates that the server
     * activation timed out.
     */
    ActivationTimedOut,
    /**
     * The server is running.
     */
    Active,
    /**
     * The server is being deactivated.
     */
    Deactivating,
    /**
     * The server is being destroyed.
     */
    Destroying,
    /**
     * The server is destroyed.
     */
    Destroyed
};

/**
 * A dictionary of proxies.
 */
using StringObjectProxyDict = ::std::map<::std::string, ::std::shared_ptr<::Ice::ObjectPrx>>;

/**
 * Information about an Ice object.
 * \headerfile IceGrid/IceGrid.h
 */
struct ObjectInfo
{
    /**
     * The proxy of the object.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> proxy;
    /**
     * The type of the object.
     */
    ::std::string type;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::std::string&> ice_tuple() const
    {
        return std::tie(proxy, type);
    }
};

/**
 * A sequence of object information structures.
 */
using ObjectInfoSeq = ::std::vector<ObjectInfo>;

/**
 * Information about an adapter registered with the IceGrid registry.
 * \headerfile IceGrid/IceGrid.h
 */
struct AdapterInfo
{
    /**
     * The id of the adapter.
     */
    ::std::string id;
    /**
     * A dummy direct proxy that contains the adapter endpoints.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> proxy;
    /**
     * The replica group id of the object adapter, or empty if the
     * adapter doesn't belong to a replica group.
     */
    ::std::string replicaGroupId;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, proxy, replicaGroupId);
    }
};

/**
 * A sequence of adapter information structures.
 */
using AdapterInfoSeq = ::std::vector<AdapterInfo>;

/**
 * Information about a server managed by an IceGrid node.
 * \headerfile IceGrid/IceGrid.h
 */
struct ServerInfo
{
    /**
     * The server application.
     */
    ::std::string application;
    /**
     * The application uuid.
     */
    ::std::string uuid;
    /**
     * The application revision.
     */
    int revision;
    /**
     * The server node.
     */
    ::std::string node;
    /**
     * The server descriptor.
     */
    ::std::shared_ptr<::IceGrid::ServerDescriptor> descriptor;
    /**
     * The id of the session which allocated the server.
     */
    ::std::string sessionId;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&, const int&, const ::std::string&, const ::std::shared_ptr<::IceGrid::ServerDescriptor>&, const ::std::string&> ice_tuple() const
    {
        return std::tie(application, uuid, revision, node, descriptor, sessionId);
    }
};

/**
 * Information about an IceGrid node.
 * \headerfile IceGrid/IceGrid.h
 */
struct NodeInfo
{
    /**
     * The name of the node.
     */
    ::std::string name;
    /**
     * The operating system name.
     */
    ::std::string os;
    /**
     * The network name of the host running this node (as defined in
     * uname()).
     */
    ::std::string hostname;
    /**
     * The operation system release level (as defined in uname()).
     */
    ::std::string release;
    /**
     * The operation system version (as defined in uname()).
     */
    ::std::string version;
    /**
     * The machine hardware type (as defined in uname()).
     */
    ::std::string machine;
    /**
     * The number of processor threads on the node.
     * For example, nProcessors is 8 on a computer with a single quad-core
     * processor and two HT threads per core.
     */
    int nProcessors;
    /**
     * The path to the node data directory.
     */
    ::std::string dataDir;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const int&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, os, hostname, release, version, machine, nProcessors, dataDir);
    }
};

/**
 * Information about an IceGrid registry replica.
 * \headerfile IceGrid/IceGrid.h
 */
struct RegistryInfo
{
    /**
     * The name of the registry.
     */
    ::std::string name;
    /**
     * The network name of the host running this registry (as defined in
     * uname()).
     */
    ::std::string hostname;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, hostname);
    }
};

/**
 * A sequence of {@link RegistryInfo} structures.
 */
using RegistryInfoSeq = ::std::vector<RegistryInfo>;

/**
 * Information about the load of a node.
 * \headerfile IceGrid/IceGrid.h
 */
struct LoadInfo
{
    /**
     * The load average over the past minute.
     */
    float avg1;
    /**
     * The load average over the past 5 minutes.
     */
    float avg5;
    /**
     * The load average over the past 15 minutes.
     */
    float avg15;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const float&, const float&, const float&> ice_tuple() const
    {
        return std::tie(avg1, avg5, avg15);
    }
};

/**
 * Information about an IceGrid application.
 * \headerfile IceGrid/IceGrid.h
 */
struct ApplicationInfo
{
    /**
     * Unique application identifier.
     */
    ::std::string uuid;
    /**
     * The creation time.
     */
    long long int createTime;
    /**
     * The user who created the application.
     */
    ::std::string createUser;
    /**
     * The update time.
     */
    long long int updateTime;
    /**
     * The user who updated the application.
     */
    ::std::string updateUser;
    /**
     * The application revision number.
     */
    int revision;
    /**
     * The application descriptor
     */
    ::IceGrid::ApplicationDescriptor descriptor;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const long long int&, const ::std::string&, const long long int&, const ::std::string&, const int&, const ::IceGrid::ApplicationDescriptor&> ice_tuple() const
    {
        return std::tie(uuid, createTime, createUser, updateTime, updateUser, revision, descriptor);
    }
};

/**
 * A sequence of {@link ApplicationInfo} structures.
 */
using ApplicationInfoSeq = ::std::vector<ApplicationInfo>;

/**
 * Information about updates to an IceGrid application.
 * \headerfile IceGrid/IceGrid.h
 */
struct ApplicationUpdateInfo
{
    /**
     * The update time.
     */
    long long int updateTime;
    /**
     * The user who updated the application.
     */
    ::std::string updateUser;
    /**
     * The application revision number.
     */
    int revision;
    /**
     * The update descriptor.
     */
    ::IceGrid::ApplicationUpdateDescriptor descriptor;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const long long int&, const ::std::string&, const int&, const ::IceGrid::ApplicationUpdateDescriptor&> ice_tuple() const
    {
        return std::tie(updateTime, updateUser, revision, descriptor);
    }
};

/**
 * Dynamic information about the state of a server.
 * \headerfile IceGrid/IceGrid.h
 */
struct ServerDynamicInfo
{
    /**
     * The id of the server.
     */
    ::std::string id;
    /**
     * The state of the server.
     */
    ::IceGrid::ServerState state;
    /**
     * The process id of the server.
     */
    int pid;
    /**
     * Indicates whether the server is enabled.
     */
    bool enabled;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::IceGrid::ServerState&, const int&, const bool&> ice_tuple() const
    {
        return std::tie(id, state, pid, enabled);
    }
};

/**
 * A sequence of server dynamic information structures.
 */
using ServerDynamicInfoSeq = ::std::vector<ServerDynamicInfo>;

/**
 * Dynamic information about the state of an adapter.
 * \headerfile IceGrid/IceGrid.h
 */
struct AdapterDynamicInfo
{
    /**
     * The id of the adapter.
     */
    ::std::string id;
    /**
     * The direct proxy containing the adapter endpoints.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> proxy;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&> ice_tuple() const
    {
        return std::tie(id, proxy);
    }
};

/**
 * A sequence of adapter dynamic information structures.
 */
using AdapterDynamicInfoSeq = ::std::vector<AdapterDynamicInfo>;

/**
 * Dynamic information about the state of a node.
 * \headerfile IceGrid/IceGrid.h
 */
struct NodeDynamicInfo
{
    /**
     * Some static information about the node.
     */
    ::IceGrid::NodeInfo info;
    /**
     * The dynamic information of the servers deployed on this node.
     */
    ::IceGrid::ServerDynamicInfoSeq servers;
    /**
     * The dynamic information of the adapters deployed on this node.
     */
    ::IceGrid::AdapterDynamicInfoSeq adapters;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::IceGrid::NodeInfo&, const ::IceGrid::ServerDynamicInfoSeq&, const ::IceGrid::AdapterDynamicInfoSeq&> ice_tuple() const
    {
        return std::tie(info, servers, adapters);
    }
};

/**
 * A sequence of node dynamic information structures.
 */
using NodeDynamicInfoSeq = ::std::vector<NodeDynamicInfo>;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceGrid
{

/**
 * The IceGrid administrative interface.
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Admin : public virtual ::Ice::Object
{
public:

    using ProxyType = AdminPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void addApplication(ApplicationDescriptor descriptor, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void syncApplication(ApplicationDescriptor descriptor, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_syncApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void updateApplication(ApplicationUpdateDescriptor descriptor, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_updateApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void syncApplicationWithoutRestart(ApplicationDescriptor descriptor, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_syncApplicationWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_updateApplicationWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    virtual void removeApplication(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if server instantiation
     * failed.
     */
    virtual void instantiateServer(::std::string application, ::std::string node, ServerInstanceDescriptor desc, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_instantiateServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::PatchException Raised if the patch failed.
     */
    virtual void patchApplicationAsync(::std::string name, bool shutdown, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_patchApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param current The Current object for the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     */
    virtual ApplicationInfo getApplicationInfo(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getApplicationInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the default application descriptor.
     * @param current The Current object for the invocation.
     * @return The default application descriptor.
     * @throws IceGrid::DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     */
    virtual ApplicationDescriptor getDefaultApplicationDescriptor(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getDefaultApplicationDescriptor(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get all the IceGrid applications currently registered.
     * @param current The Current object for the invocation.
     * @return The application names.
     */
    virtual ::Ice::StringSeq getAllApplicationNames(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllApplicationNames(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server information.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual ServerInfo getServerInfo(::std::string id, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a server's state.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server state.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual ServerState getServerState(::std::string id, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerState(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server's process id.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual int getServerPid(::std::string id, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerPid(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param current The Current object for the invocation.
     * @return The category for server admin objects.
     */
    virtual ::std::string getServerAdminCategory(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerAdminCategory(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return A proxy to the server's admin object
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> getServerAdmin(::std::string id, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual void enableServer(::std::string id, bool enabled, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_enableServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return True if the server is enabled.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual bool isServerEnabled(::std::string id, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_isServerEnabled(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStartException Raised if the server couldn't be
     * started.
     */
    virtual void startServerAsync(::std::string id, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_startServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Stop a server.
     * @param id The server id.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStopException Raised if the server couldn't be
     * stopped.
     */
    virtual void stopServerAsync(::std::string id, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_stopServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::PatchException Raised if the patch failed.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual void patchServerAsync(::std::string id, bool shutdown, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_patchServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param current The Current object for the invocation.
     * @throws IceGrid::BadSignalException Raised if the signal is not recognized
     * by the target server.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual void sendSignal(::std::string id, ::std::string signal, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_sendSignal(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get all the server ids registered with IceGrid.
     * @param current The Current object for the invocation.
     * @return The server ids.
     */
    virtual ::Ice::StringSeq getAllServerIds(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllServerIds(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param current The Current object for the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     */
    virtual AdapterInfoSeq getAdapterInfo(::std::string id, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAdapterInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    virtual void removeAdapter(::std::string id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeAdapter(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param current The Current object for the invocation.
     * @return The adapter ids.
     */
    virtual ::Ice::StringSeq getAllAdapterIds(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllAdapterIds(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    virtual void addObject(::std::shared_ptr<::Ice::ObjectPrx> obj, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addObject(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    virtual void updateObject(::std::shared_ptr<::Ice::ObjectPrx> obj, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_updateObject(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    virtual void addObjectWithType(::std::shared_ptr<::Ice::ObjectPrx> obj, ::std::string type, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_addObjectWithType(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    virtual void removeObject(::Ice::Identity id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_removeObject(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param current The Current object for the invocation.
     * @return The object info.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    virtual ObjectInfo getObjectInfo(::Ice::Identity id, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getObjectInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param current The Current object for the invocation.
     * @return The object infos.
     */
    virtual ObjectInfoSeq getObjectInfosByType(::std::string type, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getObjectInfosByType(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param current The Current object for the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     */
    virtual ObjectInfoSeq getAllObjectInfos(::std::string expr, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllObjectInfos(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     */
    virtual bool pingNode(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_pingNode(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node load information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual LoadInfo getNodeLoad(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeLoad(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual NodeInfo getNodeInfo(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param current The Current object for the invocation.
     * @return A proxy to the IceGrid node's admin object
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> getNodeAdmin(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual int getNodeProcessorSocketCount(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeProcessorSocketCount(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual void shutdownNode(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_shutdownNode(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node hostname.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual ::std::string getNodeHostname(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeHostname(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get all the IceGrid nodes currently registered.
     * @param current The Current object for the invocation.
     * @return The node names.
     */
    virtual ::Ice::StringSeq getAllNodeNames(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllNodeNames(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    virtual bool pingRegistry(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_pingRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @return The registry information.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    virtual RegistryInfo getRegistryInfo(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getRegistryInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param current The Current object for the invocation.
     * @return A proxy to the IceGrid registry's admin object
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> getRegistryAdmin(::std::string name, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getRegistryAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    virtual void shutdownRegistry(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_shutdownRegistry(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get all the IceGrid registries currently registered.
     * @param current The Current object for the invocation.
     * @return The registry names.
     */
    virtual ::Ice::StringSeq getAllRegistryNames(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllRegistryNames(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shut down the IceGrid registry.
     * @param current The Current object for the invocation.
     */
    virtual void shutdown(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * This interface provides access to IceGrid log file contents.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API FileIterator : public virtual ::Ice::Object
{
public:

    using ProxyType = FileIteratorPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Encapsulates the results of a call to read.
     */
    struct ReadResult
    {
        /** True if EOF is encountered. */
        bool returnValue;
        /** The lines read from the file. */
        ::Ice::StringSeq lines;
    };

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * @param current The Current object for the invocation.
     * @return True if EOF is encountered.
     * @throws IceGrid::FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     */
    virtual bool read(int size, ::Ice::StringSeq& lines, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_read(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the iterator.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * This interface allows applications to monitor changes the state
 * of the registry.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API RegistryObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = RegistryObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param current The Current object for the invocation.
     */
    virtual void registryInit(RegistryInfoSeq registries, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registryInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param current The Current object for the invocation.
     */
    virtual void registryUp(RegistryInfo node, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registryUp(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param current The Current object for the invocation.
     */
    virtual void registryDown(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registryDown(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The node observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * nodes.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API NodeObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = NodeObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param current The Current object for the invocation.
     */
    virtual void nodeInit(NodeDynamicInfoSeq nodes, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_nodeInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param current The Current object for the invocation.
     */
    virtual void nodeUp(NodeDynamicInfo node, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_nodeUp(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param current The Current object for the invocation.
     */
    virtual void nodeDown(::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_nodeDown(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param current The Current object for the invocation.
     */
    virtual void updateServer(::std::string node, ServerDynamicInfo updatedInfo, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_updateServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param current The Current object for the invocation.
     */
    virtual void updateAdapter(::std::string node, AdapterDynamicInfo updatedInfo, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_updateAdapter(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ApplicationObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = ApplicationObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param current The Current object for the invocation.
     */
    virtual void applicationInit(int serial, ApplicationInfoSeq applications, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_applicationInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param current The Current object for the invocation.
     */
    virtual void applicationAdded(int serial, ApplicationInfo desc, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_applicationAdded(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param current The Current object for the invocation.
     */
    virtual void applicationRemoved(int serial, ::std::string name, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_applicationRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param current The Current object for the invocation.
     */
    virtual void applicationUpdated(int serial, ApplicationUpdateInfo desc, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_applicationUpdated(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * This interface allows applications to monitor the state of object
 * adapters that are registered with IceGrid.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AdapterObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = AdapterObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param current The Current object for the invocation.
     */
    virtual void adapterInit(AdapterInfoSeq adpts, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param current The Current object for the invocation.
     */
    virtual void adapterAdded(AdapterInfo info, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterAdded(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param current The Current object for the invocation.
     */
    virtual void adapterUpdated(AdapterInfo info, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterUpdated(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param current The Current object for the invocation.
     */
    virtual void adapterRemoved(::std::string id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * This interface allows applications to monitor IceGrid well-known objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ObjectObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = ObjectObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param current The Current object for the invocation.
     */
    virtual void objectInit(ObjectInfoSeq objects, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_objectInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param current The Current object for the invocation.
     */
    virtual void objectAdded(ObjectInfo info, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_objectAdded(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param current The Current object for the invocation.
     */
    virtual void objectUpdated(ObjectInfo info, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_objectUpdated(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param current The Current object for the invocation.
     */
    virtual void objectRemoved(::Ice::Identity id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_objectRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either via the {@link Registry}
 * object or via the registry admin <code>SessionManager</code> object.
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AdminSession : public virtual ::Glacier2::Session
{
public:

    using ProxyType = AdminSessionPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param current The Current object for the invocation.
     * @see Registry#getSessionTimeout
     */
    virtual void keepAlive(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param current The Current object for the invocation.
     * @return The admin interface proxy.
     */
    virtual ::std::shared_ptr<AdminPrx> getAdmin(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param current The Current object for the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> getAdminCallbackTemplate(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAdminCallbackTemplate(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param current The Current object for the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    virtual void setObservers(::std::shared_ptr<RegistryObserverPrx> registryObs, ::std::shared_ptr<NodeObserverPrx> nodeObs, ::std::shared_ptr<ApplicationObserverPrx> appObs, ::std::shared_ptr<AdapterObserverPrx> adptObs, ::std::shared_ptr<ObjectObserverPrx> objObs, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setObservers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param current The Current object for the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    virtual void setObserversByIdentity(::Ice::Identity registryObs, ::Ice::Identity nodeObs, ::Ice::Identity appObs, ::Ice::Identity adptObs, ::Ice::Identity objObs, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setObserversByIdentity(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param current The Current object for the invocation.
     * @return The current serial.
     * @throws IceGrid::AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     */
    virtual int startUpdate(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_startUpdate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     */
    virtual void finishUpdate(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_finishUpdate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the name of the registry replica hosting this session.
     * @param current The Current object for the invocation.
     * @return The replica name of the registry.
     */
    virtual ::std::string getReplicaName(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getReplicaName(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual ::std::shared_ptr<FileIteratorPrx> openServerLog(::std::string id, ::std::string path, int count, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_openServerLog(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual ::std::shared_ptr<FileIteratorPrx> openServerStdErr(::std::string id, int count, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_openServerStdErr(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual ::std::shared_ptr<FileIteratorPrx> openServerStdOut(::std::string id, int count, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_openServerStdOut(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    virtual ::std::shared_ptr<FileIteratorPrx> openNodeStdErr(::std::string name, int count, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_openNodeStdErr(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    virtual ::std::shared_ptr<FileIteratorPrx> openNodeStdOut(::std::string name, int count, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_openNodeStdOut(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    virtual ::std::shared_ptr<FileIteratorPrx> openRegistryStdErr(::std::string name, int count, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_openRegistryStdErr(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    virtual ::std::shared_ptr<FileIteratorPrx> openRegistryStdOut(::std::string name, int count, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_openRegistryStdOut(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceGrid
{

/**
 * The IceGrid administrative interface.
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) AdminPrx : public virtual ::Ice::Proxy<AdminPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    void addApplication(const ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_addApplication, descriptor, context).get();
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addApplicationAsync(const ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_addApplication, descriptor, context);
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addApplicationAsync(const ApplicationDescriptor& descriptor,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_addApplication, descriptor, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_addApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ApplicationDescriptor&, const ::Ice::Context&);
    /// \endcond

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    void syncApplication(const ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_syncApplication, descriptor, context).get();
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto syncApplicationAsync(const ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_syncApplication, descriptor, context);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    syncApplicationAsync(const ApplicationDescriptor& descriptor,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_syncApplication, descriptor, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_syncApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ApplicationDescriptor&, const ::Ice::Context&);
    /// \endcond

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    void updateApplication(const ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_updateApplication, descriptor, context).get();
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto updateApplicationAsync(const ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_updateApplication, descriptor, context);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    updateApplicationAsync(const ApplicationUpdateDescriptor& descriptor,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_updateApplication, descriptor, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_updateApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ApplicationUpdateDescriptor&, const ::Ice::Context&);
    /// \endcond

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    void syncApplicationWithoutRestart(const ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_syncApplicationWithoutRestart, descriptor, context).get();
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto syncApplicationWithoutRestartAsync(const ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_syncApplicationWithoutRestart, descriptor, context);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    syncApplicationWithoutRestartAsync(const ApplicationDescriptor& descriptor,
                                       ::std::function<void()> response,
                                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                       ::std::function<void(bool)> sent = nullptr,
                                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_syncApplicationWithoutRestart, descriptor, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_syncApplicationWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ApplicationDescriptor&, const ::Ice::Context&);
    /// \endcond

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    void updateApplicationWithoutRestart(const ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_updateApplicationWithoutRestart, descriptor, context).get();
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto updateApplicationWithoutRestartAsync(const ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_updateApplicationWithoutRestart, descriptor, context);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    updateApplicationWithoutRestartAsync(const ApplicationUpdateDescriptor& descriptor,
                                         ::std::function<void()> response,
                                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                         ::std::function<void(bool)> sent = nullptr,
                                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_updateApplicationWithoutRestart, descriptor, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_updateApplicationWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ApplicationUpdateDescriptor&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    void removeApplication(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_removeApplication, name, context).get();
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeApplicationAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_removeApplication, name, context);
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeApplicationAsync(const ::std::string& name,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_removeApplication, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_removeApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if server instantiation
     * failed.
     */
    void instantiateServer(const ::std::string& application, const ::std::string& node, const ServerInstanceDescriptor& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_instantiateServer, application, node, desc, context).get();
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto instantiateServerAsync(const ::std::string& application, const ::std::string& node, const ServerInstanceDescriptor& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_instantiateServer, application, node, desc, context);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    instantiateServerAsync(const ::std::string& application, const ::std::string& node, const ServerInstanceDescriptor& desc,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_instantiateServer, application, node, desc, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_instantiateServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ServerInstanceDescriptor&, const ::Ice::Context&);
    /// \endcond

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::PatchException Raised if the patch failed.
     */
    void patchApplication(const ::std::string& name, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_patchApplication, name, shutdown, context).get();
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto patchApplicationAsync(const ::std::string& name, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_patchApplication, name, shutdown, context);
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    patchApplicationAsync(const ::std::string& name, bool shutdown,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_patchApplication, name, shutdown, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_patchApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     */
    ApplicationInfo getApplicationInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationInfo>(true, this, &AdminPrx::_iceI_getApplicationInfo, name, context).get();
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getApplicationInfoAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ApplicationInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationInfo, P>(false, this, &AdminPrx::_iceI_getApplicationInfo, name, context);
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getApplicationInfoAsync(const ::std::string& name,
                            ::std::function<void(::IceGrid::ApplicationInfo)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ApplicationInfo>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getApplicationInfo, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getApplicationInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationInfo>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the default application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The default application descriptor.
     * @throws IceGrid::DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     */
    ApplicationDescriptor getDefaultApplicationDescriptor(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationDescriptor>(true, this, &AdminPrx::_iceI_getDefaultApplicationDescriptor, context).get();
    }

    /**
     * Get the default application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getDefaultApplicationDescriptorAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ApplicationDescriptor>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationDescriptor, P>(false, this, &AdminPrx::_iceI_getDefaultApplicationDescriptor, context);
    }

    /**
     * Get the default application descriptor.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getDefaultApplicationDescriptorAsync(::std::function<void(::IceGrid::ApplicationDescriptor)> response,
                                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                         ::std::function<void(bool)> sent = nullptr,
                                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ApplicationDescriptor>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getDefaultApplicationDescriptor, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getDefaultApplicationDescriptor(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationDescriptor>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get all the IceGrid applications currently registered.
     * @param context The Context map to send with the invocation.
     * @return The application names.
     */
    ::Ice::StringSeq getAllApplicationNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &AdminPrx::_iceI_getAllApplicationNames, context).get();
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAllApplicationNamesAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &AdminPrx::_iceI_getAllApplicationNames, context);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAllApplicationNamesAsync(::std::function<void(::Ice::StringSeq)> response,
                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                ::std::function<void(bool)> sent = nullptr,
                                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getAllApplicationNames, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAllApplicationNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server information.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ServerInfo getServerInfo(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ServerInfo>(true, this, &AdminPrx::_iceI_getServerInfo, id, context).get();
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getServerInfoAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ServerInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ServerInfo, P>(false, this, &AdminPrx::_iceI_getServerInfo, id, context);
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getServerInfoAsync(const ::std::string& id,
                       ::std::function<void(::IceGrid::ServerInfo)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ServerInfo>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getServerInfo, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getServerInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ServerInfo>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a server's state.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server state.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ServerState getServerState(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ServerState>(true, this, &AdminPrx::_iceI_getServerState, id, context).get();
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getServerStateAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ServerState>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ServerState, P>(false, this, &AdminPrx::_iceI_getServerState, id, context);
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getServerStateAsync(const ::std::string& id,
                        ::std::function<void(::IceGrid::ServerState)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ServerState>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getServerState, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getServerState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ServerState>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server's process id.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    int getServerPid(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &AdminPrx::_iceI_getServerPid, id, context).get();
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getServerPidAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &AdminPrx::_iceI_getServerPid, id, context);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getServerPidAsync(const ::std::string& id,
                      ::std::function<void(int)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getServerPid, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getServerPid(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param context The Context map to send with the invocation.
     * @return The category for server admin objects.
     */
    ::std::string getServerAdminCategory(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &AdminPrx::_iceI_getServerAdminCategory, context).get();
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getServerAdminCategoryAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &AdminPrx::_iceI_getServerAdminCategory, context);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getServerAdminCategoryAsync(::std::function<void(::std::string)> response,
                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                ::std::function<void(bool)> sent = nullptr,
                                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getServerAdminCategory, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getServerAdminCategory(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the server's admin object
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> getServerAdmin(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &AdminPrx::_iceI_getServerAdmin, id, context).get();
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getServerAdminAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &AdminPrx::_iceI_getServerAdmin, id, context);
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getServerAdminAsync(const ::std::string& id,
                        ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getServerAdmin, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getServerAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    void enableServer(const ::std::string& id, bool enabled, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_enableServer, id, enabled, context).get();
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto enableServerAsync(const ::std::string& id, bool enabled, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_enableServer, id, enabled, context);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    enableServerAsync(const ::std::string& id, bool enabled,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_enableServer, id, enabled, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_enableServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return True if the server is enabled.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    bool isServerEnabled(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &AdminPrx::_iceI_isServerEnabled, id, context).get();
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto isServerEnabledAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &AdminPrx::_iceI_isServerEnabled, id, context);
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    isServerEnabledAsync(const ::std::string& id,
                         ::std::function<void(bool)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_isServerEnabled, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_isServerEnabled(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStartException Raised if the server couldn't be
     * started.
     */
    void startServer(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_startServer, id, context).get();
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto startServerAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_startServer, id, context);
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    startServerAsync(const ::std::string& id,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_startServer, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_startServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Stop a server.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStopException Raised if the server couldn't be
     * stopped.
     */
    void stopServer(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_stopServer, id, context).get();
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto stopServerAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_stopServer, id, context);
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    stopServerAsync(const ::std::string& id,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_stopServer, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_stopServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::PatchException Raised if the patch failed.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    void patchServer(const ::std::string& id, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_patchServer, id, shutdown, context).get();
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto patchServerAsync(const ::std::string& id, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_patchServer, id, shutdown, context);
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    patchServerAsync(const ::std::string& id, bool shutdown,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_patchServer, id, shutdown, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_patchServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::BadSignalException Raised if the signal is not recognized
     * by the target server.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    void sendSignal(const ::std::string& id, const ::std::string& signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_sendSignal, id, signal, context).get();
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto sendSignalAsync(const ::std::string& id, const ::std::string& signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_sendSignal, id, signal, context);
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    sendSignalAsync(const ::std::string& id, const ::std::string& signal,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_sendSignal, id, signal, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_sendSignal(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get all the server ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The server ids.
     */
    ::Ice::StringSeq getAllServerIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &AdminPrx::_iceI_getAllServerIds, context).get();
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAllServerIdsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &AdminPrx::_iceI_getAllServerIds, context);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAllServerIdsAsync(::std::function<void(::Ice::StringSeq)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getAllServerIds, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAllServerIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     */
    AdapterInfoSeq getAdapterInfo(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::AdapterInfoSeq>(true, this, &AdminPrx::_iceI_getAdapterInfo, id, context).get();
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAdapterInfoAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::AdapterInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::AdapterInfoSeq, P>(false, this, &AdminPrx::_iceI_getAdapterInfo, id, context);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAdapterInfoAsync(const ::std::string& id,
                        ::std::function<void(::IceGrid::AdapterInfoSeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::AdapterInfoSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getAdapterInfo, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAdapterInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::AdapterInfoSeq>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    void removeAdapter(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_removeAdapter, id, context).get();
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeAdapterAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_removeAdapter, id, context);
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeAdapterAsync(const ::std::string& id,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_removeAdapter, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_removeAdapter(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The adapter ids.
     */
    ::Ice::StringSeq getAllAdapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &AdminPrx::_iceI_getAllAdapterIds, context).get();
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAllAdapterIdsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &AdminPrx::_iceI_getAllAdapterIds, context);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAllAdapterIdsAsync(::std::function<void(::Ice::StringSeq)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getAllAdapterIds, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAllAdapterIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    void addObject(const ::std::shared_ptr<::Ice::ObjectPrx>& obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_addObject, obj, context).get();
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addObjectAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_addObject, obj, context);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addObjectAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& obj,
                   ::std::function<void()> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_addObject, obj, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_addObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    void updateObject(const ::std::shared_ptr<::Ice::ObjectPrx>& obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_updateObject, obj, context).get();
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto updateObjectAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_updateObject, obj, context);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    updateObjectAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& obj,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_updateObject, obj, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_updateObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    void addObjectWithType(const ::std::shared_ptr<::Ice::ObjectPrx>& obj, const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_addObjectWithType, obj, type, context).get();
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto addObjectWithTypeAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& obj, const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_addObjectWithType, obj, type, context);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    addObjectWithTypeAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& obj, const ::std::string& type,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_addObjectWithType, obj, type, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_addObjectWithType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    void removeObject(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_removeObject, id, context).get();
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto removeObjectAsync(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_removeObject, id, context);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    removeObjectAsync(const ::Ice::Identity& id,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_removeObject, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_removeObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param context The Context map to send with the invocation.
     * @return The object info.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    ObjectInfo getObjectInfo(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfo>(true, this, &AdminPrx::_iceI_getObjectInfo, id, context).get();
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getObjectInfoAsync(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ObjectInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfo, P>(false, this, &AdminPrx::_iceI_getObjectInfo, id, context);
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getObjectInfoAsync(const ::Ice::Identity& id,
                       ::std::function<void(::IceGrid::ObjectInfo)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ObjectInfo>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getObjectInfo, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getObjectInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfo>>&, const ::Ice::Identity&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The object infos.
     */
    ObjectInfoSeq getObjectInfosByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfoSeq>(true, this, &AdminPrx::_iceI_getObjectInfosByType, type, context).get();
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getObjectInfosByTypeAsync(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ObjectInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfoSeq, P>(false, this, &AdminPrx::_iceI_getObjectInfosByType, type, context);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getObjectInfosByTypeAsync(const ::std::string& type,
                              ::std::function<void(::IceGrid::ObjectInfoSeq)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ObjectInfoSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getObjectInfosByType, type, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getObjectInfosByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfoSeq>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param context The Context map to send with the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     */
    ObjectInfoSeq getAllObjectInfos(const ::std::string& expr, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfoSeq>(true, this, &AdminPrx::_iceI_getAllObjectInfos, expr, context).get();
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAllObjectInfosAsync(const ::std::string& expr, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ObjectInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfoSeq, P>(false, this, &AdminPrx::_iceI_getAllObjectInfos, expr, context);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAllObjectInfosAsync(const ::std::string& expr,
                           ::std::function<void(::IceGrid::ObjectInfoSeq)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ObjectInfoSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getAllObjectInfos, expr, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAllObjectInfos(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfoSeq>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     */
    bool pingNode(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &AdminPrx::_iceI_pingNode, name, context).get();
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto pingNodeAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &AdminPrx::_iceI_pingNode, name, context);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    pingNodeAsync(const ::std::string& name,
                  ::std::function<void(bool)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_pingNode, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_pingNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node load information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    LoadInfo getNodeLoad(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::LoadInfo>(true, this, &AdminPrx::_iceI_getNodeLoad, name, context).get();
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getNodeLoadAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::LoadInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::LoadInfo, P>(false, this, &AdminPrx::_iceI_getNodeLoad, name, context);
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getNodeLoadAsync(const ::std::string& name,
                     ::std::function<void(::IceGrid::LoadInfo)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::LoadInfo>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getNodeLoad, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeLoad(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::LoadInfo>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    NodeInfo getNodeInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::NodeInfo>(true, this, &AdminPrx::_iceI_getNodeInfo, name, context).get();
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getNodeInfoAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::NodeInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::NodeInfo, P>(false, this, &AdminPrx::_iceI_getNodeInfo, name, context);
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getNodeInfoAsync(const ::std::string& name,
                     ::std::function<void(::IceGrid::NodeInfo)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::NodeInfo>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getNodeInfo, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::NodeInfo>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid node's admin object
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> getNodeAdmin(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &AdminPrx::_iceI_getNodeAdmin, name, context).get();
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getNodeAdminAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &AdminPrx::_iceI_getNodeAdmin, name, context);
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getNodeAdminAsync(const ::std::string& name,
                      ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getNodeAdmin, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    int getNodeProcessorSocketCount(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &AdminPrx::_iceI_getNodeProcessorSocketCount, name, context).get();
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getNodeProcessorSocketCountAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &AdminPrx::_iceI_getNodeProcessorSocketCount, name, context);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getNodeProcessorSocketCountAsync(const ::std::string& name,
                                     ::std::function<void(int)> response,
                                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                     ::std::function<void(bool)> sent = nullptr,
                                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getNodeProcessorSocketCount, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeProcessorSocketCount(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    void shutdownNode(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_shutdownNode, name, context).get();
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto shutdownNodeAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_shutdownNode, name, context);
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    shutdownNodeAsync(const ::std::string& name,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_shutdownNode, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_shutdownNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node hostname.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ::std::string getNodeHostname(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &AdminPrx::_iceI_getNodeHostname, name, context).get();
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getNodeHostnameAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &AdminPrx::_iceI_getNodeHostname, name, context);
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getNodeHostnameAsync(const ::std::string& name,
                         ::std::function<void(::std::string)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getNodeHostname, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeHostname(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get all the IceGrid nodes currently registered.
     * @param context The Context map to send with the invocation.
     * @return The node names.
     */
    ::Ice::StringSeq getAllNodeNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &AdminPrx::_iceI_getAllNodeNames, context).get();
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAllNodeNamesAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &AdminPrx::_iceI_getAllNodeNames, context);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAllNodeNamesAsync(::std::function<void(::Ice::StringSeq)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getAllNodeNames, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAllNodeNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    bool pingRegistry(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &AdminPrx::_iceI_pingRegistry, name, context).get();
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto pingRegistryAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &AdminPrx::_iceI_pingRegistry, name, context);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    pingRegistryAsync(const ::std::string& name,
                      ::std::function<void(bool)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_pingRegistry, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_pingRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The registry information.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    RegistryInfo getRegistryInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::RegistryInfo>(true, this, &AdminPrx::_iceI_getRegistryInfo, name, context).get();
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getRegistryInfoAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::RegistryInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::RegistryInfo, P>(false, this, &AdminPrx::_iceI_getRegistryInfo, name, context);
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getRegistryInfoAsync(const ::std::string& name,
                         ::std::function<void(::IceGrid::RegistryInfo)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::RegistryInfo>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getRegistryInfo, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getRegistryInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::RegistryInfo>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid registry's admin object
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> getRegistryAdmin(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &AdminPrx::_iceI_getRegistryAdmin, name, context).get();
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getRegistryAdminAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &AdminPrx::_iceI_getRegistryAdmin, name, context);
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getRegistryAdminAsync(const ::std::string& name,
                          ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getRegistryAdmin, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getRegistryAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    void shutdownRegistry(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_shutdownRegistry, name, context).get();
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto shutdownRegistryAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_shutdownRegistry, name, context);
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    shutdownRegistryAsync(const ::std::string& name,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_shutdownRegistry, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_shutdownRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get all the IceGrid registries currently registered.
     * @param context The Context map to send with the invocation.
     * @return The registry names.
     */
    ::Ice::StringSeq getAllRegistryNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &AdminPrx::_iceI_getAllRegistryNames, context).get();
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAllRegistryNamesAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &AdminPrx::_iceI_getAllRegistryNames, context);
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAllRegistryNamesAsync(::std::function<void(::Ice::StringSeq)> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getAllRegistryNames, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAllRegistryNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Shut down the IceGrid registry.
     * @param context The Context map to send with the invocation.
     */
    void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminPrx::_iceI_shutdown, context).get();
    }

    /**
     * Shut down the IceGrid registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto shutdownAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminPrx::_iceI_shutdown, context);
    }

    /**
     * Shut down the IceGrid registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    shutdownAsync(::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_shutdown, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict>(true, this, &AdminPrx::_iceI_getSliceChecksums, context).get();
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getSliceChecksumsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::SliceChecksumDict>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict, P>(false, this, &AdminPrx::_iceI_getSliceChecksums, context);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getSliceChecksumsAsync(::std::function<void(::Ice::SliceChecksumDict)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::SliceChecksumDict>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminPrx::_iceI_getSliceChecksums, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    AdminPrx() = default;
    friend ::std::shared_ptr<AdminPrx> IceInternal::createProxy<AdminPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * This interface provides access to IceGrid log file contents.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) FileIteratorPrx : public virtual ::Ice::Proxy<FileIteratorPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * @param context The Context map to send with the invocation.
     * @return True if EOF is encountered.
     * @throws IceGrid::FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     */
    bool read(int size, ::Ice::StringSeq& lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<FileIterator::ReadResult>(true, this, &FileIteratorPrx::_iceI_read, size, context).get();
        lines = ::std::move(_result.lines);
        return _result.returnValue;
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto readAsync(int size, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<FileIterator::ReadResult>>().get_future())
    {
        return _makePromiseOutgoing<FileIterator::ReadResult, P>(false, this, &FileIteratorPrx::_iceI_read, size, context);
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    readAsync(int size,
              ::std::function<void(bool, ::Ice::StringSeq)> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](FileIterator::ReadResult&& _result)
        {
            response(_result.returnValue, ::std::move(_result.lines));
        };
        return _makeLamdaOutgoing<FileIterator::ReadResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &IceGrid::FileIteratorPrx::_iceI_read, size, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_read(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<FileIterator::ReadResult>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the iterator.
     * @param context The Context map to send with the invocation.
     */
    void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &FileIteratorPrx::_iceI_destroy, context).get();
    }

    /**
     * Destroy the iterator.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &FileIteratorPrx::_iceI_destroy, context);
    }

    /**
     * Destroy the iterator.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::FileIteratorPrx::_iceI_destroy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    FileIteratorPrx() = default;
    friend ::std::shared_ptr<FileIteratorPrx> IceInternal::createProxy<FileIteratorPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * This interface allows applications to monitor changes the state
 * of the registry.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) RegistryObserverPrx : public virtual ::Ice::Proxy<RegistryObserverPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param context The Context map to send with the invocation.
     */
    void registryInit(const RegistryInfoSeq& registries, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &RegistryObserverPrx::_iceI_registryInit, registries, context).get();
    }

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registryInitAsync(const RegistryInfoSeq& registries, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &RegistryObserverPrx::_iceI_registryInit, registries, context);
    }

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registryInitAsync(const RegistryInfoSeq& registries,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryObserverPrx::_iceI_registryInit, registries, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_registryInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const RegistryInfoSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     */
    void registryUp(const RegistryInfo& node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &RegistryObserverPrx::_iceI_registryUp, node, context).get();
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registryUpAsync(const RegistryInfo& node, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &RegistryObserverPrx::_iceI_registryUp, node, context);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registryUpAsync(const RegistryInfo& node,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryObserverPrx::_iceI_registryUp, node, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_registryUp(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const RegistryInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     */
    void registryDown(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &RegistryObserverPrx::_iceI_registryDown, name, context).get();
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registryDownAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &RegistryObserverPrx::_iceI_registryDown, name, context);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registryDownAsync(const ::std::string& name,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::RegistryObserverPrx::_iceI_registryDown, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_registryDown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    RegistryObserverPrx() = default;
    friend ::std::shared_ptr<RegistryObserverPrx> IceInternal::createProxy<RegistryObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The node observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * nodes.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) NodeObserverPrx : public virtual ::Ice::Proxy<NodeObserverPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param context The Context map to send with the invocation.
     */
    void nodeInit(const NodeDynamicInfoSeq& nodes, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeObserverPrx::_iceI_nodeInit, nodes, context).get();
    }

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto nodeInitAsync(const NodeDynamicInfoSeq& nodes, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeObserverPrx::_iceI_nodeInit, nodes, context);
    }

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    nodeInitAsync(const NodeDynamicInfoSeq& nodes,
                  ::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeObserverPrx::_iceI_nodeInit, nodes, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_nodeInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const NodeDynamicInfoSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     */
    void nodeUp(const NodeDynamicInfo& node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeObserverPrx::_iceI_nodeUp, node, context).get();
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto nodeUpAsync(const NodeDynamicInfo& node, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeObserverPrx::_iceI_nodeUp, node, context);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    nodeUpAsync(const NodeDynamicInfo& node,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeObserverPrx::_iceI_nodeUp, node, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_nodeUp(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const NodeDynamicInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     */
    void nodeDown(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeObserverPrx::_iceI_nodeDown, name, context).get();
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto nodeDownAsync(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeObserverPrx::_iceI_nodeDown, name, context);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    nodeDownAsync(const ::std::string& name,
                  ::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeObserverPrx::_iceI_nodeDown, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_nodeDown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param context The Context map to send with the invocation.
     */
    void updateServer(const ::std::string& node, const ServerDynamicInfo& updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeObserverPrx::_iceI_updateServer, node, updatedInfo, context).get();
    }

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto updateServerAsync(const ::std::string& node, const ServerDynamicInfo& updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeObserverPrx::_iceI_updateServer, node, updatedInfo, context);
    }

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    updateServerAsync(const ::std::string& node, const ServerDynamicInfo& updatedInfo,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeObserverPrx::_iceI_updateServer, node, updatedInfo, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_updateServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ServerDynamicInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param context The Context map to send with the invocation.
     */
    void updateAdapter(const ::std::string& node, const AdapterDynamicInfo& updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeObserverPrx::_iceI_updateAdapter, node, updatedInfo, context).get();
    }

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto updateAdapterAsync(const ::std::string& node, const AdapterDynamicInfo& updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeObserverPrx::_iceI_updateAdapter, node, updatedInfo, context);
    }

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    updateAdapterAsync(const ::std::string& node, const AdapterDynamicInfo& updatedInfo,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeObserverPrx::_iceI_updateAdapter, node, updatedInfo, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_updateAdapter(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const AdapterDynamicInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    NodeObserverPrx() = default;
    friend ::std::shared_ptr<NodeObserverPrx> IceInternal::createProxy<NodeObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ApplicationObserverPrx : public virtual ::Ice::Proxy<ApplicationObserverPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param context The Context map to send with the invocation.
     */
    void applicationInit(int serial, const ApplicationInfoSeq& applications, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ApplicationObserverPrx::_iceI_applicationInit, serial, applications, context).get();
    }

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto applicationInitAsync(int serial, const ApplicationInfoSeq& applications, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ApplicationObserverPrx::_iceI_applicationInit, serial, applications, context);
    }

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    applicationInitAsync(int serial, const ApplicationInfoSeq& applications,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ApplicationObserverPrx::_iceI_applicationInit, serial, applications, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_applicationInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ApplicationInfoSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param context The Context map to send with the invocation.
     */
    void applicationAdded(int serial, const ApplicationInfo& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ApplicationObserverPrx::_iceI_applicationAdded, serial, desc, context).get();
    }

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto applicationAddedAsync(int serial, const ApplicationInfo& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ApplicationObserverPrx::_iceI_applicationAdded, serial, desc, context);
    }

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    applicationAddedAsync(int serial, const ApplicationInfo& desc,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ApplicationObserverPrx::_iceI_applicationAdded, serial, desc, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_applicationAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ApplicationInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param context The Context map to send with the invocation.
     */
    void applicationRemoved(int serial, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ApplicationObserverPrx::_iceI_applicationRemoved, serial, name, context).get();
    }

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto applicationRemovedAsync(int serial, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ApplicationObserverPrx::_iceI_applicationRemoved, serial, name, context);
    }

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    applicationRemovedAsync(int serial, const ::std::string& name,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ApplicationObserverPrx::_iceI_applicationRemoved, serial, name, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_applicationRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param context The Context map to send with the invocation.
     */
    void applicationUpdated(int serial, const ApplicationUpdateInfo& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ApplicationObserverPrx::_iceI_applicationUpdated, serial, desc, context).get();
    }

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto applicationUpdatedAsync(int serial, const ApplicationUpdateInfo& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ApplicationObserverPrx::_iceI_applicationUpdated, serial, desc, context);
    }

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    applicationUpdatedAsync(int serial, const ApplicationUpdateInfo& desc,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ApplicationObserverPrx::_iceI_applicationUpdated, serial, desc, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_applicationUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ApplicationUpdateInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ApplicationObserverPrx() = default;
    friend ::std::shared_ptr<ApplicationObserverPrx> IceInternal::createProxy<ApplicationObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * This interface allows applications to monitor the state of object
 * adapters that are registered with IceGrid.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) AdapterObserverPrx : public virtual ::Ice::Proxy<AdapterObserverPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     */
    void adapterInit(const AdapterInfoSeq& adpts, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdapterObserverPrx::_iceI_adapterInit, adpts, context).get();
    }

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto adapterInitAsync(const AdapterInfoSeq& adpts, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdapterObserverPrx::_iceI_adapterInit, adpts, context);
    }

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    adapterInitAsync(const AdapterInfoSeq& adpts,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdapterObserverPrx::_iceI_adapterInit, adpts, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_adapterInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const AdapterInfoSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param context The Context map to send with the invocation.
     */
    void adapterAdded(const AdapterInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdapterObserverPrx::_iceI_adapterAdded, info, context).get();
    }

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto adapterAddedAsync(const AdapterInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdapterObserverPrx::_iceI_adapterAdded, info, context);
    }

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    adapterAddedAsync(const AdapterInfo& info,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdapterObserverPrx::_iceI_adapterAdded, info, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_adapterAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const AdapterInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param context The Context map to send with the invocation.
     */
    void adapterUpdated(const AdapterInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdapterObserverPrx::_iceI_adapterUpdated, info, context).get();
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto adapterUpdatedAsync(const AdapterInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdapterObserverPrx::_iceI_adapterUpdated, info, context);
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    adapterUpdatedAsync(const AdapterInfo& info,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdapterObserverPrx::_iceI_adapterUpdated, info, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_adapterUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const AdapterInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param context The Context map to send with the invocation.
     */
    void adapterRemoved(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdapterObserverPrx::_iceI_adapterRemoved, id, context).get();
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto adapterRemovedAsync(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdapterObserverPrx::_iceI_adapterRemoved, id, context);
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    adapterRemovedAsync(const ::std::string& id,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdapterObserverPrx::_iceI_adapterRemoved, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_adapterRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    AdapterObserverPrx() = default;
    friend ::std::shared_ptr<AdapterObserverPrx> IceInternal::createProxy<AdapterObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * This interface allows applications to monitor IceGrid well-known objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ObjectObserverPrx : public virtual ::Ice::Proxy<ObjectObserverPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     */
    void objectInit(const ObjectInfoSeq& objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ObjectObserverPrx::_iceI_objectInit, objects, context).get();
    }

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto objectInitAsync(const ObjectInfoSeq& objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ObjectObserverPrx::_iceI_objectInit, objects, context);
    }

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    objectInitAsync(const ObjectInfoSeq& objects,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ObjectObserverPrx::_iceI_objectInit, objects, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_objectInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ObjectInfoSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param context The Context map to send with the invocation.
     */
    void objectAdded(const ObjectInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ObjectObserverPrx::_iceI_objectAdded, info, context).get();
    }

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto objectAddedAsync(const ObjectInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ObjectObserverPrx::_iceI_objectAdded, info, context);
    }

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    objectAddedAsync(const ObjectInfo& info,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ObjectObserverPrx::_iceI_objectAdded, info, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_objectAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ObjectInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param context The Context map to send with the invocation.
     */
    void objectUpdated(const ObjectInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ObjectObserverPrx::_iceI_objectUpdated, info, context).get();
    }

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto objectUpdatedAsync(const ObjectInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ObjectObserverPrx::_iceI_objectUpdated, info, context);
    }

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    objectUpdatedAsync(const ObjectInfo& info,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ObjectObserverPrx::_iceI_objectUpdated, info, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_objectUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ObjectInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param context The Context map to send with the invocation.
     */
    void objectRemoved(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ObjectObserverPrx::_iceI_objectRemoved, id, context).get();
    }

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto objectRemovedAsync(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ObjectObserverPrx::_iceI_objectRemoved, id, context);
    }

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    objectRemovedAsync(const ::Ice::Identity& id,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ObjectObserverPrx::_iceI_objectRemoved, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_objectRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ObjectObserverPrx() = default;
    friend ::std::shared_ptr<ObjectObserverPrx> IceInternal::createProxy<ObjectObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either via the {@link Registry}
 * object or via the registry admin <code>SessionManager</code> object.
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) AdminSessionPrx : public virtual ::Ice::Proxy<AdminSessionPrx, ::Glacier2::SessionPrx>
{
public:

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @see Registry#getSessionTimeout
     */
    void keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminSessionPrx::_iceI_keepAlive, context).get();
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see Registry#getSessionTimeout
     */
    template<template<typename> class P = ::std::promise>
    auto keepAliveAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminSessionPrx::_iceI_keepAlive, context);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see Registry#getSessionTimeout
     */
    ::std::function<void()>
    keepAliveAsync(::std::function<void()> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_keepAlive, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param context The Context map to send with the invocation.
     * @return The admin interface proxy.
     */
    ::std::shared_ptr<AdminPrx> getAdmin(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminPrx>>(true, this, &AdminSessionPrx::_iceI_getAdmin, context).get();
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAdminAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::AdminPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminPrx>, P>(false, this, &AdminSessionPrx::_iceI_getAdmin, context);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAdminAsync(::std::function<void(::std::shared_ptr<::IceGrid::AdminPrx>)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::AdminPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_getAdmin, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param context The Context map to send with the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> getAdminCallbackTemplate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &AdminSessionPrx::_iceI_getAdminCallbackTemplate, context).get();
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getAdminCallbackTemplateAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &AdminSessionPrx::_iceI_getAdminCallbackTemplate, context);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getAdminCallbackTemplateAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                  ::std::function<void(bool)> sent = nullptr,
                                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_getAdminCallbackTemplate, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getAdminCallbackTemplate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    void setObservers(const ::std::shared_ptr<RegistryObserverPrx>& registryObs, const ::std::shared_ptr<NodeObserverPrx>& nodeObs, const ::std::shared_ptr<ApplicationObserverPrx>& appObs, const ::std::shared_ptr<AdapterObserverPrx>& adptObs, const ::std::shared_ptr<ObjectObserverPrx>& objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminSessionPrx::_iceI_setObservers, registryObs, nodeObs, appObs, adptObs, objObs, context).get();
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setObserversAsync(const ::std::shared_ptr<RegistryObserverPrx>& registryObs, const ::std::shared_ptr<NodeObserverPrx>& nodeObs, const ::std::shared_ptr<ApplicationObserverPrx>& appObs, const ::std::shared_ptr<AdapterObserverPrx>& adptObs, const ::std::shared_ptr<ObjectObserverPrx>& objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminSessionPrx::_iceI_setObservers, registryObs, nodeObs, appObs, adptObs, objObs, context);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setObserversAsync(const ::std::shared_ptr<RegistryObserverPrx>& registryObs, const ::std::shared_ptr<NodeObserverPrx>& nodeObs, const ::std::shared_ptr<ApplicationObserverPrx>& appObs, const ::std::shared_ptr<AdapterObserverPrx>& adptObs, const ::std::shared_ptr<ObjectObserverPrx>& objObs,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_setObservers, registryObs, nodeObs, appObs, adptObs, objObs, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_setObservers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<RegistryObserverPrx>&, const ::std::shared_ptr<NodeObserverPrx>&, const ::std::shared_ptr<ApplicationObserverPrx>&, const ::std::shared_ptr<AdapterObserverPrx>&, const ::std::shared_ptr<ObjectObserverPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    void setObserversByIdentity(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminSessionPrx::_iceI_setObserversByIdentity, registryObs, nodeObs, appObs, adptObs, objObs, context).get();
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setObserversByIdentityAsync(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminSessionPrx::_iceI_setObserversByIdentity, registryObs, nodeObs, appObs, adptObs, objObs, context);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setObserversByIdentityAsync(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs,
                                ::std::function<void()> response,
                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                ::std::function<void(bool)> sent = nullptr,
                                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_setObserversByIdentity, registryObs, nodeObs, appObs, adptObs, objObs, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_setObserversByIdentity(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Context&);
    /// \endcond

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param context The Context map to send with the invocation.
     * @return The current serial.
     * @throws IceGrid::AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     */
    int startUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &AdminSessionPrx::_iceI_startUpdate, context).get();
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto startUpdateAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &AdminSessionPrx::_iceI_startUpdate, context);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    startUpdateAsync(::std::function<void(int)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_startUpdate, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_startUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     */
    void finishUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdminSessionPrx::_iceI_finishUpdate, context).get();
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto finishUpdateAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdminSessionPrx::_iceI_finishUpdate, context);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    finishUpdateAsync(::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_finishUpdate, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_finishUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the name of the registry replica hosting this session.
     * @param context The Context map to send with the invocation.
     * @return The replica name of the registry.
     */
    ::std::string getReplicaName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &AdminSessionPrx::_iceI_getReplicaName, context).get();
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getReplicaNameAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &AdminSessionPrx::_iceI_getReplicaName, context);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getReplicaNameAsync(::std::function<void(::std::string)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_getReplicaName, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getReplicaName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ::std::shared_ptr<FileIteratorPrx> openServerLog(const ::std::string& id, const ::std::string& path, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &AdminSessionPrx::_iceI_openServerLog, id, path, count, context).get();
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto openServerLogAsync(const ::std::string& id, const ::std::string& path, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &AdminSessionPrx::_iceI_openServerLog, id, path, count, context);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    openServerLogAsync(const ::std::string& id, const ::std::string& path, int count,
                       ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_openServerLog, id, path, count, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_openServerLog(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ::std::shared_ptr<FileIteratorPrx> openServerStdErr(const ::std::string& id, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &AdminSessionPrx::_iceI_openServerStdErr, id, count, context).get();
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto openServerStdErrAsync(const ::std::string& id, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &AdminSessionPrx::_iceI_openServerStdErr, id, count, context);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    openServerStdErrAsync(const ::std::string& id, int count,
                          ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_openServerStdErr, id, count, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_openServerStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ::std::shared_ptr<FileIteratorPrx> openServerStdOut(const ::std::string& id, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &AdminSessionPrx::_iceI_openServerStdOut, id, count, context).get();
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto openServerStdOutAsync(const ::std::string& id, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &AdminSessionPrx::_iceI_openServerStdOut, id, count, context);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    openServerStdOutAsync(const ::std::string& id, int count,
                          ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_openServerStdOut, id, count, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_openServerStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    ::std::shared_ptr<FileIteratorPrx> openNodeStdErr(const ::std::string& name, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &AdminSessionPrx::_iceI_openNodeStdErr, name, count, context).get();
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto openNodeStdErrAsync(const ::std::string& name, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &AdminSessionPrx::_iceI_openNodeStdErr, name, count, context);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    openNodeStdErrAsync(const ::std::string& name, int count,
                        ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_openNodeStdErr, name, count, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_openNodeStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    ::std::shared_ptr<FileIteratorPrx> openNodeStdOut(const ::std::string& name, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &AdminSessionPrx::_iceI_openNodeStdOut, name, count, context).get();
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto openNodeStdOutAsync(const ::std::string& name, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &AdminSessionPrx::_iceI_openNodeStdOut, name, count, context);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    openNodeStdOutAsync(const ::std::string& name, int count,
                        ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_openNodeStdOut, name, count, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_openNodeStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    ::std::shared_ptr<FileIteratorPrx> openRegistryStdErr(const ::std::string& name, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &AdminSessionPrx::_iceI_openRegistryStdErr, name, count, context).get();
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto openRegistryStdErrAsync(const ::std::string& name, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &AdminSessionPrx::_iceI_openRegistryStdErr, name, count, context);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    openRegistryStdErrAsync(const ::std::string& name, int count,
                            ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_openRegistryStdErr, name, count, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_openRegistryStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    ::std::shared_ptr<FileIteratorPrx> openRegistryStdOut(const ::std::string& name, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &AdminSessionPrx::_iceI_openRegistryStdOut, name, count, context).get();
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto openRegistryStdOutAsync(const ::std::string& name, int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &AdminSessionPrx::_iceI_openRegistryStdOut, name, count, context);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    openRegistryStdOutAsync(const ::std::string& name, int count,
                            ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdminSessionPrx::_iceI_openRegistryStdOut, name, count, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_openRegistryStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    AdminSessionPrx() = default;
    friend ::std::shared_ptr<AdminSessionPrx> IceInternal::createProxy<AdminSessionPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::ServerState>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 6;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits<::IceGrid::ObjectInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ObjectInfo, S>
{
    static void read(S* istr, ::IceGrid::ObjectInfo& v)
    {
        istr->readAll(v.proxy, v.type);
    }
};

template<>
struct StreamableTraits<::IceGrid::AdapterInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::AdapterInfo, S>
{
    static void read(S* istr, ::IceGrid::AdapterInfo& v)
    {
        istr->readAll(v.id, v.proxy, v.replicaGroupId);
    }
};

template<>
struct StreamableTraits<::IceGrid::ServerInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 9;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ServerInfo, S>
{
    static void read(S* istr, ::IceGrid::ServerInfo& v)
    {
        istr->readAll(v.application, v.uuid, v.revision, v.node, v.descriptor, v.sessionId);
    }
};

template<>
struct StreamableTraits<::IceGrid::NodeInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::NodeInfo, S>
{
    static void read(S* istr, ::IceGrid::NodeInfo& v)
    {
        istr->readAll(v.name, v.os, v.hostname, v.release, v.version, v.machine, v.nProcessors, v.dataDir);
    }
};

template<>
struct StreamableTraits<::IceGrid::RegistryInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::RegistryInfo, S>
{
    static void read(S* istr, ::IceGrid::RegistryInfo& v)
    {
        istr->readAll(v.name, v.hostname);
    }
};

template<>
struct StreamableTraits<::IceGrid::LoadInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 12;
    static const bool fixedLength = true;
};

template<typename S>
struct StreamReader<::IceGrid::LoadInfo, S>
{
    static void read(S* istr, ::IceGrid::LoadInfo& v)
    {
        istr->readAll(v.avg1, v.avg5, v.avg15);
    }
};

template<>
struct StreamableTraits<::IceGrid::ApplicationInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 33;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ApplicationInfo, S>
{
    static void read(S* istr, ::IceGrid::ApplicationInfo& v)
    {
        istr->readAll(v.uuid, v.createTime, v.createUser, v.updateTime, v.updateUser, v.revision, v.descriptor);
    }
};

template<>
struct StreamableTraits<::IceGrid::ApplicationUpdateInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 28;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ApplicationUpdateInfo, S>
{
    static void read(S* istr, ::IceGrid::ApplicationUpdateInfo& v)
    {
        istr->readAll(v.updateTime, v.updateUser, v.revision, v.descriptor);
    }
};

template<>
struct StreamableTraits<::IceGrid::ServerDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ServerDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::ServerDynamicInfo& v)
    {
        istr->readAll(v.id, v.state, v.pid, v.enabled);
    }
};

template<>
struct StreamableTraits<::IceGrid::AdapterDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::AdapterDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::AdapterDynamicInfo& v)
    {
        istr->readAll(v.id, v.proxy);
    }
};

template<>
struct StreamableTraits<::IceGrid::NodeDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 13;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::NodeDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::NodeDynamicInfo& v)
    {
        istr->readAll(v.info, v.servers, v.adapters);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IceGrid
{

using AdminPtr = ::std::shared_ptr<Admin>;
using AdminPrxPtr = ::std::shared_ptr<AdminPrx>;

using FileIteratorPtr = ::std::shared_ptr<FileIterator>;
using FileIteratorPrxPtr = ::std::shared_ptr<FileIteratorPrx>;

using RegistryObserverPtr = ::std::shared_ptr<RegistryObserver>;
using RegistryObserverPrxPtr = ::std::shared_ptr<RegistryObserverPrx>;

using NodeObserverPtr = ::std::shared_ptr<NodeObserver>;
using NodeObserverPrxPtr = ::std::shared_ptr<NodeObserverPrx>;

using ApplicationObserverPtr = ::std::shared_ptr<ApplicationObserver>;
using ApplicationObserverPrxPtr = ::std::shared_ptr<ApplicationObserverPrx>;

using AdapterObserverPtr = ::std::shared_ptr<AdapterObserver>;
using AdapterObserverPrxPtr = ::std::shared_ptr<AdapterObserverPrx>;

using ObjectObserverPtr = ::std::shared_ptr<ObjectObserver>;
using ObjectObserverPrxPtr = ::std::shared_ptr<ObjectObserverPrx>;

using AdminSessionPtr = ::std::shared_ptr<AdminSession>;
using AdminSessionPrxPtr = ::std::shared_ptr<AdminSessionPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class Admin;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Admin>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(Admin*);
/// \endcond

class FileIterator;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< FileIterator>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(FileIterator*);
/// \endcond

class RegistryObserver;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< RegistryObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(RegistryObserver*);
/// \endcond

class NodeObserver;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< NodeObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(NodeObserver*);
/// \endcond

class ApplicationObserver;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ApplicationObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(ApplicationObserver*);
/// \endcond

class AdapterObserver;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< AdapterObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(AdapterObserver*);
/// \endcond

class ObjectObserver;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ObjectObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(ObjectObserver*);
/// \endcond

class AdminSession;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< AdminSession>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(AdminSession*);
/// \endcond

}

}

namespace IceGrid
{

class Admin;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(Admin*);
/// \endcond
typedef ::IceInternal::Handle< Admin> AdminPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Admin> AdminPrx;
typedef AdminPrx AdminPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(AdminPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class FileIterator;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(FileIterator*);
/// \endcond
typedef ::IceInternal::Handle< FileIterator> FileIteratorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::FileIterator> FileIteratorPrx;
typedef FileIteratorPrx FileIteratorPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(FileIteratorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class RegistryObserver;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(RegistryObserver*);
/// \endcond
typedef ::IceInternal::Handle< RegistryObserver> RegistryObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RegistryObserver> RegistryObserverPrx;
typedef RegistryObserverPrx RegistryObserverPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(RegistryObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class NodeObserver;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(NodeObserver*);
/// \endcond
typedef ::IceInternal::Handle< NodeObserver> NodeObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::NodeObserver> NodeObserverPrx;
typedef NodeObserverPrx NodeObserverPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(NodeObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ApplicationObserver;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(ApplicationObserver*);
/// \endcond
typedef ::IceInternal::Handle< ApplicationObserver> ApplicationObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ApplicationObserver> ApplicationObserverPrx;
typedef ApplicationObserverPrx ApplicationObserverPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(ApplicationObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class AdapterObserver;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(AdapterObserver*);
/// \endcond
typedef ::IceInternal::Handle< AdapterObserver> AdapterObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdapterObserver> AdapterObserverPrx;
typedef AdapterObserverPrx AdapterObserverPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(AdapterObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ObjectObserver;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(ObjectObserver*);
/// \endcond
typedef ::IceInternal::Handle< ObjectObserver> ObjectObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ObjectObserver> ObjectObserverPrx;
typedef ObjectObserverPrx ObjectObserverPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(ObjectObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class AdminSession;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(AdminSession*);
/// \endcond
typedef ::IceInternal::Handle< AdminSession> AdminSessionPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdminSession> AdminSessionPrx;
typedef AdminSessionPrx AdminSessionPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(AdminSessionPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceGrid
{

/**
 * An enumeration representing the state of the server.
 */
enum ServerState
{
    /**
     * The server is not running.
     */
    Inactive,
    /**
     * The server is being activated and will change to the active
     * state when the registered server object adapters are activated
     * or to the activation timed out state if the activation timeout
     * expires.
     */
    Activating,
    /**
     * The activation timed out state indicates that the server
     * activation timed out.
     */
    ActivationTimedOut,
    /**
     * The server is running.
     */
    Active,
    /**
     * The server is being deactivated.
     */
    Deactivating,
    /**
     * The server is being destroyed.
     */
    Destroying,
    /**
     * The server is destroyed.
     */
    Destroyed
};

/**
 * A dictionary of proxies.
 */
typedef ::std::map< ::std::string, ::Ice::ObjectPrx> StringObjectProxyDict;

/**
 * Information about an Ice object.
 * \headerfile IceGrid/IceGrid.h
 */
struct ObjectInfo
{
    /**
     * The proxy of the object.
     */
    ::Ice::ObjectPrx proxy;
    /**
     * The type of the object.
     */
    ::std::string type;

    bool operator==(const ObjectInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(proxy != rhs_.proxy)
        {
            return false;
        }
        if(type != rhs_.type)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ObjectInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(proxy < rhs_.proxy)
        {
            return true;
        }
        else if(rhs_.proxy < proxy)
        {
            return false;
        }
        if(type < rhs_.type)
        {
            return true;
        }
        else if(rhs_.type < type)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ObjectInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ObjectInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ObjectInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ObjectInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of object information structures.
 */
typedef ::std::vector<ObjectInfo> ObjectInfoSeq;

/**
 * Information about an adapter registered with the IceGrid registry.
 * \headerfile IceGrid/IceGrid.h
 */
struct AdapterInfo
{
    /**
     * The id of the adapter.
     */
    ::std::string id;
    /**
     * A dummy direct proxy that contains the adapter endpoints.
     */
    ::Ice::ObjectPrx proxy;
    /**
     * The replica group id of the object adapter, or empty if the
     * adapter doesn't belong to a replica group.
     */
    ::std::string replicaGroupId;

    bool operator==(const AdapterInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(proxy != rhs_.proxy)
        {
            return false;
        }
        if(replicaGroupId != rhs_.replicaGroupId)
        {
            return false;
        }
        return true;
    }

    bool operator<(const AdapterInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(proxy < rhs_.proxy)
        {
            return true;
        }
        else if(rhs_.proxy < proxy)
        {
            return false;
        }
        if(replicaGroupId < rhs_.replicaGroupId)
        {
            return true;
        }
        else if(rhs_.replicaGroupId < replicaGroupId)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const AdapterInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const AdapterInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const AdapterInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const AdapterInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of adapter information structures.
 */
typedef ::std::vector<AdapterInfo> AdapterInfoSeq;

/**
 * Information about a server managed by an IceGrid node.
 * \headerfile IceGrid/IceGrid.h
 */
struct ServerInfo
{
    /**
     * The server application.
     */
    ::std::string application;
    /**
     * The application uuid.
     */
    ::std::string uuid;
    /**
     * The application revision.
     */
    ::Ice::Int revision;
    /**
     * The server node.
     */
    ::std::string node;
    /**
     * The server descriptor.
     */
    ::IceGrid::ServerDescriptorPtr descriptor;
    /**
     * The id of the session which allocated the server.
     */
    ::std::string sessionId;
};

/**
 * Information about an IceGrid node.
 * \headerfile IceGrid/IceGrid.h
 */
struct NodeInfo
{
    /**
     * The name of the node.
     */
    ::std::string name;
    /**
     * The operating system name.
     */
    ::std::string os;
    /**
     * The network name of the host running this node (as defined in
     * uname()).
     */
    ::std::string hostname;
    /**
     * The operation system release level (as defined in uname()).
     */
    ::std::string release;
    /**
     * The operation system version (as defined in uname()).
     */
    ::std::string version;
    /**
     * The machine hardware type (as defined in uname()).
     */
    ::std::string machine;
    /**
     * The number of processor threads on the node.
     * For example, nProcessors is 8 on a computer with a single quad-core
     * processor and two HT threads per core.
     */
    ::Ice::Int nProcessors;
    /**
     * The path to the node data directory.
     */
    ::std::string dataDir;

    bool operator==(const NodeInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(os != rhs_.os)
        {
            return false;
        }
        if(hostname != rhs_.hostname)
        {
            return false;
        }
        if(release != rhs_.release)
        {
            return false;
        }
        if(version != rhs_.version)
        {
            return false;
        }
        if(machine != rhs_.machine)
        {
            return false;
        }
        if(nProcessors != rhs_.nProcessors)
        {
            return false;
        }
        if(dataDir != rhs_.dataDir)
        {
            return false;
        }
        return true;
    }

    bool operator<(const NodeInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(os < rhs_.os)
        {
            return true;
        }
        else if(rhs_.os < os)
        {
            return false;
        }
        if(hostname < rhs_.hostname)
        {
            return true;
        }
        else if(rhs_.hostname < hostname)
        {
            return false;
        }
        if(release < rhs_.release)
        {
            return true;
        }
        else if(rhs_.release < release)
        {
            return false;
        }
        if(version < rhs_.version)
        {
            return true;
        }
        else if(rhs_.version < version)
        {
            return false;
        }
        if(machine < rhs_.machine)
        {
            return true;
        }
        else if(rhs_.machine < machine)
        {
            return false;
        }
        if(nProcessors < rhs_.nProcessors)
        {
            return true;
        }
        else if(rhs_.nProcessors < nProcessors)
        {
            return false;
        }
        if(dataDir < rhs_.dataDir)
        {
            return true;
        }
        else if(rhs_.dataDir < dataDir)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const NodeInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const NodeInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const NodeInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const NodeInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * Information about an IceGrid registry replica.
 * \headerfile IceGrid/IceGrid.h
 */
struct RegistryInfo
{
    /**
     * The name of the registry.
     */
    ::std::string name;
    /**
     * The network name of the host running this registry (as defined in
     * uname()).
     */
    ::std::string hostname;

    bool operator==(const RegistryInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(hostname != rhs_.hostname)
        {
            return false;
        }
        return true;
    }

    bool operator<(const RegistryInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(hostname < rhs_.hostname)
        {
            return true;
        }
        else if(rhs_.hostname < hostname)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const RegistryInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const RegistryInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const RegistryInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const RegistryInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of {@link RegistryInfo} structures.
 */
typedef ::std::vector<RegistryInfo> RegistryInfoSeq;

/**
 * Information about the load of a node.
 * \headerfile IceGrid/IceGrid.h
 */
struct LoadInfo
{
    /**
     * The load average over the past minute.
     */
    ::Ice::Float avg1;
    /**
     * The load average over the past 5 minutes.
     */
    ::Ice::Float avg5;
    /**
     * The load average over the past 15 minutes.
     */
    ::Ice::Float avg15;
};

/**
 * Information about an IceGrid application.
 * \headerfile IceGrid/IceGrid.h
 */
struct ApplicationInfo
{
    /**
     * Unique application identifier.
     */
    ::std::string uuid;
    /**
     * The creation time.
     */
    ::Ice::Long createTime;
    /**
     * The user who created the application.
     */
    ::std::string createUser;
    /**
     * The update time.
     */
    ::Ice::Long updateTime;
    /**
     * The user who updated the application.
     */
    ::std::string updateUser;
    /**
     * The application revision number.
     */
    ::Ice::Int revision;
    /**
     * The application descriptor
     */
    ::IceGrid::ApplicationDescriptor descriptor;
};

/**
 * A sequence of {@link ApplicationInfo} structures.
 */
typedef ::std::vector<ApplicationInfo> ApplicationInfoSeq;

/**
 * Information about updates to an IceGrid application.
 * \headerfile IceGrid/IceGrid.h
 */
struct ApplicationUpdateInfo
{
    /**
     * The update time.
     */
    ::Ice::Long updateTime;
    /**
     * The user who updated the application.
     */
    ::std::string updateUser;
    /**
     * The application revision number.
     */
    ::Ice::Int revision;
    /**
     * The update descriptor.
     */
    ::IceGrid::ApplicationUpdateDescriptor descriptor;
};

/**
 * Dynamic information about the state of a server.
 * \headerfile IceGrid/IceGrid.h
 */
struct ServerDynamicInfo
{
    /**
     * The id of the server.
     */
    ::std::string id;
    /**
     * The state of the server.
     */
    ::IceGrid::ServerState state;
    /**
     * The process id of the server.
     */
    ::Ice::Int pid;
    /**
     * Indicates whether the server is enabled.
     */
    bool enabled;

    bool operator==(const ServerDynamicInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(state != rhs_.state)
        {
            return false;
        }
        if(pid != rhs_.pid)
        {
            return false;
        }
        if(enabled != rhs_.enabled)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ServerDynamicInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(state < rhs_.state)
        {
            return true;
        }
        else if(rhs_.state < state)
        {
            return false;
        }
        if(pid < rhs_.pid)
        {
            return true;
        }
        else if(rhs_.pid < pid)
        {
            return false;
        }
        if(enabled < rhs_.enabled)
        {
            return true;
        }
        else if(rhs_.enabled < enabled)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ServerDynamicInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ServerDynamicInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ServerDynamicInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ServerDynamicInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of server dynamic information structures.
 */
typedef ::std::vector<ServerDynamicInfo> ServerDynamicInfoSeq;

/**
 * Dynamic information about the state of an adapter.
 * \headerfile IceGrid/IceGrid.h
 */
struct AdapterDynamicInfo
{
    /**
     * The id of the adapter.
     */
    ::std::string id;
    /**
     * The direct proxy containing the adapter endpoints.
     */
    ::Ice::ObjectPrx proxy;
};

/**
 * A sequence of adapter dynamic information structures.
 */
typedef ::std::vector<AdapterDynamicInfo> AdapterDynamicInfoSeq;

/**
 * Dynamic information about the state of a node.
 * \headerfile IceGrid/IceGrid.h
 */
struct NodeDynamicInfo
{
    /**
     * Some static information about the node.
     */
    ::IceGrid::NodeInfo info;
    /**
     * The dynamic information of the servers deployed on this node.
     */
    ::IceGrid::ServerDynamicInfoSeq servers;
    /**
     * The dynamic information of the adapters deployed on this node.
     */
    ::IceGrid::AdapterDynamicInfoSeq adapters;
};

/**
 * A sequence of node dynamic information structures.
 */
typedef ::std::vector<NodeDynamicInfo> NodeDynamicInfoSeq;

}

namespace IceGrid
{

/**
 * AMD callback class for IceGrid::Admin::patchApplication_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICEGRID_API AMD_Admin_patchApplication : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Admin_patchApplication();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Admin_patchApplication> AMD_Admin_patchApplicationPtr;

/**
 * AMD callback class for IceGrid::Admin::startServer_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICEGRID_API AMD_Admin_startServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Admin_startServer();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Admin_startServer> AMD_Admin_startServerPtr;

/**
 * AMD callback class for IceGrid::Admin::stopServer_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICEGRID_API AMD_Admin_stopServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Admin_stopServer();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Admin_stopServer> AMD_Admin_stopServerPtr;

/**
 * AMD callback class for IceGrid::Admin::patchServer_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICEGRID_API AMD_Admin_patchServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Admin_patchServer();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Admin_patchServer> AMD_Admin_patchServerPtr;

}

/// \cond INTERNAL
namespace IceAsync
{

namespace IceGrid
{

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICEGRID_API AMD_Admin_patchApplication : public ::IceGrid::AMD_Admin_patchApplication, public ::IceInternal::IncomingAsync
{
public:

    AMD_Admin_patchApplication(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICEGRID_API AMD_Admin_startServer : public ::IceGrid::AMD_Admin_startServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Admin_startServer(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICEGRID_API AMD_Admin_stopServer : public ::IceGrid::AMD_Admin_stopServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Admin_stopServer(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICEGRID_API AMD_Admin_patchServer : public ::IceGrid::AMD_Admin_patchServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Admin_patchServer(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

}

}
/// \endcond

namespace IceGrid
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_addApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_addApplication.
 */
class Callback_Admin_addApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_addApplication_Base> Callback_Admin_addApplicationPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_syncApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_syncApplication.
 */
class Callback_Admin_syncApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_syncApplication_Base> Callback_Admin_syncApplicationPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_updateApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_updateApplication.
 */
class Callback_Admin_updateApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_updateApplication_Base> Callback_Admin_updateApplicationPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_syncApplicationWithoutRestart.
 */
class Callback_Admin_syncApplicationWithoutRestart_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_syncApplicationWithoutRestart_Base> Callback_Admin_syncApplicationWithoutRestartPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_updateApplicationWithoutRestart.
 */
class Callback_Admin_updateApplicationWithoutRestart_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_updateApplicationWithoutRestart_Base> Callback_Admin_updateApplicationWithoutRestartPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_removeApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_removeApplication.
 */
class Callback_Admin_removeApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_removeApplication_Base> Callback_Admin_removeApplicationPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_instantiateServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_instantiateServer.
 */
class Callback_Admin_instantiateServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_instantiateServer_Base> Callback_Admin_instantiateServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_patchApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_patchApplication.
 */
class Callback_Admin_patchApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_patchApplication_Base> Callback_Admin_patchApplicationPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getApplicationInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getApplicationInfo.
 */
class Callback_Admin_getApplicationInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getApplicationInfo_Base> Callback_Admin_getApplicationInfoPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getDefaultApplicationDescriptor.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getDefaultApplicationDescriptor.
 */
class Callback_Admin_getDefaultApplicationDescriptor_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getDefaultApplicationDescriptor_Base> Callback_Admin_getDefaultApplicationDescriptorPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getAllApplicationNames.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAllApplicationNames.
 */
class Callback_Admin_getAllApplicationNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllApplicationNames_Base> Callback_Admin_getAllApplicationNamesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerInfo.
 */
class Callback_Admin_getServerInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerInfo_Base> Callback_Admin_getServerInfoPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerState.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerState.
 */
class Callback_Admin_getServerState_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerState_Base> Callback_Admin_getServerStatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerPid.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerPid.
 */
class Callback_Admin_getServerPid_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerPid_Base> Callback_Admin_getServerPidPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerAdminCategory.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerAdminCategory.
 */
class Callback_Admin_getServerAdminCategory_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerAdminCategory_Base> Callback_Admin_getServerAdminCategoryPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerAdmin.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerAdmin.
 */
class Callback_Admin_getServerAdmin_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerAdmin_Base> Callback_Admin_getServerAdminPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_enableServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_enableServer.
 */
class Callback_Admin_enableServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_enableServer_Base> Callback_Admin_enableServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_isServerEnabled.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_isServerEnabled.
 */
class Callback_Admin_isServerEnabled_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_isServerEnabled_Base> Callback_Admin_isServerEnabledPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_startServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_startServer.
 */
class Callback_Admin_startServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_startServer_Base> Callback_Admin_startServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_stopServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_stopServer.
 */
class Callback_Admin_stopServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_stopServer_Base> Callback_Admin_stopServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_patchServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_patchServer.
 */
class Callback_Admin_patchServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_patchServer_Base> Callback_Admin_patchServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_sendSignal.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_sendSignal.
 */
class Callback_Admin_sendSignal_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_sendSignal_Base> Callback_Admin_sendSignalPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getAllServerIds.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAllServerIds.
 */
class Callback_Admin_getAllServerIds_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllServerIds_Base> Callback_Admin_getAllServerIdsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getAdapterInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAdapterInfo.
 */
class Callback_Admin_getAdapterInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAdapterInfo_Base> Callback_Admin_getAdapterInfoPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_removeAdapter.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_removeAdapter.
 */
class Callback_Admin_removeAdapter_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_removeAdapter_Base> Callback_Admin_removeAdapterPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getAllAdapterIds.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAllAdapterIds.
 */
class Callback_Admin_getAllAdapterIds_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllAdapterIds_Base> Callback_Admin_getAllAdapterIdsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_addObject.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_addObject.
 */
class Callback_Admin_addObject_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_addObject_Base> Callback_Admin_addObjectPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_updateObject.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_updateObject.
 */
class Callback_Admin_updateObject_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_updateObject_Base> Callback_Admin_updateObjectPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_addObjectWithType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_addObjectWithType.
 */
class Callback_Admin_addObjectWithType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_addObjectWithType_Base> Callback_Admin_addObjectWithTypePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_removeObject.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_removeObject.
 */
class Callback_Admin_removeObject_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_removeObject_Base> Callback_Admin_removeObjectPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getObjectInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getObjectInfo.
 */
class Callback_Admin_getObjectInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getObjectInfo_Base> Callback_Admin_getObjectInfoPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getObjectInfosByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getObjectInfosByType.
 */
class Callback_Admin_getObjectInfosByType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getObjectInfosByType_Base> Callback_Admin_getObjectInfosByTypePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getAllObjectInfos.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAllObjectInfos.
 */
class Callback_Admin_getAllObjectInfos_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllObjectInfos_Base> Callback_Admin_getAllObjectInfosPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_pingNode.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_pingNode.
 */
class Callback_Admin_pingNode_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_pingNode_Base> Callback_Admin_pingNodePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getNodeLoad.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getNodeLoad.
 */
class Callback_Admin_getNodeLoad_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeLoad_Base> Callback_Admin_getNodeLoadPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getNodeInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getNodeInfo.
 */
class Callback_Admin_getNodeInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeInfo_Base> Callback_Admin_getNodeInfoPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getNodeAdmin.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getNodeAdmin.
 */
class Callback_Admin_getNodeAdmin_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeAdmin_Base> Callback_Admin_getNodeAdminPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getNodeProcessorSocketCount.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getNodeProcessorSocketCount.
 */
class Callback_Admin_getNodeProcessorSocketCount_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeProcessorSocketCount_Base> Callback_Admin_getNodeProcessorSocketCountPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_shutdownNode.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_shutdownNode.
 */
class Callback_Admin_shutdownNode_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_shutdownNode_Base> Callback_Admin_shutdownNodePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getNodeHostname.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getNodeHostname.
 */
class Callback_Admin_getNodeHostname_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeHostname_Base> Callback_Admin_getNodeHostnamePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getAllNodeNames.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAllNodeNames.
 */
class Callback_Admin_getAllNodeNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllNodeNames_Base> Callback_Admin_getAllNodeNamesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_pingRegistry.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_pingRegistry.
 */
class Callback_Admin_pingRegistry_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_pingRegistry_Base> Callback_Admin_pingRegistryPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getRegistryInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getRegistryInfo.
 */
class Callback_Admin_getRegistryInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getRegistryInfo_Base> Callback_Admin_getRegistryInfoPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getRegistryAdmin.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getRegistryAdmin.
 */
class Callback_Admin_getRegistryAdmin_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getRegistryAdmin_Base> Callback_Admin_getRegistryAdminPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_shutdownRegistry.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_shutdownRegistry.
 */
class Callback_Admin_shutdownRegistry_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_shutdownRegistry_Base> Callback_Admin_shutdownRegistryPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getAllRegistryNames.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAllRegistryNames.
 */
class Callback_Admin_getAllRegistryNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllRegistryNames_Base> Callback_Admin_getAllRegistryNamesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_shutdown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_shutdown.
 */
class Callback_Admin_shutdown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_shutdown_Base> Callback_Admin_shutdownPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Admin::begin_getSliceChecksums.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getSliceChecksums.
 */
class Callback_Admin_getSliceChecksums_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getSliceChecksums_Base> Callback_Admin_getSliceChecksumsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::FileIterator::begin_read.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileIterator_read.
 */
class Callback_FileIterator_read_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileIterator_read_Base> Callback_FileIterator_readPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::FileIterator::begin_destroy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileIterator_destroy.
 */
class Callback_FileIterator_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileIterator_destroy_Base> Callback_FileIterator_destroyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::RegistryObserver::begin_registryInit.
 * Create a wrapper instance by calling ::IceGrid::newCallback_RegistryObserver_registryInit.
 */
class Callback_RegistryObserver_registryInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RegistryObserver_registryInit_Base> Callback_RegistryObserver_registryInitPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::RegistryObserver::begin_registryUp.
 * Create a wrapper instance by calling ::IceGrid::newCallback_RegistryObserver_registryUp.
 */
class Callback_RegistryObserver_registryUp_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RegistryObserver_registryUp_Base> Callback_RegistryObserver_registryUpPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::RegistryObserver::begin_registryDown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_RegistryObserver_registryDown.
 */
class Callback_RegistryObserver_registryDown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RegistryObserver_registryDown_Base> Callback_RegistryObserver_registryDownPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeObserver::begin_nodeInit.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeObserver_nodeInit.
 */
class Callback_NodeObserver_nodeInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_nodeInit_Base> Callback_NodeObserver_nodeInitPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeObserver::begin_nodeUp.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeObserver_nodeUp.
 */
class Callback_NodeObserver_nodeUp_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_nodeUp_Base> Callback_NodeObserver_nodeUpPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeObserver::begin_nodeDown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeObserver_nodeDown.
 */
class Callback_NodeObserver_nodeDown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_nodeDown_Base> Callback_NodeObserver_nodeDownPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeObserver::begin_updateServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeObserver_updateServer.
 */
class Callback_NodeObserver_updateServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_updateServer_Base> Callback_NodeObserver_updateServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeObserver::begin_updateAdapter.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeObserver_updateAdapter.
 */
class Callback_NodeObserver_updateAdapter_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_updateAdapter_Base> Callback_NodeObserver_updateAdapterPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ApplicationObserver::begin_applicationInit.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ApplicationObserver_applicationInit.
 */
class Callback_ApplicationObserver_applicationInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ApplicationObserver_applicationInit_Base> Callback_ApplicationObserver_applicationInitPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ApplicationObserver::begin_applicationAdded.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ApplicationObserver_applicationAdded.
 */
class Callback_ApplicationObserver_applicationAdded_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ApplicationObserver_applicationAdded_Base> Callback_ApplicationObserver_applicationAddedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ApplicationObserver::begin_applicationRemoved.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ApplicationObserver_applicationRemoved.
 */
class Callback_ApplicationObserver_applicationRemoved_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ApplicationObserver_applicationRemoved_Base> Callback_ApplicationObserver_applicationRemovedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ApplicationObserver::begin_applicationUpdated.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ApplicationObserver_applicationUpdated.
 */
class Callback_ApplicationObserver_applicationUpdated_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ApplicationObserver_applicationUpdated_Base> Callback_ApplicationObserver_applicationUpdatedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdapterObserver::begin_adapterInit.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdapterObserver_adapterInit.
 */
class Callback_AdapterObserver_adapterInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdapterObserver_adapterInit_Base> Callback_AdapterObserver_adapterInitPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdapterObserver::begin_adapterAdded.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdapterObserver_adapterAdded.
 */
class Callback_AdapterObserver_adapterAdded_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdapterObserver_adapterAdded_Base> Callback_AdapterObserver_adapterAddedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdapterObserver::begin_adapterUpdated.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdapterObserver_adapterUpdated.
 */
class Callback_AdapterObserver_adapterUpdated_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdapterObserver_adapterUpdated_Base> Callback_AdapterObserver_adapterUpdatedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdapterObserver::begin_adapterRemoved.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdapterObserver_adapterRemoved.
 */
class Callback_AdapterObserver_adapterRemoved_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdapterObserver_adapterRemoved_Base> Callback_AdapterObserver_adapterRemovedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ObjectObserver::begin_objectInit.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ObjectObserver_objectInit.
 */
class Callback_ObjectObserver_objectInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ObjectObserver_objectInit_Base> Callback_ObjectObserver_objectInitPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ObjectObserver::begin_objectAdded.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ObjectObserver_objectAdded.
 */
class Callback_ObjectObserver_objectAdded_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ObjectObserver_objectAdded_Base> Callback_ObjectObserver_objectAddedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ObjectObserver::begin_objectUpdated.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ObjectObserver_objectUpdated.
 */
class Callback_ObjectObserver_objectUpdated_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ObjectObserver_objectUpdated_Base> Callback_ObjectObserver_objectUpdatedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ObjectObserver::begin_objectRemoved.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ObjectObserver_objectRemoved.
 */
class Callback_ObjectObserver_objectRemoved_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ObjectObserver_objectRemoved_Base> Callback_ObjectObserver_objectRemovedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_keepAlive.
 */
class Callback_AdminSession_keepAlive_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_keepAlive_Base> Callback_AdminSession_keepAlivePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_getAdmin.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_getAdmin.
 */
class Callback_AdminSession_getAdmin_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_getAdmin_Base> Callback_AdminSession_getAdminPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_getAdminCallbackTemplate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_getAdminCallbackTemplate.
 */
class Callback_AdminSession_getAdminCallbackTemplate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_getAdminCallbackTemplate_Base> Callback_AdminSession_getAdminCallbackTemplatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_setObservers.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_setObservers.
 */
class Callback_AdminSession_setObservers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_setObservers_Base> Callback_AdminSession_setObserversPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_setObserversByIdentity.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_setObserversByIdentity.
 */
class Callback_AdminSession_setObserversByIdentity_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_setObserversByIdentity_Base> Callback_AdminSession_setObserversByIdentityPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_startUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_startUpdate.
 */
class Callback_AdminSession_startUpdate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_startUpdate_Base> Callback_AdminSession_startUpdatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_finishUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_finishUpdate.
 */
class Callback_AdminSession_finishUpdate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_finishUpdate_Base> Callback_AdminSession_finishUpdatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_getReplicaName.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_getReplicaName.
 */
class Callback_AdminSession_getReplicaName_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_getReplicaName_Base> Callback_AdminSession_getReplicaNamePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_openServerLog.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_openServerLog.
 */
class Callback_AdminSession_openServerLog_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openServerLog_Base> Callback_AdminSession_openServerLogPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_openServerStdErr.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_openServerStdErr.
 */
class Callback_AdminSession_openServerStdErr_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openServerStdErr_Base> Callback_AdminSession_openServerStdErrPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_openServerStdOut.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_openServerStdOut.
 */
class Callback_AdminSession_openServerStdOut_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openServerStdOut_Base> Callback_AdminSession_openServerStdOutPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_openNodeStdErr.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_openNodeStdErr.
 */
class Callback_AdminSession_openNodeStdErr_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openNodeStdErr_Base> Callback_AdminSession_openNodeStdErrPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_openNodeStdOut.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_openNodeStdOut.
 */
class Callback_AdminSession_openNodeStdOut_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openNodeStdOut_Base> Callback_AdminSession_openNodeStdOutPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_openRegistryStdErr.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_openRegistryStdErr.
 */
class Callback_AdminSession_openRegistryStdErr_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openRegistryStdErr_Base> Callback_AdminSession_openRegistryStdErrPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::AdminSession::begin_openRegistryStdOut.
 * Create a wrapper instance by calling ::IceGrid::newCallback_AdminSession_openRegistryStdOut.
 */
class Callback_AdminSession_openRegistryStdOut_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openRegistryStdOut_Base> Callback_AdminSession_openRegistryStdOutPtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) Admin : public virtual ::Ice::Proxy<Admin, ::IceProxy::Ice::Object>
{
public:

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void addApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addApplication(_iceI_begin_addApplication(descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addApplication(descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addApplication(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addApplication(descriptor, context, cb, cookie);
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::IceGrid::Callback_Admin_addApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addApplication(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_addApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addApplication(descriptor, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_addApplication.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_addApplication(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_addApplication(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void syncApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_syncApplication(_iceI_begin_syncApplication(descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_syncApplication(descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplication(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplication(descriptor, context, cb, cookie);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::IceGrid::Callback_Admin_syncApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplication(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_syncApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplication(descriptor, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_syncApplication.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_syncApplication(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_syncApplication(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateApplication(_iceI_begin_updateApplication(descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateApplication(descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplication(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplication(descriptor, context, cb, cookie);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::IceGrid::Callback_Admin_updateApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplication(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_updateApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplication(descriptor, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_updateApplication.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_updateApplication(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_syncApplicationWithoutRestart(_iceI_begin_syncApplicationWithoutRestart(descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_syncApplicationWithoutRestart(descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplicationWithoutRestart(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplicationWithoutRestart(descriptor, context, cb, cookie);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& descriptor, const ::IceGrid::Callback_Admin_syncApplicationWithoutRestartPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplicationWithoutRestart(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_syncApplicationWithoutRestartPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplicationWithoutRestart(descriptor, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_syncApplicationWithoutRestart.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_syncApplicationWithoutRestart(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateApplicationWithoutRestart(_iceI_begin_updateApplicationWithoutRestart(descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateApplicationWithoutRestart(descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplicationWithoutRestart(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplicationWithoutRestart(descriptor, context, cb, cookie);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::IceGrid::Callback_Admin_updateApplicationWithoutRestartPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplicationWithoutRestart(descriptor, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_updateApplicationWithoutRestartPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplicationWithoutRestart(descriptor, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_updateApplicationWithoutRestart.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_updateApplicationWithoutRestart(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    ICE_MEMBER(ICEGRID_API) void removeApplication(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeApplication(_iceI_begin_removeApplication(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeApplication(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeApplication(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeApplication(name, context, cb, cookie);
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& name, const ::IceGrid::Callback_Admin_removeApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeApplication(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_removeApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeApplication(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_removeApplication.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_removeApplication(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_removeApplication(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if server instantiation
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void instantiateServer(const ::std::string& application, const ::std::string& node, const ::IceGrid::ServerInstanceDescriptor& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_instantiateServer(_iceI_begin_instantiateServer(application, node, desc, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& application, const ::std::string& node, const ::IceGrid::ServerInstanceDescriptor& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_instantiateServer(application, node, desc, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& application, const ::std::string& node, const ::IceGrid::ServerInstanceDescriptor& desc, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_instantiateServer(application, node, desc, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& application, const ::std::string& node, const ::IceGrid::ServerInstanceDescriptor& desc, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_instantiateServer(application, node, desc, context, cb, cookie);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& application, const ::std::string& node, const ::IceGrid::ServerInstanceDescriptor& desc, const ::IceGrid::Callback_Admin_instantiateServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_instantiateServer(application, node, desc, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& application, const ::std::string& node, const ::IceGrid::ServerInstanceDescriptor& desc, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_instantiateServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_instantiateServer(application, node, desc, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_instantiateServer.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if server instantiation
     * failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_instantiateServer(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_instantiateServer(const ::std::string&, const ::std::string&, const ::IceGrid::ServerInstanceDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::PatchException Raised if the patch failed.
     */
    ICE_MEMBER(ICEGRID_API) void patchApplication(const ::std::string& name, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_patchApplication(_iceI_begin_patchApplication(name, shutdown, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& name, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_patchApplication(name, shutdown, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& name, bool shutdown, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchApplication(name, shutdown, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& name, bool shutdown, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchApplication(name, shutdown, context, cb, cookie);
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& name, bool shutdown, const ::IceGrid::Callback_Admin_patchApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchApplication(name, shutdown, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& name, bool shutdown, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_patchApplicationPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchApplication(name, shutdown, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_patchApplication.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::PatchException Raised if the patch failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_patchApplication(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_patchApplication(const ::std::string&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationInfo getApplicationInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getApplicationInfo(_iceI_begin_getApplicationInfo(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getApplicationInfo(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplicationInfo(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplicationInfo(name, context, cb, cookie);
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& name, const ::IceGrid::Callback_Admin_getApplicationInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplicationInfo(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getApplicationInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplicationInfo(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getApplicationInfo.
     * @param result The asynchronous result object for the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationInfo end_getApplicationInfo(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getApplicationInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the default application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The default application descriptor.
     * @throws IceGrid::DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationDescriptor getDefaultApplicationDescriptor(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getDefaultApplicationDescriptor(_iceI_begin_getDefaultApplicationDescriptor(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the default application descriptor.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the default application descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the default application descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(context, cb, cookie);
    }

    /**
     * Get the default application descriptor.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::IceGrid::Callback_Admin_getDefaultApplicationDescriptorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the default application descriptor.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getDefaultApplicationDescriptorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getDefaultApplicationDescriptor.
     * @param result The asynchronous result object for the invocation.
     * @return The default application descriptor.
     * @throws IceGrid::DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationDescriptor end_getDefaultApplicationDescriptor(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getDefaultApplicationDescriptor(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get all the IceGrid applications currently registered.
     * @param context The Context map to send with the invocation.
     * @return The application names.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllApplicationNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllApplicationNames(_iceI_begin_getAllApplicationNames(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllApplicationNames(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllApplicationNames(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllApplicationNames(context, cb, cookie);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::IceGrid::Callback_Admin_getAllApplicationNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllApplicationNames(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllApplicationNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllApplicationNames(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAllApplicationNames.
     * @param result The asynchronous result object for the invocation.
     * @return The application names.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllApplicationNames(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllApplicationNames(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server information.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ServerInfo getServerInfo(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerInfo(_iceI_begin_getServerInfo(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerInfo(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerInfo(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerInfo(id, context, cb, cookie);
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& id, const ::IceGrid::Callback_Admin_getServerInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerInfo(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerInfo(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getServerInfo.
     * @param result The asynchronous result object for the invocation.
     * @return The server information.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ServerInfo end_getServerInfo(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a server's state.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server state.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ServerState getServerState(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerState(_iceI_begin_getServerState(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerState(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerState(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerState(id, context, cb, cookie);
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& id, const ::IceGrid::Callback_Admin_getServerStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerState(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a server's state.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerState(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getServerState.
     * @param result The asynchronous result object for the invocation.
     * @return The server state.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ServerState end_getServerState(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerState(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The server's process id.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int getServerPid(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerPid(_iceI_begin_getServerPid(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerPid(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerPid(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerPid(id, context, cb, cookie);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& id, const ::IceGrid::Callback_Admin_getServerPidPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerPid(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerPidPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerPid(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getServerPid.
     * @param result The asynchronous result object for the invocation.
     * @return The server's process id.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_getServerPid(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerPid(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param context The Context map to send with the invocation.
     * @return The category for server admin objects.
     */
    ICE_MEMBER(ICEGRID_API) ::std::string getServerAdminCategory(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerAdminCategory(_iceI_begin_getServerAdminCategory(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerAdminCategory(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdminCategory(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdminCategory(context, cb, cookie);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::IceGrid::Callback_Admin_getServerAdminCategoryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdminCategory(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerAdminCategoryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdminCategory(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getServerAdminCategory.
     * @param result The asynchronous result object for the invocation.
     * @return The category for server admin objects.
     */
    ICE_MEMBER(ICEGRID_API) ::std::string end_getServerAdminCategory(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerAdminCategory(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the server's admin object
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx getServerAdmin(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerAdmin(_iceI_begin_getServerAdmin(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerAdmin(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdmin(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdmin(id, context, cb, cookie);
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& id, const ::IceGrid::Callback_Admin_getServerAdminPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdmin(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerAdminPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdmin(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getServerAdmin.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to the server's admin object
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_getServerAdmin(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerAdmin(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) void enableServer(const ::std::string& id, bool enabled, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_enableServer(_iceI_begin_enableServer(id, enabled, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& id, bool enabled, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_enableServer(id, enabled, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& id, bool enabled, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableServer(id, enabled, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& id, bool enabled, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableServer(id, enabled, context, cb, cookie);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& id, bool enabled, const ::IceGrid::Callback_Admin_enableServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableServer(id, enabled, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& id, bool enabled, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_enableServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableServer(id, enabled, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_enableServer.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) void end_enableServer(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_enableServer(const ::std::string&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return True if the server is enabled.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) bool isServerEnabled(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_isServerEnabled(_iceI_begin_isServerEnabled(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_isServerEnabled(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isServerEnabled(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isServerEnabled(id, context, cb, cookie);
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& id, const ::IceGrid::Callback_Admin_isServerEnabledPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isServerEnabled(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_isServerEnabledPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isServerEnabled(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_isServerEnabled.
     * @param result The asynchronous result object for the invocation.
     * @return True if the server is enabled.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) bool end_isServerEnabled(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_isServerEnabled(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStartException Raised if the server couldn't be
     * started.
     */
    ICE_MEMBER(ICEGRID_API) void startServer(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_startServer(_iceI_begin_startServer(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_startServer(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startServer(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startServer(id, context, cb, cookie);
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& id, const ::IceGrid::Callback_Admin_startServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startServer(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_startServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startServer(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_startServer.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStartException Raised if the server couldn't be
     * started.
     */
    ICE_MEMBER(ICEGRID_API) void end_startServer(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_startServer(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Stop a server.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStopException Raised if the server couldn't be
     * stopped.
     */
    ICE_MEMBER(ICEGRID_API) void stopServer(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_stopServer(_iceI_begin_stopServer(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_stopServer(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopServer(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopServer(id, context, cb, cookie);
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& id, const ::IceGrid::Callback_Admin_stopServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopServer(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Stop a server.
     * @param id The server id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_stopServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopServer(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_stopServer.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStopException Raised if the server couldn't be
     * stopped.
     */
    ICE_MEMBER(ICEGRID_API) void end_stopServer(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_stopServer(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::PatchException Raised if the patch failed.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) void patchServer(const ::std::string& id, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_patchServer(_iceI_begin_patchServer(id, shutdown, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& id, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_patchServer(id, shutdown, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& id, bool shutdown, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchServer(id, shutdown, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& id, bool shutdown, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchServer(id, shutdown, context, cb, cookie);
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& id, bool shutdown, const ::IceGrid::Callback_Admin_patchServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchServer(id, shutdown, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& id, bool shutdown, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_patchServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchServer(id, shutdown, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_patchServer.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::PatchException Raised if the patch failed.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) void end_patchServer(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_patchServer(const ::std::string&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::BadSignalException Raised if the signal is not recognized
     * by the target server.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) void sendSignal(const ::std::string& id, const ::std::string& signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_sendSignal(_iceI_begin_sendSignal(id, signal, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& id, const ::std::string& signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_sendSignal(id, signal, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& id, const ::std::string& signal, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(id, signal, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& id, const ::std::string& signal, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(id, signal, context, cb, cookie);
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& id, const ::std::string& signal, const ::IceGrid::Callback_Admin_sendSignalPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(id, signal, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& id, const ::std::string& signal, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_sendSignalPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(id, signal, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_sendSignal.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::BadSignalException Raised if the signal is not recognized
     * by the target server.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) void end_sendSignal(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_sendSignal(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get all the server ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The server ids.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllServerIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllServerIds(_iceI_begin_getAllServerIds(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllServerIds(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServerIds(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServerIds(context, cb, cookie);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::IceGrid::Callback_Admin_getAllServerIdsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServerIds(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllServerIdsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServerIds(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAllServerIds.
     * @param result The asynchronous result object for the invocation.
     * @return The server ids.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllServerIds(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllServerIds(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdapterInfoSeq getAdapterInfo(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAdapterInfo(_iceI_begin_getAdapterInfo(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAdapterInfo(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapterInfo(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapterInfo(id, context, cb, cookie);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& id, const ::IceGrid::Callback_Admin_getAdapterInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapterInfo(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAdapterInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapterInfo(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAdapterInfo.
     * @param result The asynchronous result object for the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdapterInfoSeq end_getAdapterInfo(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAdapterInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    ICE_MEMBER(ICEGRID_API) void removeAdapter(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeAdapter(_iceI_begin_removeAdapter(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeAdapter(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeAdapter(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeAdapter(id, context, cb, cookie);
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& id, const ::IceGrid::Callback_Admin_removeAdapterPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeAdapter(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_removeAdapterPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeAdapter(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_removeAdapter.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    ICE_MEMBER(ICEGRID_API) void end_removeAdapter(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_removeAdapter(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The adapter ids.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllAdapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllAdapterIds(_iceI_begin_getAllAdapterIds(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllAdapterIds(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllAdapterIds(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllAdapterIds(context, cb, cookie);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::IceGrid::Callback_Admin_getAllAdapterIdsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllAdapterIds(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllAdapterIdsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllAdapterIds(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAllAdapterIds.
     * @param result The asynchronous result object for the invocation.
     * @return The adapter ids.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllAdapterIds(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllAdapterIds(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    ICE_MEMBER(ICEGRID_API) void addObject(const ::Ice::ObjectPrx& obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addObject(_iceI_begin_addObject(obj, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addObject(obj, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& obj, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObject(obj, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& obj, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObject(obj, context, cb, cookie);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& obj, const ::IceGrid::Callback_Admin_addObjectPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObject(obj, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& obj, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_addObjectPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObject(obj, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_addObject.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    ICE_MEMBER(ICEGRID_API) void end_addObject(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_addObject(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) void updateObject(const ::Ice::ObjectPrx& obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateObject(_iceI_begin_updateObject(obj, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateObject(obj, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& obj, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateObject(obj, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& obj, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateObject(obj, context, cb, cookie);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& obj, const ::IceGrid::Callback_Admin_updateObjectPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateObject(obj, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& obj, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_updateObjectPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateObject(obj, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_updateObject.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) void end_updateObject(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateObject(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    ICE_MEMBER(ICEGRID_API) void addObjectWithType(const ::Ice::ObjectPrx& obj, const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addObjectWithType(_iceI_begin_addObjectWithType(obj, type, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& obj, const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addObjectWithType(obj, type, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& obj, const ::std::string& type, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObjectWithType(obj, type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& obj, const ::std::string& type, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObjectWithType(obj, type, context, cb, cookie);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& obj, const ::std::string& type, const ::IceGrid::Callback_Admin_addObjectWithTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObjectWithType(obj, type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& obj, const ::std::string& type, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_addObjectWithTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObjectWithType(obj, type, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_addObjectWithType.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    ICE_MEMBER(ICEGRID_API) void end_addObjectWithType(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_addObjectWithType(const ::Ice::ObjectPrx&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) void removeObject(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeObject(_iceI_begin_removeObject(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeObject(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeObject(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeObject(id, context, cb, cookie);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& id, const ::IceGrid::Callback_Admin_removeObjectPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeObject(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_removeObjectPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeObject(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_removeObject.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) void end_removeObject(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_removeObject(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param context The Context map to send with the invocation.
     * @return The object info.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfo getObjectInfo(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getObjectInfo(_iceI_begin_getObjectInfo(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getObjectInfo(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfo(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfo(id, context, cb, cookie);
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& id, const ::IceGrid::Callback_Admin_getObjectInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfo(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getObjectInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfo(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getObjectInfo.
     * @param result The asynchronous result object for the invocation.
     * @return The object info.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfo end_getObjectInfo(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getObjectInfo(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The object infos.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfoSeq getObjectInfosByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getObjectInfosByType(_iceI_begin_getObjectInfosByType(type, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getObjectInfosByType(type, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& type, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfosByType(type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& type, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfosByType(type, context, cb, cookie);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& type, const ::IceGrid::Callback_Admin_getObjectInfosByTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfosByType(type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& type, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getObjectInfosByTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfosByType(type, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getObjectInfosByType.
     * @param result The asynchronous result object for the invocation.
     * @return The object infos.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfoSeq end_getObjectInfosByType(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getObjectInfosByType(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param context The Context map to send with the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfoSeq getAllObjectInfos(const ::std::string& expr, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllObjectInfos(_iceI_begin_getAllObjectInfos(expr, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& expr, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllObjectInfos(expr, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& expr, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllObjectInfos(expr, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& expr, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllObjectInfos(expr, context, cb, cookie);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& expr, const ::IceGrid::Callback_Admin_getAllObjectInfosPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllObjectInfos(expr, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& expr, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllObjectInfosPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllObjectInfos(expr, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAllObjectInfos.
     * @param result The asynchronous result object for the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfoSeq end_getAllObjectInfos(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllObjectInfos(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) bool pingNode(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_pingNode(_iceI_begin_pingNode(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_pingNode(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingNode(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingNode(name, context, cb, cookie);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& name, const ::IceGrid::Callback_Admin_pingNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingNode(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_pingNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingNode(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_pingNode.
     * @param result The asynchronous result object for the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) bool end_pingNode(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_pingNode(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node load information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::LoadInfo getNodeLoad(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeLoad(_iceI_begin_getNodeLoad(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeLoad(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeLoad(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeLoad(name, context, cb, cookie);
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& name, const ::IceGrid::Callback_Admin_getNodeLoadPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeLoad(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeLoadPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeLoad(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getNodeLoad.
     * @param result The asynchronous result object for the invocation.
     * @return The node load information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::LoadInfo end_getNodeLoad(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeLoad(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::NodeInfo getNodeInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeInfo(_iceI_begin_getNodeInfo(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeInfo(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeInfo(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeInfo(name, context, cb, cookie);
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& name, const ::IceGrid::Callback_Admin_getNodeInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeInfo(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeInfo(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getNodeInfo.
     * @param result The asynchronous result object for the invocation.
     * @return The node information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::NodeInfo end_getNodeInfo(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid node's admin object
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx getNodeAdmin(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeAdmin(_iceI_begin_getNodeAdmin(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeAdmin(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeAdmin(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeAdmin(name, context, cb, cookie);
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& name, const ::IceGrid::Callback_Admin_getNodeAdminPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeAdmin(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeAdminPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeAdmin(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getNodeAdmin.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to the IceGrid node's admin object
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_getNodeAdmin(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeAdmin(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int getNodeProcessorSocketCount(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeProcessorSocketCount(_iceI_begin_getNodeProcessorSocketCount(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeProcessorSocketCount(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeProcessorSocketCount(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeProcessorSocketCount(name, context, cb, cookie);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& name, const ::IceGrid::Callback_Admin_getNodeProcessorSocketCountPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeProcessorSocketCount(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeProcessorSocketCountPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeProcessorSocketCount(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getNodeProcessorSocketCount.
     * @param result The asynchronous result object for the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_getNodeProcessorSocketCount(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeProcessorSocketCount(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) void shutdownNode(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdownNode(_iceI_begin_shutdownNode(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdownNode(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownNode(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownNode(name, context, cb, cookie);
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& name, const ::IceGrid::Callback_Admin_shutdownNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownNode(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_shutdownNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownNode(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_shutdownNode.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) void end_shutdownNode(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_shutdownNode(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The node hostname.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::std::string getNodeHostname(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeHostname(_iceI_begin_getNodeHostname(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeHostname(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeHostname(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeHostname(name, context, cb, cookie);
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& name, const ::IceGrid::Callback_Admin_getNodeHostnamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeHostname(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeHostnamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeHostname(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getNodeHostname.
     * @param result The asynchronous result object for the invocation.
     * @return The node hostname.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::std::string end_getNodeHostname(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeHostname(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get all the IceGrid nodes currently registered.
     * @param context The Context map to send with the invocation.
     * @return The node names.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllNodeNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllNodeNames(_iceI_begin_getAllNodeNames(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllNodeNames(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllNodeNames(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllNodeNames(context, cb, cookie);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::IceGrid::Callback_Admin_getAllNodeNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllNodeNames(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllNodeNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllNodeNames(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAllNodeNames.
     * @param result The asynchronous result object for the invocation.
     * @return The node names.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllNodeNames(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllNodeNames(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) bool pingRegistry(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_pingRegistry(_iceI_begin_pingRegistry(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_pingRegistry(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingRegistry(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingRegistry(name, context, cb, cookie);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& name, const ::IceGrid::Callback_Admin_pingRegistryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingRegistry(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_pingRegistryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingRegistry(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_pingRegistry.
     * @param result The asynchronous result object for the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) bool end_pingRegistry(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_pingRegistry(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The registry information.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::RegistryInfo getRegistryInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegistryInfo(_iceI_begin_getRegistryInfo(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegistryInfo(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryInfo(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryInfo(name, context, cb, cookie);
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& name, const ::IceGrid::Callback_Admin_getRegistryInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryInfo(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getRegistryInfoPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryInfo(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getRegistryInfo.
     * @param result The asynchronous result object for the invocation.
     * @return The registry information.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::RegistryInfo end_getRegistryInfo(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getRegistryInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid registry's admin object
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx getRegistryAdmin(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegistryAdmin(_iceI_begin_getRegistryAdmin(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegistryAdmin(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryAdmin(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryAdmin(name, context, cb, cookie);
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& name, const ::IceGrid::Callback_Admin_getRegistryAdminPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryAdmin(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getRegistryAdminPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryAdmin(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getRegistryAdmin.
     * @param result The asynchronous result object for the invocation.
     * @return A proxy to the IceGrid registry's admin object
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_getRegistryAdmin(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getRegistryAdmin(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) void shutdownRegistry(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdownRegistry(_iceI_begin_shutdownRegistry(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdownRegistry(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownRegistry(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownRegistry(name, context, cb, cookie);
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& name, const ::IceGrid::Callback_Admin_shutdownRegistryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownRegistry(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_shutdownRegistryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownRegistry(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_shutdownRegistry.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    ICE_MEMBER(ICEGRID_API) void end_shutdownRegistry(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_shutdownRegistry(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get all the IceGrid registries currently registered.
     * @param context The Context map to send with the invocation.
     * @return The registry names.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllRegistryNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllRegistryNames(_iceI_begin_getAllRegistryNames(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllRegistryNames(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllRegistryNames(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllRegistryNames(context, cb, cookie);
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::IceGrid::Callback_Admin_getAllRegistryNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllRegistryNames(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all the IceGrid registries currently registered.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllRegistryNamesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllRegistryNames(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAllRegistryNames.
     * @param result The asynchronous result object for the invocation.
     * @return The registry names.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllRegistryNames(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllRegistryNames(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Shut down the IceGrid registry.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdown(_iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Shut down the IceGrid registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Shut down the IceGrid registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shut down the IceGrid registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, cb, cookie);
    }

    /**
     * Shut down the IceGrid registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::IceGrid::Callback_Admin_shutdownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shut down the IceGrid registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_shutdownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_shutdown.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_shutdown(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_shutdown(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSliceChecksums(_iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, cb, cookie);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::IceGrid::Callback_Admin_getSliceChecksumsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getSliceChecksumsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getSliceChecksums.
     * @param result The asynchronous result object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::SliceChecksumDict end_getSliceChecksums(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getSliceChecksums(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) FileIterator : public virtual ::Ice::Proxy<FileIterator, ::IceProxy::Ice::Object>
{
public:

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * @param context The Context map to send with the invocation.
     * @return True if EOF is encountered.
     * @throws IceGrid::FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     */
    ICE_MEMBER(ICEGRID_API) bool read(::Ice::Int size, ::Ice::StringSeq& lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_read(lines, _iceI_begin_read(size, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(::Ice::Int size, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_read(size, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(::Ice::Int size, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(size, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(::Ice::Int size, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(size, context, cb, cookie);
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(::Ice::Int size, const ::IceGrid::Callback_FileIterator_readPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(size, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(::Ice::Int size, const ::Ice::Context& context, const ::IceGrid::Callback_FileIterator_readPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(size, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_read.
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * @param result The asynchronous result object for the invocation.
     * @return True if EOF is encountered.
     * @throws IceGrid::FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     */
    ICE_MEMBER(ICEGRID_API) bool end_read(::Ice::StringSeq& lines, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) void _iceI_end_read(::Ice::StringSeq& iceP_lines, bool& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_read(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the iterator.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the iterator.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the iterator.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the iterator.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Destroy the iterator.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::IceGrid::Callback_FileIterator_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the iterator.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::IceGrid::Callback_FileIterator_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroy.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_destroy(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) RegistryObserver : public virtual ::Ice::Proxy<RegistryObserver, ::IceProxy::Ice::Object>
{
public:

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void registryInit(const ::IceGrid::RegistryInfoSeq& registries, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registryInit(_iceI_begin_registryInit(registries, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& registries, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registryInit(registries, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& registries, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryInit(registries, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& registries, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryInit(registries, context, cb, cookie);
    }

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& registries, const ::IceGrid::Callback_RegistryObserver_registryInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryInit(registries, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& registries, const ::Ice::Context& context, const ::IceGrid::Callback_RegistryObserver_registryInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryInit(registries, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registryInit.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_registryInit(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_registryInit(const ::IceGrid::RegistryInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void registryUp(const ::IceGrid::RegistryInfo& node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registryUp(_iceI_begin_registryUp(node, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registryUp(node, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& node, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryUp(node, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& node, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryUp(node, context, cb, cookie);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& node, const ::IceGrid::Callback_RegistryObserver_registryUpPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryUp(node, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& node, const ::Ice::Context& context, const ::IceGrid::Callback_RegistryObserver_registryUpPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryUp(node, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registryUp.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_registryUp(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_registryUp(const ::IceGrid::RegistryInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void registryDown(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registryDown(_iceI_begin_registryDown(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registryDown(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryDown(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryDown(name, context, cb, cookie);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& name, const ::IceGrid::Callback_RegistryObserver_registryDownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryDown(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_RegistryObserver_registryDownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryDown(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registryDown.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_registryDown(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_registryDown(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) NodeObserver : public virtual ::Ice::Proxy<NodeObserver, ::IceProxy::Ice::Object>
{
public:

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void nodeInit(const ::IceGrid::NodeDynamicInfoSeq& nodes, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_nodeInit(_iceI_begin_nodeInit(nodes, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& nodes, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_nodeInit(nodes, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& nodes, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeInit(nodes, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& nodes, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeInit(nodes, context, cb, cookie);
    }

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& nodes, const ::IceGrid::Callback_NodeObserver_nodeInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeInit(nodes, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& nodes, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_nodeInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeInit(nodes, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_nodeInit.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_nodeInit(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void nodeUp(const ::IceGrid::NodeDynamicInfo& node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_nodeUp(_iceI_begin_nodeUp(node, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_nodeUp(node, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& node, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeUp(node, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& node, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeUp(node, context, cb, cookie);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& node, const ::IceGrid::Callback_NodeObserver_nodeUpPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeUp(node, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& node, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_nodeUpPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeUp(node, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_nodeUp.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_nodeUp(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_nodeUp(const ::IceGrid::NodeDynamicInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void nodeDown(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_nodeDown(_iceI_begin_nodeDown(name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_nodeDown(name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeDown(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeDown(name, context, cb, cookie);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& name, const ::IceGrid::Callback_NodeObserver_nodeDownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeDown(name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_nodeDownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeDown(name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_nodeDown.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_nodeDown(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_nodeDown(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void updateServer(const ::std::string& node, const ::IceGrid::ServerDynamicInfo& updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateServer(_iceI_begin_updateServer(node, updatedInfo, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& node, const ::IceGrid::ServerDynamicInfo& updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateServer(node, updatedInfo, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& node, const ::IceGrid::ServerDynamicInfo& updatedInfo, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateServer(node, updatedInfo, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& node, const ::IceGrid::ServerDynamicInfo& updatedInfo, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateServer(node, updatedInfo, context, cb, cookie);
    }

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& node, const ::IceGrid::ServerDynamicInfo& updatedInfo, const ::IceGrid::Callback_NodeObserver_updateServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateServer(node, updatedInfo, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& node, const ::IceGrid::ServerDynamicInfo& updatedInfo, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_updateServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateServer(node, updatedInfo, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_updateServer.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_updateServer(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateServer(const ::std::string&, const ::IceGrid::ServerDynamicInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void updateAdapter(const ::std::string& node, const ::IceGrid::AdapterDynamicInfo& updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateAdapter(_iceI_begin_updateAdapter(node, updatedInfo, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& node, const ::IceGrid::AdapterDynamicInfo& updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateAdapter(node, updatedInfo, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& node, const ::IceGrid::AdapterDynamicInfo& updatedInfo, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateAdapter(node, updatedInfo, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& node, const ::IceGrid::AdapterDynamicInfo& updatedInfo, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateAdapter(node, updatedInfo, context, cb, cookie);
    }

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& node, const ::IceGrid::AdapterDynamicInfo& updatedInfo, const ::IceGrid::Callback_NodeObserver_updateAdapterPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateAdapter(node, updatedInfo, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& node, const ::IceGrid::AdapterDynamicInfo& updatedInfo, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_updateAdapterPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateAdapter(node, updatedInfo, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_updateAdapter.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_updateAdapter(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateAdapter(const ::std::string&, const ::IceGrid::AdapterDynamicInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) ApplicationObserver : public virtual ::Ice::Proxy<ApplicationObserver, ::IceProxy::Ice::Object>
{
public:

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void applicationInit(::Ice::Int serial, const ::IceGrid::ApplicationInfoSeq& applications, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_applicationInit(_iceI_begin_applicationInit(serial, applications, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int serial, const ::IceGrid::ApplicationInfoSeq& applications, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_applicationInit(serial, applications, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int serial, const ::IceGrid::ApplicationInfoSeq& applications, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationInit(serial, applications, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int serial, const ::IceGrid::ApplicationInfoSeq& applications, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationInit(serial, applications, context, cb, cookie);
    }

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int serial, const ::IceGrid::ApplicationInfoSeq& applications, const ::IceGrid::Callback_ApplicationObserver_applicationInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationInit(serial, applications, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int serial, const ::IceGrid::ApplicationInfoSeq& applications, const ::Ice::Context& context, const ::IceGrid::Callback_ApplicationObserver_applicationInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationInit(serial, applications, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_applicationInit.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_applicationInit(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_applicationInit(::Ice::Int, const ::IceGrid::ApplicationInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void applicationAdded(::Ice::Int serial, const ::IceGrid::ApplicationInfo& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_applicationAdded(_iceI_begin_applicationAdded(serial, desc, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int serial, const ::IceGrid::ApplicationInfo& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_applicationAdded(serial, desc, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int serial, const ::IceGrid::ApplicationInfo& desc, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationAdded(serial, desc, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int serial, const ::IceGrid::ApplicationInfo& desc, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationAdded(serial, desc, context, cb, cookie);
    }

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int serial, const ::IceGrid::ApplicationInfo& desc, const ::IceGrid::Callback_ApplicationObserver_applicationAddedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationAdded(serial, desc, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int serial, const ::IceGrid::ApplicationInfo& desc, const ::Ice::Context& context, const ::IceGrid::Callback_ApplicationObserver_applicationAddedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationAdded(serial, desc, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_applicationAdded.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_applicationAdded(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_applicationAdded(::Ice::Int, const ::IceGrid::ApplicationInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void applicationRemoved(::Ice::Int serial, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_applicationRemoved(_iceI_begin_applicationRemoved(serial, name, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int serial, const ::std::string& name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_applicationRemoved(serial, name, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int serial, const ::std::string& name, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationRemoved(serial, name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int serial, const ::std::string& name, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationRemoved(serial, name, context, cb, cookie);
    }

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int serial, const ::std::string& name, const ::IceGrid::Callback_ApplicationObserver_applicationRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationRemoved(serial, name, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int serial, const ::std::string& name, const ::Ice::Context& context, const ::IceGrid::Callback_ApplicationObserver_applicationRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationRemoved(serial, name, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_applicationRemoved.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_applicationRemoved(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_applicationRemoved(::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void applicationUpdated(::Ice::Int serial, const ::IceGrid::ApplicationUpdateInfo& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_applicationUpdated(_iceI_begin_applicationUpdated(serial, desc, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int serial, const ::IceGrid::ApplicationUpdateInfo& desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_applicationUpdated(serial, desc, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int serial, const ::IceGrid::ApplicationUpdateInfo& desc, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationUpdated(serial, desc, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int serial, const ::IceGrid::ApplicationUpdateInfo& desc, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationUpdated(serial, desc, context, cb, cookie);
    }

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int serial, const ::IceGrid::ApplicationUpdateInfo& desc, const ::IceGrid::Callback_ApplicationObserver_applicationUpdatedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationUpdated(serial, desc, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int serial, const ::IceGrid::ApplicationUpdateInfo& desc, const ::Ice::Context& context, const ::IceGrid::Callback_ApplicationObserver_applicationUpdatedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationUpdated(serial, desc, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_applicationUpdated.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_applicationUpdated(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_applicationUpdated(::Ice::Int, const ::IceGrid::ApplicationUpdateInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) AdapterObserver : public virtual ::Ice::Proxy<AdapterObserver, ::IceProxy::Ice::Object>
{
public:

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void adapterInit(const ::IceGrid::AdapterInfoSeq& adpts, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_adapterInit(_iceI_begin_adapterInit(adpts, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& adpts, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterInit(adpts, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& adpts, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterInit(adpts, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& adpts, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterInit(adpts, context, cb, cookie);
    }

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& adpts, const ::IceGrid::Callback_AdapterObserver_adapterInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterInit(adpts, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& adpts, const ::Ice::Context& context, const ::IceGrid::Callback_AdapterObserver_adapterInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterInit(adpts, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_adapterInit.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_adapterInit(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_adapterInit(const ::IceGrid::AdapterInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void adapterAdded(const ::IceGrid::AdapterInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_adapterAdded(_iceI_begin_adapterAdded(info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterAdded(info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterAdded(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterAdded(info, context, cb, cookie);
    }

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& info, const ::IceGrid::Callback_AdapterObserver_adapterAddedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterAdded(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& info, const ::Ice::Context& context, const ::IceGrid::Callback_AdapterObserver_adapterAddedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterAdded(info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_adapterAdded.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_adapterAdded(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_adapterAdded(const ::IceGrid::AdapterInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void adapterUpdated(const ::IceGrid::AdapterInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_adapterUpdated(_iceI_begin_adapterUpdated(info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterUpdated(info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterUpdated(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterUpdated(info, context, cb, cookie);
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& info, const ::IceGrid::Callback_AdapterObserver_adapterUpdatedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterUpdated(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& info, const ::Ice::Context& context, const ::IceGrid::Callback_AdapterObserver_adapterUpdatedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterUpdated(info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_adapterUpdated.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_adapterUpdated(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_adapterUpdated(const ::IceGrid::AdapterInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void adapterRemoved(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_adapterRemoved(_iceI_begin_adapterRemoved(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterRemoved(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterRemoved(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterRemoved(id, context, cb, cookie);
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& id, const ::IceGrid::Callback_AdapterObserver_adapterRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterRemoved(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& id, const ::Ice::Context& context, const ::IceGrid::Callback_AdapterObserver_adapterRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterRemoved(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_adapterRemoved.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_adapterRemoved(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_adapterRemoved(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) ObjectObserver : public virtual ::Ice::Proxy<ObjectObserver, ::IceProxy::Ice::Object>
{
public:

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void objectInit(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_objectInit(_iceI_begin_objectInit(objects, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_objectInit(objects, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectInit(objects, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectInit(objects, context, cb, cookie);
    }

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& objects, const ::IceGrid::Callback_ObjectObserver_objectInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectInit(objects, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::Context& context, const ::IceGrid::Callback_ObjectObserver_objectInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectInit(objects, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_objectInit.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_objectInit(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_objectInit(const ::IceGrid::ObjectInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void objectAdded(const ::IceGrid::ObjectInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_objectAdded(_iceI_begin_objectAdded(info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_objectAdded(info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectAdded(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectAdded(info, context, cb, cookie);
    }

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& info, const ::IceGrid::Callback_ObjectObserver_objectAddedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectAdded(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& info, const ::Ice::Context& context, const ::IceGrid::Callback_ObjectObserver_objectAddedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectAdded(info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_objectAdded.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_objectAdded(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_objectAdded(const ::IceGrid::ObjectInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void objectUpdated(const ::IceGrid::ObjectInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_objectUpdated(_iceI_begin_objectUpdated(info, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_objectUpdated(info, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& info, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectUpdated(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& info, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectUpdated(info, context, cb, cookie);
    }

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& info, const ::IceGrid::Callback_ObjectObserver_objectUpdatedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectUpdated(info, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& info, const ::Ice::Context& context, const ::IceGrid::Callback_ObjectObserver_objectUpdatedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectUpdated(info, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_objectUpdated.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_objectUpdated(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_objectUpdated(const ::IceGrid::ObjectInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void objectRemoved(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_objectRemoved(_iceI_begin_objectRemoved(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_objectRemoved(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectRemoved(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectRemoved(id, context, cb, cookie);
    }

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& id, const ::IceGrid::Callback_ObjectObserver_objectRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectRemoved(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& id, const ::Ice::Context& context, const ::IceGrid::Callback_ObjectObserver_objectRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectRemoved(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_objectRemoved.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_objectRemoved(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_objectRemoved(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) AdminSession : public virtual ::Ice::Proxy<AdminSession, ::IceProxy::Glacier2::Session>
{
public:

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @see Registry#getSessionTimeout
     */
    ICE_MEMBER(ICEGRID_API) void keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_keepAlive(_iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, cb, cookie);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::Callback_AdminSession_keepAlivePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_keepAlivePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_keepAlive.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_keepAlive(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_keepAlive(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param context The Context map to send with the invocation.
     * @return The admin interface proxy.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminPrx getAdmin(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAdmin(_iceI_begin_getAdmin(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdmin(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAdmin(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdmin(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdmin(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdmin(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdmin(context, cb, cookie);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdmin(const ::IceGrid::Callback_AdminSession_getAdminPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdmin(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdmin(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_getAdminPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdmin(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAdmin.
     * @param result The asynchronous result object for the invocation.
     * @return The admin interface proxy.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminPrx end_getAdmin(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAdmin(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param context The Context map to send with the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx getAdminCallbackTemplate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAdminCallbackTemplate(_iceI_begin_getAdminCallbackTemplate(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAdminCallbackTemplate(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdminCallbackTemplate(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdminCallbackTemplate(context, cb, cookie);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::IceGrid::Callback_AdminSession_getAdminCallbackTemplatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdminCallbackTemplate(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_getAdminCallbackTemplatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdminCallbackTemplate(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getAdminCallbackTemplate.
     * @param result The asynchronous result object for the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_getAdminCallbackTemplate(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAdminCallbackTemplate(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    ICE_MEMBER(ICEGRID_API) void setObservers(const ::IceGrid::RegistryObserverPrx& registryObs, const ::IceGrid::NodeObserverPrx& nodeObs, const ::IceGrid::ApplicationObserverPrx& appObs, const ::IceGrid::AdapterObserverPrx& adptObs, const ::IceGrid::ObjectObserverPrx& objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setObservers(_iceI_begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& registryObs, const ::IceGrid::NodeObserverPrx& nodeObs, const ::IceGrid::ApplicationObserverPrx& appObs, const ::IceGrid::AdapterObserverPrx& adptObs, const ::IceGrid::ObjectObserverPrx& objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& registryObs, const ::IceGrid::NodeObserverPrx& nodeObs, const ::IceGrid::ApplicationObserverPrx& appObs, const ::IceGrid::AdapterObserverPrx& adptObs, const ::IceGrid::ObjectObserverPrx& objObs, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& registryObs, const ::IceGrid::NodeObserverPrx& nodeObs, const ::IceGrid::ApplicationObserverPrx& appObs, const ::IceGrid::AdapterObserverPrx& adptObs, const ::IceGrid::ObjectObserverPrx& objObs, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, context, cb, cookie);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& registryObs, const ::IceGrid::NodeObserverPrx& nodeObs, const ::IceGrid::ApplicationObserverPrx& appObs, const ::IceGrid::AdapterObserverPrx& adptObs, const ::IceGrid::ObjectObserverPrx& objObs, const ::IceGrid::Callback_AdminSession_setObserversPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& registryObs, const ::IceGrid::NodeObserverPrx& nodeObs, const ::IceGrid::ApplicationObserverPrx& appObs, const ::IceGrid::AdapterObserverPrx& adptObs, const ::IceGrid::ObjectObserverPrx& objObs, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_setObserversPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setObservers.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    ICE_MEMBER(ICEGRID_API) void end_setObservers(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_setObservers(const ::IceGrid::RegistryObserverPrx&, const ::IceGrid::NodeObserverPrx&, const ::IceGrid::ApplicationObserverPrx&, const ::IceGrid::AdapterObserverPrx&, const ::IceGrid::ObjectObserverPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    ICE_MEMBER(ICEGRID_API) void setObserversByIdentity(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setObserversByIdentity(_iceI_begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, context, cb, cookie);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::IceGrid::Callback_AdminSession_setObserversByIdentityPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_setObserversByIdentityPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setObserversByIdentity.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    ICE_MEMBER(ICEGRID_API) void end_setObserversByIdentity(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_setObserversByIdentity(const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param context The Context map to send with the invocation.
     * @return The current serial.
     * @throws IceGrid::AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int startUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_startUpdate(_iceI_begin_startUpdate(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_startUpdate(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startUpdate(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startUpdate(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startUpdate(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startUpdate(context, cb, cookie);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startUpdate(const ::IceGrid::Callback_AdminSession_startUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startUpdate(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_startUpdate(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_startUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startUpdate(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_startUpdate.
     * @param result The asynchronous result object for the invocation.
     * @return The current serial.
     * @throws IceGrid::AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_startUpdate(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_startUpdate(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     */
    ICE_MEMBER(ICEGRID_API) void finishUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_finishUpdate(_iceI_begin_finishUpdate(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finishUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_finishUpdate(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finishUpdate(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finishUpdate(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finishUpdate(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finishUpdate(context, cb, cookie);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finishUpdate(const ::IceGrid::Callback_AdminSession_finishUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finishUpdate(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finishUpdate(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_finishUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finishUpdate(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_finishUpdate.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     */
    ICE_MEMBER(ICEGRID_API) void end_finishUpdate(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_finishUpdate(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the name of the registry replica hosting this session.
     * @param context The Context map to send with the invocation.
     * @return The replica name of the registry.
     */
    ICE_MEMBER(ICEGRID_API) ::std::string getReplicaName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getReplicaName(_iceI_begin_getReplicaName(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getReplicaName(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaName(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaName(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaName(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaName(context, cb, cookie);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaName(const ::IceGrid::Callback_AdminSession_getReplicaNamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaName(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaName(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_getReplicaNamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaName(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getReplicaName.
     * @param result The asynchronous result object for the invocation.
     * @return The replica name of the registry.
     */
    ICE_MEMBER(ICEGRID_API) ::std::string end_getReplicaName(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getReplicaName(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openServerLog(const ::std::string& id, const ::std::string& path, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openServerLog(_iceI_begin_openServerLog(id, path, count, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& id, const ::std::string& path, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openServerLog(id, path, count, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& id, const ::std::string& path, ::Ice::Int count, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerLog(id, path, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& id, const ::std::string& path, ::Ice::Int count, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerLog(id, path, count, context, cb, cookie);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& id, const ::std::string& path, ::Ice::Int count, const ::IceGrid::Callback_AdminSession_openServerLogPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerLog(id, path, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& id, const ::std::string& path, ::Ice::Int count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openServerLogPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerLog(id, path, count, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_openServerLog.
     * @param result The asynchronous result object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openServerLog(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openServerLog(const ::std::string&, const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openServerStdErr(const ::std::string& id, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openServerStdErr(_iceI_begin_openServerStdErr(id, count, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& id, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openServerStdErr(id, count, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& id, ::Ice::Int count, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdErr(id, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& id, ::Ice::Int count, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdErr(id, count, context, cb, cookie);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& id, ::Ice::Int count, const ::IceGrid::Callback_AdminSession_openServerStdErrPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdErr(id, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& id, ::Ice::Int count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openServerStdErrPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdErr(id, count, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_openServerStdErr.
     * @param result The asynchronous result object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openServerStdErr(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openServerStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openServerStdOut(const ::std::string& id, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openServerStdOut(_iceI_begin_openServerStdOut(id, count, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& id, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openServerStdOut(id, count, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& id, ::Ice::Int count, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdOut(id, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& id, ::Ice::Int count, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdOut(id, count, context, cb, cookie);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& id, ::Ice::Int count, const ::IceGrid::Callback_AdminSession_openServerStdOutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdOut(id, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& id, ::Ice::Int count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openServerStdOutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdOut(id, count, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_openServerStdOut.
     * @param result The asynchronous result object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openServerStdOut(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openServerStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openNodeStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openNodeStdErr(_iceI_begin_openNodeStdErr(name, count, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openNodeStdErr(name, count, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdErr(name, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdErr(name, count, context, cb, cookie);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& name, ::Ice::Int count, const ::IceGrid::Callback_AdminSession_openNodeStdErrPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdErr(name, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openNodeStdErrPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdErr(name, count, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_openNodeStdErr.
     * @param result The asynchronous result object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openNodeStdErr(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openNodeStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openNodeStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openNodeStdOut(_iceI_begin_openNodeStdOut(name, count, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openNodeStdOut(name, count, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdOut(name, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdOut(name, count, context, cb, cookie);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& name, ::Ice::Int count, const ::IceGrid::Callback_AdminSession_openNodeStdOutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdOut(name, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openNodeStdOutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdOut(name, count, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_openNodeStdOut.
     * @param result The asynchronous result object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openNodeStdOut(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openNodeStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openRegistryStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openRegistryStdErr(_iceI_begin_openRegistryStdErr(name, count, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openRegistryStdErr(name, count, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdErr(name, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdErr(name, count, context, cb, cookie);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& name, ::Ice::Int count, const ::IceGrid::Callback_AdminSession_openRegistryStdErrPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdErr(name, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openRegistryStdErrPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdErr(name, count, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_openRegistryStdErr.
     * @param result The asynchronous result object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openRegistryStdErr(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openRegistryStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openRegistryStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openRegistryStdOut(_iceI_begin_openRegistryStdOut(name, count, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openRegistryStdOut(name, count, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdOut(name, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdOut(name, count, context, cb, cookie);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& name, ::Ice::Int count, const ::IceGrid::Callback_AdminSession_openRegistryStdOutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdOut(name, count, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openRegistryStdOutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdOut(name, count, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_openRegistryStdOut.
     * @param result The asynchronous result object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openRegistryStdOut(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openRegistryStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceGrid
{

/**
 * The IceGrid administrative interface.
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Admin : public virtual ::Ice::Object
{
public:

    typedef AdminPrx ProxyType;
    typedef AdminPtr PointerType;

    virtual ~Admin();

#ifdef ICE_CPP11_COMPILER
    Admin() = default;
    Admin(const Admin&) = default;
    Admin& operator=(const Admin&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void addApplication(const ApplicationDescriptor& descriptor, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void syncApplication(const ApplicationDescriptor& descriptor, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_syncApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void updateApplication(const ApplicationUpdateDescriptor& descriptor, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_updateApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void syncApplicationWithoutRestart(const ApplicationDescriptor& descriptor, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_syncApplicationWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment
     * failed.
     */
    virtual void updateApplicationWithoutRestart(const ApplicationUpdateDescriptor& descriptor, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_updateApplicationWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    virtual void removeApplication(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::DeploymentException Raised if server instantiation
     * failed.
     */
    virtual void instantiateServer(const ::std::string& application, const ::std::string& node, const ServerInstanceDescriptor& desc, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_instantiateServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Patch the given application data.
     * @param cb The AMD callback object for the invocation.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param current The Current object for the invocation.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws IceGrid::PatchException Raised if the patch failed.
     */
    virtual void patchApplication_async(const ::IceGrid::AMD_Admin_patchApplicationPtr& cb, const ::std::string& name, bool shutdown, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_patchApplication(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param current The Current object for the invocation.
     * @return The application descriptor.
     * @throws IceGrid::ApplicationNotExistException Raised if the application
     * doesn't exist.
     */
    virtual ApplicationInfo getApplicationInfo(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getApplicationInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the default application descriptor.
     * @param current The Current object for the invocation.
     * @return The default application descriptor.
     * @throws IceGrid::DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     */
    virtual ApplicationDescriptor getDefaultApplicationDescriptor(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getDefaultApplicationDescriptor(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get all the IceGrid applications currently registered.
     * @param current The Current object for the invocation.
     * @return The application names.
     */
    virtual ::Ice::StringSeq getAllApplicationNames(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllApplicationNames(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server information.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual ServerInfo getServerInfo(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a server's state.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server state.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual ServerState getServerState(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerState(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server's process id.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual ::Ice::Int getServerPid(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerPid(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param current The Current object for the invocation.
     * @return The category for server admin objects.
     */
    virtual ::std::string getServerAdminCategory(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerAdminCategory(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return A proxy to the server's admin object
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual ::Ice::ObjectPrx getServerAdmin(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServerAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't exist.
     */
    virtual void enableServer(const ::std::string& id, bool enabled, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_enableServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return True if the server is enabled.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual bool isServerEnabled(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_isServerEnabled(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Start a server and wait for its activation.
     * @param cb The AMD callback object for the invocation.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStartException Raised if the server couldn't be
     * started.
     */
    virtual void startServer_async(const ::IceGrid::AMD_Admin_startServerPtr& cb, const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_startServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Stop a server.
     * @param cb The AMD callback object for the invocation.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws IceGrid::ServerStopException Raised if the server couldn't be
     * stopped.
     */
    virtual void stopServer_async(const ::IceGrid::AMD_Admin_stopServerPtr& cb, const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_stopServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Patch a server.
     * @param cb The AMD callback object for the invocation.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::PatchException Raised if the patch failed.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual void patchServer_async(const ::IceGrid::AMD_Admin_patchServerPtr& cb, const ::std::string& id, bool shutdown, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_patchServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param current The Current object for the invocation.
     * @throws IceGrid::BadSignalException Raised if the signal is not recognized
     * by the target server.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual void sendSignal(const ::std::string& id, const ::std::string& signal, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_sendSignal(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get all the server ids registered with IceGrid.
     * @param current The Current object for the invocation.
     * @return The server ids.
     */
    virtual ::Ice::StringSeq getAllServerIds(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllServerIds(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param current The Current object for the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     */
    virtual AdapterInfoSeq getAdapterInfo(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAdapterInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     */
    virtual void removeAdapter(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeAdapter(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param current The Current object for the invocation.
     * @return The adapter ids.
     */
    virtual ::Ice::StringSeq getAllAdapterIds(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllAdapterIds(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    virtual void addObject(const ::Ice::ObjectPrx& obj, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addObject(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    virtual void updateObject(const ::Ice::ObjectPrx& obj, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_updateObject(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if application deployment failed.
     * @throws IceGrid::ObjectExistsException Raised if the object is already
     * registered.
     */
    virtual void addObjectWithType(const ::Ice::ObjectPrx& obj, const ::std::string& type, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_addObjectWithType(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param current The Current object for the invocation.
     * @throws IceGrid::DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    virtual void removeObject(const ::Ice::Identity& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_removeObject(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param current The Current object for the invocation.
     * @return The object info.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     */
    virtual ObjectInfo getObjectInfo(const ::Ice::Identity& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getObjectInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param current The Current object for the invocation.
     * @return The object infos.
     */
    virtual ObjectInfoSeq getObjectInfosByType(const ::std::string& type, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getObjectInfosByType(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param current The Current object for the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     */
    virtual ObjectInfoSeq getAllObjectInfos(const ::std::string& expr, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllObjectInfos(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     */
    virtual bool pingNode(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_pingNode(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node load information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual LoadInfo getNodeLoad(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeLoad(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node information.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual NodeInfo getNodeInfo(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param current The Current object for the invocation.
     * @return A proxy to the IceGrid node's admin object
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual ::Ice::ObjectPrx getNodeAdmin(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual ::Ice::Int getNodeProcessorSocketCount(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeProcessorSocketCount(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual void shutdownNode(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_shutdownNode(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node hostname.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not be
     * reached.
     */
    virtual ::std::string getNodeHostname(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodeHostname(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get all the IceGrid nodes currently registered.
     * @param current The Current object for the invocation.
     * @return The node names.
     */
    virtual ::Ice::StringSeq getAllNodeNames(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllNodeNames(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    virtual bool pingRegistry(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_pingRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @return The registry information.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    virtual RegistryInfo getRegistryInfo(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getRegistryInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param current The Current object for the invocation.
     * @return A proxy to the IceGrid registry's admin object
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     */
    virtual ::Ice::ObjectPrx getRegistryAdmin(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getRegistryAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @throws IceGrid::RegistryNotExistException Raised if the registry doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry could not be
     * reached.
     */
    virtual void shutdownRegistry(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_shutdownRegistry(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get all the IceGrid registries currently registered.
     * @param current The Current object for the invocation.
     * @return The registry names.
     */
    virtual ::Ice::StringSeq getAllRegistryNames(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAllRegistryNames(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shut down the IceGrid registry.
     * @param current The Current object for the invocation.
     */
    virtual void shutdown(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     */
    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Admin& lhs, const Admin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Admin& lhs, const Admin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * This interface provides access to IceGrid log file contents.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API FileIterator : public virtual ::Ice::Object
{
public:

    typedef FileIteratorPrx ProxyType;
    typedef FileIteratorPtr PointerType;

    virtual ~FileIterator();

#ifdef ICE_CPP11_COMPILER
    FileIterator() = default;
    FileIterator(const FileIterator&) = default;
    FileIterator& operator=(const FileIterator&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Read lines from the log file.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * @param current The Current object for the invocation.
     * @return True if EOF is encountered.
     * @throws IceGrid::FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     */
    virtual bool read(::Ice::Int size, ::Ice::StringSeq& lines, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_read(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the iterator.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const FileIterator& lhs, const FileIterator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const FileIterator& lhs, const FileIterator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * This interface allows applications to monitor changes the state
 * of the registry.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API RegistryObserver : public virtual ::Ice::Object
{
public:

    typedef RegistryObserverPrx ProxyType;
    typedef RegistryObserverPtr PointerType;

    virtual ~RegistryObserver();

#ifdef ICE_CPP11_COMPILER
    RegistryObserver() = default;
    RegistryObserver(const RegistryObserver&) = default;
    RegistryObserver& operator=(const RegistryObserver&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The <code>registryInit</code> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param current The Current object for the invocation.
     */
    virtual void registryInit(const RegistryInfoSeq& registries, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registryInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param current The Current object for the invocation.
     */
    virtual void registryUp(const RegistryInfo& node, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registryUp(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param current The Current object for the invocation.
     */
    virtual void registryDown(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registryDown(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const RegistryObserver& lhs, const RegistryObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RegistryObserver& lhs, const RegistryObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The node observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * nodes.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API NodeObserver : public virtual ::Ice::Object
{
public:

    typedef NodeObserverPrx ProxyType;
    typedef NodeObserverPtr PointerType;

    virtual ~NodeObserver();

#ifdef ICE_CPP11_COMPILER
    NodeObserver() = default;
    NodeObserver(const NodeObserver&) = default;
    NodeObserver& operator=(const NodeObserver&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The <code>nodeInit</code> operation indicates the current state
     * of nodes. It is called after the registration of an observer.
     * @param nodes The current state of the nodes.
     * @param current The Current object for the invocation.
     */
    virtual void nodeInit(const NodeDynamicInfoSeq& nodes, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_nodeInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>nodeUp</code> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param current The Current object for the invocation.
     */
    virtual void nodeUp(const NodeDynamicInfo& node, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_nodeUp(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>nodeDown</code> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param current The Current object for the invocation.
     */
    virtual void nodeDown(const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_nodeDown(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>updateServer</code> operation is called to notify an observer that
     * the state of a server changed.
     * @param node The node hosting the server.
     * @param updatedInfo The new server state.
     * @param current The Current object for the invocation.
     */
    virtual void updateServer(const ::std::string& node, const ServerDynamicInfo& updatedInfo, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_updateServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>updateAdapter</code> operation is called to notify an observer that
     * the state of an adapter changed.
     * @param node The node hosting the adapter.
     * @param updatedInfo The new adapter state.
     * @param current The Current object for the invocation.
     */
    virtual void updateAdapter(const ::std::string& node, const AdapterDynamicInfo& updatedInfo, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_updateAdapter(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const NodeObserver& lhs, const NodeObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const NodeObserver& lhs, const NodeObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ApplicationObserver : public virtual ::Ice::Object
{
public:

    typedef ApplicationObserverPrx ProxyType;
    typedef ApplicationObserverPtr PointerType;

    virtual ~ApplicationObserver();

#ifdef ICE_CPP11_COMPILER
    ApplicationObserver() = default;
    ApplicationObserver(const ApplicationObserver&) = default;
    ApplicationObserver& operator=(const ApplicationObserver&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * <code>applicationInit</code> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param current The Current object for the invocation.
     */
    virtual void applicationInit(::Ice::Int serial, const ApplicationInfoSeq& applications, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_applicationInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>applicationAdded</code> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param current The Current object for the invocation.
     */
    virtual void applicationAdded(::Ice::Int serial, const ApplicationInfo& desc, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_applicationAdded(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>applicationRemoved</code> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param current The Current object for the invocation.
     */
    virtual void applicationRemoved(::Ice::Int serial, const ::std::string& name, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_applicationRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>applicationUpdated</code> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param current The Current object for the invocation.
     */
    virtual void applicationUpdated(::Ice::Int serial, const ApplicationUpdateInfo& desc, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_applicationUpdated(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ApplicationObserver& lhs, const ApplicationObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ApplicationObserver& lhs, const ApplicationObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * This interface allows applications to monitor the state of object
 * adapters that are registered with IceGrid.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AdapterObserver : public virtual ::Ice::Object
{
public:

    typedef AdapterObserverPrx ProxyType;
    typedef AdapterObserverPtr PointerType;

    virtual ~AdapterObserver();

#ifdef ICE_CPP11_COMPILER
    AdapterObserver() = default;
    AdapterObserver(const AdapterObserver&) = default;
    AdapterObserver& operator=(const AdapterObserver&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * <code>adapterInit</code> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param current The Current object for the invocation.
     */
    virtual void adapterInit(const AdapterInfoSeq& adpts, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>adapterAdded</code> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param current The Current object for the invocation.
     */
    virtual void adapterAdded(const AdapterInfo& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterAdded(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param current The Current object for the invocation.
     */
    virtual void adapterUpdated(const AdapterInfo& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterUpdated(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param current The Current object for the invocation.
     */
    virtual void adapterRemoved(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_adapterRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const AdapterObserver& lhs, const AdapterObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const AdapterObserver& lhs, const AdapterObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * This interface allows applications to monitor IceGrid well-known objects.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ObjectObserver : public virtual ::Ice::Object
{
public:

    typedef ObjectObserverPrx ProxyType;
    typedef ObjectObserverPtr PointerType;

    virtual ~ObjectObserver();

#ifdef ICE_CPP11_COMPILER
    ObjectObserver() = default;
    ObjectObserver(const ObjectObserver&) = default;
    ObjectObserver& operator=(const ObjectObserver&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * <code>objectInit</code> is called after the registration of
     * an observer to indicate the state of the registry.
     * @param objects The objects registered with the {@link Admin}
     * interface (not through the deployment mechanism).
     * @param current The Current object for the invocation.
     */
    virtual void objectInit(const ObjectInfoSeq& objects, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_objectInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The <code>objectAdded</code> operation is called to notify an observer when an
     * object was added to the {@link Admin} interface.
     * @param info The details of the added object.
     * @param current The Current object for the invocation.
     */
    virtual void objectAdded(const ObjectInfo& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_objectAdded(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * <code>objectUpdated</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was updated.
     * @param info The details of the updated object.
     * @param current The Current object for the invocation.
     */
    virtual void objectUpdated(const ObjectInfo& info, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_objectUpdated(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * <code>objectRemoved</code> is called to notify an observer when
     * an object registered with the {@link Admin} interface was removed.
     * @param id The identity of the removed object.
     * @param current The Current object for the invocation.
     */
    virtual void objectRemoved(const ::Ice::Identity& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_objectRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ObjectObserver& lhs, const ObjectObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ObjectObserver& lhs, const ObjectObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either via the {@link Registry}
 * object or via the registry admin <code>SessionManager</code> object.
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AdminSession : virtual public ::Glacier2::Session
{
public:

    typedef AdminSessionPrx ProxyType;
    typedef AdminSessionPtr PointerType;

    virtual ~AdminSession();

#ifdef ICE_CPP11_COMPILER
    AdminSession() = default;
    AdminSession(const AdminSession&) = default;
    AdminSession& operator=(const AdminSession&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param current The Current object for the invocation.
     * @see Registry#getSessionTimeout
     */
    virtual void keepAlive(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param current The Current object for the invocation.
     * @return The admin interface proxy.
     */
    virtual AdminPrx getAdmin(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param current The Current object for the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     */
    virtual ::Ice::ObjectPrx getAdminCallbackTemplate(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAdminCallbackTemplate(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param current The Current object for the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    virtual void setObservers(const RegistryObserverPrx& registryObs, const NodeObserverPrx& nodeObs, const ApplicationObserverPrx& appObs, const AdapterObserverPrx& adptObs, const ObjectObserverPrx& objObs, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setObservers(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param current The Current object for the invocation.
     * @throws IceGrid::ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     */
    virtual void setObserversByIdentity(const ::Ice::Identity& registryObs, const ::Ice::Identity& nodeObs, const ::Ice::Identity& appObs, const ::Ice::Identity& adptObs, const ::Ice::Identity& objObs, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setObserversByIdentity(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param current The Current object for the invocation.
     * @return The current serial.
     * @throws IceGrid::AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     */
    virtual ::Ice::Int startUpdate(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_startUpdate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     */
    virtual void finishUpdate(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_finishUpdate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the name of the registry replica hosting this session.
     * @param current The Current object for the invocation.
     * @return The replica name of the registry.
     */
    virtual ::std::string getReplicaName(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getReplicaName(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual FileIteratorPrx openServerLog(const ::std::string& id, const ::std::string& path, ::Ice::Int count, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_openServerLog(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual FileIteratorPrx openServerStdErr(const ::std::string& id, ::Ice::Int count, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_openServerStdErr(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws IceGrid::ServerNotExistException Raised if the server doesn't
     * exist.
     */
    virtual FileIteratorPrx openServerStdOut(const ::std::string& id, ::Ice::Int count, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_openServerStdOut(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    virtual FileIteratorPrx openNodeStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_openNodeStdErr(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::NodeNotExistException Raised if the node doesn't exist.
     * @throws IceGrid::NodeUnreachableException Raised if the node could not
     * be reached.
     */
    virtual FileIteratorPrx openNodeStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_openNodeStdOut(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    virtual FileIteratorPrx openRegistryStdErr(const ::std::string& name, ::Ice::Int count, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_openRegistryStdErr(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param current The Current object for the invocation.
     * @return An iterator to read the file.
     * @throws IceGrid::FileNotAvailableException Raised if the file can't be
     * read.
     * @throws IceGrid::RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws IceGrid::RegistryUnreachableException Raised if the registry
     * could not be reached.
     */
    virtual FileIteratorPrx openRegistryStdOut(const ::std::string& name, ::Ice::Int count, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_openRegistryStdOut(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const AdminSession& lhs, const AdminSession& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const AdminSession& lhs, const AdminSession& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::ServerState>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 6;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits< ::IceGrid::ObjectInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObjectInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ObjectInfo& v)
    {
        ostr->write(v.proxy);
        ostr->write(v.type);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObjectInfo, S>
{
    static void read(S* istr, ::IceGrid::ObjectInfo& v)
    {
        istr->read(v.proxy);
        istr->read(v.type);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterInfo, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.proxy);
        ostr->write(v.replicaGroupId);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterInfo, S>
{
    static void read(S* istr, ::IceGrid::AdapterInfo& v)
    {
        istr->read(v.id);
        istr->read(v.proxy);
        istr->read(v.replicaGroupId);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 9;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ServerInfo& v)
    {
        ostr->write(v.application);
        ostr->write(v.uuid);
        ostr->write(v.revision);
        ostr->write(v.node);
        ostr->write(v.descriptor);
        ostr->write(v.sessionId);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerInfo, S>
{
    static void read(S* istr, ::IceGrid::ServerInfo& v)
    {
        istr->read(v.application);
        istr->read(v.uuid);
        istr->read(v.revision);
        istr->read(v.node);
        istr->read(v.descriptor);
        istr->read(v.sessionId);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeInfo, S>
{
    static void write(S* ostr, const ::IceGrid::NodeInfo& v)
    {
        ostr->write(v.name);
        ostr->write(v.os);
        ostr->write(v.hostname);
        ostr->write(v.release);
        ostr->write(v.version);
        ostr->write(v.machine);
        ostr->write(v.nProcessors);
        ostr->write(v.dataDir);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeInfo, S>
{
    static void read(S* istr, ::IceGrid::NodeInfo& v)
    {
        istr->read(v.name);
        istr->read(v.os);
        istr->read(v.hostname);
        istr->read(v.release);
        istr->read(v.version);
        istr->read(v.machine);
        istr->read(v.nProcessors);
        istr->read(v.dataDir);
    }
};

template<>
struct StreamableTraits< ::IceGrid::RegistryInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::RegistryInfo, S>
{
    static void write(S* ostr, const ::IceGrid::RegistryInfo& v)
    {
        ostr->write(v.name);
        ostr->write(v.hostname);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::RegistryInfo, S>
{
    static void read(S* istr, ::IceGrid::RegistryInfo& v)
    {
        istr->read(v.name);
        istr->read(v.hostname);
    }
};

template<>
struct StreamableTraits< ::IceGrid::LoadInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 12;
    static const bool fixedLength = true;
};

template<typename S>
struct StreamWriter< ::IceGrid::LoadInfo, S>
{
    static void write(S* ostr, const ::IceGrid::LoadInfo& v)
    {
        ostr->write(v.avg1);
        ostr->write(v.avg5);
        ostr->write(v.avg15);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::LoadInfo, S>
{
    static void read(S* istr, ::IceGrid::LoadInfo& v)
    {
        istr->read(v.avg1);
        istr->read(v.avg5);
        istr->read(v.avg15);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ApplicationInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 33;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationInfo& v)
    {
        ostr->write(v.uuid);
        ostr->write(v.createTime);
        ostr->write(v.createUser);
        ostr->write(v.updateTime);
        ostr->write(v.updateUser);
        ostr->write(v.revision);
        ostr->write(v.descriptor);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationInfo, S>
{
    static void read(S* istr, ::IceGrid::ApplicationInfo& v)
    {
        istr->read(v.uuid);
        istr->read(v.createTime);
        istr->read(v.createUser);
        istr->read(v.updateTime);
        istr->read(v.updateUser);
        istr->read(v.revision);
        istr->read(v.descriptor);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ApplicationUpdateInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 28;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationUpdateInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationUpdateInfo& v)
    {
        ostr->write(v.updateTime);
        ostr->write(v.updateUser);
        ostr->write(v.revision);
        ostr->write(v.descriptor);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationUpdateInfo, S>
{
    static void read(S* istr, ::IceGrid::ApplicationUpdateInfo& v)
    {
        istr->read(v.updateTime);
        istr->read(v.updateUser);
        istr->read(v.revision);
        istr->read(v.descriptor);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerDynamicInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ServerDynamicInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.state);
        ostr->write(v.pid);
        ostr->write(v.enabled);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::ServerDynamicInfo& v)
    {
        istr->read(v.id);
        istr->read(v.state);
        istr->read(v.pid);
        istr->read(v.enabled);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterDynamicInfo, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterDynamicInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.proxy);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::AdapterDynamicInfo& v)
    {
        istr->read(v.id);
        istr->read(v.proxy);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 13;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeDynamicInfo, S>
{
    static void write(S* ostr, const ::IceGrid::NodeDynamicInfo& v)
    {
        ostr->write(v.info);
        ostr->write(v.servers);
        ostr->write(v.adapters);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::NodeDynamicInfo& v)
    {
        istr->read(v.info);
        istr->read(v.servers);
        istr->read(v.adapters);
    }
};

}
/// \endcond

namespace IceGrid
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_addApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_addApplication.
 */
template<class T>
class CallbackNC_Admin_addApplication : public Callback_Admin_addApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_addApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_addApplication.
 */
template<class T> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_addApplication.
 */
template<class T> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_addApplication.
 */
template<class T> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_addApplication.
 */
template<class T> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_addApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_addApplication.
 */
template<class T, typename CT>
class Callback_Admin_addApplication : public Callback_Admin_addApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_addApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_addApplication.
 */
template<class T, typename CT> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_addApplication.
 */
template<class T, typename CT> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_addApplication.
 */
template<class T, typename CT> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_addApplication.
 */
template<class T, typename CT> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_syncApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_syncApplication.
 */
template<class T>
class CallbackNC_Admin_syncApplication : public Callback_Admin_syncApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_syncApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_syncApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplication.
 */
template<class T> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplication.
 */
template<class T> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplication.
 */
template<class T> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplication.
 */
template<class T> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_syncApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_syncApplication.
 */
template<class T, typename CT>
class Callback_Admin_syncApplication : public Callback_Admin_syncApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_syncApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_syncApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplication.
 */
template<class T, typename CT> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplication.
 */
template<class T, typename CT> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplication.
 */
template<class T, typename CT> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplication.
 */
template<class T, typename CT> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_updateApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_updateApplication.
 */
template<class T>
class CallbackNC_Admin_updateApplication : public Callback_Admin_updateApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_updateApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplication.
 */
template<class T> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplication.
 */
template<class T> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplication.
 */
template<class T> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplication.
 */
template<class T> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_updateApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_updateApplication.
 */
template<class T, typename CT>
class Callback_Admin_updateApplication : public Callback_Admin_updateApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_updateApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplication.
 */
template<class T, typename CT> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplication.
 */
template<class T, typename CT> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplication.
 */
template<class T, typename CT> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplication.
 */
template<class T, typename CT> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_syncApplicationWithoutRestart.
 */
template<class T>
class CallbackNC_Admin_syncApplicationWithoutRestart : public Callback_Admin_syncApplicationWithoutRestart_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_syncApplicationWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_syncApplicationWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 */
template<class T> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplicationWithoutRestart<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 */
template<class T> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplicationWithoutRestart<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 */
template<class T> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplicationWithoutRestart<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 */
template<class T> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplicationWithoutRestart<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_syncApplicationWithoutRestart.
 */
template<class T, typename CT>
class Callback_Admin_syncApplicationWithoutRestart : public Callback_Admin_syncApplicationWithoutRestart_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_syncApplicationWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_syncApplicationWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 */
template<class T, typename CT> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplicationWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 */
template<class T, typename CT> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplicationWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 */
template<class T, typename CT> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplicationWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_syncApplicationWithoutRestart.
 */
template<class T, typename CT> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplicationWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_updateApplicationWithoutRestart.
 */
template<class T>
class CallbackNC_Admin_updateApplicationWithoutRestart : public Callback_Admin_updateApplicationWithoutRestart_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_updateApplicationWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateApplicationWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 */
template<class T> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplicationWithoutRestart<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 */
template<class T> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplicationWithoutRestart<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 */
template<class T> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplicationWithoutRestart<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 */
template<class T> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplicationWithoutRestart<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_updateApplicationWithoutRestart.
 */
template<class T, typename CT>
class Callback_Admin_updateApplicationWithoutRestart : public Callback_Admin_updateApplicationWithoutRestart_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_updateApplicationWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateApplicationWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 */
template<class T, typename CT> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplicationWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 */
template<class T, typename CT> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplicationWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 */
template<class T, typename CT> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplicationWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_updateApplicationWithoutRestart.
 */
template<class T, typename CT> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplicationWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_removeApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_removeApplication.
 */
template<class T>
class CallbackNC_Admin_removeApplication : public Callback_Admin_removeApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_removeApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_removeApplication.
 */
template<class T> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_removeApplication.
 */
template<class T> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_removeApplication.
 */
template<class T> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_removeApplication.
 */
template<class T> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_removeApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_removeApplication.
 */
template<class T, typename CT>
class Callback_Admin_removeApplication : public Callback_Admin_removeApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_removeApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_removeApplication.
 */
template<class T, typename CT> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_removeApplication.
 */
template<class T, typename CT> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_removeApplication.
 */
template<class T, typename CT> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_removeApplication.
 */
template<class T, typename CT> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_instantiateServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_instantiateServer.
 */
template<class T>
class CallbackNC_Admin_instantiateServer : public Callback_Admin_instantiateServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_instantiateServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_instantiateServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_instantiateServer.
 */
template<class T> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_instantiateServer<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_instantiateServer.
 */
template<class T> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_instantiateServer<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_instantiateServer.
 */
template<class T> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_instantiateServer<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_instantiateServer.
 */
template<class T> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_instantiateServer<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_instantiateServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_instantiateServer.
 */
template<class T, typename CT>
class Callback_Admin_instantiateServer : public Callback_Admin_instantiateServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_instantiateServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_instantiateServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_instantiateServer.
 */
template<class T, typename CT> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_instantiateServer<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_instantiateServer.
 */
template<class T, typename CT> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_instantiateServer<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_instantiateServer.
 */
template<class T, typename CT> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_instantiateServer<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_instantiateServer.
 */
template<class T, typename CT> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_instantiateServer<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_patchApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_patchApplication.
 */
template<class T>
class CallbackNC_Admin_patchApplication : public Callback_Admin_patchApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_patchApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_patchApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_patchApplication.
 */
template<class T> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_patchApplication.
 */
template<class T> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_patchApplication.
 */
template<class T> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchApplication<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_patchApplication.
 */
template<class T> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchApplication<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_patchApplication.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_patchApplication.
 */
template<class T, typename CT>
class Callback_Admin_patchApplication : public Callback_Admin_patchApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_patchApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_patchApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_patchApplication.
 */
template<class T, typename CT> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_patchApplication.
 */
template<class T, typename CT> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_patchApplication.
 */
template<class T, typename CT> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchApplication<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_patchApplication.
 */
template<class T, typename CT> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchApplication<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_getApplicationInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getApplicationInfo.
 */
template<class T>
class CallbackNC_Admin_getApplicationInfo : public Callback_Admin_getApplicationInfo_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ApplicationInfo&);

    CallbackNC_Admin_getApplicationInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ApplicationInfo ret;
        try
        {
            ret = proxy->end_getApplicationInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getApplicationInfo.
 */
template<class T> Callback_Admin_getApplicationInfoPtr
newCallback_Admin_getApplicationInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ApplicationInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getApplicationInfo<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getApplicationInfo.
 */
template<class T> Callback_Admin_getApplicationInfoPtr
newCallback_Admin_getApplicationInfo(T* instance, void (T::*cb)(const ApplicationInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getApplicationInfo<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_getApplicationInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getApplicationInfo.
 */
template<class T, typename CT>
class Callback_Admin_getApplicationInfo : public Callback_Admin_getApplicationInfo_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ApplicationInfo&, const CT&);

    Callback_Admin_getApplicationInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ApplicationInfo ret;
        try
        {
            ret = proxy->end_getApplicationInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getApplicationInfo.
 */
template<class T, typename CT> Callback_Admin_getApplicationInfoPtr
newCallback_Admin_getApplicationInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ApplicationInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getApplicationInfo<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getApplicationInfo.
 */
template<class T, typename CT> Callback_Admin_getApplicationInfoPtr
newCallback_Admin_getApplicationInfo(T* instance, void (T::*cb)(const ApplicationInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getApplicationInfo<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_getDefaultApplicationDescriptor.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getDefaultApplicationDescriptor.
 */
template<class T>
class CallbackNC_Admin_getDefaultApplicationDescriptor : public Callback_Admin_getDefaultApplicationDescriptor_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ApplicationDescriptor&);

    CallbackNC_Admin_getDefaultApplicationDescriptor(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ApplicationDescriptor ret;
        try
        {
            ret = proxy->end_getDefaultApplicationDescriptor(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getDefaultApplicationDescriptor.
 */
template<class T> Callback_Admin_getDefaultApplicationDescriptorPtr
newCallback_Admin_getDefaultApplicationDescriptor(const IceUtil::Handle<T>& instance, void (T::*cb)(const ApplicationDescriptor&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getDefaultApplicationDescriptor<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getDefaultApplicationDescriptor.
 */
template<class T> Callback_Admin_getDefaultApplicationDescriptorPtr
newCallback_Admin_getDefaultApplicationDescriptor(T* instance, void (T::*cb)(const ApplicationDescriptor&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getDefaultApplicationDescriptor<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_getDefaultApplicationDescriptor.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getDefaultApplicationDescriptor.
 */
template<class T, typename CT>
class Callback_Admin_getDefaultApplicationDescriptor : public Callback_Admin_getDefaultApplicationDescriptor_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ApplicationDescriptor&, const CT&);

    Callback_Admin_getDefaultApplicationDescriptor(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ApplicationDescriptor ret;
        try
        {
            ret = proxy->end_getDefaultApplicationDescriptor(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getDefaultApplicationDescriptor.
 */
template<class T, typename CT> Callback_Admin_getDefaultApplicationDescriptorPtr
newCallback_Admin_getDefaultApplicationDescriptor(const IceUtil::Handle<T>& instance, void (T::*cb)(const ApplicationDescriptor&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getDefaultApplicationDescriptor<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getDefaultApplicationDescriptor.
 */
template<class T, typename CT> Callback_Admin_getDefaultApplicationDescriptorPtr
newCallback_Admin_getDefaultApplicationDescriptor(T* instance, void (T::*cb)(const ApplicationDescriptor&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getDefaultApplicationDescriptor<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_getAllApplicationNames.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAllApplicationNames.
 */
template<class T>
class CallbackNC_Admin_getAllApplicationNames : public Callback_Admin_getAllApplicationNames_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_Admin_getAllApplicationNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllApplicationNames(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getAllApplicationNames.
 */
template<class T> Callback_Admin_getAllApplicationNamesPtr
newCallback_Admin_getAllApplicationNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllApplicationNames<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getAllApplicationNames.
 */
template<class T> Callback_Admin_getAllApplicationNamesPtr
newCallback_Admin_getAllApplicationNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllApplicationNames<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_getAllApplicationNames.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getAllApplicationNames.
 */
template<class T, typename CT>
class Callback_Admin_getAllApplicationNames : public Callback_Admin_getAllApplicationNames_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_Admin_getAllApplicationNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllApplicationNames(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getAllApplicationNames.
 */
template<class T, typename CT> Callback_Admin_getAllApplicationNamesPtr
newCallback_Admin_getAllApplicationNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllApplicationNames<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getAllApplicationNames.
 */
template<class T, typename CT> Callback_Admin_getAllApplicationNamesPtr
newCallback_Admin_getAllApplicationNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllApplicationNames<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerInfo.
 */
template<class T>
class CallbackNC_Admin_getServerInfo : public Callback_Admin_getServerInfo_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ServerInfo&);

    CallbackNC_Admin_getServerInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ServerInfo ret;
        try
        {
            ret = proxy->end_getServerInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerInfo.
 */
template<class T> Callback_Admin_getServerInfoPtr
newCallback_Admin_getServerInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ServerInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerInfo<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerInfo.
 */
template<class T> Callback_Admin_getServerInfoPtr
newCallback_Admin_getServerInfo(T* instance, void (T::*cb)(const ServerInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerInfo<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerInfo.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerInfo.
 */
template<class T, typename CT>
class Callback_Admin_getServerInfo : public Callback_Admin_getServerInfo_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ServerInfo&, const CT&);

    Callback_Admin_getServerInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ServerInfo ret;
        try
        {
            ret = proxy->end_getServerInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerInfo.
 */
template<class T, typename CT> Callback_Admin_getServerInfoPtr
newCallback_Admin_getServerInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ServerInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerInfo<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerInfo.
 */
template<class T, typename CT> Callback_Admin_getServerInfoPtr
newCallback_Admin_getServerInfo(T* instance, void (T::*cb)(const ServerInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerInfo<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerState.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerState.
 */
template<class T>
class CallbackNC_Admin_getServerState : public Callback_Admin_getServerState_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(ServerState);

    CallbackNC_Admin_getServerState(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ServerState ret;
        try
        {
            ret = proxy->end_getServerState(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerState.
 */
template<class T> Callback_Admin_getServerStatePtr
newCallback_Admin_getServerState(const IceUtil::Handle<T>& instance, void (T::*cb)(ServerState), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerState<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerState.
 */
template<class T> Callback_Admin_getServerStatePtr
newCallback_Admin_getServerState(T* instance, void (T::*cb)(ServerState), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerState<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerState.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerState.
 */
template<class T, typename CT>
class Callback_Admin_getServerState : public Callback_Admin_getServerState_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(ServerState, const CT&);

    Callback_Admin_getServerState(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ServerState ret;
        try
        {
            ret = proxy->end_getServerState(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerState.
 */
template<class T, typename CT> Callback_Admin_getServerStatePtr
newCallback_Admin_getServerState(const IceUtil::Handle<T>& instance, void (T::*cb)(ServerState, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerState<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerState.
 */
template<class T, typename CT> Callback_Admin_getServerStatePtr
newCallback_Admin_getServerState(T* instance, void (T::*cb)(ServerState, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerState<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerPid.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerPid.
 */
template<class T>
class CallbackNC_Admin_getServerPid : public Callback_Admin_getServerPid_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Admin_getServerPid(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getServerPid(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerPid.
 */
template<class T> Callback_Admin_getServerPidPtr
newCallback_Admin_getServerPid(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerPid<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerPid.
 */
template<class T> Callback_Admin_getServerPidPtr
newCallback_Admin_getServerPid(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerPid<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerPid.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerPid.
 */
template<class T, typename CT>
class Callback_Admin_getServerPid : public Callback_Admin_getServerPid_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Admin_getServerPid(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getServerPid(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerPid.
 */
template<class T, typename CT> Callback_Admin_getServerPidPtr
newCallback_Admin_getServerPid(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerPid<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerPid.
 */
template<class T, typename CT> Callback_Admin_getServerPidPtr
newCallback_Admin_getServerPid(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerPid<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerAdminCategory.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerAdminCategory.
 */
template<class T>
class CallbackNC_Admin_getServerAdminCategory : public Callback_Admin_getServerAdminCategory_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Admin_getServerAdminCategory(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getServerAdminCategory(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerAdminCategory.
 */
template<class T> Callback_Admin_getServerAdminCategoryPtr
newCallback_Admin_getServerAdminCategory(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerAdminCategory<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerAdminCategory.
 */
template<class T> Callback_Admin_getServerAdminCategoryPtr
newCallback_Admin_getServerAdminCategory(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerAdminCategory<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerAdminCategory.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerAdminCategory.
 */
template<class T, typename CT>
class Callback_Admin_getServerAdminCategory : public Callback_Admin_getServerAdminCategory_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Admin_getServerAdminCategory(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getServerAdminCategory(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerAdminCategory.
 */
template<class T, typename CT> Callback_Admin_getServerAdminCategoryPtr
newCallback_Admin_getServerAdminCategory(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerAdminCategory<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerAdminCategory.
 */
template<class T, typename CT> Callback_Admin_getServerAdminCategoryPtr
newCallback_Admin_getServerAdminCategory(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerAdminCategory<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerAdmin.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerAdmin.
 */
template<class T>
class CallbackNC_Admin_getServerAdmin : public Callback_Admin_getServerAdmin_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Admin_getServerAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getServerAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerAdmin.
 */
template<class T> Callback_Admin_getServerAdminPtr
newCallback_Admin_getServerAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerAdmin<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerAdmin.
 */
template<class T> Callback_Admin_getServerAdminPtr
newCallback_Admin_getServerAdmin(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerAdmin<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_getServerAdmin.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_getServerAdmin.
 */
template<class T, typename CT>
class Callback_Admin_getServerAdmin : public Callback_Admin_getServerAdmin_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Admin_getServerAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getServerAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerAdmin.
 */
template<class T, typename CT> Callback_Admin_getServerAdminPtr
newCallback_Admin_getServerAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerAdmin<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_getServerAdmin.
 */
template<class T, typename CT> Callback_Admin_getServerAdminPtr
newCallback_Admin_getServerAdmin(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerAdmin<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_enableServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_enableServer.
 */
template<class T>
class CallbackNC_Admin_enableServer : public Callback_Admin_enableServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_enableServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_enableServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_enableServer.
 */
template<class T> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_enableServer<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_enableServer.
 */
template<class T> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_enableServer<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_enableServer.
 */
template<class T> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_enableServer<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_enableServer.
 */
template<class T> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_enableServer<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Admin::begin_enableServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_enableServer.
 */
template<class T, typename CT>
class Callback_Admin_enableServer : public Callback_Admin_enableServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_enableServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_enableServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_enableServer.
 */
template<class T, typename CT> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_enableServer<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_enableServer.
 */
template<class T, typename CT> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_enableServer<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_enableServer.
 */
template<class T, typename CT> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_enableServer<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_enableServer.
 */
template<class T, typename CT> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_enableServer<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Admin::begin_isServerEnabled.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Admin_isServerEnabled.
 */
template<class T>
class CallbackNC_Admin_isServerEnabled : public Callback_Admin_isServerEnabled_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_Admin_isServerEnabled(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdminPrx proxy = AdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_isServerEnabled(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Admin::begin_isServerEnabled.
 */
template<class T> Callback_Admin_isServerEnabledPtr
newCallback_Admin_isServerEnabled(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_isServerEnabled<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exceptio