/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.utils.formatting.MethodNameFormatterFactory;

public class DiffFlatProfileContainer
extends FlatProfileContainer {
    private final ClientUtils.SourceCodeSelection[] sels;
    private final double wholeGraphNetTime0;
    private final double wholeGraphNetTime1;
    private final long minTime;
    private final long maxTime;

    static DiffFlatProfileContainer create(FlatProfileContainer c1, FlatProfileContainer c2) {
        ClientUtils.SourceCodeSelection sel;
        int i;
        boolean collectingTwoTimeStamps = c1.collectingTwoTimeStamps && c2.collectingTwoTimeStamps;
        HashSet<ClientUtils.SourceCodeSelection> sels1 = new HashSet<ClientUtils.SourceCodeSelection>();
        int rows1 = c1.timeInMcs0.length;
        for (int i2 = 0; i2 < rows1; ++i2) {
            sels1.add(c1.getSourceCodeSelectionAtRow(i2));
        }
        HashMap<ClientUtils.SourceCodeSelection, Integer> sels2 = new HashMap<ClientUtils.SourceCodeSelection, Integer>();
        int rows2 = c2.timeInMcs0.length;
        for (int i3 = 0; i3 < rows2; ++i3) {
            sels2.put(c2.getSourceCodeSelectionAtRow(i3), i3);
        }
        int pointer = 0;
        long[] timesInMcs0 = new long[rows1 + rows2];
        long[] timesInMcs1 = collectingTwoTimeStamps ? new long[rows1 + rows2] : null;
        long[] totalTimesInMcs0 = new long[rows1 + rows2];
        long[] totalTimesInMcs1 = collectingTwoTimeStamps ? new long[rows1 + rows2] : null;
        int[] nInvocations = new int[rows1 + rows2];
        ClientUtils.SourceCodeSelection[] sels = new ClientUtils.SourceCodeSelection[rows1 + rows2];
        int[] methodIDs = new int[rows1 + rows2];
        for (i = 0; i < rows1; ++i) {
            sel = c1.getSourceCodeSelectionAtRow(i);
            timesInMcs0[pointer] = -c1.timeInMcs0[i];
            totalTimesInMcs0[pointer] = -c1.totalTimeInMcs0[i];
            if (collectingTwoTimeStamps) {
                timesInMcs1[pointer] = -c1.timeInMcs1[i];
                totalTimesInMcs1[pointer] = -c1.totalTimeInMcs1[i];
            }
            nInvocations[pointer] = -c1.nInvocations[i];
            sels[pointer] = sel;
            methodIDs[pointer] = c1.methodIds[i];
            Integer i2 = (Integer)sels2.get(sel);
            if (i2 != null) {
                int n = pointer;
                timesInMcs0[n] = timesInMcs0[n] + c2.timeInMcs0[i2];
                int n2 = pointer;
                totalTimesInMcs0[n2] = totalTimesInMcs0[n2] + c2.totalTimeInMcs0[i2];
                if (collectingTwoTimeStamps) {
                    int n3 = pointer;
                    timesInMcs1[n3] = timesInMcs1[n3] + c2.timeInMcs1[i2];
                    int n4 = pointer;
                    totalTimesInMcs1[n4] = totalTimesInMcs1[n4] + c2.totalTimeInMcs1[i2];
                }
                int n5 = pointer;
                nInvocations[n5] = nInvocations[n5] + c2.nInvocations[i2];
            }
            ++pointer;
        }
        for (i = 0; i < rows2; ++i) {
            sel = c2.getSourceCodeSelectionAtRow(i);
            if (sels1.contains(sel)) continue;
            timesInMcs0[pointer] = c2.timeInMcs0[i];
            totalTimesInMcs0[pointer] = c2.totalTimeInMcs0[i];
            if (collectingTwoTimeStamps) {
                timesInMcs1[pointer] = c2.timeInMcs1[i];
                totalTimesInMcs1[pointer] = c2.totalTimeInMcs1[i];
            }
            nInvocations[pointer] = c2.nInvocations[i];
            sels[pointer] = sel;
            methodIDs[pointer] = -c2.methodIds[i];
            ++pointer;
        }
        double wholeGraphNetTime0 = c2.getWholeGraphNetTime0() - c1.getWholeGraphNetTime0();
        double wholeGraphNetTime1 = c2.getWholeGraphNetTime1() - c1.getWholeGraphNetTime1();
        return new DiffFlatProfileContainer(collectingTwoTimeStamps, Arrays.copyOf(timesInMcs0, pointer), collectingTwoTimeStamps ? Arrays.copyOf(timesInMcs1, pointer) : null, Arrays.copyOf(totalTimesInMcs0, pointer), collectingTwoTimeStamps ? Arrays.copyOf(totalTimesInMcs1, pointer) : null, Arrays.copyOf(nInvocations, pointer), Arrays.copyOf(sels, pointer), Arrays.copyOf(methodIDs, pointer), pointer, wholeGraphNetTime0, wholeGraphNetTime1);
    }

    private DiffFlatProfileContainer(boolean collectingTwoTimeStamps, long[] timeInMcs0, long[] timeInMcs1, long[] totalTimeInMcs0, long[] totalTimeInMcs1, int[] nInvocations, ClientUtils.SourceCodeSelection[] sels, int[] methodIDs, int nMethods, double wholeGraphNetTime0, double wholeGraphNetTime1) {
        super(timeInMcs0, timeInMcs1, totalTimeInMcs0, totalTimeInMcs1, nInvocations, null, nMethods);
        this.collectingTwoTimeStamps = collectingTwoTimeStamps;
        this.sels = sels;
        this.wholeGraphNetTime0 = wholeGraphNetTime0;
        this.wholeGraphNetTime1 = wholeGraphNetTime1;
        long minTimeX = Long.MAX_VALUE;
        long maxTimeX = Long.MIN_VALUE;
        this.nRows = nMethods;
        this.methodIds = methodIDs;
        for (int i = 0; i < this.nRows; ++i) {
            minTimeX = Math.min(minTimeX, timeInMcs0[i]);
            maxTimeX = Math.max(maxTimeX, timeInMcs0[i]);
            this.nTotalInvocations += (long)nInvocations[i];
        }
        if (minTimeX > 0L && maxTimeX > 0L) {
            minTimeX = 0L;
        } else if (minTimeX < 0L && maxTimeX < 0L) {
            maxTimeX = 0L;
        }
        this.minTime = minTimeX;
        this.maxTime = maxTimeX;
    }

    @Override
    public String getMethodNameAtRow(int row) {
        ClientUtils.SourceCodeSelection sel = this.getSourceCodeSelectionAtRow(row);
        return MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(sel.getClassName(), sel.getMethodName(), sel.getMethodSignature()).toFormatted();
    }

    @Override
    public ClientUtils.SourceCodeSelection getSourceCodeSelectionAtRow(int row) {
        return this.sels[row];
    }

    @Override
    public double getWholeGraphNetTime0() {
        return this.wholeGraphNetTime0;
    }

    @Override
    public double getWholeGraphNetTime1() {
        return this.wholeGraphNetTime1;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    @Override
    protected void swap(int a, int b) {
        ClientUtils.SourceCodeSelection sel = this.sels[a];
        this.sels[a] = this.sels[b];
        this.sels[b] = sel;
    }
}

