/* plugin-notification-extension.c generated by valac 0.56.3, the Vala compiler
 * generated from plugin-notification-extension.vala, do not modify */

/*
 * Copyright © 2019-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>

enum  {
	PLUGIN_NOTIFICATION_CONTEXT_NEW_MESSAGES_ARRIVED_SIGNAL,
	PLUGIN_NOTIFICATION_CONTEXT_NEW_MESSAGES_RETIRED_SIGNAL,
	PLUGIN_NOTIFICATION_CONTEXT_NUM_SIGNALS
};
static guint plugin_notification_context_signals[PLUGIN_NOTIFICATION_CONTEXT_NUM_SIGNALS] = {0};

static GType plugin_notification_extension_get_type_once (void);
static void g_cclosure_user_marshal_VOID__OBJECT_INT_OBJECT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static GType plugin_notification_context_get_type_once (void);

PluginNotificationContext*
plugin_notification_extension_get_notifications (PluginNotificationExtension* self)
{
	PluginNotificationExtensionIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_NOTIFICATION_EXTENSION (self), NULL);
	_iface_ = PLUGIN_NOTIFICATION_EXTENSION_GET_INTERFACE (self);
	if (_iface_->get_notifications) {
		return _iface_->get_notifications (self);
	}
	return NULL;
}

void
plugin_notification_extension_set_notifications (PluginNotificationExtension* self,
                                                 PluginNotificationContext* value)
{
	PluginNotificationExtensionIface* _iface_;
	g_return_if_fail (PLUGIN_IS_NOTIFICATION_EXTENSION (self));
	_iface_ = PLUGIN_NOTIFICATION_EXTENSION_GET_INTERFACE (self);
	if (_iface_->set_notifications) {
		_iface_->set_notifications (self, value);
	}
}

static void
plugin_notification_extension_default_init (PluginNotificationExtensionIface * iface,
                                            gpointer iface_data)
{
	/**
	     * Context object for notifications.
	     *
	     * This will be set during (or just after) plugin construction,
	     * before {@link PluginBase.activate} is called.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("notifications", "notifications", "notifications", PLUGIN_TYPE_NOTIFICATION_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

/**
 * A plugin extension point for notifying of mail sending or arriving.
 */
static GType
plugin_notification_extension_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginNotificationExtensionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_notification_extension_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_notification_extension_type_id;
	plugin_notification_extension_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginNotificationExtension", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_notification_extension_type_id, PLUGIN_TYPE_PLUGIN_BASE);
	return plugin_notification_extension_type_id;
}

GType
plugin_notification_extension_get_type (void)
{
	static volatile gsize plugin_notification_extension_type_id__once = 0;
	if (g_once_init_enter (&plugin_notification_extension_type_id__once)) {
		GType plugin_notification_extension_type_id;
		plugin_notification_extension_type_id = plugin_notification_extension_get_type_once ();
		g_once_init_leave (&plugin_notification_extension_type_id__once, plugin_notification_extension_type_id);
	}
	return plugin_notification_extension_type_id__once;
}

gint
plugin_notification_context_get_total_new_messages (PluginNotificationContext* self)
{
	PluginNotificationContextIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_NOTIFICATION_CONTEXT (self), 0);
	_iface_ = PLUGIN_NOTIFICATION_CONTEXT_GET_INTERFACE (self);
	if (_iface_->get_total_new_messages) {
		return _iface_->get_total_new_messages (self);
	}
	return -1;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_INT_OBJECT (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_INT_OBJECT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), g_value_get_object (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), data2);
}

void
plugin_notification_context_get_contacts_for_folder (PluginNotificationContext* self,
                                                     PluginFolder* source,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	PluginNotificationContextIface* _iface_;
	_iface_ = PLUGIN_NOTIFICATION_CONTEXT_GET_INTERFACE (self);
	if (_iface_->get_contacts_for_folder) {
		_iface_->get_contacts_for_folder (self, source, _callback_, _user_data_);
	}
}

PluginContactStore*
plugin_notification_context_get_contacts_for_folder_finish (PluginNotificationContext* self,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	PluginNotificationContextIface* _iface_;
	_iface_ = PLUGIN_NOTIFICATION_CONTEXT_GET_INTERFACE (self);
	if (_iface_->get_contacts_for_folder_finish) {
		return _iface_->get_contacts_for_folder_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Determines if notifications should be made for a specific folder.
     *
     * Notification plugins should call this to first before
     * displaying a "new mail" notification for mail in a specific
     * folder. It will return true for any monitored folder that is
     * not currently visible in the currently focused main window, if
     * any.
     */
gboolean
plugin_notification_context_should_notify_new_messages (PluginNotificationContext* self,
                                                        PluginFolder* target)
{
	PluginNotificationContextIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_NOTIFICATION_CONTEXT (self), FALSE);
	_iface_ = PLUGIN_NOTIFICATION_CONTEXT_GET_INTERFACE (self);
	if (_iface_->should_notify_new_messages) {
		return _iface_->should_notify_new_messages (self, target);
	}
	return FALSE;
}

/**
     * Returns the new message count for a specific folder.
     *
     * The context must have already been requested to monitor the
     * folder by a call to {@link start_monitoring_folder}.
     */
gint
plugin_notification_context_get_new_message_count (PluginNotificationContext* self,
                                                   PluginFolder* target,
                                                   GError** error)
{
	PluginNotificationContextIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_NOTIFICATION_CONTEXT (self), 0);
	_iface_ = PLUGIN_NOTIFICATION_CONTEXT_GET_INTERFACE (self);
	if (_iface_->get_new_message_count) {
		return _iface_->get_new_message_count (self, target, error);
	}
	return -1;
}

/**
     * Starts monitoring a folder for new messages.
     *
     * Notification plugins should call this to start the context
     * recording new messages for a specific folder.
     */
void
plugin_notification_context_start_monitoring_folder (PluginNotificationContext* self,
                                                     PluginFolder* target)
{
	PluginNotificationContextIface* _iface_;
	g_return_if_fail (PLUGIN_IS_NOTIFICATION_CONTEXT (self));
	_iface_ = PLUGIN_NOTIFICATION_CONTEXT_GET_INTERFACE (self);
	if (_iface_->start_monitoring_folder) {
		_iface_->start_monitoring_folder (self, target);
	}
}

/** Stops monitoring a folder for new messages. */
void
plugin_notification_context_stop_monitoring_folder (PluginNotificationContext* self,
                                                    PluginFolder* target)
{
	PluginNotificationContextIface* _iface_;
	g_return_if_fail (PLUGIN_IS_NOTIFICATION_CONTEXT (self));
	_iface_ = PLUGIN_NOTIFICATION_CONTEXT_GET_INTERFACE (self);
	if (_iface_->stop_monitoring_folder) {
		_iface_->stop_monitoring_folder (self, target);
	}
}

/** Determines if a folder is currently being monitored. */
gboolean
plugin_notification_context_is_monitoring_folder (PluginNotificationContext* self,
                                                  PluginFolder* target)
{
	PluginNotificationContextIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_NOTIFICATION_CONTEXT (self), FALSE);
	_iface_ = PLUGIN_NOTIFICATION_CONTEXT_GET_INTERFACE (self);
	if (_iface_->is_monitoring_folder) {
		return _iface_->is_monitoring_folder (self, target);
	}
	return FALSE;
}

static void
plugin_notification_context_default_init (PluginNotificationContextIface * iface,
                                          gpointer iface_data)
{
	/**
	     * Current total new message count for all monitored folders.
	     *
	     * This is the sum of the the counts returned by {@link
	     * get_new_message_count} for all folders that are being monitored
	     * after a call to {@link start_monitoring_folder}.
	     */
	g_object_interface_install_property (iface, g_param_spec_int ("total-new-messages", "total-new-messages", "total-new-messages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Emitted when new messages have been downloaded.
	     *
	     * This will only be emitted for folders that are being monitored
	     * by calling {@link start_monitoring_folder}.
	     */
	plugin_notification_context_signals[PLUGIN_NOTIFICATION_CONTEXT_NEW_MESSAGES_ARRIVED_SIGNAL] = g_signal_new ("new-messages-arrived", PLUGIN_TYPE_NOTIFICATION_CONTEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT_OBJECT, G_TYPE_NONE, 3, PLUGIN_TYPE_FOLDER, G_TYPE_INT, GEE_TYPE_COLLECTION);
	/**
	     * Emitted when a folder has been cleared of new messages.
	     *
	     * This will only be emitted for folders that are being monitored
	     * after a call to {@link start_monitoring_folder}.
	     */
	plugin_notification_context_signals[PLUGIN_NOTIFICATION_CONTEXT_NEW_MESSAGES_RETIRED_SIGNAL] = g_signal_new ("new-messages-retired", PLUGIN_TYPE_NOTIFICATION_CONTEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT, G_TYPE_NONE, 2, PLUGIN_TYPE_FOLDER, G_TYPE_INT);
}

/**
 * Provides a context for notification plugins.
 *
 * The context provides an interface for notification plugins to
 * interface with the Geary client application. Plugins that implement
 * the {@link NotificationExtension} interface will be given an
 * instance of this class.
 *
 * Plugins should register folders they wish to monitor by calling
 * {@link start_monitoring_folder}. The context will then start
 * keeping track of email being delivered to the folder and being seen
 * in a main window updating {@link total_new_messages} and emitting
 * the {@link new_messages_arrived} and {@link new_messages_retired}
 * signals as appropriate.
 *
 * @see Plugin.NotificationExtension.notifications
 */
static GType
plugin_notification_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginNotificationContextIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_notification_context_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_notification_context_type_id;
	plugin_notification_context_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginNotificationContext", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_notification_context_type_id, GEARY_TYPE_BASE_OBJECT);
	return plugin_notification_context_type_id;
}

GType
plugin_notification_context_get_type (void)
{
	static volatile gsize plugin_notification_context_type_id__once = 0;
	if (g_once_init_enter (&plugin_notification_context_type_id__once)) {
		GType plugin_notification_context_type_id;
		plugin_notification_context_type_id = plugin_notification_context_get_type_once ();
		g_once_init_leave (&plugin_notification_context_type_id__once, plugin_notification_context_type_id);
	}
	return plugin_notification_context_type_id__once;
}

