"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingPlugin;

var _constants = require("../../utils/constants");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
function alertingPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alerting = components.clientAction.namespaceFactory();
  const alerting = Client.prototype.alerting.prototype;
  alerting.searchMonitors = ca({
    url: {
      fmt: `${_constants.API.ALERTING_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alerting.searchAlerts = ca({
    url: {
      fmt: `${_constants.API.ALERTING_BASE}/alerts?size=${_constants.MAX_ALERTS}&monitorId=<%=monitorId%>&sortString=start_time&sortOrder=desc&searchString=start_time:[<%=startTime%>%20TO%20<%=endTime%>]`,
      req: {
        monitorId: {
          type: 'string',
          required: true
        },
        startTime: {
          type: 'number',
          required: true
        },
        endTime: {
          type: 'number',
          required: true
        }
      }
    },
    method: 'GET'
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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