/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.SecureString;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.repositories.s3.ProxySettings;
import org.opensearch.repositories.s3.S3BasicCredentials;
import org.opensearch.repositories.s3.S3Repository;

final class S3ClientSettings {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(S3ClientSettings.class);
    private static final String PREFIX = "s3.client.";
    private static final String PLACEHOLDER_CLIENT = "placeholder";
    static final Setting.AffixSetting<String> IDENTITY_TOKEN_FILE_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"identity_token_file", key -> SecureSetting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> ROLE_ARN_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"role_arn", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> ROLE_SESSION_NAME_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"role_session_name", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> ACCESS_KEY_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"access_key", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> SECRET_KEY_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"secret_key", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> SESSION_TOKEN_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"session_token", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> ENDPOINT_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"endpoint", key -> new Setting(key, "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<Protocol> PROTOCOL_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"protocol", key -> new Setting(key, "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<ProxySettings.ProxyType> PROXY_TYPE_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.type", key -> new Setting(key, "direct", s -> ProxySettings.ProxyType.valueOf(s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> PROXY_HOST_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.host", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<Integer> PROXY_PORT_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.port", key -> Setting.intSetting((String)key, (int)80, (int)0, (int)65535, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> PROXY_USERNAME_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.username", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> PROXY_PASSWORD_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"proxy.password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<TimeValue> READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMillis((long)50000L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<Integer> MAX_RETRIES_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"max_retries", key -> Setting.intSetting((String)key, (int)ClientConfiguration.DEFAULT_RETRY_POLICY.getMaxErrorRetry(), (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<Boolean> USE_THROTTLE_RETRIES_SETTING = Setting.affixKeySetting((String)"s3.client.", (String)"use_throttle_retries", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<Boolean> USE_PATH_STYLE_ACCESS = Setting.affixKeySetting((String)"s3.client.", (String)"path_style_access", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<Boolean> DISABLE_CHUNKED_ENCODING = Setting.affixKeySetting((String)"s3.client.", (String)"disable_chunked_encoding", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> REGION = Setting.affixKeySetting((String)"s3.client.", (String)"region", key -> new Setting(key, "", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> SIGNER_OVERRIDE = Setting.affixKeySetting((String)"s3.client.", (String)"signer_override", key -> new Setting(key, "", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    final S3BasicCredentials credentials;
    final IrsaCredentials irsaCredentials;
    final String endpoint;
    final Protocol protocol;
    final ProxySettings proxySettings;
    final int readTimeoutMillis;
    final int maxRetries;
    final boolean throttleRetries;
    final boolean pathStyleAccess;
    final boolean disableChunkedEncoding;
    final String region;
    final String signerOverride;

    private S3ClientSettings(S3BasicCredentials credentials, IrsaCredentials irsaCredentials, String endpoint, Protocol protocol, int readTimeoutMillis, int maxRetries, boolean throttleRetries, boolean pathStyleAccess, boolean disableChunkedEncoding, String region, String signerOverride, ProxySettings proxySettings) {
        this.credentials = credentials;
        this.irsaCredentials = irsaCredentials;
        this.endpoint = endpoint;
        this.protocol = protocol;
        this.readTimeoutMillis = readTimeoutMillis;
        this.maxRetries = maxRetries;
        this.throttleRetries = throttleRetries;
        this.pathStyleAccess = pathStyleAccess;
        this.disableChunkedEncoding = disableChunkedEncoding;
        this.region = region;
        this.signerOverride = signerOverride;
        this.proxySettings = proxySettings;
    }

    S3ClientSettings refine(Settings repositorySettings) {
        Settings normalizedSettings = Settings.builder().put(repositorySettings).normalizePrefix("s3.client.placeholder.").build();
        String newEndpoint = S3ClientSettings.getRepoSettingOrDefault(ENDPOINT_SETTING, normalizedSettings, this.endpoint);
        Protocol newProtocol = S3ClientSettings.getRepoSettingOrDefault(PROTOCOL_SETTING, normalizedSettings, this.protocol);
        String newProxyHost = S3ClientSettings.getRepoSettingOrDefault(PROXY_HOST_SETTING, normalizedSettings, this.proxySettings.getHostName());
        int newProxyPort = S3ClientSettings.getRepoSettingOrDefault(PROXY_PORT_SETTING, normalizedSettings, this.proxySettings.getPort());
        int newReadTimeoutMillis = Math.toIntExact(S3ClientSettings.getRepoSettingOrDefault(READ_TIMEOUT_SETTING, normalizedSettings, TimeValue.timeValueMillis((long)this.readTimeoutMillis)).millis());
        int newMaxRetries = S3ClientSettings.getRepoSettingOrDefault(MAX_RETRIES_SETTING, normalizedSettings, this.maxRetries);
        boolean newThrottleRetries = S3ClientSettings.getRepoSettingOrDefault(USE_THROTTLE_RETRIES_SETTING, normalizedSettings, this.throttleRetries);
        boolean newPathStyleAccess = S3ClientSettings.getRepoSettingOrDefault(USE_PATH_STYLE_ACCESS, normalizedSettings, this.pathStyleAccess);
        boolean newDisableChunkedEncoding = S3ClientSettings.getRepoSettingOrDefault(DISABLE_CHUNKED_ENCODING, normalizedSettings, this.disableChunkedEncoding);
        S3BasicCredentials newCredentials = S3ClientSettings.checkDeprecatedCredentials(repositorySettings) ? S3ClientSettings.loadDeprecatedCredentials(repositorySettings) : this.credentials;
        String newRegion = S3ClientSettings.getRepoSettingOrDefault(REGION, normalizedSettings, this.region);
        String newSignerOverride = S3ClientSettings.getRepoSettingOrDefault(SIGNER_OVERRIDE, normalizedSettings, this.signerOverride);
        if (Objects.equals(this.endpoint, newEndpoint) && this.protocol == newProtocol && Objects.equals(this.proxySettings.getHostName(), newProxyHost) && this.proxySettings.getPort() == newProxyPort && newReadTimeoutMillis == this.readTimeoutMillis && this.maxRetries == newMaxRetries && newThrottleRetries == this.throttleRetries && Objects.equals(this.credentials, newCredentials) && newPathStyleAccess == this.pathStyleAccess && newDisableChunkedEncoding == this.disableChunkedEncoding && Objects.equals(this.region, newRegion) && Objects.equals(this.signerOverride, newSignerOverride)) {
            return this;
        }
        S3ClientSettings.validateInetAddressFor(newProxyHost);
        return new S3ClientSettings(newCredentials, this.irsaCredentials, newEndpoint, newProtocol, newReadTimeoutMillis, newMaxRetries, newThrottleRetries, newPathStyleAccess, newDisableChunkedEncoding, newRegion, newSignerOverride, this.proxySettings.recreateWithNewHostAndPort(newProxyHost, newProxyPort));
    }

    static Map<String, S3ClientSettings> load(Settings settings) {
        Set clientNames = settings.getGroups(PREFIX).keySet();
        HashMap<String, S3ClientSettings> clients = new HashMap<String, S3ClientSettings>();
        for (String clientName : clientNames) {
            clients.put(clientName, S3ClientSettings.getClientSettings(settings, clientName));
        }
        if (!clients.containsKey("default")) {
            clients.put("default", S3ClientSettings.getClientSettings(settings, "default"));
        }
        return Collections.unmodifiableMap(clients);
    }

    static boolean checkDeprecatedCredentials(Settings repositorySettings) {
        if (S3Repository.ACCESS_KEY_SETTING.exists(repositorySettings)) {
            if (!S3Repository.SECRET_KEY_SETTING.exists(repositorySettings)) {
                throw new IllegalArgumentException("Repository setting [" + S3Repository.ACCESS_KEY_SETTING.getKey() + " must be accompanied by setting [" + S3Repository.SECRET_KEY_SETTING.getKey() + "]");
            }
            return true;
        }
        if (S3Repository.SECRET_KEY_SETTING.exists(repositorySettings)) {
            throw new IllegalArgumentException("Repository setting [" + S3Repository.SECRET_KEY_SETTING.getKey() + " must be accompanied by setting [" + S3Repository.ACCESS_KEY_SETTING.getKey() + "]");
        }
        return false;
    }

    private static S3BasicCredentials loadDeprecatedCredentials(Settings repositorySettings) {
        assert (S3ClientSettings.checkDeprecatedCredentials(repositorySettings));
        try (SecureString key = (SecureString)S3Repository.ACCESS_KEY_SETTING.get(repositorySettings);){
            S3BasicCredentials s3BasicCredentials;
            block13: {
                SecureString secret = (SecureString)S3Repository.SECRET_KEY_SETTING.get(repositorySettings);
                try {
                    s3BasicCredentials = new S3BasicCredentials(key.toString(), secret.toString());
                    if (secret == null) break block13;
                }
                catch (Throwable throwable) {
                    if (secret != null) {
                        try {
                            secret.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                secret.close();
            }
            return s3BasicCredentials;
        }
    }

    /*
     * Exception decompiling
     */
    private static S3BasicCredentials loadCredentials(Settings settings, String clientName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IrsaCredentials loadIrsaCredentials(Settings settings, String clientName) {
        String identityTokenFile = S3ClientSettings.getConfigValue(settings, clientName, IDENTITY_TOKEN_FILE_SETTING);
        try (SecureString roleArn = S3ClientSettings.getConfigValue(settings, clientName, ROLE_ARN_SETTING);){
            IrsaCredentials irsaCredentials;
            block16: {
                SecureString roleSessionName;
                block14: {
                    IrsaCredentials irsaCredentials2;
                    block15: {
                        roleSessionName = S3ClientSettings.getConfigValue(settings, clientName, ROLE_SESSION_NAME_SETTING);
                        try {
                            if (identityTokenFile.length() == 0 && roleArn.length() == 0 && roleSessionName.length() == 0) break block14;
                            irsaCredentials2 = new IrsaCredentials(identityTokenFile.toString(), roleArn.toString(), roleSessionName.toString());
                            if (roleSessionName == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (roleSessionName != null) {
                                try {
                                    roleSessionName.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        roleSessionName.close();
                    }
                    return irsaCredentials2;
                }
                irsaCredentials = null;
                if (roleSessionName == null) break block16;
                roleSessionName.close();
            }
            return irsaCredentials;
        }
    }

    static S3ClientSettings getClientSettings(Settings settings, String clientName) {
        Protocol awsProtocol = S3ClientSettings.getConfigValue(settings, clientName, PROTOCOL_SETTING);
        return new S3ClientSettings(S3ClientSettings.loadCredentials(settings, clientName), S3ClientSettings.loadIrsaCredentials(settings, clientName), S3ClientSettings.getConfigValue(settings, clientName, ENDPOINT_SETTING), awsProtocol, Math.toIntExact(S3ClientSettings.getConfigValue(settings, clientName, READ_TIMEOUT_SETTING).millis()), S3ClientSettings.getConfigValue(settings, clientName, MAX_RETRIES_SETTING), S3ClientSettings.getConfigValue(settings, clientName, USE_THROTTLE_RETRIES_SETTING), S3ClientSettings.getConfigValue(settings, clientName, USE_PATH_STYLE_ACCESS), S3ClientSettings.getConfigValue(settings, clientName, DISABLE_CHUNKED_ENCODING), S3ClientSettings.getConfigValue(settings, clientName, REGION), S3ClientSettings.getConfigValue(settings, clientName, SIGNER_OVERRIDE), S3ClientSettings.validateAndCreateProxySettings(settings, clientName, awsProtocol));
    }

    static ProxySettings validateAndCreateProxySettings(Settings settings, String clientName, Protocol awsProtocol) {
        ProxySettings.ProxyType proxyType = S3ClientSettings.getConfigValue(settings, clientName, PROXY_TYPE_SETTING);
        String proxyHost = S3ClientSettings.getConfigValue(settings, clientName, PROXY_HOST_SETTING);
        int proxyPort = S3ClientSettings.getConfigValue(settings, clientName, PROXY_PORT_SETTING);
        SecureString proxyUserName = S3ClientSettings.getConfigValue(settings, clientName, PROXY_USERNAME_SETTING);
        SecureString proxyPassword = S3ClientSettings.getConfigValue(settings, clientName, PROXY_PASSWORD_SETTING);
        if (awsProtocol != Protocol.HTTPS && proxyType == ProxySettings.ProxyType.DIRECT && Strings.hasText((String)proxyHost)) {
            proxyType = ProxySettings.ProxyType.valueOf(awsProtocol.name());
            deprecationLogger.deprecate(PROTOCOL_SETTING.getConcreteSettingForNamespace(clientName).getKey(), "Using of " + PROTOCOL_SETTING.getConcreteSettingForNamespace(clientName).getKey() + " as proxy type is deprecated and will be removed in future releases. Please use " + PROXY_TYPE_SETTING.getConcreteSettingForNamespace(clientName).getKey() + " instead to specify proxy type.", new Object[0]);
        }
        if (proxyType == ProxySettings.ProxyType.DIRECT && (proxyPort != 80 || Strings.hasText((String)proxyHost) || Strings.hasText((CharSequence)proxyUserName) || Strings.hasText((CharSequence)proxyPassword))) {
            throw new SettingsException("S3 proxy port or host or username or password have been set but proxy type is not defined.");
        }
        if (proxyType != ProxySettings.ProxyType.DIRECT && Strings.isEmpty((CharSequence)proxyHost)) {
            throw new SettingsException("S3 proxy type has been set but proxy host or port is not defined.");
        }
        if (proxyType == ProxySettings.ProxyType.DIRECT) {
            return ProxySettings.NO_PROXY_SETTINGS;
        }
        if (awsProtocol == Protocol.HTTP && proxyType == ProxySettings.ProxyType.SOCKS) {
            throw new SettingsException("SOCKS proxy is not supported for HTTP protocol");
        }
        S3ClientSettings.validateInetAddressFor(proxyHost);
        return new ProxySettings(proxyType, proxyHost, proxyPort, proxyUserName.toString(), proxyPassword.toString());
    }

    static void validateInetAddressFor(String proxyHost) {
        try {
            InetAddress.getByName(proxyHost);
        }
        catch (UnknownHostException e) {
            throw new SettingsException("S3 proxy host is unknown.", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ClientSettings that = (S3ClientSettings)o;
        return this.readTimeoutMillis == that.readTimeoutMillis && this.maxRetries == that.maxRetries && this.throttleRetries == that.throttleRetries && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.endpoint, that.endpoint) && this.protocol == that.protocol && this.proxySettings.equals(that.proxySettings) && Objects.equals(this.disableChunkedEncoding, that.disableChunkedEncoding) && Objects.equals(this.region, that.region) && Objects.equals(this.signerOverride, that.signerOverride) && Objects.equals(this.irsaCredentials, that.irsaCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.endpoint, this.protocol, this.proxySettings, this.readTimeoutMillis, this.maxRetries, this.throttleRetries, this.disableChunkedEncoding, this.region, this.signerOverride);
    }

    private static <T> T getConfigValue(Settings settings, String clientName, Setting.AffixSetting<T> clientSetting) {
        Setting concreteSetting = clientSetting.getConcreteSettingForNamespace(clientName);
        return (T)concreteSetting.get(settings);
    }

    private static <T> T getRepoSettingOrDefault(Setting.AffixSetting<T> setting, Settings normalizedSettings, T defaultValue) {
        if (setting.getConcreteSettingForNamespace(PLACEHOLDER_CLIENT).exists(normalizedSettings)) {
            return S3ClientSettings.getConfigValue(normalizedSettings, PLACEHOLDER_CLIENT, setting);
        }
        return defaultValue;
    }

    static class IrsaCredentials {
        private final String identityTokenFile;
        private final String roleArn;
        private final String roleSessionName;

        IrsaCredentials(String identityTokenFile, String roleArn, String roleSessionName) {
            this.identityTokenFile = Strings.isNullOrEmpty((String)identityTokenFile) ? null : identityTokenFile;
            this.roleArn = Strings.isNullOrEmpty((String)roleArn) ? null : roleArn;
            this.roleSessionName = Strings.isNullOrEmpty((String)roleSessionName) ? "s3-sdk-java-" + System.currentTimeMillis() : roleSessionName;
        }

        public String getIdentityTokenFile() {
            return this.identityTokenFile;
        }

        public String getRoleArn() {
            return this.roleArn;
        }

        public String getRoleSessionName() {
            return this.roleSessionName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IrsaCredentials that = (IrsaCredentials)o;
            return Objects.equals(this.identityTokenFile, that.identityTokenFile) && Objects.equals(this.roleArn, that.roleArn) && Objects.equals(this.roleSessionName, that.roleSessionName);
        }

        public int hashCode() {
            return Objects.hash(this.identityTokenFile, this.roleArn, this.roleSessionName);
        }
    }
}

