/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandDecoratorMultine;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemCommandFactory
extends PSystemAbstractFactory {
    private List<Command> cmds;

    protected abstract List<Command> createCommands();

    public abstract AbstractPSystem createEmptyDiagram(UmlSource var1, Map<String, String> var2);

    protected PSystemCommandFactory() {
        this(DiagramType.UML);
    }

    protected PSystemCommandFactory(DiagramType type) {
        super(type);
    }

    @Override
    public final Diagram createSystem(UmlSource source, Map<String, String> skinParam) {
        IteratorCounter2 it = source.iterator2();
        StringLocated startLine = (StringLocated)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine.getString())) {
            throw new UnsupportedOperationException();
        }
        if (source.isEmpty()) {
            if (it.hasNext()) {
                it.next();
            }
            return this.buildEmptyError(source, startLine.getLocation(), it.getTrace());
        }
        AbstractPSystem sys = this.createEmptyDiagram(source, skinParam);
        while (it.hasNext()) {
            if (StartUtils.isArobaseEndDiagram(it.peek().getString())) {
                if (sys == null) {
                    return null;
                }
                String err = sys.checkFinalError();
                if (err != null) {
                    LineLocation location = ((StringLocated)it.next()).getLocation();
                    return this.buildExecutionError(source, err, location, it.getTrace());
                }
                if (source.getTotalLineCount() == 2) {
                    LineLocation location = ((StringLocated)it.next()).getLocation();
                    return this.buildEmptyError(source, location, it.getTrace());
                }
                sys.makeDiagramReady();
                if (!sys.isOk()) {
                    return null;
                }
                return sys;
            }
            if (!((sys = this.executeFewLines(sys, source, it)) instanceof PSystemError)) continue;
            return sys;
        }
        return sys;
    }

    private AbstractPSystem executeFewLines(AbstractPSystem sys, UmlSource source, IteratorCounter2 it) {
        Step step = this.getCandidate(it);
        if (step == null) {
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", 0, it.peek().getLocation());
            it.next();
            return PSystemErrorUtils.buildV2(source, err, null, it.getTrace());
        }
        CommandExecutionResult result = sys.executeCommand(step.command, step.blocLines);
        if (!result.isOk()) {
            LineLocation location = step.blocLines.getFirst().getLocation();
            ErrorUml err = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, result.getError(), result.getScore(), location);
            sys = PSystemErrorUtils.buildV2(source, err, result.getDebugLines(), it.getTrace());
        }
        if (result.getNewDiagram() != null) {
            sys = result.getNewDiagram();
        }
        return sys;
    }

    private Step getCandidate(IteratorCounter2 it) {
        BlocLines single = BlocLines.single(it.peek());
        if (this.cmds == null) {
            this.cmds = this.createCommands();
        }
        for (Command cmd : this.cmds) {
            IteratorCounter2 cloned;
            BlocLines lines;
            CommandControl result = cmd.isValid(single);
            if (result == CommandControl.OK) {
                it.next();
                return new Step(cmd, single);
            }
            if (result != CommandControl.OK_PARTIAL || (lines = this.isMultilineCommandOk(cloned = it.cloneMe(), cmd)) == null) continue;
            it.copyStateFrom(cloned);
            return new Step(cmd, lines);
        }
        return null;
    }

    private BlocLines isMultilineCommandOk(IteratorCounter2 it, Command cmd) {
        BlocLines lines = BlocLines.create();
        int nb = 0;
        while (it.hasNext()) {
            CommandControl result = cmd.isValid(lines = PSystemCommandFactory.addOneSingleLineManageEmbedded2(it, lines));
            if (result == CommandControl.NOT_OK) {
                return null;
            }
            if (result == CommandControl.OK) {
                return lines;
            }
            if (!(cmd instanceof CommandDecoratorMultine) || ++nb <= ((CommandDecoratorMultine)cmd).getNbMaxLines()) continue;
            return null;
        }
        return null;
    }

    private static BlocLines addOneSingleLineManageEmbedded2(IteratorCounter2 it, BlocLines lines) {
        StringLocated linetoBeAdded = (StringLocated)it.next();
        lines = lines.add(linetoBeAdded);
        if (EmbeddedDiagram.getEmbeddedType(linetoBeAdded.getTrimmed().getString()) != null) {
            int nested = 1;
            while (it.hasNext()) {
                StringLocated s = (StringLocated)it.next();
                lines = lines.add(s);
                if (EmbeddedDiagram.getEmbeddedType(s.getTrimmed().getString()) != null) {
                    ++nested;
                    continue;
                }
                if (!s.getTrimmed().getString().equals("}}") || --nested != 0) continue;
                return lines;
            }
        }
        return lines;
    }

    static class Step {
        final Command command;
        final BlocLines blocLines;

        Step(Command command, BlocLines blocLines) {
            this.command = command;
            this.blocLines = blocLines;
        }
    }
}

