/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class Position {
    private final double x;
    private final double y;
    private final XDimension2D dim;

    public Position(double x, double y, XDimension2D dim) {
        this.x = x;
        this.y = y;
        this.dim = dim;
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y + " dim=" + this.dim;
    }

    public Position align(double height) {
        double dy = height - this.dim.getHeight();
        return this.translateY(dy);
    }

    public final double getMinY() {
        return this.y;
    }

    public final double getMaxY() {
        return this.y + this.getHeight();
    }

    public UGraphic translate(UGraphic ug) {
        return ug.apply(new UTranslate(this.x, this.y));
    }

    public Position translateY(double dy) {
        return new Position(this.x, this.y + dy, this.dim);
    }

    public Position translateX(double dx) {
        return new Position(this.x + dx, this.y, this.dim);
    }

    public MinMax update(MinMax minMax) {
        return minMax.addPoint(this.x + this.dim.getWidth(), this.y + this.dim.getHeight());
    }

    public void drawDebug(UGraphic ug) {
        ug = ug.apply(HColors.BLACK).apply(HColors.none().bg());
        ug = ug.apply(new UTranslate(this.x, this.y));
        ug.draw(new URectangle(this.dim));
    }

    public double getHeight() {
        return this.dim.getHeight();
    }

    public double getWidth() {
        return this.dim.getWidth();
    }

    public UTranslate getTranslate() {
        return new UTranslate(this.x, this.y);
    }
}

