/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Clusterable;

public class Cluster
implements Clusterable {
    private static int CPT = 1;
    private final Cluster parent;
    private final Collection<Block> blocs = new ArrayList<Block>();
    private final Collection<Cluster> children = new ArrayList<Cluster>();
    private final int uid = CPT++;
    private double x;
    private double y;
    private double width;
    private double height;
    private final double titleWidth;
    private final double titleHeight;

    public Cluster(Cluster parent, double titleWidth, double titleHeight) {
        this.parent = parent;
        this.titleWidth = titleWidth;
        this.titleHeight = titleHeight;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public Collection<Cluster> getSubClusters() {
        return Collections.unmodifiableCollection(this.children);
    }

    public Collection<Block> getRecursiveContents() {
        ArrayList<Block> result = new ArrayList<Block>();
        this.addContentRecurse(result);
        return Collections.unmodifiableCollection(result);
    }

    private void addContentRecurse(Collection<Block> result) {
        result.addAll(this.blocs);
        for (Cluster c : this.children) {
            c.addContentRecurse(result);
        }
    }

    public int getUid() {
        return this.uid;
    }

    public void addBloc(Block b) {
        this.blocs.add(b);
    }

    @Override
    public Cluster getParent() {
        return this.parent;
    }

    public Collection<Block> getContents() {
        return Collections.unmodifiableCollection(this.blocs);
    }

    public Block getBlock(int uid) {
        for (Block b : this.blocs) {
            if (b.getUid() != uid) continue;
            return b;
        }
        for (Cluster sub : this.children) {
            Block result = sub.getBlock(uid);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public XPoint2D getPosition() {
        return new XPoint2D(this.x, this.y);
    }

    @Override
    public XDimension2D getSize() {
        return new XDimension2D(this.width, this.height);
    }

    public final void setX(double x) {
        this.x = x;
    }

    public final void setY(double y) {
        this.y = y;
    }

    public final void setWidth(double width) {
        this.width = width;
    }

    public final void setHeight(double height) {
        this.height = height;
    }

    public final double getTitleWidth() {
        return this.titleWidth;
    }

    public final double getTitleHeight() {
        return this.titleHeight;
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        throw new UnsupportedOperationException();
    }
}

