/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseEnglober
extends AbstractTextualComponent {
    private final SymbolContext symbolContext;
    private final double roundCorner;

    public ComponentRoseEnglober(Style style, Display strings, ISkinSimple spriteContainer) {
        super(style, LineBreakStrategy.NONE, 3, 3, 1, spriteContainer, strings, false);
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.symbolContext = style.getSymbolContext(this.getIHtmlColorSet());
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        ug = this.symbolContext.apply(ug);
        ug.draw(new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight()).rounded(this.roundCorner));
        double xpos = (dimensionToUse.getWidth() - this.getPureTextWidth(ug.getStringBounder())) / 2.0;
        this.getTextBlock().drawU(ug.apply(UTranslate.dx(xpos)));
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 3.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

