/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.EnumMap;
import net.sourceforge.plantuml.CornerParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.TextBlockMap;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageMap
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock entries;
    private final Url url;
    private final double roundCorner;
    private final LineConfigurable lineConfig;
    private int marginEmptyFieldsOrMethod = 13;
    private int xMarginCircle = 5;

    public EntityImageMap(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        this.lineConfig = entity;
        Stereotype stereotype = entity.getStereotype();
        this.roundCorner = skinParam.getRoundCorner(CornerParam.DEFAULT, null);
        FontConfiguration fcHeader = this.getStyleHeader().getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        this.name = TextBlockUtils.withMargin(entity.getDisplay().create(fcHeader, HorizontalAlignment.CENTER, skinParam), 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? null : Display.create(stereotype.getLabels(skinParam.guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.OBJECT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
        FontConfiguration fontConfiguration = this.getStyleHeader().getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        this.entries = entity.getBodier().getBody(skinParam, false, false, entity.getStereotype(), this.getStyle(), fontConfiguration);
        this.url = entity.getUrl99();
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        return ((WithPorts)((Object)this.entries)).getPorts(stringBounder).translateY(dimTitle.getHeight());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double minClassWidth;
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        XDimension2D dimFields = this.entries.calculateDimension(stringBounder);
        double width = Math.max(dimFields.getWidth(), dimTitle.getWidth() + (double)(2 * this.xMarginCircle));
        if (width < (minClassWidth = this.getStyle().value(PName.MinimumWidth).asDouble())) {
            width = minClassWidth;
        }
        double height = this.getMethodOrFieldHeight(dimFields) + dimTitle.getHeight();
        return new XDimension2D(width, height);
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.objectDiagram, SName.map).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private Style getStyleHeader() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.objectDiagram, SName.map, SName.header).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(this.roundCorner);
        HColor borderColor = this.lineConfig.getColors().getColor(ColorType.LINE);
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        HColor headerBackcolor = this.getEntity().getColors().getColor(ColorType.HEADER);
        Style style = this.getStyle();
        if (borderColor == null) {
            borderColor = this.getStyle().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        if (headerBackcolor == null) {
            HColor hColor = headerBackcolor = backcolor == null ? this.getStyleHeader().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : backcolor;
        }
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        rect.setDeltaShadow(style.value(PName.Shadowing).asDouble());
        UStroke stroke = style.getStroke();
        ug = ug.apply(borderColor).apply(backcolor.bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getCode());
        ug.startGroup(typeIDent);
        ug.apply(stroke).draw(rect);
        if (this.roundCorner == 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            URectangle rect2 = new URectangle(widthTotal, dimTitle.getHeight());
            UGraphic ugHeader = ug.apply(headerBackcolor.bg());
            ugHeader.apply(stroke).draw(rect2);
        }
        ULayoutGroup header = new ULayoutGroup(new PlacementStrategyY1Y2(ug.getStringBounder()));
        if (this.stereo != null) {
            header.add(this.stereo);
        }
        header.add(this.name);
        header.drawU(ug, dimTotal.getWidth(), dimTitle.getHeight());
        UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
        ((TextBlockMap)this.entries).setTotalWidth(dimTotal.getWidth());
        this.entries.drawU(ug2.apply(UTranslate.dy(dimTitle.getHeight())));
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    private double getMethodOrFieldHeight(XDimension2D dim) {
        double fieldsHeight = dim.getHeight();
        if (fieldsHeight == 0.0 && this.getEntity().getLeafType() != LeafType.MAP) {
            return this.marginEmptyFieldsOrMethod;
        }
        return fieldsHeight;
    }

    private XDimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private XDimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        XDimension2D nameDim = this.name.calculateDimension(stringBounder);
        XDimension2D stereoDim = this.stereo == null ? new XDimension2D(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        XDimension2D nameAndStereo = new XDimension2D(Math.max(nameDim.getWidth(), stereoDim.getWidth()), nameDim.getHeight() + stereoDim.getHeight());
        return nameAndStereo;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE_HTML_FOR_PORTS;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

