/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class MenuShortcut
implements Serializable {
    int key;
    boolean usesShift;
    private static final long serialVersionUID = 143448358473180225L;

    public MenuShortcut(int key) {
        this(key, false);
    }

    public MenuShortcut(int key, boolean useShiftModifier) {
        this.key = key;
        this.usesShift = useShiftModifier;
    }

    public int getKey() {
        return this.key;
    }

    public boolean usesShiftModifier() {
        return this.usesShift;
    }

    public boolean equals(MenuShortcut s) {
        return s != null && s.getKey() == this.key && s.usesShiftModifier() == this.usesShift;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MenuShortcut) {
            return this.equals((MenuShortcut)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.usesShift ? ~this.key : this.key;
    }

    public String toString() {
        int modifiers = 0;
        if (!GraphicsEnvironment.isHeadless()) {
            modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        if (this.usesShiftModifier()) {
            modifiers |= 1;
        }
        return KeyEvent.getKeyModifiersText(modifiers) + "+" + KeyEvent.getKeyText(this.key);
    }

    protected String paramString() {
        String str = "key=" + this.key;
        if (this.usesShiftModifier()) {
            str = str + ",usesShiftModifier";
        }
        return str;
    }
}

