/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ListDataListener;
import net.sourceforge.jnlp.controlpanel.ClassFinder;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.dialogs.remember.AppletSecurityActions;
import net.sourceforge.jnlp.security.dialogs.remember.ExecuteAppletAction;
import net.sourceforge.jnlp.security.dialogs.remember.RememberableDialog;
import net.sourceforge.jnlp.security.dialogs.remember.SavedRememberAction;

public class RemmeberableDialogueEditor
extends JDialog {
    private final List<Class<? extends RememberableDialog>> allClasses;
    private final AppletSecurityActions actions;
    private AppletSecurityActions result;
    private final RemmeberableDialogueEditor self;
    private final JFrame frame;

    RemmeberableDialogueEditor(JFrame jFrame, boolean modal, Object dialogs) {
        super((Frame)jFrame, modal);
        this.frame = jFrame;
        this.setDefaultCloseOperation(0);
        this.self = this;
        this.actions = (AppletSecurityActions)dialogs;
        this.allClasses = ClassFinder.findAllMatchingTypes(RememberableDialog.class);
        this.recreateGui();
        this.setLocationRelativeTo(jFrame);
    }

    private void recreateGui() {
        Component b;
        Collection<Map.Entry<String, SavedRememberAction>> entries = this.actions.getEntries();
        RemmeberableDialogueEditor d = this;
        this.getContentPane().removeAll();
        d.setLayout(new GridLayout(0, 4));
        final ArrayList<Class<? extends RememberableDialog>> addedableClasses = new ArrayList<Class<? extends RememberableDialog>>(this.allClasses);
        for (final Map.Entry<String, SavedRememberAction> entry : entries) {
            String dialog = entry.getKey();
            for (int i = 0; i < addedableClasses.size(); ++i) {
                final Class get = (Class)addedableClasses.get(i);
                String s = get.getSimpleName();
                if (!s.equals(dialog)) continue;
                JButton bb = new JButton("-");
                bb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RemmeberableDialogueEditor.this.actions.removeAction(get);
                        RemmeberableDialogueEditor.this.recreateGui();
                    }
                });
                d.add(bb);
                d.add(new JLabel(entry.getKey()));
                final JComboBox<ExecuteAppletAction> cbb = new JComboBox<ExecuteAppletAction>(ExecuteAppletAction.values());
                cbb.setSelectedItem((Object)entry.getValue().getAction());
                cbb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RemmeberableDialogueEditor.this.actions.setAction((String)entry.getKey(), this.createRember((ExecuteAppletAction)((Object)cbb.getSelectedItem()), entry));
                    }

                    private SavedRememberAction createRember(ExecuteAppletAction nwValue, Map.Entry<String, SavedRememberAction> entry2) {
                        return new SavedRememberAction(nwValue, entry2.getValue().getSavedValue());
                    }
                });
                d.add(cbb);
                JButton expertButton = new JButton(Translator.R("EPEexpert"));
                expertButton.setToolTipText(Translator.R("EPEexpertHelp"));
                expertButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String s;
                        Object result = JOptionPane.showInputDialog(RemmeberableDialogueEditor.this.self.frame, ((SavedRememberAction)entry.getValue()).getSavedValue(), Translator.R("EPEexpertHint"), 0, null, null, ((SavedRememberAction)entry.getValue()).getSavedValue());
                        if (result != null && !(s = result.toString()).trim().isEmpty()) {
                            RemmeberableDialogueEditor.this.actions.setAction((String)entry.getKey(), this.createRember(((SavedRememberAction)entry.getValue()).getAction(), s));
                        }
                    }

                    private SavedRememberAction createRember(ExecuteAppletAction action, String newValue) {
                        return new SavedRememberAction(action, newValue);
                    }
                });
                d.add(expertButton);
                addedableClasses.remove(i);
                --i;
            }
        }
        ComboBoxModel<String> model = new ComboBoxModel<String>(){
            Object selected = null;

            @Override
            public void setSelectedItem(Object anItem) {
                for (int i = 0; i < addedableClasses.size(); ++i) {
                    Class get = (Class)addedableClasses.get(i);
                    if (!get.getSimpleName().equals(anItem)) continue;
                    this.selected = get.getSimpleName();
                }
            }

            @Override
            public Object getSelectedItem() {
                return this.selected;
            }

            @Override
            public int getSize() {
                return addedableClasses.size();
            }

            @Override
            public String getElementAt(int index) {
                return ((Class)addedableClasses.get(index)).getSimpleName();
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        };
        for (int x = 0; x < 4; ++x) {
            b = new Button(Translator.R("EPEhelp" + (x + 1)));
            b.setEnabled(false);
            d.add(b);
        }
        final JComboBox<String> cb = new JComboBox<String>(model);
        b = new JButton("+");
        ((AbstractButton)b).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cb.getSelectedIndex() < 0) {
                    return;
                }
                RemmeberableDialogueEditor.this.actions.setAction((Class)addedableClasses.get(cb.getSelectedIndex()), new SavedRememberAction(ExecuteAppletAction.NEVER, ExecuteAppletAction.NEVER.toChar()));
                RemmeberableDialogueEditor.this.recreateGui();
            }
        });
        d.add(b);
        d.add(cb);
        JButton save = new JButton(Translator.R("EPEsave"));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemmeberableDialogueEditor.this.result = RemmeberableDialogueEditor.this.actions;
                RemmeberableDialogueEditor.this.self.setVisible(false);
            }
        });
        d.add(save);
        JButton cancel = new JButton(Translator.R("EPEcancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemmeberableDialogueEditor.this.result = null;
                RemmeberableDialogueEditor.this.self.setVisible(false);
            }
        });
        d.add(cancel);
        d.pack();
    }

    public AppletSecurityActions getResult() {
        return this.result;
    }
}

