/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtPositioning.h"

#line 28 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtPositioning/qgeocoordinate.sip"
#include <qgeocoordinate.h>
#line 29 "/build/pyqt6/src/PyQt6-6.3.1/build/QtPositioning/sipQtPositioningQGeoCoordinate.cpp"

#line 24 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt6/src/PyQt6-6.3.1/build/QtPositioning/sipQtPositioningQGeoCoordinate.cpp"


PyDoc_STRVAR(doc_QGeoCoordinate_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QGeoCoordinate_isValid(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGeoCoordinate, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_isValid, doc_QGeoCoordinate_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_type, "type(self) -> QGeoCoordinate.CoordinateType");

extern "C" {static PyObject *meth_QGeoCoordinate_type(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGeoCoordinate, &sipCpp))
        {
             ::QGeoCoordinate::CoordinateType sipRes;

            sipRes = sipCpp->type();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QGeoCoordinate_CoordinateType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_type, doc_QGeoCoordinate_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_setLatitude, "setLatitude(self, float)");

extern "C" {static PyObject *meth_QGeoCoordinate_setLatitude(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_setLatitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
         ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QGeoCoordinate, &sipCpp, &a0))
        {
            sipCpp->setLatitude(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_setLatitude, doc_QGeoCoordinate_setLatitude);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_latitude, "latitude(self) -> float");

extern "C" {static PyObject *meth_QGeoCoordinate_latitude(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_latitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGeoCoordinate, &sipCpp))
        {
            double sipRes;

            sipRes = sipCpp->latitude();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_latitude, doc_QGeoCoordinate_latitude);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_setLongitude, "setLongitude(self, float)");

extern "C" {static PyObject *meth_QGeoCoordinate_setLongitude(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_setLongitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
         ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QGeoCoordinate, &sipCpp, &a0))
        {
            sipCpp->setLongitude(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_setLongitude, doc_QGeoCoordinate_setLongitude);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_longitude, "longitude(self) -> float");

extern "C" {static PyObject *meth_QGeoCoordinate_longitude(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_longitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGeoCoordinate, &sipCpp))
        {
            double sipRes;

            sipRes = sipCpp->longitude();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_longitude, doc_QGeoCoordinate_longitude);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_setAltitude, "setAltitude(self, float)");

extern "C" {static PyObject *meth_QGeoCoordinate_setAltitude(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_setAltitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
         ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QGeoCoordinate, &sipCpp, &a0))
        {
            sipCpp->setAltitude(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_setAltitude, doc_QGeoCoordinate_setAltitude);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_altitude, "altitude(self) -> float");

extern "C" {static PyObject *meth_QGeoCoordinate_altitude(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_altitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGeoCoordinate, &sipCpp))
        {
            double sipRes;

            sipRes = sipCpp->altitude();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_altitude, doc_QGeoCoordinate_altitude);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_distanceTo, "distanceTo(self, QGeoCoordinate) -> float");

extern "C" {static PyObject *meth_QGeoCoordinate_distanceTo(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_distanceTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate* a0;
        const  ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QGeoCoordinate, &sipCpp, sipType_QGeoCoordinate, &a0))
        {
             ::qreal sipRes;

            sipRes = sipCpp->distanceTo(*a0);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_distanceTo, doc_QGeoCoordinate_distanceTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_azimuthTo, "azimuthTo(self, QGeoCoordinate) -> float");

extern "C" {static PyObject *meth_QGeoCoordinate_azimuthTo(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_azimuthTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate* a0;
        const  ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QGeoCoordinate, &sipCpp, sipType_QGeoCoordinate, &a0))
        {
             ::qreal sipRes;

            sipRes = sipCpp->azimuthTo(*a0);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_azimuthTo, doc_QGeoCoordinate_azimuthTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_atDistanceAndAzimuth, "atDistanceAndAzimuth(self, float, float, distanceUp: float = 0) -> QGeoCoordinate");

extern "C" {static PyObject *meth_QGeoCoordinate_atDistanceAndAzimuth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_atDistanceAndAzimuth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qreal a0;
         ::qreal a1;
         ::qreal a2 = 0;
        const  ::QGeoCoordinate *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_distanceUp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd|d", &sipSelf, sipType_QGeoCoordinate, &sipCpp, &a0, &a1, &a2))
        {
             ::QGeoCoordinate*sipRes;

            sipRes = new  ::QGeoCoordinate(sipCpp->atDistanceAndAzimuth(a0,a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QGeoCoordinate,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_atDistanceAndAzimuth, doc_QGeoCoordinate_atDistanceAndAzimuth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_toString, "toString(self, format: QGeoCoordinate.CoordinateFormat = QGeoCoordinate.DegreesMinutesSecondsWithHemisphere) -> str");

extern "C" {static PyObject *meth_QGeoCoordinate_toString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_toString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QGeoCoordinate::CoordinateFormat a0 = QGeoCoordinate::DegreesMinutesSecondsWithHemisphere;
        const  ::QGeoCoordinate *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_QGeoCoordinate, &sipCpp, sipType_QGeoCoordinate_CoordinateFormat, &a0))
        {
             ::QString*sipRes;

            sipRes = new  ::QString(sipCpp->toString(a0));

            return sipConvertFromNewType(sipRes,sipType_QString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_toString, doc_QGeoCoordinate_toString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGeoCoordinate_swap, "swap(self, QGeoCoordinate)");

extern "C" {static PyObject *meth_QGeoCoordinate_swap(PyObject *, PyObject *);}
static PyObject *meth_QGeoCoordinate_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QGeoCoordinate* a0;
         ::QGeoCoordinate *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QGeoCoordinate, &sipCpp, sipType_QGeoCoordinate, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGeoCoordinate, sipName_swap, doc_QGeoCoordinate_swap);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QGeoCoordinate___eq__(PyObject *,PyObject *);}
static PyObject *slot_QGeoCoordinate___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QGeoCoordinate *sipCpp = reinterpret_cast< ::QGeoCoordinate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QGeoCoordinate));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QGeoCoordinate, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtPositioning, eq_slot, sipType_QGeoCoordinate, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QGeoCoordinate___ne__(PyObject *,PyObject *);}
static PyObject *slot_QGeoCoordinate___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QGeoCoordinate *sipCpp = reinterpret_cast< ::QGeoCoordinate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QGeoCoordinate));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QGeoCoordinate* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QGeoCoordinate, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtPositioning, ne_slot, sipType_QGeoCoordinate, sipSelf, sipArg);
}


extern "C" {static Py_hash_t slot_QGeoCoordinate___hash__(PyObject *);}
static Py_hash_t slot_QGeoCoordinate___hash__(PyObject *sipSelf)
{
     ::QGeoCoordinate *sipCpp = reinterpret_cast< ::QGeoCoordinate *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QGeoCoordinate));

    if (!sipCpp)
        return 0;


    {
        {
            Py_hash_t sipRes = 0;

#line 69 "/build/pyqt6/src/PyQt6-6.3.1/sip/QtPositioning/qgeocoordinate.sip"
        sipRes = qHash(*sipCpp);
#line 482 "/build/pyqt6/src/PyQt6-6.3.1/build/QtPositioning/sipQtPositioningQGeoCoordinate.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QGeoCoordinate(void *, int);}
static void release_QGeoCoordinate(void *sipCppV, int)
{
    delete reinterpret_cast< ::QGeoCoordinate *>(sipCppV);
}


extern "C" {static void *array_QGeoCoordinate(Py_ssize_t);}
static void *array_QGeoCoordinate(Py_ssize_t sipNrElem)
{
    return new  ::QGeoCoordinate[sipNrElem];
}


extern "C" {static void array_delete_QGeoCoordinate(void *);}
static void array_delete_QGeoCoordinate(void *sipCpp)
{
    delete[] reinterpret_cast< ::QGeoCoordinate *>(sipCpp);
}


extern "C" {static void assign_QGeoCoordinate(void *, Py_ssize_t, void *);}
static void assign_QGeoCoordinate(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QGeoCoordinate *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QGeoCoordinate *>(sipSrc);
}


extern "C" {static void *copy_QGeoCoordinate(const void *, Py_ssize_t);}
static void *copy_QGeoCoordinate(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QGeoCoordinate(reinterpret_cast<const  ::QGeoCoordinate *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QGeoCoordinate(sipSimpleWrapper *);}
static void dealloc_QGeoCoordinate(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QGeoCoordinate(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QGeoCoordinate(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QGeoCoordinate(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QGeoCoordinate *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QGeoCoordinate();

            return sipCpp;
        }
    }

    {
        double a0;
        double a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "dd", &a0, &a1))
        {
            sipCpp = new  ::QGeoCoordinate(a0,a1);

            return sipCpp;
        }
    }

    {
        double a0;
        double a1;
        double a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "ddd", &a0, &a1, &a2))
        {
            sipCpp = new  ::QGeoCoordinate(a0,a1,a2);

            return sipCpp;
        }
    }

    {
        const  ::QGeoCoordinate* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QGeoCoordinate, &a0))
        {
            sipCpp = new  ::QGeoCoordinate(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QGeoCoordinate[] = {
    {(void *)slot_QGeoCoordinate___eq__, eq_slot},
    {(void *)slot_QGeoCoordinate___ne__, ne_slot},
    {(void *)slot_QGeoCoordinate___hash__, hash_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QGeoCoordinate[] = {
    {sipName_altitude, meth_QGeoCoordinate_altitude, METH_VARARGS, doc_QGeoCoordinate_altitude},
    {sipName_atDistanceAndAzimuth, SIP_MLMETH_CAST(meth_QGeoCoordinate_atDistanceAndAzimuth), METH_VARARGS|METH_KEYWORDS, doc_QGeoCoordinate_atDistanceAndAzimuth},
    {sipName_azimuthTo, meth_QGeoCoordinate_azimuthTo, METH_VARARGS, doc_QGeoCoordinate_azimuthTo},
    {sipName_distanceTo, meth_QGeoCoordinate_distanceTo, METH_VARARGS, doc_QGeoCoordinate_distanceTo},
    {sipName_isValid, meth_QGeoCoordinate_isValid, METH_VARARGS, doc_QGeoCoordinate_isValid},
    {sipName_latitude, meth_QGeoCoordinate_latitude, METH_VARARGS, doc_QGeoCoordinate_latitude},
    {sipName_longitude, meth_QGeoCoordinate_longitude, METH_VARARGS, doc_QGeoCoordinate_longitude},
    {sipName_setAltitude, meth_QGeoCoordinate_setAltitude, METH_VARARGS, doc_QGeoCoordinate_setAltitude},
    {sipName_setLatitude, meth_QGeoCoordinate_setLatitude, METH_VARARGS, doc_QGeoCoordinate_setLatitude},
    {sipName_setLongitude, meth_QGeoCoordinate_setLongitude, METH_VARARGS, doc_QGeoCoordinate_setLongitude},
    {sipName_swap, meth_QGeoCoordinate_swap, METH_VARARGS, doc_QGeoCoordinate_swap},
    {sipName_toString, SIP_MLMETH_CAST(meth_QGeoCoordinate_toString), METH_VARARGS|METH_KEYWORDS, doc_QGeoCoordinate_toString},
    {sipName_type, meth_QGeoCoordinate_type, METH_VARARGS, doc_QGeoCoordinate_type}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QGeoCoordinate[] = {
    {sipName_Degrees, static_cast<int>( ::QGeoCoordinate::Degrees)},
    {sipName_DegreesWithHemisphere, static_cast<int>( ::QGeoCoordinate::DegreesWithHemisphere)},
    {sipName_DegreesMinutes, static_cast<int>( ::QGeoCoordinate::DegreesMinutes)},
    {sipName_DegreesMinutesWithHemisphere, static_cast<int>( ::QGeoCoordinate::DegreesMinutesWithHemisphere)},
    {sipName_DegreesMinutesSeconds, static_cast<int>( ::QGeoCoordinate::DegreesMinutesSeconds)},
    {sipName_DegreesMinutesSecondsWithHemisphere, static_cast<int>( ::QGeoCoordinate::DegreesMinutesSecondsWithHemisphere)},
    {sipName_InvalidCoordinate, static_cast<int>( ::QGeoCoordinate::InvalidCoordinate)},
    {sipName_Coordinate2D, static_cast<int>( ::QGeoCoordinate::Coordinate2D)},
    {sipName_Coordinate3D, static_cast<int>( ::QGeoCoordinate::Coordinate3D)},
    {0, 0}
};

PyDoc_STRVAR(doc_QGeoCoordinate, "\1QGeoCoordinate()\n"
"QGeoCoordinate(float, float)\n"
"QGeoCoordinate(float, float, float)\n"
"QGeoCoordinate(QGeoCoordinate)");


sipClassTypeDef sipTypeDef_QtPositioning_QGeoCoordinate = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QGeoCoordinate,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_QGeoCoordinate,
        {0, 0, 1},
        13, methods_QGeoCoordinate,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QGeoCoordinate, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QGeoCoordinate,
    -1,
    -1,
    SIP_NULLPTR,
    slots_QGeoCoordinate,
    init_type_QGeoCoordinate,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QGeoCoordinate,
    assign_QGeoCoordinate,
    array_QGeoCoordinate,
    copy_QGeoCoordinate,
    release_QGeoCoordinate,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QGeoCoordinate,
    sizeof ( ::QGeoCoordinate),
};
