/* dummy-backend.c generated by valac 0.56.3, the Vala compiler
 * generated from dummy-backend.vala, do not modify */

/*
 * Copyright (C) 2013 Philip Withnall
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks-dummy.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "folks/folks.h"
#include <gio/gio.h>
#include "folks-internal.h"

enum  {
	FOLKS_DUMMY_BACKEND_0_PROPERTY,
	FOLKS_DUMMY_BACKEND_IS_PREPARED_PROPERTY,
	FOLKS_DUMMY_BACKEND_IS_QUIESCENT_PROPERTY,
	FOLKS_DUMMY_BACKEND_NAME_PROPERTY,
	FOLKS_DUMMY_BACKEND_PERSONA_STORES_PROPERTY,
	FOLKS_DUMMY_BACKEND_NUM_PROPERTIES
};
static GParamSpec* folks_dummy_backend_properties[FOLKS_DUMMY_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksDummyBackendPrepareData FolksDummyBackendPrepareData;
typedef struct _FolksDummyBackendUnprepareData FolksDummyBackendUnprepareData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksDummyBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GeeHashMap* _all_persona_stores;
	GeeHashMap* _enabled_persona_stores;
	GeeMap* _enabled_persona_stores_ro;
};

struct _FolksDummyBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksDummyBackend* self;
	gboolean _tmp0_;
	GError* _inner_error0_;
};

struct _FolksDummyBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksDummyBackend* self;
	gboolean _tmp0_;
	FolksDummyPersonaStore** enabled_stores;
	GeeHashMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	gint _tmp5_;
	gpointer* _tmp6_;
	FolksDummyPersonaStore** _tmp7_;
	gint _tmp7__length1;
	gint enabled_stores_length1;
	gint _enabled_stores_size_;
	FolksDummyPersonaStore** _tmp8_;
	gint _tmp8__length1;
	FolksDummyPersonaStore** persona_store_collection;
	gint persona_store_collection_length1;
	gint _persona_store_collection_size_;
	gint persona_store_it;
	FolksDummyPersonaStore* _tmp9_;
	FolksDummyPersonaStore* persona_store;
	FolksDummyPersonaStore* _tmp10_;
	GError* _inner_error0_;
};

static gint FolksDummyBackend_private_offset;
static gpointer folks_dummy_backend_parent_class = NULL;

static void folks_dummy_backend_real_disable_persona_store (FolksBackend* base,
                                                     FolksPersonaStore* store);
static void _folks_dummy_backend_disable_persona_store (FolksDummyBackend* self,
                                                 FolksPersonaStore* store);
static void folks_dummy_backend_real_enable_persona_store (FolksBackend* base,
                                                    FolksPersonaStore* store);
static void _folks_dummy_backend_enable_persona_store (FolksDummyBackend* self,
                                                FolksDummyPersonaStore* store);
static void folks_dummy_backend_real_set_persona_stores (FolksBackend* base,
                                                  GeeSet* store_ids);
static void _vala_array_add1 (FolksDummyPersonaStore** * array,
                       gint* length,
                       gint* size,
                       FolksDummyPersonaStore* value);
static void _folks_dummy_backend_store_removed_cb (FolksDummyBackend* self,
                                            FolksPersonaStore* store);
static void __folks_dummy_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender,
                                                                         gpointer self);
static void folks_dummy_backend_real_prepare_data_free (gpointer _data);
static void folks_dummy_backend_real_prepare (FolksBackend* base,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean folks_dummy_backend_real_prepare_co (FolksDummyBackendPrepareData* _data_);
static void folks_dummy_backend_real_unprepare_data_free (gpointer _data);
static void folks_dummy_backend_real_unprepare (FolksBackend* base,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean folks_dummy_backend_real_unprepare_co (FolksDummyBackendUnprepareData* _data_);
static GObject * folks_dummy_backend_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void folks_dummy_backend_finalize (GObject * obj);
static GType folks_dummy_backend_get_type_once (void);
static void _vala_folks_dummy_backend_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
folks_dummy_backend_get_instance_private (FolksDummyBackend* self)
{
	return G_STRUCT_MEMBER_P (self, FolksDummyBackend_private_offset);
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
FolksDummyBackend*
folks_dummy_backend_construct (GType object_type)
{
	FolksDummyBackend * self = NULL;
	self = (FolksDummyBackend*) g_object_new (object_type, NULL);
	return self;
}

FolksDummyBackend*
folks_dummy_backend_new (void)
{
	return folks_dummy_backend_construct (FOLKS_DUMMY_TYPE_BACKEND);
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static void
folks_dummy_backend_real_disable_persona_store (FolksBackend* base,
                                                FolksPersonaStore* store)
{
	FolksDummyBackend * self;
	self = (FolksDummyBackend*) base;
	g_return_if_fail (store != NULL);
	_folks_dummy_backend_disable_persona_store (self, store);
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static void
folks_dummy_backend_real_enable_persona_store (FolksBackend* base,
                                               FolksPersonaStore* store)
{
	FolksDummyBackend * self;
	self = (FolksDummyBackend*) base;
	g_return_if_fail (store != NULL);
	_folks_dummy_backend_enable_persona_store (self, G_TYPE_CHECK_INSTANCE_CAST (store, FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore));
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add1 (FolksDummyPersonaStore** * array,
                  gint* length,
                  gint* size,
                  FolksDummyPersonaStore* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksDummyPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
folks_dummy_backend_real_set_persona_stores (FolksBackend* base,
                                             GeeSet* store_ids)
{
	FolksDummyBackend * self;
	FolksDummyPersonaStore** stores_to_remove = NULL;
	FolksDummyPersonaStore** _tmp21_;
	gint stores_to_remove_length1;
	gint _stores_to_remove_size_;
	FolksDummyPersonaStore** _tmp36_;
	gint _tmp36__length1;
	self = (FolksDummyBackend*) base;
	if (store_ids == NULL) {
		g_object_freeze_notify ((GObject*) self);
		{
			GeeIterator* _store_it = NULL;
			GeeHashMap* _tmp0_;
			GeeCollection* _tmp1_;
			GeeCollection* _tmp2_;
			GeeCollection* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* _tmp5_;
			_tmp0_ = self->priv->_all_persona_stores;
			_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
			_tmp2_ = _tmp1_;
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_store_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				FolksDummyPersonaStore* store = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				FolksDummyPersonaStore* _tmp9_;
				_tmp6_ = _store_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _store_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				store = (FolksDummyPersonaStore*) _tmp8_;
				_tmp9_ = store;
				_folks_dummy_backend_enable_persona_store (self, _tmp9_);
				_g_object_unref0 (store);
			}
			_g_object_unref0 (_store_it);
		}
		g_object_thaw_notify ((GObject*) self);
		return;
	}
	g_object_freeze_notify ((GObject*) self);
	{
		GeeIterator* _id_it = NULL;
		GeeIterator* _tmp10_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) store_ids);
		_id_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			gchar* id = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			_tmp11_ = _id_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _id_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			id = (gchar*) _tmp13_;
			_tmp14_ = self->priv->_enabled_persona_stores;
			_tmp15_ = id;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp14_, _tmp15_)) {
				FolksDummyPersonaStore* store = NULL;
				GeeHashMap* _tmp16_;
				const gchar* _tmp17_;
				gpointer _tmp18_;
				FolksDummyPersonaStore* _tmp19_;
				_tmp16_ = self->priv->_all_persona_stores;
				_tmp17_ = id;
				_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
				store = (FolksDummyPersonaStore*) _tmp18_;
				_tmp19_ = store;
				if (_tmp19_ != NULL) {
					FolksDummyPersonaStore* _tmp20_;
					_tmp20_ = store;
					_folks_dummy_backend_enable_persona_store (self, _tmp20_);
				}
				_g_object_unref0 (store);
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp21_ = g_new0 (FolksDummyPersonaStore*, 0 + 1);
	stores_to_remove = _tmp21_;
	stores_to_remove_length1 = 0;
	_stores_to_remove_size_ = stores_to_remove_length1;
	{
		GeeIterator* _store_it = NULL;
		GeeHashMap* _tmp22_;
		GeeCollection* _tmp23_;
		GeeCollection* _tmp24_;
		GeeCollection* _tmp25_;
		GeeIterator* _tmp26_;
		GeeIterator* _tmp27_;
		_tmp22_ = self->priv->_enabled_persona_stores;
		_tmp23_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
		_tmp27_ = _tmp26_;
		_g_object_unref0 (_tmp25_);
		_store_it = _tmp27_;
		while (TRUE) {
			GeeIterator* _tmp28_;
			FolksDummyPersonaStore* store = NULL;
			GeeIterator* _tmp29_;
			gpointer _tmp30_;
			FolksDummyPersonaStore* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp28_ = _store_it;
			if (!gee_iterator_next (_tmp28_)) {
				break;
			}
			_tmp29_ = _store_it;
			_tmp30_ = gee_iterator_get (_tmp29_);
			store = (FolksDummyPersonaStore*) _tmp30_;
			_tmp31_ = store;
			_tmp32_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp31_);
			_tmp33_ = _tmp32_;
			if (!gee_collection_contains ((GeeCollection*) store_ids, _tmp33_)) {
				FolksDummyPersonaStore* _tmp34_;
				FolksDummyPersonaStore* _tmp35_;
				_tmp34_ = store;
				_tmp35_ = _g_object_ref0 (_tmp34_);
				_vala_array_add1 (&stores_to_remove, &stores_to_remove_length1, &_stores_to_remove_size_, _tmp35_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	_tmp36_ = stores_to_remove;
	_tmp36__length1 = stores_to_remove_length1;
	{
		FolksDummyPersonaStore** store_collection = NULL;
		gint store_collection_length1 = 0;
		gint _store_collection_size_ = 0;
		gint store_it = 0;
		store_collection = _tmp36_;
		store_collection_length1 = _tmp36__length1;
		for (store_it = 0; store_it < store_collection_length1; store_it = store_it + 1) {
			FolksDummyPersonaStore* _tmp37_;
			FolksDummyPersonaStore* store = NULL;
			_tmp37_ = _g_object_ref0 (store_collection[store_it]);
			store = _tmp37_;
			{
				FolksDummyPersonaStore* _tmp38_;
				_tmp38_ = store;
				_folks_dummy_backend_disable_persona_store (self, (FolksPersonaStore*) _tmp38_);
				_g_object_unref0 (store);
			}
		}
	}
	g_object_thaw_notify ((GObject*) self);
	stores_to_remove = (_vala_array_free (stores_to_remove, stores_to_remove_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
__folks_dummy_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender,
                                                                    gpointer self)
{
	_folks_dummy_backend_store_removed_cb ((FolksDummyBackend*) self, _sender);
}

static void
_folks_dummy_backend_enable_persona_store (FolksDummyBackend* self,
                                           FolksDummyPersonaStore* store)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_enabled_persona_stores;
	_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp2_ = _tmp1_;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_)) {
		return;
	}
	_tmp3_ = self->priv->_all_persona_stores;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp5_ = _tmp4_;
	_vala_assert (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp5_), "this._all_persona_stores.has_key (store.id)");
	g_signal_connect_object ((FolksPersonaStore*) store, "removed", (GCallback) __folks_dummy_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	_tmp6_ = self->priv->_enabled_persona_stores;
	_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp8_ = _tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp8_, store);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) store);
	g_object_notify ((GObject*) self, "persona-stores");
}

static void
_folks_dummy_backend_disable_persona_store (FolksDummyBackend* self,
                                            FolksPersonaStore* store)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	guint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_enabled_persona_stores;
	_tmp1_ = folks_persona_store_get_id (store);
	_tmp2_ = _tmp1_;
	if (!gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp2_, NULL)) {
		return;
	}
	_tmp3_ = self->priv->_all_persona_stores;
	_tmp4_ = folks_persona_store_get_id (store);
	_tmp5_ = _tmp4_;
	_vala_assert (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp5_), "this._all_persona_stores.has_key (store.id)");
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", store);
	g_object_notify ((GObject*) self, "persona-stores");
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __folks_dummy_backend_store_removed_cb_folks_persona_store_removed, self);
}

static void
_folks_dummy_backend_store_removed_cb (FolksDummyBackend* self,
                                       FolksPersonaStore* store)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_folks_dummy_backend_disable_persona_store (self, store);
}

static void
folks_dummy_backend_real_prepare_data_free (gpointer _data)
{
	FolksDummyBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyBackendPrepareData, _data_);
}

static void
folks_dummy_backend_real_prepare (FolksBackend* base,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	FolksDummyBackend * self;
	FolksDummyBackendPrepareData* _data_;
	FolksDummyBackend* _tmp0_;
	self = (FolksDummyBackend*) base;
	_data_ = g_slice_new0 (FolksDummyBackendPrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_dummy_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_dummy_backend_real_prepare_co (_data_);
}

static void
folks_dummy_backend_prepare_finish (FolksBackend* base,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	FolksDummyBackendPrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static gboolean
folks_dummy_backend_real_prepare_co (FolksDummyBackendPrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	folks_internal_profiling_start ("preparing Dummy.Backend", NULL);
	if (_data_->self->priv->_is_prepared) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = _data_->self->priv->_prepare_pending;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
	}
	__finally0:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	folks_internal_profiling_end ("preparing Dummy.Backend", NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_dummy_backend_real_unprepare_data_free (gpointer _data)
{
	FolksDummyBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyBackendUnprepareData, _data_);
}

static void
folks_dummy_backend_real_unprepare (FolksBackend* base,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksDummyBackend * self;
	FolksDummyBackendUnprepareData* _data_;
	FolksDummyBackend* _tmp0_;
	self = (FolksDummyBackend*) base;
	_data_ = g_slice_new0 (FolksDummyBackendUnprepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_dummy_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_dummy_backend_real_unprepare_co (_data_);
}

static void
folks_dummy_backend_unprepare_finish (FolksBackend* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	FolksDummyBackendUnprepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static gboolean
folks_dummy_backend_real_unprepare_co (FolksDummyBackendUnprepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!_data_->self->priv->_is_prepared) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = _data_->self->priv->_prepare_pending;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		_data_->_tmp1_ = _data_->self->priv->_enabled_persona_stores;
		_data_->_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = 0;
		_data_->_tmp6_ = gee_collection_to_array (_data_->_tmp4_, &_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp7__length1 = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp4_);
		_data_->enabled_stores = _data_->_tmp7_;
		_data_->enabled_stores_length1 = _data_->_tmp7__length1;
		_data_->_enabled_stores_size_ = _data_->enabled_stores_length1;
		_data_->_tmp8_ = _data_->enabled_stores;
		_data_->_tmp8__length1 = _data_->enabled_stores_length1;
		{
			_data_->persona_store_collection_length1 = 0;
			_data_->_persona_store_collection_size_ = 0;
			_data_->persona_store_collection = _data_->_tmp8_;
			_data_->persona_store_collection_length1 = _data_->_tmp8__length1;
			for (_data_->persona_store_it = 0; _data_->persona_store_it < _data_->persona_store_collection_length1; _data_->persona_store_it = _data_->persona_store_it + 1) {
				_data_->_tmp9_ = _g_object_ref0 (_data_->persona_store_collection[_data_->persona_store_it]);
				_data_->persona_store = _data_->_tmp9_;
				{
					_data_->_tmp10_ = _data_->persona_store;
					_folks_dummy_backend_disable_persona_store (_data_->self, (FolksPersonaStore*) _data_->_tmp10_);
					_g_object_unref0 (_data_->persona_store);
				}
			}
		}
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->enabled_stores = (_vala_array_free (_data_->enabled_stores, _data_->enabled_stores_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	__finally0:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Register and enable some {@link FolksDummy.PersonaStore}s.
   *
   * For each of the persona stores in ``stores``, register it with this
   * backend. If ``enable_stores`` is ``true``, added stores will also be
   * enabled, emitting {@link Folks.Backend.persona_store_added} for each
   * newly-enabled store. After all addition signals are emitted, a change
   * notification for {@link Folks.Backend.persona_stores} will be emitted (but
   * only if at least one addition signal is emitted).
   *
   * Persona stores are identified by their {@link Folks.PersonaStore.id}; if a
   * store in ``stores`` has the same ID as a store previously registered
   * through this method, the duplicate will be ignored (so
   * {@link Folks.Backend.persona_store_added} won't be emitted for that store).
   *
   * Persona stores must be instances of {@link FolksDummy.PersonaStore} or
   * subclasses of it, allowing for different persona store implementations to
   * be tested.
   *
   * @param stores set of persona stores to register
   * @param enable_stores whether to automatically enable the stores
   * @since 0.9.7
   */
void
folks_dummy_backend_register_persona_stores (FolksDummyBackend* self,
                                             GeeSet* stores,
                                             gboolean enable_stores)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (stores != NULL);
	g_object_freeze_notify ((GObject*) self);
	{
		GeeIterator* _store_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) stores);
		_store_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			FolksDummyPersonaStore* store = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			FolksDummyPersonaStore* _tmp4_;
			GeeHashMap* _tmp5_;
			FolksDummyPersonaStore* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			GeeHashMap* _tmp9_;
			FolksDummyPersonaStore* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			FolksDummyPersonaStore* _tmp13_;
			_tmp1_ = _store_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _store_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			store = (FolksDummyPersonaStore*) _tmp3_;
			_tmp4_ = store;
			_vala_assert (FOLKS_DUMMY_IS_PERSONA_STORE (_tmp4_), "store is FolksDummy.PersonaStore");
			_tmp5_ = self->priv->_all_persona_stores;
			_tmp6_ = store;
			_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp8_)) {
				_g_object_unref0 (store);
				continue;
			}
			_tmp9_ = self->priv->_all_persona_stores;
			_tmp10_ = store;
			_tmp11_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = store;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp12_, _tmp13_);
			if (enable_stores == TRUE) {
				FolksDummyPersonaStore* _tmp14_;
				_tmp14_ = store;
				_folks_dummy_backend_enable_persona_store (self, _tmp14_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	g_object_thaw_notify ((GObject*) self);
}

/**
   * Disable and unregister some {@link FolksDummy.PersonaStore}s.
   *
   * For each of the persona stores in ``stores``, disable it (if it was
   * enabled) and unregister it from the backend so that it cannot be re-enabled
   * using {@link Folks.Backend.enable_persona_store} or
   * {@link Folks.Backend.set_persona_stores}.
   *
   * {@link Folks.Backend.persona_store_removed} will be emitted for all persona
   * stores in ``stores`` which were previously enabled. After all removal
   * signals are emitted, a change notification for
   * {@link Folks.Backend.persona_stores} will be emitted (but only if at least
   * one removal signal is emitted).
   *
   * @since 0.9.7
   */
void
folks_dummy_backend_unregister_persona_stores (FolksDummyBackend* self,
                                               GeeSet* stores)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (stores != NULL);
	g_object_freeze_notify ((GObject*) self);
	{
		GeeIterator* _store_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) stores);
		_store_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			FolksDummyPersonaStore* store = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			FolksDummyPersonaStore* _tmp4_;
			GeeHashMap* _tmp5_;
			FolksDummyPersonaStore* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			FolksDummyPersonaStore* _tmp9_;
			GeeHashMap* _tmp10_;
			FolksDummyPersonaStore* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp1_ = _store_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _store_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			store = (FolksDummyPersonaStore*) _tmp3_;
			_tmp4_ = store;
			_vala_assert (FOLKS_DUMMY_IS_PERSONA_STORE (_tmp4_), "store is FolksDummy.PersonaStore");
			_tmp5_ = self->priv->_all_persona_stores;
			_tmp6_ = store;
			_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp8_)) {
				_g_object_unref0 (store);
				continue;
			}
			_tmp9_ = store;
			_folks_dummy_backend_disable_persona_store (self, (FolksPersonaStore*) _tmp9_);
			_tmp10_ = self->priv->_all_persona_stores;
			_tmp11_ = store;
			_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
			_tmp13_ = _tmp12_;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, _tmp13_, NULL);
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	g_object_thaw_notify ((GObject*) self);
}

static gboolean
folks_dummy_backend_real_get_is_prepared (FolksBackend* base)
{
	gboolean result;
	FolksDummyBackend* self;
	self = (FolksDummyBackend*) base;
	result = self->priv->_is_prepared;
	return result;
}

static gboolean
folks_dummy_backend_real_get_is_quiescent (FolksBackend* base)
{
	gboolean result;
	FolksDummyBackend* self;
	self = (FolksDummyBackend*) base;
	result = self->priv->_is_quiescent;
	return result;
}

static const gchar*
folks_dummy_backend_real_get_name (FolksBackend* base)
{
	const gchar* result;
	FolksDummyBackend* self;
	self = (FolksDummyBackend*) base;
	result = BACKEND_NAME;
	return result;
}

static GeeMap*
folks_dummy_backend_real_get_persona_stores (FolksBackend* base)
{
	GeeMap* result;
	FolksDummyBackend* self;
	GeeMap* _tmp0_;
	self = (FolksDummyBackend*) base;
	_tmp0_ = self->priv->_enabled_persona_stores_ro;
	result = _tmp0_;
	return result;
}

static GObject *
folks_dummy_backend_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksDummyBackend * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	parent_class = G_OBJECT_CLASS (folks_dummy_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_DUMMY_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_all_persona_stores);
	self->priv->_all_persona_stores = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_DUMMY_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_enabled_persona_stores);
	self->priv->_enabled_persona_stores = _tmp1_;
	_tmp2_ = self->priv->_enabled_persona_stores;
	_tmp3_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_enabled_persona_stores_ro);
	self->priv->_enabled_persona_stores_ro = _tmp4_;
	return obj;
}

static void
folks_dummy_backend_class_init (FolksDummyBackendClass * klass,
                                gpointer klass_data)
{
	folks_dummy_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksDummyBackend_private_offset);
	((FolksBackendClass *) klass)->disable_persona_store = (void (*) (FolksBackend*, FolksPersonaStore*)) folks_dummy_backend_real_disable_persona_store;
	((FolksBackendClass *) klass)->enable_persona_store = (void (*) (FolksBackend*, FolksPersonaStore*)) folks_dummy_backend_real_enable_persona_store;
	((FolksBackendClass *) klass)->set_persona_stores = (void (*) (FolksBackend*, GeeSet*)) folks_dummy_backend_real_set_persona_stores;
	((FolksBackendClass *) klass)->prepare = (void (*) (FolksBackend*, GAsyncReadyCallback, gpointer)) folks_dummy_backend_real_prepare;
	((FolksBackendClass *) klass)->prepare_finish = (void (*) (FolksBackend*, GAsyncResult*, GError**)) folks_dummy_backend_prepare_finish;
	((FolksBackendClass *) klass)->unprepare = (void (*) (FolksBackend*, GAsyncReadyCallback, gpointer)) folks_dummy_backend_real_unprepare;
	((FolksBackendClass *) klass)->unprepare_finish = (void (*) (FolksBackend*, GAsyncResult*, GError**)) folks_dummy_backend_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_dummy_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_dummy_backend_real_get_is_quiescent;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_dummy_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_dummy_backend_real_get_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_dummy_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_dummy_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_dummy_backend_finalize;
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_BACKEND_IS_PREPARED_PROPERTY, folks_dummy_backend_properties[FOLKS_DUMMY_BACKEND_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_BACKEND_IS_QUIESCENT_PROPERTY, folks_dummy_backend_properties[FOLKS_DUMMY_BACKEND_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_BACKEND_NAME_PROPERTY, folks_dummy_backend_properties[FOLKS_DUMMY_BACKEND_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_BACKEND_PERSONA_STORES_PROPERTY, folks_dummy_backend_properties[FOLKS_DUMMY_BACKEND_PERSONA_STORES_PROPERTY] = g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
folks_dummy_backend_instance_init (FolksDummyBackend * self,
                                   gpointer klass)
{
	self->priv = folks_dummy_backend_get_instance_private (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}

static void
folks_dummy_backend_finalize (GObject * obj)
{
	FolksDummyBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackend);
	_g_object_unref0 (self->priv->_all_persona_stores);
	_g_object_unref0 (self->priv->_enabled_persona_stores);
	_g_object_unref0 (self->priv->_enabled_persona_stores_ro);
	G_OBJECT_CLASS (folks_dummy_backend_parent_class)->finalize (obj);
}

/**
 * A backend which allows {@link FolksDummy.PersonaStore}s and
 * {@link FolksDummy.Persona}s to be programmatically created and manipulated,
 * for the purposes of testing the core of libfolks itself.
 *
 * This backend is not meant to be enabled in production use. The methods on
 * {@link FolksDummy.Backend} (and other classes) for programmatically
 * manipulating the backend's state are considered internal to libfolks and are
 * not stable.
 *
 * This backend maintains two sets of persona stores: the set of all persona
 * stores, and the set of enabled persona stores (which must be a subset of the
 * former). {@link FolksDummy.Backend.register_persona_stores} adds persona
 * stores to the set of all stores. Optionally it also enables them, adding them
 * to the set of enabled stores. The set of persona stores advertised by the
 * backend as {@link Folks.Backend.persona_stores} is the set of enabled stores.
 * libfolks may internally enable or disable stores using
 * {@link Folks.Backend.enable_persona_store},
 * {@link Folks.Backend.disable_persona_store}
 * and {@link Folks.Backend.set_persona_stores}.  The ``register_`` and
 * ``unregister_`` prefixes are commonly used for backend methods.
 *
 * The API in {@link FolksDummy} is unstable and may change wildly. It is
 * designed mostly for use by libfolks unit tests.
 *
 * @since 0.9.7
 */
static GType
folks_dummy_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksDummyBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_dummy_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDummyBackend), 0, (GInstanceInitFunc) folks_dummy_backend_instance_init, NULL };
	GType folks_dummy_backend_type_id;
	folks_dummy_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksDummyBackend", &g_define_type_info, 0);
	FolksDummyBackend_private_offset = g_type_add_instance_private (folks_dummy_backend_type_id, sizeof (FolksDummyBackendPrivate));
	return folks_dummy_backend_type_id;
}

GType
folks_dummy_backend_get_type (void)
{
	static volatile gsize folks_dummy_backend_type_id__once = 0;
	if (g_once_init_enter (&folks_dummy_backend_type_id__once)) {
		GType folks_dummy_backend_type_id;
		folks_dummy_backend_type_id = folks_dummy_backend_get_type_once ();
		g_once_init_leave (&folks_dummy_backend_type_id__once, folks_dummy_backend_type_id);
	}
	return folks_dummy_backend_type_id__once;
}

static void
_vala_folks_dummy_backend_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	FolksDummyBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_BACKEND, FolksDummyBackend);
	switch (property_id) {
		case FOLKS_DUMMY_BACKEND_IS_PREPARED_PROPERTY:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_DUMMY_BACKEND_IS_QUIESCENT_PROPERTY:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		case FOLKS_DUMMY_BACKEND_NAME_PROPERTY:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_DUMMY_BACKEND_PERSONA_STORES_PROPERTY:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

