/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.ChecksKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.CompilerWithICKt;
import org.jetbrains.kotlin.ir.backend.js.IcCompatibleIr2Js;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.LoweredIr;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.WholeWorldStageController;
import org.jetbrains.kotlin.ir.backend.js.codegen.JsGenerationGranularity;
import org.jetbrains.kotlin.ir.backend.js.lower.CollectNativeImplementationsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.MoveBodilessDeclarationsToSeparatePlaceKt;
import org.jetbrains.kotlin.ir.backend.js.lower.TestGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.TranslationMode;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTables;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.StageController;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0094\u0001\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\t2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000e\u001a\u00aa\u0001\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e\u001a\u001e\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-\u001a\u0012\u0010.\u001a\u00020/*\u0002002\u0006\u00101\u001a\u000202\u00a8\u00063"}, d2={"compile", "Lorg/jetbrains/kotlin/ir/backend/js/LoweredIr;", "depsDescriptors", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "dceRuntimeDiagnostic", "Lorg/jetbrains/kotlin/js/config/RuntimeDiagnostic;", "es6mode", "", "verifySignatures", "baseClassIntoMetadata", "safeExternalBoolean", "safeExternalBooleanDiagnostic", "filesToLower", "", "granularity", "Lorg/jetbrains/kotlin/ir/backend/js/codegen/JsGenerationGranularity;", "icCompatibleIr2Js", "compileIr", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "mainModule", "Lorg/jetbrains/kotlin/ir/backend/js/MainModule;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "dependencyModules", "", "moduleToName", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irLinker", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsIrLinker;", "generateJsCode", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "nameTables", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "writeSourceMapIfPresent", "", "Lorg/jetbrains/kotlin/ir/backend/js/CompilationOutputs;", "outputJsFile", "Ljava/io/File;", "backend.js"})
public final class CompilerKt {
    @NotNull
    public static final LoweredIr compile(@NotNull ModulesStructure depsDescriptors, @NotNull PhaseConfig phaseConfig, @NotNull IrFactory irFactory, @NotNull Set<FqName> exportedDeclarations, @Nullable RuntimeDiagnostic dceRuntimeDiagnostic, boolean es6mode, boolean verifySignatures, boolean baseClassIntoMetadata, boolean safeExternalBoolean, @Nullable RuntimeDiagnostic safeExternalBooleanDiagnostic, @Nullable Set<String> filesToLower, @NotNull JsGenerationGranularity granularity, boolean icCompatibleIr2Js) {
        Intrinsics.checkNotNullParameter(depsDescriptors, "depsDescriptors");
        Intrinsics.checkNotNullParameter(phaseConfig, "phaseConfig");
        Intrinsics.checkNotNullParameter(irFactory, "irFactory");
        Intrinsics.checkNotNullParameter(exportedDeclarations, "exportedDeclarations");
        Intrinsics.checkNotNullParameter((Object)granularity, "granularity");
        IrModuleInfo irModuleInfo = KlibKt.loadIr(depsDescriptors, irFactory, verifySignatures, filesToLower, true);
        IrModuleFragment moduleFragment2 = irModuleInfo.component1();
        List<IrModuleFragment> dependencyModules = irModuleInfo.component2();
        IrBuiltIns irBuiltIns = irModuleInfo.component3();
        SymbolTable symbolTable = irModuleInfo.component4();
        JsIrLinker deserializer2 = irModuleInfo.component5();
        Map<IrModuleFragment, String> moduleToName = irModuleInfo.component6();
        return CompilerKt.compileIr(moduleFragment2, depsDescriptors.getMainModule(), depsDescriptors.getCompilerConfiguration(), dependencyModules, moduleToName, irBuiltIns, symbolTable, deserializer2, phaseConfig, exportedDeclarations, dceRuntimeDiagnostic, es6mode, baseClassIntoMetadata, safeExternalBoolean, safeExternalBooleanDiagnostic, granularity, icCompatibleIr2Js);
    }

    public static /* synthetic */ LoweredIr compile$default(ModulesStructure modulesStructure, PhaseConfig phaseConfig, IrFactory irFactory, Set set, RuntimeDiagnostic runtimeDiagnostic, boolean bl, boolean bl2, boolean bl3, boolean bl4, RuntimeDiagnostic runtimeDiagnostic2, Set set2, JsGenerationGranularity jsGenerationGranularity, boolean bl5, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            runtimeDiagnostic = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        if ((n & 0x100) != 0) {
            bl4 = false;
        }
        if ((n & 0x200) != 0) {
            runtimeDiagnostic2 = null;
        }
        if ((n & 0x400) != 0) {
            set2 = null;
        }
        if ((n & 0x800) != 0) {
            jsGenerationGranularity = JsGenerationGranularity.WHOLE_PROGRAM;
        }
        if ((n & 0x1000) != 0) {
            bl5 = false;
        }
        return CompilerKt.compile(modulesStructure, phaseConfig, irFactory, set, runtimeDiagnostic, bl, bl2, bl3, bl4, runtimeDiagnostic2, set2, jsGenerationGranularity, bl5);
    }

    @NotNull
    public static final LoweredIr compileIr(@NotNull IrModuleFragment moduleFragment2, @NotNull MainModule mainModule, @NotNull CompilerConfiguration configuration2, @NotNull List<? extends IrModuleFragment> dependencyModules, @NotNull Map<IrModuleFragment, String> moduleToName, @NotNull IrBuiltIns irBuiltIns, @NotNull SymbolTable symbolTable, @NotNull JsIrLinker irLinker, @NotNull PhaseConfig phaseConfig, @NotNull Set<FqName> exportedDeclarations, @Nullable RuntimeDiagnostic dceRuntimeDiagnostic, boolean es6mode, boolean baseClassIntoMetadata, boolean safeExternalBoolean, @Nullable RuntimeDiagnostic safeExternalBooleanDiagnostic, @NotNull JsGenerationGranularity granularity, boolean icCompatibleIr2Js) {
        List<IrModuleFragment> list2;
        Intrinsics.checkNotNullParameter(moduleFragment2, "moduleFragment");
        Intrinsics.checkNotNullParameter(mainModule, "mainModule");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(dependencyModules, "dependencyModules");
        Intrinsics.checkNotNullParameter(moduleToName, "moduleToName");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(irLinker, "irLinker");
        Intrinsics.checkNotNullParameter(phaseConfig, "phaseConfig");
        Intrinsics.checkNotNullParameter(exportedDeclarations, "exportedDeclarations");
        Intrinsics.checkNotNullParameter((Object)granularity, "granularity");
        ModuleDescriptor moduleDescriptor = moduleFragment2.getDescriptor();
        IrFactory irFactory = symbolTable.getIrFactory();
        MainModule mainModule2 = mainModule;
        if (mainModule2 instanceof MainModule.SourceFiles) {
            list2 = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf(moduleFragment2));
        } else if (mainModule2 instanceof MainModule.Klib) {
            list2 = dependencyModules;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List<IrModuleFragment> allModules2 = list2;
        JsIrBackendContext context = new JsIrBackendContext(moduleDescriptor, irBuiltIns, symbolTable, CollectionsKt.first(allModules2), exportedDeclarations, configuration2, false, es6mode, dceRuntimeDiagnostic, baseClassIntoMetadata, safeExternalBoolean, safeExternalBooleanDiagnostic, null, granularity, icCompatibleIr2Js ? IcCompatibleIr2Js.COMPATIBLE : IcCompatibleIr2Js.DISABLED, 4160, null);
        List<JsIrLinker> irProviders = CollectionsKt.listOf(irLinker);
        new ExternalDependenciesGenerator(symbolTable, irProviders).generateUnboundSymbolsAsDependencies();
        irLinker.postProcess();
        ChecksKt.checkNoUnboundSymbols(irLinker, symbolTable, "at the end of IR linkage process");
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment module2 = (IrModuleFragment)element$iv;
            boolean bl = false;
            CollectNativeImplementationsKt.collectNativeImplementations(context, module2);
            MoveBodilessDeclarationsToSeparatePlaceKt.moveBodilessDeclarationsToSeparatePlace(context, module2);
        }
        TestGeneratorKt.generateJsTests(context, CollectionsKt.last(allModules2));
        StageController stageController = irFactory.getStageController();
        WholeWorldStageController wholeWorldStageController = stageController instanceof WholeWorldStageController ? (WholeWorldStageController)stageController : null;
        if (wholeWorldStageController != null) {
            WholeWorldStageController it = wholeWorldStageController;
            boolean bl = false;
            CompilerWithICKt.lowerPreservingTags((Iterable<? extends IrModuleFragment>)allModules2, context, phaseConfig, it);
        } else {
            CompilerPhaseKt.invokeToplevel((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), phaseConfig, (CommonBackendContext)context, allModules2);
        }
        return new LoweredIr(context, moduleFragment2, allModules2, moduleToName);
    }

    @NotNull
    public static final String generateJsCode(@NotNull JsIrBackendContext context, @NotNull IrModuleFragment moduleFragment2, @NotNull NameTables nameTables) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(moduleFragment2, "moduleFragment");
        Intrinsics.checkNotNullParameter(nameTables, "nameTables");
        CollectNativeImplementationsKt.collectNativeImplementations(context, moduleFragment2);
        MoveBodilessDeclarationsToSeparatePlaceKt.moveBodilessDeclarationsToSeparatePlace(context, moduleFragment2);
        CompilerPhaseKt.invokeToplevel((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), new PhaseConfig(JsLoweringPhasesKt.getJsPhases(), null, null, null, null, null, null, null, null, null, null, false, false, false, 16382, null), (CommonBackendContext)context, CollectionsKt.listOf(moduleFragment2));
        IrModuleToJsTransformer transformer2 = new IrModuleToJsTransformer(context, null, true, nameTables, false, false, false, false, null, false, 1008, null);
        CompilationOutputs compilationOutputs = transformer2.generateModule((Iterable<? extends IrModuleFragment>)CollectionsKt.listOf(moduleFragment2)).getOutputs().get((Object)TranslationMode.FULL);
        Intrinsics.checkNotNull(compilationOutputs);
        return compilationOutputs.getJsCode();
    }

    public static final void writeSourceMapIfPresent(@NotNull CompilationOutputs $this$writeSourceMapIfPresent, @NotNull File outputJsFile) {
        block0: {
            Intrinsics.checkNotNullParameter($this$writeSourceMapIfPresent, "<this>");
            Intrinsics.checkNotNullParameter(outputJsFile, "outputJsFile");
            String string2 = $this$writeSourceMapIfPresent.getSourceMap();
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            File mapFile = FilesKt.resolveSibling(outputJsFile, outputJsFile.getName() + ".map");
            FilesKt.appendText$default(outputJsFile, "\n//# sourceMappingURL=" + mapFile.getName() + '\n', null, 2, null);
            FilesKt.writeText$default(mapFile, it, null, 2, null);
        }
    }
}

