/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.java.JavaVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java8ParameterNamesLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaValueParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReflectJavaMember
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaMember {
    @NotNull
    public abstract Member getMember();

    @Override
    @NotNull
    public AnnotatedElement getElement() {
        Member member = this.getMember();
        Intrinsics.checkNotNull((Object)member, (String)"null cannot be cast to non-null type java.lang.reflect.AnnotatedElement");
        return (AnnotatedElement)((Object)member);
    }

    @Override
    public int getModifiers() {
        return this.getMember().getModifiers();
    }

    @Override
    @NotNull
    public Name getName() {
        Name name;
        Name name2;
        String string = this.getMember().getName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            name2 = Name.identifier(it);
        } else {
            name2 = name = null;
        }
        if (name2 == null) {
            name = SpecialNames.NO_NAME_PROVIDED;
        }
        return name;
    }

    @Override
    @NotNull
    public ReflectJavaClass getContainingClass() {
        Class<?> clazz = this.getMember().getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"member.declaringClass");
        return new ReflectJavaClass(clazz);
    }

    @NotNull
    protected final List<JavaValueParameter> getValueParameters(@NotNull Type[] parameterTypes, @NotNull Annotation[][] parameterAnnotations, boolean isVararg) {
        List<String> names;
        Intrinsics.checkNotNullParameter((Object)parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)parameterAnnotations, (String)"parameterAnnotations");
        ArrayList<ReflectJavaValueParameter> result = new ArrayList<ReflectJavaValueParameter>(parameterTypes.length);
        List<String> list = names = Java8ParameterNamesLoader.INSTANCE.loadParameterNames(this.getMember());
        int shift = list != null ? list.size() - parameterTypes.length : 0;
        int n = parameterTypes.length;
        for (int i = 0; i < n; ++i) {
            String string;
            ReflectJavaType type2 = ReflectJavaType.Factory.create(parameterTypes[i]);
            if (names != null) {
                List<String> $this$getValueParameters_u24lambda_u241;
                boolean bl = false;
                string = (String)CollectionsKt.getOrNull($this$getValueParameters_u24lambda_u241, (int)(i + shift));
                if (string == null) {
                    throw new IllegalStateException(("No parameter with index " + i + '+' + shift + " (name=" + this.getName() + " type=" + type2 + ") in " + this).toString());
                }
            } else {
                string = null;
            }
            String name = string;
            boolean isParamVararg = isVararg && i == ArraysKt.getLastIndex((Object[])parameterTypes);
            result.add(new ReflectJavaValueParameter(type2, parameterAnnotations[i], name, isParamVararg));
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ReflectJavaMember && Intrinsics.areEqual((Object)this.getMember(), (Object)((ReflectJavaMember)other).getMember());
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.getMember();
    }

    @Override
    @NotNull
    public List<ReflectJavaAnnotation> getAnnotations() {
        Object object = this.getElement();
        if (object == null || (object = object.getDeclaredAnnotations()) == null || (object = ReflectJavaAnnotationOwnerKt.getAnnotations(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    @Nullable
    public ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Annotation[] annotationArray = this.getElement();
        return annotationArray != null && (annotationArray = annotationArray.getDeclaredAnnotations()) != null ? ReflectJavaAnnotationOwnerKt.findAnnotation(annotationArray, fqName2) : null;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        int modifiers = this.getModifiers();
        boolean bl = false;
        return Modifier.isPublic(modifiers) ? (Visibility)Visibilities.Public.INSTANCE : (Modifier.isPrivate(modifiers) ? (Visibility)Visibilities.Private.INSTANCE : (Modifier.isProtected(modifiers) ? (Modifier.isStatic(modifiers) ? (Visibility)JavaVisibilities.ProtectedStaticVisibility.INSTANCE : (Visibility)JavaVisibilities.ProtectedAndPackage.INSTANCE) : (Visibility)JavaVisibilities.PackageVisibility.INSTANCE));
    }
}

