import { EventEmitter } from "events";
import { ITransport } from "./ITransport";
import { IWidgetApiRequest, IWidgetApiRequestData, IWidgetApiResponse, IWidgetApiResponseData, WidgetApiAction, WidgetApiDirection } from "..";
/**
 * Transport for the Widget API over postMessage.
 */
export declare class PostmessageTransport extends EventEmitter implements ITransport {
    private sendDirection;
    private initialWidgetId;
    private transportWindow;
    private inboundWindow;
    strictOriginCheck: boolean;
    targetOrigin: string;
    timeoutSeconds: number;
    private _ready;
    private _widgetId;
    private outboundRequests;
    private stopController;
    get ready(): boolean;
    get widgetId(): string;
    constructor(sendDirection: WidgetApiDirection, initialWidgetId: string, transportWindow: Window, inboundWindow: Window);
    private get nextRequestId();
    private sendInternal;
    reply<T extends IWidgetApiResponseData>(request: IWidgetApiRequest, responseData: T): void;
    send<T extends IWidgetApiRequestData, R extends IWidgetApiResponseData>(action: WidgetApiAction, data: T): Promise<R>;
    sendComplete<T extends IWidgetApiRequestData, R extends IWidgetApiResponse>(action: WidgetApiAction, data: T): Promise<R>;
    start(): void;
    stop(): void;
    private handleMessage;
    private handleRequest;
    private handleResponse;
}
