-- This file is automatically generated using maintenance/generateSchemaSql.php.
-- Source: db_patches/tables.json
-- Do not modify this file directly.
-- See https://www.mediawiki.org/wiki/Manual:Schema_changes
CREATE TABLE abuse_filter (
  af_id BIGSERIAL NOT NULL,
  af_pattern TEXT NOT NULL,
  af_user BIGINT NOT NULL,
  af_user_text TEXT NOT NULL,
  af_timestamp TIMESTAMPTZ NOT NULL,
  af_enabled SMALLINT DEFAULT 1 NOT NULL,
  af_comments TEXT DEFAULT NULL,
  af_public_comments TEXT DEFAULT NULL,
  af_hidden SMALLINT DEFAULT 0 NOT NULL,
  af_hit_count BIGINT DEFAULT 0 NOT NULL,
  af_throttled SMALLINT DEFAULT 0 NOT NULL,
  af_deleted SMALLINT DEFAULT 0 NOT NULL,
  af_actions VARCHAR(255) DEFAULT '' NOT NULL,
  af_global SMALLINT DEFAULT 0 NOT NULL,
  af_group TEXT DEFAULT 'default' NOT NULL,
  PRIMARY KEY(af_id)
);

CREATE INDEX af_user ON abuse_filter (af_user);

CREATE INDEX af_group_enabled ON abuse_filter (af_group, af_enabled, af_id);


CREATE TABLE abuse_filter_action (
  afa_filter BIGINT NOT NULL,
  afa_consequence VARCHAR(255) NOT NULL,
  afa_parameters TEXT NOT NULL,
  PRIMARY KEY(afa_filter, afa_consequence)
);

CREATE INDEX afa_consequence ON abuse_filter_action (afa_consequence);


CREATE TABLE abuse_filter_log (
  afl_id BIGSERIAL NOT NULL,
  afl_global SMALLINT NOT NULL,
  afl_filter_id BIGINT NOT NULL,
  afl_user BIGINT NOT NULL,
  afl_user_text TEXT NOT NULL,
  afl_ip VARCHAR(255) NOT NULL,
  afl_action TEXT NOT NULL,
  afl_actions TEXT NOT NULL,
  afl_var_dump TEXT NOT NULL,
  afl_timestamp TIMESTAMPTZ NOT NULL,
  afl_namespace INT NOT NULL,
  afl_title TEXT NOT NULL,
  afl_wiki TEXT DEFAULT NULL,
  afl_deleted SMALLINT DEFAULT 0 NOT NULL,
  afl_patrolled_by INT DEFAULT 0 NOT NULL,
  afl_rev_id INT DEFAULT NULL,
  PRIMARY KEY(afl_id)
);

CREATE INDEX afl_filter_timestamp_full ON abuse_filter_log (
  afl_global, afl_filter_id, afl_timestamp
);

CREATE INDEX afl_user_timestamp ON abuse_filter_log (
  afl_user, afl_user_text, afl_timestamp
);

CREATE INDEX afl_timestamp ON abuse_filter_log (afl_timestamp);

CREATE INDEX afl_page_timestamp ON abuse_filter_log (
  afl_namespace, afl_title, afl_timestamp
);

CREATE INDEX afl_ip_timestamp ON abuse_filter_log (afl_ip, afl_timestamp);

CREATE INDEX afl_rev_id ON abuse_filter_log (afl_rev_id);

CREATE INDEX afl_wiki_timestamp ON abuse_filter_log (afl_wiki, afl_timestamp);


CREATE TABLE abuse_filter_history (
  afh_id BIGSERIAL NOT NULL,
  afh_filter BIGINT NOT NULL,
  afh_user BIGINT NOT NULL,
  afh_user_text TEXT NOT NULL,
  afh_timestamp TIMESTAMPTZ NOT NULL,
  afh_pattern TEXT NOT NULL,
  afh_comments TEXT NOT NULL,
  afh_flags TEXT NOT NULL,
  afh_public_comments TEXT DEFAULT NULL,
  afh_actions TEXT DEFAULT NULL,
  afh_deleted SMALLINT DEFAULT 0 NOT NULL,
  afh_changed_fields VARCHAR(255) DEFAULT '' NOT NULL,
  afh_group TEXT DEFAULT NULL,
  PRIMARY KEY(afh_id)
);

CREATE INDEX afh_filter ON abuse_filter_history (afh_filter);

CREATE INDEX afh_user ON abuse_filter_history (afh_user);

CREATE INDEX afh_user_text ON abuse_filter_history (afh_user_text);

CREATE INDEX afh_timestamp ON abuse_filter_history (afh_timestamp);
