"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageAuthorChanged = exports.newest = exports.minor = exports.latest = exports.greatest = exports.getPeerDependencies = exports.distTag = exports.defaultPrefix = exports.list = void 0;
const spawn_please_1 = __importDefault(require("spawn-please"));
const keyValueBy_1 = __importDefault(require("../lib/keyValueBy"));
const npm_1 = require("./npm");
/** Fetches the list of all installed packages. */
const list = async (options = {}) => {
    // use npm for local ls
    if (!options.global)
        return (0, npm_1.list)(options);
    const cmd = process.platform === 'win32' ? 'pnpm.cmd' : 'pnpm';
    const result = JSON.parse(await (0, spawn_please_1.default)(cmd, ['ls', '-g', '--json']));
    const list = (0, keyValueBy_1.default)(result[0].dependencies || {}, (name, { version }) => ({
        [name]: version,
    }));
    return list;
};
exports.list = list;
var npm_2 = require("./npm");
Object.defineProperty(exports, "defaultPrefix", { enumerable: true, get: function () { return npm_2.defaultPrefix; } });
Object.defineProperty(exports, "distTag", { enumerable: true, get: function () { return npm_2.distTag; } });
Object.defineProperty(exports, "getPeerDependencies", { enumerable: true, get: function () { return npm_2.getPeerDependencies; } });
Object.defineProperty(exports, "greatest", { enumerable: true, get: function () { return npm_2.greatest; } });
Object.defineProperty(exports, "latest", { enumerable: true, get: function () { return npm_2.latest; } });
Object.defineProperty(exports, "minor", { enumerable: true, get: function () { return npm_2.minor; } });
Object.defineProperty(exports, "newest", { enumerable: true, get: function () { return npm_2.newest; } });
Object.defineProperty(exports, "packageAuthorChanged", { enumerable: true, get: function () { return npm_2.packageAuthorChanged; } });
//# sourceMappingURL=pnpm.js.map