import abc
from collections.abc import ItemsView, KeysView, Mapping, Sequence, ValuesView
from typing import Any

from ..cresultproxy import BaseRow as BaseRow

MD_INDEX: int

def rowproxy_reconstructor(cls, state): ...

KEY_INTEGER_ONLY: int
KEY_OBJECTS_ONLY: int
KEY_OBJECTS_BUT_WARN: int
KEY_OBJECTS_NO_WARN: int

class Row(BaseRow, Sequence[Any], metaclass=abc.ABCMeta):
    @property
    def count(self): ...
    @property
    def index(self): ...
    def __contains__(self, key): ...
    __hash__ = BaseRow.__hash__
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __ge__(self, other): ...
    def __gt__(self, other): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def keys(self): ...

class LegacyRow(Row, metaclass=abc.ABCMeta):
    def __contains__(self, key): ...
    def has_key(self, key): ...
    def items(self): ...
    def iterkeys(self): ...
    def itervalues(self): ...
    def values(self): ...

BaseRowProxy = BaseRow
RowProxy = Row

class ROMappingView(KeysView[Any], ValuesView[Any], ItemsView[Any, Any]):
    def __init__(self, mapping, items) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self): ...
    def __contains__(self, item): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...

class RowMapping(BaseRow, Mapping[Any, Any]):
    __getitem__: Any
    def __iter__(self): ...
    def __len__(self) -> int: ...
    def __contains__(self, key): ...
    def items(self): ...
    def keys(self): ...
    def values(self): ...
