# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm and other development tools to provide
# more information, such as PEP 484 type hints, than it is able to glean from
# introspection of extension types and methods.  They are not intended to be
# imported, executed or used for any other purpose other than providing info
# to the tools. If you don't use use a tool that makes use of .pyi files then
# you can safely ignore this file.
#
# See: https://www.python.org/dev/peps/pep-0484/
#      https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
# Copyright: (c) 2020 by Total Control Software
# License:   wxWindows License
#---------------------------------------------------------------------------


"""
The ``wx.adv`` module contains classes which are more advanced and/or less
commonly used than those in the core namespace. They are provided in a
separate module to help reduce overhead and dependencies for those
applications which do not need any of these classes.
"""
#-- begin-_adv --#

import wx
#-- end-_adv --#
#-- begin-aboutdlg --#

class AboutDialogInfo(object):
    """
    AboutDialogInfo()
    
    wxAboutDialogInfo contains information shown in the standard About
    dialog displayed by the wxAboutBox() function.
    """

    def __init__(self):
        """
        AboutDialogInfo()
        
        wxAboutDialogInfo contains information shown in the standard About
        dialog displayed by the wxAboutBox() function.
        """

    def AddArtist(self, artist):
        """
        AddArtist(artist)
        
        Adds an artist name to be shown in the program credits.
        """

    def AddDeveloper(self, developer):
        """
        AddDeveloper(developer)
        
        Adds a developer name to be shown in the program credits.
        """

    def AddDocWriter(self, docwriter):
        """
        AddDocWriter(docwriter)
        
        Adds a documentation writer name to be shown in the program credits.
        """

    def AddTranslator(self, translator):
        """
        AddTranslator(translator)
        
        Adds a translator name to be shown in the program credits.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Get the name of the program.
        """

    def HasDescription(self):
        """
        HasDescription() -> bool
        
        Returns true if a description string has been specified.
        """

    def GetDescription(self):
        """
        GetDescription() -> String
        
        Get the description string.
        """

    def HasCopyright(self):
        """
        HasCopyright() -> bool
        
        Returns true if a copyright string has been specified.
        """

    def GetCopyright(self):
        """
        GetCopyright() -> String
        
        Get the copyright string.
        """

    def SetArtists(self, artists):
        """
        SetArtists(artists)
        
        Sets the list of artists to be shown in the program credits.
        """

    def SetCopyright(self, copyright):
        """
        SetCopyright(copyright)
        
        Set the short string containing the program copyright information.
        """

    def SetDescription(self, desc):
        """
        SetDescription(desc)
        
        Set brief, but possibly multiline, description of the program.
        """

    def SetDevelopers(self, developers):
        """
        SetDevelopers(developers)
        
        Set the list of developers of the program.
        """

    def SetDocWriters(self, docwriters):
        """
        SetDocWriters(docwriters)
        
        Set the list of documentation writers.
        """

    def HasIcon(self):
        """
        HasIcon() -> bool
        
        Returns true if an icon has been set for the about dialog.
        """

    def GetIcon(self):
        """
        GetIcon() -> wx.Icon
        
        Returns the icon set by SetIcon().
        """

    def SetIcon(self, icon):
        """
        SetIcon(icon)
        
        Set the icon to be shown in the dialog.
        """

    def HasLicence(self):
        """
        HasLicence() -> bool
        
        Returns true if the licence string has been set.
        """

    def GetLicence(self):
        """
        GetLicence() -> String
        
        Returns the licence string.
        """

    def SetLicence(self, licence):
        """
        SetLicence(licence)
        
        Set the long, multiline string containing the text of the program
        licence.
        """

    def SetLicense(self, licence):
        """
        SetLicense(licence)
        
        This is the same as SetLicence().
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Set the name of the program.
        """

    def SetTranslators(self, translators):
        """
        SetTranslators(translators)
        
        Set the list of translators.
        """

    def SetVersion(self, version, longVersion=""):
        """
        SetVersion(version, longVersion="")
        
        Set the version of the program.
        """

    def GetVersion(self):
        """
        GetVersion() -> String
        
        Return the short version string.
        """

    def GetLongVersion(self):
        """
        GetLongVersion() -> String
        
        Return the long version string if set.
        """

    def HasWebSite(self):
        """
        HasWebSite() -> bool
        
        Returns true if the website info has been set.
        """

    def GetWebSiteURL(self):
        """
        GetWebSiteURL() -> String
        
        Returns the website URL set for the dialog.
        """

    def GetWebSiteDescription(self):
        """
        GetWebSiteDescription() -> String
        
        Returns the description of the website URL set for the dialog.
        """

    def SetWebSite(self, url, desc=wx.EmptyString):
        """
        SetWebSite(url, desc=wx.EmptyString)
        
        Set the web site for the program and its description (which defaults
        to url itself if empty).
        """

    def HasDevelopers(self):
        """
        HasDevelopers() -> bool
        
        Returns true if developers have been set in the dialog info.
        """

    def GetDevelopers(self):
        """
        GetDevelopers() -> ArrayString
        
        Returns an array of the developer strings set in the dialog info.
        """

    def HasDocWriters(self):
        """
        HasDocWriters() -> bool
        
        Returns true if writers have been set in the dialog info.
        """

    def GetDocWriters(self):
        """
        GetDocWriters() -> ArrayString
        
        Returns an array of the writer strings set in the dialog info.
        """

    def HasArtists(self):
        """
        HasArtists() -> bool
        
        Returns true if artists have been set in the dialog info.
        """

    def GetArtists(self):
        """
        GetArtists() -> ArrayString
        
        Returns an array of the artist strings set in the dialog info.
        """

    def HasTranslators(self):
        """
        HasTranslators() -> bool
        
        Returns true if translators have been set in the dialog info.
        """

    def GetTranslators(self):
        """
        GetTranslators() -> ArrayString
        
        Returns an array of the translator strings set in the dialog info.
        """
    Artists = property(None, None)
    Copyright = property(None, None)
    Description = property(None, None)
    Developers = property(None, None)
    DocWriters = property(None, None)
    Icon = property(None, None)
    Licence = property(None, None)
    LongVersion = property(None, None)
    Name = property(None, None)
    Translators = property(None, None)
    Version = property(None, None)
    WebSiteDescription = property(None, None)
    WebSiteURL = property(None, None)

    HasLicense = HasLicence
    GetLicense = GetLicence
    License = Licence
# end of class AboutDialogInfo


def AboutBox(info, parent=None):
    """
    AboutBox(info, parent=None)
    
    This function shows the standard about dialog containing the
    information specified in info.
    """

def GenericAboutBox(info, parent=None):
    """
    GenericAboutBox(info, parent=None)
    
    This function does the same thing as wxAboutBox() except that it
    always uses the generic wxWidgets version of the dialog instead of the
    native one.
    """
#-- end-aboutdlg --#
#-- begin-helpext --#

class ExtHelpController(wx.HelpControllerBase):
    """
    ExtHelpController(parentWindow=None)
    
    This class implements help via an external browser.
    """

    def __init__(self, parentWindow=None):
        """
        ExtHelpController(parentWindow=None)
        
        This class implements help via an external browser.
        """

    def SetViewer(self, viewer=wx.EmptyString, flags=wx.HELP_NETSCAPE):
        """
        SetViewer(viewer=wx.EmptyString, flags=wx.HELP_NETSCAPE)
        
        Tell it which browser to use.
        """

    def Initialize(self, dir):
        """
        Initialize(dir) -> bool
        
        This must be called to tell the controller where to find the
        documentation.
        """

    def LoadFile(self, file=wx.EmptyString):
        """
        LoadFile(file=wx.EmptyString) -> bool
        
        If file is "", reloads file given in Initialize.
        """

    def DisplayContents(self):
        """
        DisplayContents() -> bool
        
        Display list of all help entries.
        """

    def DisplaySection(self, *args, **kw):
        """
        DisplaySection(sectionNo) -> bool
        DisplaySection(section) -> bool
        
        Display help for id sectionNo.
        """

    def DisplayBlock(self, blockNo):
        """
        DisplayBlock(blockNo) -> bool
        
        Display help for URL (using DisplayHelp) or keyword (using
        KeywordSearch)
        """

    def KeywordSearch(self, k, mode=wx.HELP_SEARCH_ALL):
        """
        KeywordSearch(k, mode=wx.HELP_SEARCH_ALL) -> bool
        
        Search comment/documentation fields in map file and present a list to
        chose from.
        """

    def Quit(self):
        """
        Quit() -> bool
        
        Does nothing.
        """

    def OnQuit(self):
        """
        OnQuit()
        
        Does nothing.
        """

    def DisplayHelp(self, relativeURL):
        """
        DisplayHelp(relativeURL) -> bool
        
        Call the browser using a relative URL.
        """

    def SetFrameParameters(self, titleFormat, size, pos=wx.DefaultPosition, newFrameEachTime=False):
        """
        SetFrameParameters(titleFormat, size, pos=wx.DefaultPosition, newFrameEachTime=False)
        
        Allows one to override the default settings for the help frame.
        """

    def GetFrameParameters(self, size=None, pos=None, newFrameEachTime=None):
        """
        GetFrameParameters(size=None, pos=None, newFrameEachTime=None) -> wx.Frame
        
        Obtains the latest settings used by the help frame and the help frame.
        """
    FrameParameters = property(None, None)
# end of class ExtHelpController

#-- end-helpext --#
#-- begin-commandlinkbutton --#

class CommandLinkButton(wx.Button):
    """
    CommandLinkButton()
    CommandLinkButton(parent, id=wx.ID_ANY, mainLabel=wx.EmptyString, note=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=wx.ButtonNameStr)
    
    Objects of this class are similar in appearance to the normal
    wxButtons but are similar to the links in a web page in functionality.
    """

    def __init__(self, *args, **kw):
        """
        CommandLinkButton()
        CommandLinkButton(parent, id=wx.ID_ANY, mainLabel=wx.EmptyString, note=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=wx.ButtonNameStr)
        
        Objects of this class are similar in appearance to the normal
        wxButtons but are similar to the links in a web page in functionality.
        """

    def Create(self, parent, id=wx.ID_ANY, mainLabel=wx.EmptyString, note=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=wx.ButtonNameStr):
        """
        Create(parent, id=wx.ID_ANY, mainLabel=wx.EmptyString, note=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=wx.ButtonNameStr) -> bool
        
        Button creation function for two-step creation.
        """

    def SetMainLabelAndNote(self, mainLabel, note):
        """
        SetMainLabelAndNote(mainLabel, note)
        
        Sets a new main label and note for the button.
        """

    def SetLabel(self, label):
        """
        SetLabel(label)
        
        Sets the string label and note for the button.
        """

    def GetLabel(self):
        """
        GetLabel() -> String
        
        Returns the string label for the button.
        """

    def SetMainLabel(self, mainLabel):
        """
        SetMainLabel(mainLabel)
        
        Changes the main label.
        """

    def SetNote(self, note):
        """
        SetNote(note)
        
        Changes the note.
        """

    def GetMainLabel(self):
        """
        GetMainLabel() -> String
        
        Returns the current main label.
        """

    def GetNote(self):
        """
        GetNote() -> String
        
        Returns the currently used note.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Label = property(None, None)
    MainLabel = property(None, None)
    Note = property(None, None)
# end of class CommandLinkButton

#-- end-commandlinkbutton --#
#-- begin-dateevt --#
wxEVT_DATE_CHANGED = 0
wxEVT_TIME_CHANGED = 0

class DateEvent(wx.CommandEvent):
    """
    DateEvent()
    DateEvent(win, dt, type)
    
    This event class holds information about a date change and is used
    together with wxDatePickerCtrl.
    """

    def __init__(self, *args, **kw):
        """
        DateEvent()
        DateEvent(win, dt, type)
        
        This event class holds information about a date change and is used
        together with wxDatePickerCtrl.
        """

    def GetDate(self):
        """
        GetDate() -> wx.DateTime
        
        Returns the date.
        """

    def SetDate(self, date):
        """
        SetDate(date)
        
        Sets the date carried by the event, normally only used by the library
        internally.
        """

    def PyGetDate(self):
        """
        Return the date as a Python datetime.date object.
        """

    PySetDate = wx.deprecated(SetDate, 'Use SetDate instead.')
    Date = property(None, None)
# end of class DateEvent


EVT_DATE_CHANGED = wx.PyEventBinder( wxEVT_DATE_CHANGED, 1 )
EVT_TIME_CHANGED = wx.PyEventBinder( wxEVT_TIME_CHANGED, 1 )
#-- end-dateevt --#
#-- begin-datectrl --#
DP_DEFAULT = 0
DP_SPIN = 0
DP_DROPDOWN = 0
DP_SHOWCENTURY = 0
DP_ALLOWNONE = 0

class DatePickerCtrl(wx.Control):
    """
    DatePickerCtrl()
    DatePickerCtrl(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DP_DEFAULT|DP_SHOWCENTURY, validator=wx.DefaultValidator, name="datectrl")
    
    This control allows the user to select a date.
    """

    def __init__(self, *args, **kw):
        """
        DatePickerCtrl()
        DatePickerCtrl(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DP_DEFAULT|DP_SHOWCENTURY, validator=wx.DefaultValidator, name="datectrl")
        
        This control allows the user to select a date.
        """

    def Create(self, parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DP_DEFAULT|DP_SHOWCENTURY, validator=wx.DefaultValidator, name="datectrl"):
        """
        Create(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DP_DEFAULT|DP_SHOWCENTURY, validator=wx.DefaultValidator, name="datectrl") -> bool
        
        Create the control window.
        """

    def GetRange(self):
        """
        GetRange() -> (bool, dt1, dt2)
        
        If the control had been previously limited to a range of dates using
        SetRange(), returns the lower and upper bounds of this range.
        """

    def GetValue(self):
        """
        GetValue() -> wx.DateTime
        
        Returns the currently entered date.
        """

    def SetNullText(self, text):
        """
        SetNullText(text)
        
        Set the text to show when there is no valid value.
        """

    def SetRange(self, dt1, dt2):
        """
        SetRange(dt1, dt2)
        
        Sets the valid range for the date selection.
        """

    def SetValue(self, dt):
        """
        SetValue(dt)
        
        Changes the current value of the control.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Value = property(None, None)
# end of class DatePickerCtrl


class DatePickerCtrlGeneric(wx.Control):
    """
    DatePickerCtrlGeneric()
    DatePickerCtrlGeneric(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DP_DEFAULT|DP_SHOWCENTURY, validator=wx.DefaultValidator, name="datectrl")
    
    This control allows the user to select a date.
    """

    def __init__(self, *args, **kw):
        """
        DatePickerCtrlGeneric()
        DatePickerCtrlGeneric(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DP_DEFAULT|DP_SHOWCENTURY, validator=wx.DefaultValidator, name="datectrl")
        
        This control allows the user to select a date.
        """

    def Create(self, parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DP_DEFAULT|DP_SHOWCENTURY, validator=wx.DefaultValidator, name="datectrl"):
        """
        Create(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=DP_DEFAULT|DP_SHOWCENTURY, validator=wx.DefaultValidator, name="datectrl") -> bool
        
        Create the control window.
        """

    def GetRange(self):
        """
        GetRange() -> (bool, dt1, dt2)
        
        If the control had been previously limited to a range of dates using
        SetRange(), returns the lower and upper bounds of this range.
        """

    def GetValue(self):
        """
        GetValue() -> wx.DateTime
        
        Returns the currently entered date.
        """

    def SetNullText(self, text):
        """
        SetNullText(text)
        
        Set the text to show when there is no valid value.
        """

    def SetRange(self, dt1, dt2):
        """
        SetRange(dt1, dt2)
        
        Sets the valid range for the date selection.
        """

    def SetValue(self, dt):
        """
        SetValue(dt)
        
        Changes the current value of the control.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Value = property(None, None)
# end of class DatePickerCtrlGeneric


GenericDatePickerCtrl = DatePickerCtrlGeneric
#-- end-datectrl --#
#-- begin-calctrl --#
CAL_SUNDAY_FIRST = 0
CAL_MONDAY_FIRST = 0
CAL_SHOW_HOLIDAYS = 0
CAL_NO_YEAR_CHANGE = 0
CAL_NO_MONTH_CHANGE = 0
CAL_SEQUENTIAL_MONTH_SELECTION = 0
CAL_SHOW_SURROUNDING_WEEKS = 0
CAL_SHOW_WEEK_NUMBERS = 0
CAL_BORDER_NONE = 0
CAL_BORDER_SQUARE = 0
CAL_BORDER_ROUND = 0
CAL_HITTEST_NOWHERE = 0
CAL_HITTEST_HEADER = 0
CAL_HITTEST_DAY = 0
CAL_HITTEST_INCMONTH = 0
CAL_HITTEST_DECMONTH = 0
CAL_HITTEST_SURROUNDING_WEEK = 0
CAL_HITTEST_WEEK = 0
wxEVT_CALENDAR_SEL_CHANGED = 0
wxEVT_CALENDAR_PAGE_CHANGED = 0
wxEVT_CALENDAR_DOUBLECLICKED = 0
wxEVT_CALENDAR_WEEKDAY_CLICKED = 0
wxEVT_CALENDAR_WEEK_CLICKED = 0
wxEVT_CALENDAR_YEAR_CHANGED = 0
wxEVT_CALENDAR_MONTH_CHANGED = 0
wxEVT_CALENDAR_DAY_CHANGED = 0

class CalendarEvent(DateEvent):
    """
    CalendarEvent()
    CalendarEvent(win, dt, type)
    
    The wxCalendarEvent class is used together with wxCalendarCtrl.
    """

    def __init__(self, *args, **kw):
        """
        CalendarEvent()
        CalendarEvent(win, dt, type)
        
        The wxCalendarEvent class is used together with wxCalendarCtrl.
        """

    def GetWeekDay(self):
        """
        GetWeekDay() -> DateTime.WeekDay
        
        Returns the week day on which the user clicked in
        EVT_CALENDAR_WEEKDAY_CLICKED handler.
        """

    def SetWeekDay(self, day):
        """
        SetWeekDay(day)
        
        Sets the week day carried by the event, normally only used by the
        library internally.
        """
    WeekDay = property(None, None)
# end of class CalendarEvent


class CalendarDateAttr(object):
    """
    CalendarDateAttr(colText=wx.NullColour, colBack=wx.NullColour, colBorder=wx.NullColour, font=wx.NullFont, border=CAL_BORDER_NONE)
    CalendarDateAttr(border, colBorder=wx.NullColour)
    
    wxCalendarDateAttr is a custom attributes for a calendar date.
    """

    def __init__(self, *args, **kw):
        """
        CalendarDateAttr(colText=wx.NullColour, colBack=wx.NullColour, colBorder=wx.NullColour, font=wx.NullFont, border=CAL_BORDER_NONE)
        CalendarDateAttr(border, colBorder=wx.NullColour)
        
        wxCalendarDateAttr is a custom attributes for a calendar date.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> wx.Colour
        
        Returns the background colour set for the calendar date.
        """

    def GetBorder(self):
        """
        GetBorder() -> CalendarDateBorder
        
        Returns the border set for the calendar date.
        """

    def GetBorderColour(self):
        """
        GetBorderColour() -> wx.Colour
        
        Returns the border colour set for the calendar date.
        """

    def GetFont(self):
        """
        GetFont() -> wx.Font
        
        Returns the font set for the calendar date.
        """

    def GetTextColour(self):
        """
        GetTextColour() -> wx.Colour
        
        Returns the text colour set for the calendar date.
        """

    def HasBackgroundColour(self):
        """
        HasBackgroundColour() -> bool
        
        Returns true if a non-default text background colour is set.
        """

    def HasBorder(self):
        """
        HasBorder() -> bool
        
        Returns true if a non-default (i.e. any) border is set.
        """

    def HasBorderColour(self):
        """
        HasBorderColour() -> bool
        
        Returns true if a non-default border colour is set.
        """

    def HasFont(self):
        """
        HasFont() -> bool
        
        Returns true if a non-default font is set.
        """

    def HasTextColour(self):
        """
        HasTextColour() -> bool
        
        Returns true if a non-default text foreground colour is set.
        """

    def IsHoliday(self):
        """
        IsHoliday() -> bool
        
        Returns true if this calendar day is displayed as a holiday.
        """

    def SetBackgroundColour(self, colBack):
        """
        SetBackgroundColour(colBack)
        
        Sets the text background colour to use.
        """

    def SetBorder(self, border):
        """
        SetBorder(border)
        
        Sets the border to use.
        """

    def SetBorderColour(self, col):
        """
        SetBorderColour(col)
        
        Sets the border colour to use.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets the font to use.
        """

    def SetHoliday(self, holiday):
        """
        SetHoliday(holiday)
        
        If holiday is true, this calendar day will be displayed as a holiday.
        """

    def SetTextColour(self, colText):
        """
        SetTextColour(colText)
        
        Sets the text (foreground) colour to use.
        """

    @staticmethod
    def GetMark():
        """
        GetMark() -> CalendarDateAttr
        
        Used (internally) by the generic wxCalendarCtrl::Mark().
        """

    @staticmethod
    def SetMark(m):
        """
        SetMark(m)
        
        Set the attributes that will be used to Mark() days on the generic
        wxCalendarCtrl.
        """
    BackgroundColour = property(None, None)
    Border = property(None, None)
    BorderColour = property(None, None)
    Font = property(None, None)
    TextColour = property(None, None)
# end of class CalendarDateAttr

CalendarNameStr = ""

class CalendarCtrl(wx.Control):
    """
    CalendarCtrl()
    CalendarCtrl(parent, id=wx.ID_ANY, date=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=CAL_SHOW_HOLIDAYS, name=CalendarNameStr)
    
    The calendar control allows the user to pick a date.
    """

    def __init__(self, *args, **kw):
        """
        CalendarCtrl()
        CalendarCtrl(parent, id=wx.ID_ANY, date=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=CAL_SHOW_HOLIDAYS, name=CalendarNameStr)
        
        The calendar control allows the user to pick a date.
        """

    def SetDateRange(self, lowerdate=wx.DefaultDateTime, upperdate=wx.DefaultDateTime):
        """
        SetDateRange(lowerdate=wx.DefaultDateTime, upperdate=wx.DefaultDateTime) -> bool
        
        Restrict the dates that can be selected in the control to the
        specified range.
        """

    def GetDateRange(self):
        """
        GetDateRange() -> (bool, lowerdate, upperdate)
        
        Returns the limits currently being used.
        """

    def Create(self, parent, id=wx.ID_ANY, date=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=CAL_SHOW_HOLIDAYS, name=CalendarNameStr):
        """
        Create(parent, id=wx.ID_ANY, date=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=CAL_SHOW_HOLIDAYS, name=CalendarNameStr) -> bool
        
        Creates the control.
        """

    def EnableHolidayDisplay(self, display=True):
        """
        EnableHolidayDisplay(display=True)
        
        This function should be used instead of changing wxCAL_SHOW_HOLIDAYS
        style bit directly.
        """

    def EnableMonthChange(self, enable=True):
        """
        EnableMonthChange(enable=True) -> bool
        
        This function should be used instead of changing wxCAL_NO_MONTH_CHANGE
        style bit.
        """

    def GetAttr(self, day):
        """
        GetAttr(day) -> CalendarDateAttr
        
        Returns the attribute for the given date (should be in the range
        1...31).
        """

    def GetDate(self):
        """
        GetDate() -> wx.DateTime
        
        Gets the currently selected date.
        """

    def GetHeaderColourBg(self):
        """
        GetHeaderColourBg() -> wx.Colour
        
        Gets the background colour of the header part of the calendar window.
        """

    def GetHeaderColourFg(self):
        """
        GetHeaderColourFg() -> wx.Colour
        
        Gets the foreground colour of the header part of the calendar window.
        """

    def GetHighlightColourBg(self):
        """
        GetHighlightColourBg() -> wx.Colour
        
        Gets the background highlight colour.
        """

    def GetHighlightColourFg(self):
        """
        GetHighlightColourFg() -> wx.Colour
        
        Gets the foreground highlight colour.
        """

    def GetHolidayColourBg(self):
        """
        GetHolidayColourBg() -> wx.Colour
        
        Return the background colour currently used for holiday highlighting.
        """

    def GetHolidayColourFg(self):
        """
        GetHolidayColourFg() -> wx.Colour
        
        Return the foreground colour currently used for holiday highlighting.
        """

    def HitTest(self, pos):
        """
        HitTest(pos) -> (CalendarHitTestResult, date, wd)
        
        Returns one of wxCalendarHitTestResult constants and fills either date
        or wd pointer with the corresponding value depending on the hit test
        code.
        """

    def ResetAttr(self, day):
        """
        ResetAttr(day)
        
        Clears any attributes associated with the given day (in the range
        1...31).
        """

    def SetAttr(self, day, attr):
        """
        SetAttr(day, attr)
        
        Associates the attribute with the specified date (in the range
        1...31).
        """

    def SetDate(self, date):
        """
        SetDate(date) -> bool
        
        Sets the current date.
        """

    def SetHeaderColours(self, colFg, colBg):
        """
        SetHeaderColours(colFg, colBg)
        
        Set the colours used for painting the weekdays at the top of the
        control.
        """

    def SetHighlightColours(self, colFg, colBg):
        """
        SetHighlightColours(colFg, colBg)
        
        Set the colours to be used for highlighting the currently selected
        date.
        """

    def SetHoliday(self, day):
        """
        SetHoliday(day)
        
        Marks the specified day as being a holiday in the current month.
        """

    def SetHolidayColours(self, colFg, colBg):
        """
        SetHolidayColours(colFg, colBg)
        
        Sets the colours to be used for the holidays highlighting.
        """

    def Mark(self, day, mark):
        """
        Mark(day, mark)
        
        Mark or unmark the day.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def PyGetDate(self):
        """
        Return the date as a Python datetime.date object.
        """

    PySetDate = wx.deprecated(SetDate, 'Use SetDate instead.')
    PySetDateRange = wx.deprecated(SetDateRange, 'Use SetDateRange instead.')
    Date = property(None, None)
    DateRange = property(None, None)
    HeaderColourBg = property(None, None)
    HeaderColourFg = property(None, None)
    HighlightColourBg = property(None, None)
    HighlightColourFg = property(None, None)
    HolidayColourBg = property(None, None)
    HolidayColourFg = property(None, None)
# end of class CalendarCtrl


class GenericCalendarCtrl(wx.Control):
    """
    GenericCalendarCtrl()
    GenericCalendarCtrl(parent, id=wx.ID_ANY, date=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=CAL_SHOW_HOLIDAYS, name=CalendarNameStr)
    
    The calendar control allows the user to pick a date.
    """

    def __init__(self, *args, **kw):
        """
        GenericCalendarCtrl()
        GenericCalendarCtrl(parent, id=wx.ID_ANY, date=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=CAL_SHOW_HOLIDAYS, name=CalendarNameStr)
        
        The calendar control allows the user to pick a date.
        """

    def SetDateRange(self, lowerdate=wx.DefaultDateTime, upperdate=wx.DefaultDateTime):
        """
        SetDateRange(lowerdate=wx.DefaultDateTime, upperdate=wx.DefaultDateTime) -> bool
        
        Restrict the dates that can be selected in the control to the
        specified range.
        """

    def GetDateRange(self):
        """
        GetDateRange() -> (bool, lowerdate, upperdate)
        
        Returns the limits currently being used.
        """

    def Create(self, parent, id=wx.ID_ANY, date=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=CAL_SHOW_HOLIDAYS, name=CalendarNameStr):
        """
        Create(parent, id=wx.ID_ANY, date=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=CAL_SHOW_HOLIDAYS, name=CalendarNameStr) -> bool
        
        Creates the control.
        """

    def EnableHolidayDisplay(self, display=True):
        """
        EnableHolidayDisplay(display=True)
        
        This function should be used instead of changing wxCAL_SHOW_HOLIDAYS
        style bit directly.
        """

    def EnableMonthChange(self, enable=True):
        """
        EnableMonthChange(enable=True) -> bool
        
        This function should be used instead of changing wxCAL_NO_MONTH_CHANGE
        style bit.
        """

    def EnableYearChange(self, enable=True):
        """
        EnableYearChange(enable=True)
        """

    def GetAttr(self, day):
        """
        GetAttr(day) -> CalendarDateAttr
        
        Returns the attribute for the given date (should be in the range
        1...31).
        """

    def GetDate(self):
        """
        GetDate() -> wx.DateTime
        
        Gets the currently selected date.
        """

    def GetHeaderColourBg(self):
        """
        GetHeaderColourBg() -> wx.Colour
        
        Gets the background colour of the header part of the calendar window.
        """

    def GetHeaderColourFg(self):
        """
        GetHeaderColourFg() -> wx.Colour
        
        Gets the foreground colour of the header part of the calendar window.
        """

    def GetHighlightColourBg(self):
        """
        GetHighlightColourBg() -> wx.Colour
        
        Gets the background highlight colour.
        """

    def GetHighlightColourFg(self):
        """
        GetHighlightColourFg() -> wx.Colour
        
        Gets the foreground highlight colour.
        """

    def GetHolidayColourBg(self):
        """
        GetHolidayColourBg() -> wx.Colour
        
        Return the background colour currently used for holiday highlighting.
        """

    def GetHolidayColourFg(self):
        """
        GetHolidayColourFg() -> wx.Colour
        
        Return the foreground colour currently used for holiday highlighting.
        """

    def HitTest(self, pos):
        """
        HitTest(pos) -> (CalendarHitTestResult, date, wd)
        
        Returns one of wxCalendarHitTestResult constants and fills either date
        or wd pointer with the corresponding value depending on the hit test
        code.
        """

    def ResetAttr(self, day):
        """
        ResetAttr(day)
        
        Clears any attributes associated with the given day (in the range
        1...31).
        """

    def SetAttr(self, day, attr):
        """
        SetAttr(day, attr)
        
        Associates the attribute with the specified date (in the range
        1...31).
        """

    def SetDate(self, date):
        """
        SetDate(date) -> bool
        
        Sets the current date.
        """

    def SetHeaderColours(self, colFg, colBg):
        """
        SetHeaderColours(colFg, colBg)
        
        Set the colours used for painting the weekdays at the top of the
        control.
        """

    def SetHighlightColours(self, colFg, colBg):
        """
        SetHighlightColours(colFg, colBg)
        
        Set the colours to be used for highlighting the currently selected
        date.
        """

    def SetHoliday(self, day):
        """
        SetHoliday(day)
        
        Marks the specified day as being a holiday in the current month.
        """

    def SetHolidayColours(self, colFg, colBg):
        """
        SetHolidayColours(colFg, colBg)
        
        Sets the colours to be used for the holidays highlighting.
        """

    def Mark(self, day, mark):
        """
        Mark(day, mark)
        
        Mark or unmark the day.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def PyGetDate(self):
        """
        Return the date as a Python datetime.date object.
        """

    PySetDate = wx.deprecated(SetDate, 'Use SetDate instead.')
    PySetDateRange = wx.deprecated(SetDateRange, 'Use SetDateRange instead.')
    Date = property(None, None)
    DateRange = property(None, None)
    HeaderColourBg = property(None, None)
    HeaderColourFg = property(None, None)
    HighlightColourBg = property(None, None)
    HighlightColourFg = property(None, None)
    HolidayColourBg = property(None, None)
    HolidayColourFg = property(None, None)
# end of class GenericCalendarCtrl


EVT_CALENDAR =                 wx.PyEventBinder( wxEVT_CALENDAR_DOUBLECLICKED, 1)
EVT_CALENDAR_SEL_CHANGED =     wx.PyEventBinder( wxEVT_CALENDAR_SEL_CHANGED, 1)
EVT_CALENDAR_WEEKDAY_CLICKED = wx.PyEventBinder( wxEVT_CALENDAR_WEEKDAY_CLICKED, 1)
EVT_CALENDAR_PAGE_CHANGED =    wx.PyEventBinder( wxEVT_CALENDAR_PAGE_CHANGED, 1)
EVT_CALENDAR_WEEK_CLICKED =    wx.PyEventBinder( wxEVT_CALENDAR_WEEK_CLICKED, 1)

# These are deprecated, will be removed later...
EVT_CALENDAR_DAY =             wx.PyEventBinder( wxEVT_CALENDAR_DAY_CHANGED, 1)
EVT_CALENDAR_MONTH =           wx.PyEventBinder( wxEVT_CALENDAR_MONTH_CHANGED, 1)
EVT_CALENDAR_YEAR =            wx.PyEventBinder( wxEVT_CALENDAR_YEAR_CHANGED, 1)
#-- end-calctrl --#
#-- begin-hyperlink --#
HL_CONTEXTMENU = 0
HL_ALIGN_LEFT = 0
HL_ALIGN_RIGHT = 0
HL_ALIGN_CENTRE = 0
HL_DEFAULT_STYLE = 0
wxEVT_HYPERLINK = 0

class HyperlinkEvent(wx.CommandEvent):
    """
    HyperlinkEvent(generator, id, url)
    
    This event class is used for the events generated by wxHyperlinkCtrl.
    """

    def __init__(self, generator, id, url):
        """
        HyperlinkEvent(generator, id, url)
        
        This event class is used for the events generated by wxHyperlinkCtrl.
        """

    def GetURL(self):
        """
        GetURL() -> String
        
        Returns the URL of the hyperlink where the user has just clicked.
        """

    def SetURL(self, url):
        """
        SetURL(url)
        
        Sets the URL associated with the event.
        """
    URL = property(None, None)
# end of class HyperlinkEvent

HyperlinkCtrlNameStr = ""

class HyperlinkCtrl(wx.Control):
    """
    HyperlinkCtrl()
    HyperlinkCtrl(parent, id=wx.ID_ANY, label=wx.EmptyString, url=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=HL_DEFAULT_STYLE, name=HyperlinkCtrlNameStr)
    
    This class shows a static text element which links to an URL.
    """

    def __init__(self, *args, **kw):
        """
        HyperlinkCtrl()
        HyperlinkCtrl(parent, id=wx.ID_ANY, label=wx.EmptyString, url=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=HL_DEFAULT_STYLE, name=HyperlinkCtrlNameStr)
        
        This class shows a static text element which links to an URL.
        """

    def Create(self, parent, id=wx.ID_ANY, label=wx.EmptyString, url=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=HL_DEFAULT_STYLE, name=HyperlinkCtrlNameStr):
        """
        Create(parent, id=wx.ID_ANY, label=wx.EmptyString, url=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=HL_DEFAULT_STYLE, name=HyperlinkCtrlNameStr) -> bool
        
        Creates the hyperlink control.
        """

    def GetHoverColour(self):
        """
        GetHoverColour() -> wx.Colour
        
        Returns the colour used to print the label of the hyperlink when the
        mouse is over the control.
        """

    def GetNormalColour(self):
        """
        GetNormalColour() -> wx.Colour
        
        Returns the colour used to print the label when the link has never
        been clicked before (i.e. the link has not been visited) and the mouse
        is not over the control.
        """

    def GetURL(self):
        """
        GetURL() -> String
        
        Returns the URL associated with the hyperlink.
        """

    def GetVisited(self):
        """
        GetVisited() -> bool
        
        Returns true if the hyperlink has already been clicked by the user at
        least one time.
        """

    def GetVisitedColour(self):
        """
        GetVisitedColour() -> wx.Colour
        
        Returns the colour used to print the label when the mouse is not over
        the control and the link has already been clicked before (i.e. the
        link has been visited).
        """

    def SetHoverColour(self, colour):
        """
        SetHoverColour(colour)
        
        Sets the colour used to print the label of the hyperlink when the
        mouse is over the control.
        """

    def SetNormalColour(self, colour):
        """
        SetNormalColour(colour)
        
        Sets the colour used to print the label when the link has never been
        clicked before (i.e. the link has not been visited) and the mouse is
        not over the control.
        """

    def SetURL(self, url):
        """
        SetURL(url)
        
        Sets the URL associated with the hyperlink.
        """

    def SetVisited(self, visited=True):
        """
        SetVisited(visited=True)
        
        Marks the hyperlink as visited (see
        wxHyperlinkCtrl::SetVisitedColour).
        """

    def SetVisitedColour(self, colour):
        """
        SetVisitedColour(colour)
        
        Sets the colour used to print the label when the mouse is not over the
        control and the link has already been clicked before (i.e. the link
        has been visited).
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    HoverColour = property(None, None)
    NormalColour = property(None, None)
    URL = property(None, None)
    Visited = property(None, None)
    VisitedColour = property(None, None)
# end of class HyperlinkCtrl


EVT_HYPERLINK = wx.PyEventBinder( wxEVT_HYPERLINK, 1 )

# deprecated wxEVT alias
wxEVT_COMMAND_HYPERLINK  = wxEVT_HYPERLINK
#-- end-hyperlink --#
#-- begin-tipdlg --#

class TipProvider(object):
    """
    TipProvider(currentTip)
    
    This is the class used together with wxShowTip() function.
    """

    def __init__(self, currentTip):
        """
        TipProvider(currentTip)
        
        This is the class used together with wxShowTip() function.
        """

    def GetCurrentTip(self):
        """
        GetCurrentTip() -> size_t
        
        Returns the index of the current tip (i.e. the one which would be
        returned by GetTip()).
        """

    def GetTip(self):
        """
        GetTip() -> String
        
        Return the text of the current tip and pass to the next one.
        """
    CurrentTip = property(None, None)
    Tip = property(None, None)
# end of class TipProvider


def CreateFileTipProvider(filename, currentTip):
    """
    CreateFileTipProvider(filename, currentTip) -> TipProvider
    
    This function creates a wxTipProvider which may be used with
    wxShowTip().
    """

def ShowTip(parent, tipProvider, showAtStartup=True):
    """
    ShowTip(parent, tipProvider, showAtStartup=True) -> bool
    
    This function shows a "startup tip" to the user.
    """
#-- end-tipdlg --#
#-- begin-taskbar --#
TBI_DOCK = 0
TBI_CUSTOM_STATUSITEM = 0
TBI_DEFAULT_TYPE = 0
wxEVT_TASKBAR_MOVE = 0
wxEVT_TASKBAR_LEFT_DOWN = 0
wxEVT_TASKBAR_LEFT_UP = 0
wxEVT_TASKBAR_RIGHT_DOWN = 0
wxEVT_TASKBAR_RIGHT_UP = 0
wxEVT_TASKBAR_LEFT_DCLICK = 0
wxEVT_TASKBAR_RIGHT_DCLICK = 0
wxEVT_TASKBAR_CLICK = 0
wxEVT_TASKBAR_BALLOON_TIMEOUT = 0
wxEVT_TASKBAR_BALLOON_CLICK = 0

class TaskBarIconEvent(wx.Event):
    """
    TaskBarIconEvent(evtType, tbIcon)
    
    The event class used by wxTaskBarIcon.
    """

    def __init__(self, evtType, tbIcon):
        """
        TaskBarIconEvent(evtType, tbIcon)
        
        The event class used by wxTaskBarIcon.
        """
# end of class TaskBarIconEvent


class TaskBarIcon(wx.EvtHandler):
    """
    TaskBarIcon(iconType=TBI_DEFAULT_TYPE)
    
    This class represents a taskbar icon.
    """

    def __init__(self, iconType=TBI_DEFAULT_TYPE):
        """
        TaskBarIcon(iconType=TBI_DEFAULT_TYPE)
        
        This class represents a taskbar icon.
        """

    def Destroy(self):
        """
        Destroy()
        
        This method is similar to wxWindow::Destroy and can be used to
        schedule the task bar icon object for the delayed destruction: it will
        be deleted during the next event loop iteration, which allows the task
        bar icon to process any pending events for it before being destroyed.
        """

    def IsIconInstalled(self):
        """
        IsIconInstalled() -> bool
        
        Returns true if SetIcon() was called with no subsequent RemoveIcon().
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the object initialized successfully.
        """

    def PopupMenu(self, menu):
        """
        PopupMenu(menu) -> bool
        
        Pops up a menu at the current mouse position.
        """

    def RemoveIcon(self):
        """
        RemoveIcon() -> bool
        
        Removes the icon previously set with SetIcon().
        """

    def SetIcon(self, icon, tooltip=wx.EmptyString):
        """
        SetIcon(icon, tooltip=wx.EmptyString) -> bool
        
        Sets the icon, and optional tooltip text.
        """

    @staticmethod
    def IsAvailable():
        """
        IsAvailable() -> bool
        
        Returns true if system tray is available in the desktop environment
        the app runs under.
        """

    def ShowBalloon(self, title, text, msec=0, flags=0):
        """
        ShowBalloon(title, text, msec=0, flags=0) -> bool
        
        Show a balloon notification (the icon must have been already
        initialized using SetIcon).  Only implemented for Windows.
        
        The ``title`` and ``text`` parameters are limited to 63 and 255
        characters respectively, ``msec`` is the timeout, in milliseconds,
        before the balloon disappears (will be clamped down to the allowed
        10-30s range by Windows if it's outside it) and ``flags`` can
        include wxICON_ERROR/INFO/WARNING to show a corresponding icon.
        
        Returns ``True`` if balloon was shown, ``False`` on error (incorrect
        parameters or function unsupported by OS).
        """

    def CreatePopupMenu(self):
        """
        CreatePopupMenu() -> wx.Menu
        
        Called by the library when the user requests popup menu if
        GetPopupMenu() is not overridden.
        """

    def GetPopupMenu(self):
        """
        GetPopupMenu() -> wx.Menu
        
        Called by the library when the user requests popup menu.
        """
# end of class TaskBarIcon


EVT_TASKBAR_MOVE = wx.PyEventBinder (         wxEVT_TASKBAR_MOVE )
EVT_TASKBAR_LEFT_DOWN = wx.PyEventBinder (    wxEVT_TASKBAR_LEFT_DOWN )
EVT_TASKBAR_LEFT_UP = wx.PyEventBinder (      wxEVT_TASKBAR_LEFT_UP )
EVT_TASKBAR_RIGHT_DOWN = wx.PyEventBinder (   wxEVT_TASKBAR_RIGHT_DOWN )
EVT_TASKBAR_RIGHT_UP = wx.PyEventBinder (     wxEVT_TASKBAR_RIGHT_UP )
EVT_TASKBAR_LEFT_DCLICK = wx.PyEventBinder (  wxEVT_TASKBAR_LEFT_DCLICK )
EVT_TASKBAR_RIGHT_DCLICK = wx.PyEventBinder ( wxEVT_TASKBAR_RIGHT_DCLICK )
EVT_TASKBAR_CLICK =  wx.PyEventBinder (       wxEVT_TASKBAR_CLICK )
EVT_TASKBAR_BALLOON_TIMEOUT = wx.PyEventBinder ( wxEVT_TASKBAR_BALLOON_TIMEOUT )
EVT_TASKBAR_BALLOON_CLICK = wx.PyEventBinder ( wxEVT_TASKBAR_BALLOON_CLICK )
#-- end-taskbar --#
#-- begin-sound --#
SOUND_SYNC = 0
SOUND_ASYNC = 0
SOUND_LOOP = 0

class Sound(wx.Object):
    """
    Sound()
    Sound(fileName)
    
    This class represents a short sound (loaded from Windows WAV file),
    that can be stored in memory and played.
    """

    def __init__(self, *args, **kw):
        """
        Sound()
        Sound(fileName)
        
        This class represents a short sound (loaded from Windows WAV file),
        that can be stored in memory and played.
        """

    def Create(self, fileName):
        """
        Create(fileName) -> bool
        
        Constructs a wave object from a file or resource.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the object contains a successfully loaded file or
        resource, false otherwise.
        """

    def Play(self, flags=SOUND_ASYNC):
        """
        Play(flags=SOUND_ASYNC) -> bool
        
        Plays the sound file.
        """

    @staticmethod
    def PlaySound(filename, flags=SOUND_ASYNC):
        """
        PlaySound(filename, flags=SOUND_ASYNC) -> bool
        """

    @staticmethod
    def Stop():
        """
        Stop()
        
        If a sound is played, this function stops it.
        """

    def CreateFromData(self, data):
        """
        CreateFromData(data) -> bool
        
        Create a sound object from data in a memory buffer in WAV format.
        """

    def __nonzero__(self):
        """
        __nonzero__() -> int
        """

    def __bool__(self):
        """
        __bool__() -> int
        """
# end of class Sound

#-- end-sound --#
#-- begin-joystick --#

class Joystick(wx.Object):
    """
    Joystick(joystick=wx.JOYSTICK1)
    
    wxJoystick allows an application to control one or more joysticks.
    """

    def __init__(self, joystick=wx.JOYSTICK1):
        """
        Joystick(joystick=wx.JOYSTICK1)
        
        wxJoystick allows an application to control one or more joysticks.
        """

    def GetButtonState(self, *args, **kw):
        """
        GetButtonState() -> int
        GetButtonState(id) -> bool
        
        Returns the state of the joystick buttons.
        """

    def GetManufacturerId(self):
        """
        GetManufacturerId() -> int
        
        Returns the manufacturer id.
        """

    def GetMovementThreshold(self):
        """
        GetMovementThreshold() -> int
        
        Returns the movement threshold, the number of steps outside which the
        joystick is deemed to have moved.
        """

    def GetNumberAxes(self):
        """
        GetNumberAxes() -> int
        
        Returns the number of axes for this joystick.
        """

    def GetNumberButtons(self):
        """
        GetNumberButtons() -> int
        
        Returns the number of buttons for this joystick.
        """

    def GetPOVCTSPosition(self):
        """
        GetPOVCTSPosition() -> int
        
        Returns the point-of-view position, expressed in continuous, one-
        hundredth of a degree units.
        """

    def GetPOVPosition(self):
        """
        GetPOVPosition() -> int
        
        Returns the point-of-view position, expressed in continuous, one-
        hundredth of a degree units, but limited to return 0, 9000, 18000 or
        27000.
        """

    def GetPollingMax(self):
        """
        GetPollingMax() -> int
        
        Returns the maximum polling frequency.
        """

    def GetPollingMin(self):
        """
        GetPollingMin() -> int
        
        Returns the minimum polling frequency.
        """

    def GetPosition(self, *args, **kw):
        """
        GetPosition() -> wx.Point
        GetPosition(axis) -> int
        
        Returns the x, y position of the joystick.
        """

    def GetProductId(self):
        """
        GetProductId() -> int
        
        Returns the product id for the joystick.
        """

    def GetProductName(self):
        """
        GetProductName() -> String
        
        Returns the product name for the joystick.
        """

    def GetRudderMax(self):
        """
        GetRudderMax() -> int
        
        Returns the maximum rudder position.
        """

    def GetRudderMin(self):
        """
        GetRudderMin() -> int
        
        Returns the minimum rudder position.
        """

    def GetRudderPosition(self):
        """
        GetRudderPosition() -> int
        
        Returns the rudder position.
        """

    def GetUMax(self):
        """
        GetUMax() -> int
        
        Returns the maximum U position.
        """

    def GetUMin(self):
        """
        GetUMin() -> int
        
        Returns the minimum U position.
        """

    def GetUPosition(self):
        """
        GetUPosition() -> int
        
        Gets the position of the fifth axis of the joystick, if it exists.
        """

    def GetVMax(self):
        """
        GetVMax() -> int
        
        Returns the maximum V position.
        """

    def GetVMin(self):
        """
        GetVMin() -> int
        
        Returns the minimum V position.
        """

    def GetVPosition(self):
        """
        GetVPosition() -> int
        
        Gets the position of the sixth axis of the joystick, if it exists.
        """

    def GetXMax(self):
        """
        GetXMax() -> int
        
        Returns the maximum x position.
        """

    def GetXMin(self):
        """
        GetXMin() -> int
        
        Returns the minimum x position.
        """

    def GetYMax(self):
        """
        GetYMax() -> int
        
        Returns the maximum y position.
        """

    def GetYMin(self):
        """
        GetYMin() -> int
        
        Returns the minimum y position.
        """

    def GetZMax(self):
        """
        GetZMax() -> int
        
        Returns the maximum z position.
        """

    def GetZMin(self):
        """
        GetZMin() -> int
        
        Returns the minimum z position.
        """

    def GetZPosition(self):
        """
        GetZPosition() -> int
        
        Returns the z position of the joystick.
        """

    def HasPOV(self):
        """
        HasPOV() -> bool
        
        Returns true if the joystick has a point of view control.
        """

    def HasPOV4Dir(self):
        """
        HasPOV4Dir() -> bool
        
        Returns true if the joystick point-of-view supports discrete values
        (centered, forward, backward, left, and right).
        """

    def HasPOVCTS(self):
        """
        HasPOVCTS() -> bool
        
        Returns true if the joystick point-of-view supports continuous degree
        bearings.
        """

    def HasRudder(self):
        """
        HasRudder() -> bool
        
        Returns true if there is a rudder attached to the computer.
        """

    def HasU(self):
        """
        HasU() -> bool
        
        Returns true if the joystick has a U axis.
        """

    def HasV(self):
        """
        HasV() -> bool
        
        Returns true if the joystick has a V axis.
        """

    def HasZ(self):
        """
        HasZ() -> bool
        
        Returns true if the joystick has a Z axis.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if the joystick is functioning.
        """

    def ReleaseCapture(self):
        """
        ReleaseCapture() -> bool
        
        Releases the capture set by SetCapture.
        """

    def SetCapture(self, win, pollingFreq=0):
        """
        SetCapture(win, pollingFreq=0) -> bool
        
        Sets the capture to direct joystick events to win.
        """

    def SetMovementThreshold(self, threshold):
        """
        SetMovementThreshold(threshold)
        
        Sets the movement threshold, the number of steps outside which the
        joystick is deemed to have moved.
        """

    @staticmethod
    def GetNumberJoysticks():
        """
        GetNumberJoysticks() -> int
        
        Returns the number of joysticks currently attached to the computer.
        """

    def GetMaxButtons(self):
        """
        GetMaxButtons() -> int
        """

    def GetMaxAxes(self):
        """
        GetMaxAxes() -> int
        """
    ButtonState = property(None, None)
    ManufacturerId = property(None, None)
    MaxAxes = property(None, None)
    MaxButtons = property(None, None)
    MovementThreshold = property(None, None)
    NumberAxes = property(None, None)
    NumberButtons = property(None, None)
    POVCTSPosition = property(None, None)
    POVPosition = property(None, None)
    PollingMax = property(None, None)
    PollingMin = property(None, None)
    Position = property(None, None)
    ProductId = property(None, None)
    ProductName = property(None, None)
    RudderMax = property(None, None)
    RudderMin = property(None, None)
    RudderPosition = property(None, None)
    UMax = property(None, None)
    UMin = property(None, None)
    UPosition = property(None, None)
    VMax = property(None, None)
    VMin = property(None, None)
    VPosition = property(None, None)
    XMax = property(None, None)
    XMin = property(None, None)
    YMax = property(None, None)
    YMin = property(None, None)
    ZMax = property(None, None)
    ZMin = property(None, None)
    ZPosition = property(None, None)
# end of class Joystick

USE_JOYSTICK = 0
#-- end-joystick --#
#-- begin-animate --#
AC_NO_AUTORESIZE = 0
AC_DEFAULT_STYLE = 0
ANIMATION_TYPE_INVALID = 0
ANIMATION_TYPE_GIF = 0
ANIMATION_TYPE_ANI = 0
ANIMATION_TYPE_ANY = 0
ANIM_UNSPECIFIED = 0
ANIM_DONOTREMOVE = 0
ANIM_TOBACKGROUND = 0
ANIM_TOPREVIOUS = 0

class Animation(wx.Object):
    """
    Animation()
    Animation(name, type=ANIMATION_TYPE_ANY)
    Animation(other)
    
    The wxAnimation class handles the interface between the animation
    control and the details of the animation image or data.
    """

    def __init__(self, *args, **kw):
        """
        Animation()
        Animation(name, type=ANIMATION_TYPE_ANY)
        Animation(other)
        
        The wxAnimation class handles the interface between the animation
        control and the details of the animation image or data.
        """

    def IsOk(self):
        """
        IsOk() -> bool
        
        Returns true if animation data is present.
        """

    def IsCompatibleWith(self, ci):
        """
        IsCompatibleWith(ci) -> bool
        
        Returns true if animation can be used with controls of the given type.
        """

    def GetDelay(self, frame):
        """
        GetDelay(frame) -> int
        
        Returns the delay for the i-th frame in milliseconds.
        """

    def GetFrameCount(self):
        """
        GetFrameCount() -> unsignedint
        
        Returns the number of frames for this animation.
        """

    def GetFrame(self, frame):
        """
        GetFrame(frame) -> wx.Image
        
        Returns the i-th frame as a wxImage.
        """

    def GetSize(self):
        """
        GetSize() -> wx.Size
        
        Returns the size of the animation.
        """

    def LoadFile(self, name, type=ANIMATION_TYPE_ANY):
        """
        LoadFile(name, type=ANIMATION_TYPE_ANY) -> bool
        
        Loads an animation from a file.
        """

    def Load(self, stream, type=ANIMATION_TYPE_ANY):
        """
        Load(stream, type=ANIMATION_TYPE_ANY) -> bool
        
        Loads an animation from the given stream.
        """

    @staticmethod
    def GetHandlers():
        """
        GetHandlers() -> AnimationDecoderList
        
        Returns the list of animation decoders used by the generic animation
        and wxGenericAnimationCtrl.
        """

    @staticmethod
    def AddHandler(handler):
        """
        AddHandler(handler)
        
        Add a new decoder to the list of animation decoders.
        """

    @staticmethod
    def InsertHandler(handler):
        """
        InsertHandler(handler)
        
        Insert a new decoder to the front of the list of animation decoders.
        """

    @staticmethod
    def FindHandler(animType):
        """
        FindHandler(animType) -> AnimationDecoder
        
        Search for an animation decoder by type.
        """

    @staticmethod
    def InitStandardHandlers():
        """
        InitStandardHandlers()
        
        Load the stock animation decoders (currently GIF and ANI) into the
        list of decoders.
        """

    @staticmethod
    def CleanUpHandlers():
        """
        CleanUpHandlers()
        
        Clear out the animation decoder list.
        """
    FrameCount = property(None, None)
    Size = property(None, None)
# end of class Animation


class AnimationCtrl(wx.Control):
    """
    AnimationCtrl(parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr)
    
    This is a static control which displays an animation.
    """

    def __init__(self, parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr):
        """
        AnimationCtrl(parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr)
        
        This is a static control which displays an animation.
        """

    def Create(self, parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr):
        """
        Create(parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr) -> bool
        
        Creates the control with the given anim animation.
        """

    def CreateAnimation(self):
        """
        CreateAnimation() -> Animation
        
        Create a new animation object compatible with this control.
        """

    def GetAnimation(self):
        """
        GetAnimation() -> Animation
        
        Returns the animation associated with this control.
        """

    def GetInactiveBitmap(self):
        """
        GetInactiveBitmap() -> wx.Bitmap
        
        Returns the inactive bitmap shown in this control when the; see
        SetInactiveBitmap() for more info.
        """

    def IsPlaying(self):
        """
        IsPlaying() -> bool
        
        Returns true if the animation is being played.
        """

    def LoadFile(self, file, animType=ANIMATION_TYPE_ANY):
        """
        LoadFile(file, animType=ANIMATION_TYPE_ANY) -> bool
        
        Loads the animation from the given file and calls SetAnimation().
        """

    def Load(self, file, animType=ANIMATION_TYPE_ANY):
        """
        Load(file, animType=ANIMATION_TYPE_ANY) -> bool
        
        Loads the animation from the given stream and calls SetAnimation().
        """

    def Play(self):
        """
        Play() -> bool
        
        Starts playing the animation.
        """

    def SetAnimation(self, anim):
        """
        SetAnimation(anim)
        
        Sets the animation to play in this control.
        """

    def SetInactiveBitmap(self, bmp):
        """
        SetInactiveBitmap(bmp)
        
        Sets the bitmap to show on the control when it's not playing an
        animation.
        """

    def Stop(self):
        """
        Stop()
        
        Stops playing the animation.
        """

    @staticmethod
    def CreateCompatibleAnimation():
        """
        CreateCompatibleAnimation() -> Animation
        
        Create a new animation object compatible with this control.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Animation = property(None, None)
    InactiveBitmap = property(None, None)
# end of class AnimationCtrl

AnimationCtrlNameStr = ""
NullAnimation = Animation()

class GenericAnimationCtrl(wx.Control):
    """
    GenericAnimationCtrl(parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr)
    
    Generic implementation of wxAnimationCtrl interface.
    """

    def __init__(self, parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr):
        """
        GenericAnimationCtrl(parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr)
        
        Generic implementation of wxAnimationCtrl interface.
        """

    def Create(self, parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr):
        """
        Create(parent, id=wx.ID_ANY, anim=NullAnimation, pos=wx.DefaultPosition, size=wx.DefaultSize, style=AC_DEFAULT_STYLE, name=AnimationCtrlNameStr) -> bool
        
        Creates the control with the given anim animation.
        """

    def DrawCurrentFrame(self, dc):
        """
        DrawCurrentFrame(dc)
        
        Draw the current frame of the animation into given DC.
        """

    def GetBackingStore(self):
        """
        GetBackingStore() -> wx.Bitmap
        
        Returns a wxBitmap with the current frame drawn in it.
        """

    def Play(self, *args, **kw):
        """
        Play(looped) -> bool
        Play() -> bool
        
        This overload of Play() lets you specify if the animation must loop or
        not.
        """

    def SetUseWindowBackgroundColour(self, useWinBackground=True):
        """
        SetUseWindowBackgroundColour(useWinBackground=True)
        
        Specify whether the animation's background colour is to be shown (the
        default), or whether the window background should show through.
        """

    def IsUsingWindowBackgroundColour(self):
        """
        IsUsingWindowBackgroundColour() -> bool
        
        Returns true if the window's background colour is being used.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def Stop(self):
        """
        Stop()
        
        Stops playing the animation.
        """

    def IsPlaying(self):
        """
        IsPlaying() -> bool
        
        Returns true if the animation is being played.
        """

    def Load(self, file, animType=ANIMATION_TYPE_ANY):
        """
        Load(file, animType=ANIMATION_TYPE_ANY) -> bool
        
        Loads the animation from the given stream and calls SetAnimation().
        """

    def LoadFile(self, file, animType=ANIMATION_TYPE_ANY):
        """
        LoadFile(file, animType=ANIMATION_TYPE_ANY) -> bool
        
        Loads the animation from the given file and calls SetAnimation().
        """

    def GetAnimation(self):
        """
        GetAnimation() -> Animation
        
        Returns the animation associated with this control.
        """

    def SetAnimation(self, anim):
        """
        SetAnimation(anim)
        
        Sets the animation to play in this control.
        """

    def SetInactiveBitmap(self, bmp):
        """
        SetInactiveBitmap(bmp)
        
        Sets the bitmap to show on the control when it's not playing an
        animation.
        """

    def GetInactiveBitmap(self):
        """
        GetInactiveBitmap() -> wx.Bitmap
        
        Returns the inactive bitmap shown in this control when the; see
        SetInactiveBitmap() for more info.
        """

    def CreateAnimation(self):
        """
        CreateAnimation() -> Animation
        
        Create a new animation object compatible with this control.
        """

    @staticmethod
    def CreateCompatibleAnimation():
        """
        CreateCompatibleAnimation() -> Animation
        
        Create a new animation object compatible with this control.
        """
    Animation = property(None, None)
    BackingStore = property(None, None)
    InactiveBitmap = property(None, None)
# end of class GenericAnimationCtrl


class AnimationDecoder(ObjectRefData):
    """
    AnimationDecoder()
    
    wxAnimationDecoder is used by wxAnimation for loading frames and other
    information for the animation from the animation image file.
    """

    def __init__(self):
        """
        AnimationDecoder()
        
        wxAnimationDecoder is used by wxAnimation for loading frames and other
        information for the animation from the animation image file.
        """

    def Load(self, stream):
        """
        Load(stream) -> bool
        
        Load the animation image frames from the given stream.
        """

    def CanRead(self, stream):
        """
        CanRead(stream) -> bool
        
        Returns true if this decoder supports loading from the given stream.
        """

    def Clone(self):
        """
        Clone() -> AnimationDecoder
        
        Create a copy of this decoder.
        """

    def GetType(self):
        """
        GetType() -> AnimationType
        
        Return the animation type this decoder implements.
        """

    def ConvertToImage(self, frame, image):
        """
        ConvertToImage(frame, image) -> bool
        
        Convert given frame to wxImage.
        """

    def GetFrameSize(self, frame):
        """
        GetFrameSize(frame) -> wx.Size
        """

    def GetFramePosition(self, frame):
        """
        GetFramePosition(frame) -> wx.Point
        """

    def GetDisposalMethod(self, frame):
        """
        GetDisposalMethod(frame) -> AnimationDisposal
        
        What should be done after displaying this frame.
        """

    def GetDelay(self, frame):
        """
        GetDelay(frame) -> long
        
        Return the number of milliseconds this frame should be displayed.
        """

    def GetTransparentColour(self, frame):
        """
        GetTransparentColour(frame) -> wx.Colour
        
        The transparent colour for this frame, if any, or wxNullColour.
        """

    def GetAnimationSize(self):
        """
        GetAnimationSize() -> wx.Size
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> wx.Colour
        """

    def GetFrameCount(self):
        """
        GetFrameCount() -> unsignedint
        """
    AnimationSize = property(None, None)
    BackgroundColour = property(None, None)
    FrameCount = property(None, None)
    Type = property(None, None)

    def DoCanRead(self, stream):
        """
        DoCanRead(stream) -> bool
        
        Checks the signature of the data in the given stream and returns true
        if it appears to be a valid animation format recognized by the
        animation decoder; this function should modify the stream current
        position without taking care of restoring it since CanRead() will do
        it.
        """
# end of class AnimationDecoder


class ANIDecoder(AnimationDecoder):
    """
    ANIDecoder()
    
    An animation decoder supporting animated cursor (.ani) files.
    """

    def __init__(self):
        """
        ANIDecoder()
        
        An animation decoder supporting animated cursor (.ani) files.
        """

    def Load(self, stream):
        """
        Load(stream) -> bool
        
        Load the animation image frames from the given stream.
        """

    def Clone(self):
        """
        Clone() -> AnimationDecoder
        
        Create a copy of this decoder.
        """

    def GetType(self):
        """
        GetType() -> AnimationType
        
        Return the animation type this decoder implements.
        """

    def ConvertToImage(self, frame, image):
        """
        ConvertToImage(frame, image) -> bool
        
        Convert given frame to wxImage.
        """

    def GetFrameSize(self, frame):
        """
        GetFrameSize(frame) -> wx.Size
        """

    def GetFramePosition(self, frame):
        """
        GetFramePosition(frame) -> wx.Point
        """

    def GetDisposalMethod(self, frame):
        """
        GetDisposalMethod(frame) -> AnimationDisposal
        
        What should be done after displaying this frame.
        """

    def GetDelay(self, frame):
        """
        GetDelay(frame) -> long
        
        Return the number of milliseconds this frame should be displayed.
        """

    def GetTransparentColour(self, frame):
        """
        GetTransparentColour(frame) -> wx.Colour
        
        The transparent colour for this frame, if any, or wxNullColour.
        """
    Type = property(None, None)

    def DoCanRead(self, stream):
        """
        DoCanRead(stream) -> bool
        
        Checks the signature of the data in the given stream and returns true
        if it appears to be a valid animation format recognized by the
        animation decoder; this function should modify the stream current
        position without taking care of restoring it since CanRead() will do
        it.
        """
# end of class ANIDecoder


class GIFDecoder(AnimationDecoder):
    """
    GIFDecoder()
    
    An animation decoder supporting animated GIF files.
    """

    def __init__(self):
        """
        GIFDecoder()
        
        An animation decoder supporting animated GIF files.
        """

    def Load(self, stream):
        """
        Load(stream) -> bool
        
        Load the animation image frames from the given stream.
        """

    def Clone(self):
        """
        Clone() -> AnimationDecoder
        
        Create a copy of this decoder.
        """

    def GetType(self):
        """
        GetType() -> AnimationType
        
        Return the animation type this decoder implements.
        """

    def ConvertToImage(self, frame, image):
        """
        ConvertToImage(frame, image) -> bool
        
        Convert given frame to wxImage.
        """

    def GetFrameSize(self, frame):
        """
        GetFrameSize(frame) -> wx.Size
        """

    def GetFramePosition(self, frame):
        """
        GetFramePosition(frame) -> wx.Point
        """

    def GetDisposalMethod(self, frame):
        """
        GetDisposalMethod(frame) -> AnimationDisposal
        
        What should be done after displaying this frame.
        """

    def GetDelay(self, frame):
        """
        GetDelay(frame) -> long
        
        Return the number of milliseconds this frame should be displayed.
        """

    def GetTransparentColour(self, frame):
        """
        GetTransparentColour(frame) -> wx.Colour
        
        The transparent colour for this frame, if any, or wxNullColour.
        """
    Type = property(None, None)

    def DoCanRead(self, stream):
        """
        DoCanRead(stream) -> bool
        
        Checks the signature of the data in the given stream and returns true
        if it appears to be a valid animation format recognized by the
        animation decoder; this function should modify the stream current
        position without taking care of restoring it since CanRead() will do
        it.
        """
# end of class GIFDecoder

#-- end-animate --#
#-- begin-bannerwindow --#
BannerWindowNameStr = ""

class BannerWindow(wx.Window):
    """
    BannerWindow()
    BannerWindow(parent, winid=wx.ID_ANY, dir=wx.LEFT, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name=BannerWindowNameStr)
    
    A simple banner window showing either a bitmap or text.
    """

    def __init__(self, *args, **kw):
        """
        BannerWindow()
        BannerWindow(parent, winid=wx.ID_ANY, dir=wx.LEFT, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name=BannerWindowNameStr)
        
        A simple banner window showing either a bitmap or text.
        """

    def Create(self, parent, winid=wx.ID_ANY, dir=wx.LEFT, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name=BannerWindowNameStr):
        """
        Create(parent, winid=wx.ID_ANY, dir=wx.LEFT, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name=BannerWindowNameStr) -> bool
        
        Really create the banner window for the objects created using the
        default constructor.
        """

    def SetBitmap(self, bmp):
        """
        SetBitmap(bmp)
        
        Provide the bitmap to use as background.
        """

    def SetText(self, title, message):
        """
        SetText(title, message)
        
        Set the text to display.
        """

    def SetGradient(self, start, end):
        """
        SetGradient(start, end)
        
        Set the colours between which the gradient runs.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
# end of class BannerWindow

#-- end-bannerwindow --#
#-- begin-editlbox --#
EL_ALLOW_NEW = 0
EL_ALLOW_EDIT = 0
EL_ALLOW_DELETE = 0
EL_NO_REORDER = 0
EL_DEFAULT_STYLE = 0
EditableListBoxNameStr = ""

class EditableListBox(wx.Panel):
    """
    EditableListBox()
    EditableListBox(parent, id=wx.ID_ANY, label=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=EL_DEFAULT_STYLE, name=EditableListBoxNameStr)
    
    An editable listbox is composite control that lets the user easily
    enter, delete and reorder a list of strings.
    """

    def __init__(self, *args, **kw):
        """
        EditableListBox()
        EditableListBox(parent, id=wx.ID_ANY, label=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=EL_DEFAULT_STYLE, name=EditableListBoxNameStr)
        
        An editable listbox is composite control that lets the user easily
        enter, delete and reorder a list of strings.
        """

    def Create(self, parent, id=wx.ID_ANY, label=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=EL_DEFAULT_STYLE, name=EditableListBoxNameStr):
        """
        Create(parent, id=wx.ID_ANY, label=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=EL_DEFAULT_STYLE, name=EditableListBoxNameStr) -> bool
        
        Creates the editable listbox for two-step construction.
        """

    def SetStrings(self, strings):
        """
        SetStrings(strings)
        
        Replaces current contents with given strings.
        """

    def GetStrings(self):
        """
        GetStrings() -> ArrayString
        
        Returns a list of the current contents of the control.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def GetListCtrl(self):
        """
        GetListCtrl() -> wx.ListCtrl
        
        Returns a reference to the listctrl used in the EditableListBox.
        """

    def GetDelButton(self):
        """
        GetDelButton() -> wx.BitmapButton
        
        Returns a reference to the delete button used in the EditableListBox.
        """

    def GetNewButton(self):
        """
        GetNewButton() -> wx.BitmapButton
        
        Returns a reference to the new button used in the EditableListBox.
        """

    def GetUpButton(self):
        """
        GetUpButton() -> wx.BitmapButton
        
        Returns a reference to the up button used in the EditableListBox.
        """

    def GetDownButton(self):
        """
        GetDownButton() -> wx.BitmapButton
        
        Returns a reference to the down button used in the EditableListBox.
        """

    def GetEditButton(self):
        """
        GetEditButton() -> wx.BitmapButton
        
        Returns a reference to the edit button used in the EditableListBox.
        """
    DelButton = property(None, None)
    DownButton = property(None, None)
    EditButton = property(None, None)
    ListCtrl = property(None, None)
    NewButton = property(None, None)
    Strings = property(None, None)
    UpButton = property(None, None)
# end of class EditableListBox

#-- end-editlbox --#
#-- begin-notifmsg --#
wxEVT_NOTIFICATION_MESSAGE_CLICK = 0
wxEVT_NOTIFICATION_MESSAGE_DISMISSED = 0
wxEVT_NOTIFICATION_MESSAGE_ACTION = 0

class NotificationMessage(wx.EvtHandler):
    """
    NotificationMessage()
    NotificationMessage(title, message=wx.EmptyString, parent=None, flags=wx.ICON_INFORMATION)
    
    This class allows showing the user a message non intrusively.
    """
    Timeout_Auto = 0
    Timeout_Never = 0

    def __init__(self, *args, **kw):
        """
        NotificationMessage()
        NotificationMessage(title, message=wx.EmptyString, parent=None, flags=wx.ICON_INFORMATION)
        
        This class allows showing the user a message non intrusively.
        """

    def AddAction(self, actionid, label=""):
        """
        AddAction(actionid, label="") -> bool
        
        Add an action to the notification.
        """

    def Close(self):
        """
        Close() -> bool
        
        Hides the notification.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        This parameter can be currently used to specify the icon to show in
        the notification.
        """

    def SetIcon(self, icon):
        """
        SetIcon(icon)
        
        Specify a custom icon to be displayed in the notification.
        """

    def SetMessage(self, message):
        """
        SetMessage(message)
        
        Set the main text of the notification.
        """

    def SetParent(self, parent):
        """
        SetParent(parent)
        
        Set the parent for this notification: the notification will be
        associated with the top level parent of this window or, if this method
        is not called, with the main application window by default.
        """

    def SetTitle(self, title):
        """
        SetTitle(title)
        
        Set the title, it must be a concise string (not more than 64
        characters), use SetMessage() to give the user more details.
        """

    def Show(self, timeout=Timeout_Auto):
        """
        Show(timeout=Timeout_Auto) -> bool
        
        Show the notification to the user and hides it after timeout seconds
        are elapsed.
        """

    @staticmethod
    def UseTaskBarIcon(icon):
        """
        UseTaskBarIcon(icon) -> TaskBarIcon
        
        If the application already uses a wxTaskBarIcon, it should be
        connected to notifications by using this method.
        """

    @staticmethod
    def MSWUseToasts(shortcutPath="", appId=""):
        """
        MSWUseToasts(shortcutPath="", appId="") -> bool
        
        Enables toast notifications available since Windows 8 and suppresses
        the additional icon in the notification area on Windows 10.
        """
# end of class NotificationMessage

#-- end-notifmsg --#
#-- begin-splash --#
SPLASH_CENTRE_ON_PARENT = 0
SPLASH_CENTRE_ON_SCREEN = 0
SPLASH_NO_CENTRE = 0
SPLASH_TIMEOUT = 0
SPLASH_NO_TIMEOUT = 0

class SplashScreen(wx.Frame):
    """
    SplashScreen(bitmap, splashStyle, milliseconds, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.BORDER_SIMPLE|wx.FRAME_NO_TASKBAR|wx.STAY_ON_TOP)
    
    wxSplashScreen shows a window with a thin border, displaying a bitmap
    describing your application.
    """

    def __init__(self, bitmap, splashStyle, milliseconds, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.BORDER_SIMPLE|wx.FRAME_NO_TASKBAR|wx.STAY_ON_TOP):
        """
        SplashScreen(bitmap, splashStyle, milliseconds, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.BORDER_SIMPLE|wx.FRAME_NO_TASKBAR|wx.STAY_ON_TOP)
        
        wxSplashScreen shows a window with a thin border, displaying a bitmap
        describing your application.
        """

    def GetSplashStyle(self):
        """
        GetSplashStyle() -> long
        
        Returns the splash style (see wxSplashScreen() for details).
        """

    def GetTimeout(self):
        """
        GetTimeout() -> int
        
        Returns the timeout in milliseconds.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def GetBitmap(self):
        """
        GetBitmap() -> wx.Bitmap
        
        Get the spash screen's bitmap
        """

    def SetBitmap(self, bitmap):
        """
        SetBitmap(bitmap)
        
        Set a new bitmap for the splash screen.
        """
    Bitmap = property(None, None)
    SplashStyle = property(None, None)
    Timeout = property(None, None)
# end of class SplashScreen


SPLASH_CENTER_ON_PARENT = SPLASH_CENTRE_ON_PARENT
SPLASH_CENTER_ON_SCREEN = SPLASH_CENTRE_ON_SCREEN
SPLASH_NO_CENTER = SPLASH_NO_CENTRE
#-- end-splash --#
#-- begin-sashwin --#
SW_NOBORDER = 0
SW_BORDER = 0
SW_3DSASH = 0
SW_3DBORDER = 0
SW_3D = 0
SASH_TOP = 0
SASH_RIGHT = 0
SASH_BOTTOM = 0
SASH_LEFT = 0
SASH_NONE = 0
SASH_STATUS_OK = 0
SASH_STATUS_OUT_OF_RANGE = 0
wxEVT_SASH_DRAGGED = 0

class SashWindow(wx.Window):
    """
    SashWindow()
    SashWindow(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.CLIP_CHILDREN|SW_3D, name="sashWindow")
    
    wxSashWindow allows any of its edges to have a sash which can be
    dragged to resize the window.
    """

    def __init__(self, *args, **kw):
        """
        SashWindow()
        SashWindow(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.CLIP_CHILDREN|SW_3D, name="sashWindow")
        
        wxSashWindow allows any of its edges to have a sash which can be
        dragged to resize the window.
        """

    def GetMaximumSizeX(self):
        """
        GetMaximumSizeX() -> int
        
        Gets the maximum window size in the x direction.
        """

    def GetMaximumSizeY(self):
        """
        GetMaximumSizeY() -> int
        
        Gets the maximum window size in the y direction.
        """

    def GetMinimumSizeX(self):
        """
        GetMinimumSizeX() -> int
        
        Gets the minimum window size in the x direction.
        """

    def GetMinimumSizeY(self):
        """
        GetMinimumSizeY() -> int
        
        Gets the minimum window size in the y direction.
        """

    def GetSashVisible(self, edge):
        """
        GetSashVisible(edge) -> bool
        
        Returns true if a sash is visible on the given edge, false otherwise.
        """

    def SetMaximumSizeX(self, min):
        """
        SetMaximumSizeX(min)
        
        Sets the maximum window size in the x direction.
        """

    def SetMaximumSizeY(self, min):
        """
        SetMaximumSizeY(min)
        
        Sets the maximum window size in the y direction.
        """

    def SetMinimumSizeX(self, min):
        """
        SetMinimumSizeX(min)
        
        Sets the minimum window size in the x direction.
        """

    def SetMinimumSizeY(self, min):
        """
        SetMinimumSizeY(min)
        
        Sets the minimum window size in the y direction.
        """

    def SetSashVisible(self, edge, visible):
        """
        SetSashVisible(edge, visible)
        
        Call this function to make a sash visible or invisible on a particular
        edge.
        """

    def GetEdgeMargin(self, edge):
        """
        GetEdgeMargin(edge) -> int
        
        Get border size.
        """

    def SetDefaultBorderSize(self, width):
        """
        SetDefaultBorderSize(width)
        
        Sets the default sash border size.
        """

    def GetDefaultBorderSize(self):
        """
        GetDefaultBorderSize() -> int
        
        Gets the default sash border size.
        """

    def SetExtraBorderSize(self, width):
        """
        SetExtraBorderSize(width)
        
        Sets the additional border size between child and sash window.
        """

    def GetExtraBorderSize(self):
        """
        GetExtraBorderSize() -> int
        
        Gets the addition border size between child and sash window.
        """

    def SashHitTest(self, x, y, tolerance=2):
        """
        SashHitTest(x, y, tolerance=2) -> SashEdgePosition
        
        Tests for x, y over sash.
        """

    def SizeWindows(self):
        """
        SizeWindows()
        
        Resizes subwindows.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    DefaultBorderSize = property(None, None)
    ExtraBorderSize = property(None, None)
    MaximumSizeX = property(None, None)
    MaximumSizeY = property(None, None)
    MinimumSizeX = property(None, None)
    MinimumSizeY = property(None, None)
# end of class SashWindow


class SashEvent(wx.CommandEvent):
    """
    SashEvent(id=0, edge=SASH_NONE)
    
    A sash event is sent when the sash of a wxSashWindow has been dragged
    by the user.
    """

    def __init__(self, id=0, edge=SASH_NONE):
        """
        SashEvent(id=0, edge=SASH_NONE)
        
        A sash event is sent when the sash of a wxSashWindow has been dragged
        by the user.
        """

    def GetDragRect(self):
        """
        GetDragRect() -> wx.Rect
        
        Returns the rectangle representing the new size the window would be if
        the resize was applied.
        """

    def GetDragStatus(self):
        """
        GetDragStatus() -> SashDragStatus
        
        Returns the status of the sash: one of wxSASH_STATUS_OK,
        wxSASH_STATUS_OUT_OF_RANGE.
        """

    def GetEdge(self):
        """
        GetEdge() -> SashEdgePosition
        
        Returns the dragged edge.
        """

    def SetEdge(self, edge):
        """
        SetEdge(edge)
        """

    def SetDragRect(self, rect):
        """
        SetDragRect(rect)
        """

    def SetDragStatus(self, status):
        """
        SetDragStatus(status)
        """
    DragRect = property(None, None)
    DragStatus = property(None, None)
    Edge = property(None, None)
# end of class SashEvent


EVT_SASH_DRAGGED = wx.PyEventBinder( wxEVT_SASH_DRAGGED, 1 )
EVT_SASH_DRAGGED_RANGE = wx.PyEventBinder( wxEVT_SASH_DRAGGED, 2 )
#-- end-sashwin --#
#-- begin-laywin --#
LAYOUT_HORIZONTAL = 0
LAYOUT_VERTICAL = 0
LAYOUT_NONE = 0
LAYOUT_TOP = 0
LAYOUT_LEFT = 0
LAYOUT_RIGHT = 0
LAYOUT_BOTTOM = 0
wxEVT_QUERY_LAYOUT_INFO = 0
wxEVT_CALCULATE_LAYOUT = 0

class LayoutAlgorithm(wx.Object):
    """
    LayoutAlgorithm()
    
    wxLayoutAlgorithm implements layout of subwindows in MDI or SDI
    frames.
    """

    def __init__(self):
        """
        LayoutAlgorithm()
        
        wxLayoutAlgorithm implements layout of subwindows in MDI or SDI
        frames.
        """

    def LayoutFrame(self, frame, mainWindow=None):
        """
        LayoutFrame(frame, mainWindow=None) -> bool
        
        Lays out the children of a normal frame.
        """

    def LayoutMDIFrame(self, frame, rect=None):
        """
        LayoutMDIFrame(frame, rect=None) -> bool
        
        Lays out the children of an MDI parent frame.
        """

    def LayoutWindow(self, parent, mainWindow=None):
        """
        LayoutWindow(parent, mainWindow=None) -> bool
        
        Lays out the children of a normal frame or other window.
        """
# end of class LayoutAlgorithm


class SashLayoutWindow(SashWindow):
    """
    SashLayoutWindow()
    SashLayoutWindow(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.CLIP_CHILDREN|SW_3D, name="layoutWindow")
    
    wxSashLayoutWindow responds to OnCalculateLayout events generated by
    wxLayoutAlgorithm.
    """

    def __init__(self, *args, **kw):
        """
        SashLayoutWindow()
        SashLayoutWindow(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.CLIP_CHILDREN|SW_3D, name="layoutWindow")
        
        wxSashLayoutWindow responds to OnCalculateLayout events generated by
        wxLayoutAlgorithm.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.CLIP_CHILDREN|SW_3D, name="layoutWindow"):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.CLIP_CHILDREN|SW_3D, name="layoutWindow") -> bool
        
        Initializes a sash layout window, which can be a child of a frame,
        dialog or any other non-control window.
        """

    def GetAlignment(self):
        """
        GetAlignment() -> LayoutAlignment
        
        Returns the alignment of the window: one of wxLAYOUT_TOP,
        wxLAYOUT_LEFT, wxLAYOUT_RIGHT, wxLAYOUT_BOTTOM.
        """

    def GetOrientation(self):
        """
        GetOrientation() -> LayoutOrientation
        
        Returns the orientation of the window: one of wxLAYOUT_HORIZONTAL,
        wxLAYOUT_VERTICAL.
        """

    def OnCalculateLayout(self, event):
        """
        OnCalculateLayout(event)
        
        The default handler for the event that is generated by
        wxLayoutAlgorithm.
        """

    def OnQueryLayoutInfo(self, event):
        """
        OnQueryLayoutInfo(event)
        
        The default handler for the event that is generated by
        OnCalculateLayout to get size, alignment and orientation information
        for the window.
        """

    def SetAlignment(self, alignment):
        """
        SetAlignment(alignment)
        
        Sets the alignment of the window (which edge of the available parent
        client area the window is attached to).
        """

    def SetDefaultSize(self, size):
        """
        SetDefaultSize(size)
        
        Sets the default dimensions of the window.
        """

    def SetOrientation(self, orientation):
        """
        SetOrientation(orientation)
        
        Sets the orientation of the window (the direction the window will
        stretch in, to fill the available parent client area).
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Alignment = property(None, None)
    Orientation = property(None, None)
# end of class SashLayoutWindow


class QueryLayoutInfoEvent(wx.Event):
    """
    QueryLayoutInfoEvent(id=0)
    
    This event is sent when wxLayoutAlgorithm wishes to get the size,
    orientation and alignment of a window.
    """

    def __init__(self, id=0):
        """
        QueryLayoutInfoEvent(id=0)
        
        This event is sent when wxLayoutAlgorithm wishes to get the size,
        orientation and alignment of a window.
        """

    def GetAlignment(self):
        """
        GetAlignment() -> LayoutAlignment
        
        Specifies the alignment of the window (which side of the remaining
        parent client area the window sticks to).
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Returns the flags associated with this event.
        """

    def GetOrientation(self):
        """
        GetOrientation() -> LayoutOrientation
        
        Returns the orientation that the event handler specified to the event
        object.
        """

    def GetRequestedLength(self):
        """
        GetRequestedLength() -> int
        
        Returns the requested length of the window in the direction of the
        window orientation.
        """

    def GetSize(self):
        """
        GetSize() -> wx.Size
        
        Returns the size that the event handler specified to the event object
        as being the requested size of the window.
        """

    def SetAlignment(self, alignment):
        """
        SetAlignment(alignment)
        
        Call this to specify the alignment of the window (which side of the
        remaining parent client area the window sticks to).
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets the flags associated with this event.
        """

    def SetOrientation(self, orientation):
        """
        SetOrientation(orientation)
        
        Call this to specify the orientation of the window.
        """

    def SetRequestedLength(self, length):
        """
        SetRequestedLength(length)
        
        Sets the requested length of the window in the direction of the window
        orientation.
        """

    def SetSize(self, size):
        """
        SetSize(size)
        
        Call this to let the calling code know what the size of the window is.
        """
    Alignment = property(None, None)
    Flags = property(None, None)
    Orientation = property(None, None)
    RequestedLength = property(None, None)
    Size = property(None, None)
# end of class QueryLayoutInfoEvent


class CalculateLayoutEvent(wx.Event):
    """
    CalculateLayoutEvent(id=0)
    
    This event is sent by wxLayoutAlgorithm to calculate the amount of the
    remaining client area that the window should occupy.
    """

    def __init__(self, id=0):
        """
        CalculateLayoutEvent(id=0)
        
        This event is sent by wxLayoutAlgorithm to calculate the amount of the
        remaining client area that the window should occupy.
        """

    def GetFlags(self):
        """
        GetFlags() -> int
        
        Returns the flags associated with this event.
        """

    def GetRect(self):
        """
        GetRect() -> wx.Rect
        
        Before the event handler is entered, returns the remaining parent
        client area that the window could occupy.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Sets the flags associated with this event.
        """

    def SetRect(self, rect):
        """
        SetRect(rect)
        
        Call this to specify the new remaining parent client area, after the
        space occupied by the window has been subtracted.
        """
    Flags = property(None, None)
    Rect = property(None, None)
# end of class CalculateLayoutEvent


EVT_QUERY_LAYOUT_INFO = wx.PyEventBinder( wxEVT_QUERY_LAYOUT_INFO )
EVT_CALCULATE_LAYOUT = wx.PyEventBinder( wxEVT_CALCULATE_LAYOUT )
#-- end-laywin --#
#-- begin-odcombo --#
ODCB_PAINTING_CONTROL = 0
ODCB_PAINTING_SELECTED = 0
ODCB_DCLICK_CYCLES = 0
ODCB_STD_CONTROL_PAINT = 0

class OwnerDrawnComboBox(wx.ComboCtrl, wx.ItemContainer):
    """
    OwnerDrawnComboBox()
    OwnerDrawnComboBox(parent, id=wx.ID_ANY, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=0, validator=wx.DefaultValidator, name="comboBox")
    
    wxOwnerDrawnComboBox is a combobox with owner-drawn list items.
    """

    def __init__(self, *args, **kw):
        """
        OwnerDrawnComboBox()
        OwnerDrawnComboBox(parent, id=wx.ID_ANY, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=0, validator=wx.DefaultValidator, name="comboBox")
        
        wxOwnerDrawnComboBox is a combobox with owner-drawn list items.
        """

    def Create(self, parent, id=wx.ID_ANY, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=0, validator=wx.DefaultValidator, name=wx.ComboBoxNameStr):
        """
        Create(parent, id=wx.ID_ANY, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=0, validator=wx.DefaultValidator, name=wx.ComboBoxNameStr) -> bool
        """

    def IsListEmpty(self):
        """
        IsListEmpty() -> bool
        
        Returns true if the list of combobox choices is empty.
        """

    def IsTextEmpty(self):
        """
        IsTextEmpty() -> bool
        
        Returns true if the text of the combobox is empty.
        """

    def GetWidestItem(self):
        """
        GetWidestItem() -> int
        
        Returns index to the widest item in the list.
        """

    def GetWidestItemWidth(self):
        """
        GetWidestItemWidth() -> int
        
        Returns width of the widest item in the list.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    WidestItem = property(None, None)
    WidestItemWidth = property(None, None)

    def OnDrawBackground(self, dc, rect, item, flags):
        """
        OnDrawBackground(dc, rect, item, flags)
        
        This method is used to draw the items background and, maybe, a border
        around it.
        """

    def OnDrawItem(self, dc, rect, item, flags):
        """
        OnDrawItem(dc, rect, item, flags)
        
        The derived class may implement this function to actually draw the
        item with the given index on the provided DC.
        """

    def OnMeasureItem(self, item):
        """
        OnMeasureItem(item) -> Coord
        
        The derived class may implement this method to return the height of
        the specified item (in pixels).
        """

    def OnMeasureItemWidth(self, item):
        """
        OnMeasureItemWidth(item) -> Coord
        
        The derived class may implement this method to return the width of the
        specified item (in pixels).
        """
# end of class OwnerDrawnComboBox

#-- end-odcombo --#
#-- begin-bmpcbox --#
BitmapComboBoxNameStr = ""

class BitmapComboBox(wx.Control, wx.TextEntry, wx.ItemContainer):
    """
    BitmapComboBox()
    BitmapComboBox(parent, id=wx.ID_ANY, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=0, validator=wx.DefaultValidator, name=BitmapComboBoxNameStr)
    
    A combobox that displays bitmap in front of the list items.
    """

    def __init__(self, *args, **kw):
        """
        BitmapComboBox()
        BitmapComboBox(parent, id=wx.ID_ANY, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=0, validator=wx.DefaultValidator, name=BitmapComboBoxNameStr)
        
        A combobox that displays bitmap in front of the list items.
        """

    def Append(self, *args, **kw):
        """
        Append(item, bitmap=wx.NullBitmap) -> int
        Append(item, bitmap, clientData) -> int
        
        Adds the item to the end of the combo box.
        """

    def Create(self, parent, id=wx.ID_ANY, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=0, validator=wx.DefaultValidator, name=BitmapComboBoxNameStr):
        """
        Create(parent, id=wx.ID_ANY, value=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=0, validator=wx.DefaultValidator, name=BitmapComboBoxNameStr) -> bool
        
        Creates the combobox for two-step construction.
        """

    def GetBitmapSize(self):
        """
        GetBitmapSize() -> wx.Size
        
        Returns the size of the bitmaps used in the combo box.
        """

    def GetItemBitmap(self, n):
        """
        GetItemBitmap(n) -> wx.Bitmap
        
        Returns the bitmap of the item with the given index.
        """

    def Insert(self, *args, **kw):
        """
        Insert(item, bitmap, pos) -> int
        Insert(item, bitmap, pos, clientData) -> int
        
        Inserts the item into the list before pos.
        """

    def SetItemBitmap(self, n, bitmap):
        """
        SetItemBitmap(n, bitmap)
        
        Sets the bitmap for the given item.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def GetInsertionPoint(self):
        """
        GetInsertionPoint() -> long
        
        Same as wxTextEntry::GetInsertionPoint().
        """

    def IsListEmpty(self):
        """
        IsListEmpty() -> bool
        
        Returns true if the list of combobox choices is empty.
        """

    def IsTextEmpty(self):
        """
        IsTextEmpty() -> bool
        
        Returns true if the text of the combobox is empty.
        """

    def SetSelection(self, *args, **kw):
        """
        SetSelection(from_, to_)
        SetSelection(n)
        
        Same as wxTextEntry::SetSelection().
        """

    def SetTextSelection(self, from_, to_):
        """
        SetTextSelection(from_, to_)
        
        Same as wxTextEntry::SetSelection().
        """

    def SetValue(self, text):
        """
        SetValue(text)
        
        Sets the text for the combobox text field.
        """

    def Popup(self):
        """
        Popup()
        
        Shows the list box portion of the combo box.
        """

    def Dismiss(self):
        """
        Dismiss()
        
        Hides the list box portion of the combo box.
        """

    def GetSelection(self):
        """
        GetSelection() -> int
        
        Returns the index of the selected item or wxNOT_FOUND if no item is
        selected.
        """

    def GetTextSelection(self):
        """
        GetTextSelection() -> (from, to)
        
        Gets the current selection span.
        """

    def FindString(self, string, caseSensitive=False):
        """
        FindString(string, caseSensitive=False) -> int
        
        Finds an item whose label matches the given string.
        """

    def GetString(self, n):
        """
        GetString(n) -> String
        
        Returns the label of the item with the given index.
        """

    def SetString(self, n, text):
        """
        SetString(n, text)
        
        Changes the text of the specified combobox item.
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Returns the number of items in the control.
        """
    BitmapSize = property(None, None)
    Count = property(None, None)
    InsertionPoint = property(None, None)
    Selection = property(None, None)
# end of class BitmapComboBox

#-- end-bmpcbox --#
#-- begin-richtooltip --#
TipKind_None = 0
TipKind_TopLeft = 0
TipKind_Top = 0
TipKind_TopRight = 0
TipKind_BottomLeft = 0
TipKind_Bottom = 0
TipKind_BottomRight = 0
TipKind_Auto = 0

class RichToolTip(object):
    """
    RichToolTip(title, message)
    
    Allows showing a tool tip with more customizations than wxToolTip.
    """

    def __init__(self, title, message):
        """
        RichToolTip(title, message)
        
        Allows showing a tool tip with more customizations than wxToolTip.
        """

    def SetBackgroundColour(self, col, colEnd=wx.Colour()):
        """
        SetBackgroundColour(col, colEnd=wx.Colour())
        
        Set the background colour.
        """

    def SetIcon(self, *args, **kw):
        """
        SetIcon(icon=wx.ICON_INFORMATION)
        SetIcon(icon)
        
        Set the small icon to show.
        """

    def SetTimeout(self, millisecondsTimeout, millisecondsDelay=0):
        """
        SetTimeout(millisecondsTimeout, millisecondsDelay=0)
        
        Set timeout after which the tooltip should disappear and optionally
        set a delay before the tooltip is shown, in milliseconds.
        """

    def SetTipKind(self, tipKind):
        """
        SetTipKind(tipKind)
        
        Choose the tip kind, possibly none.
        """

    def SetTitleFont(self, font):
        """
        SetTitleFont(font)
        
        Set the title text font.
        """

    def ShowFor(self, win, rect=None):
        """
        ShowFor(win, rect=None)
        
        Show the tooltip for the given window and optionally specify where to
        show the tooltip.
        """
# end of class RichToolTip

#-- end-richtooltip --#
#-- begin-timectrl --#
TP_DEFAULT = 0
TimePickerCtrlNameStr = ""

class TimePickerCtrl(wx.Control):
    """
    TimePickerCtrl()
    TimePickerCtrl(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=TP_DEFAULT, validator=wx.DefaultValidator, name=TimePickerCtrlNameStr)
    
    This control allows the user to enter time.
    """

    def __init__(self, *args, **kw):
        """
        TimePickerCtrl()
        TimePickerCtrl(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=TP_DEFAULT, validator=wx.DefaultValidator, name=TimePickerCtrlNameStr)
        
        This control allows the user to enter time.
        """

    def Create(self, parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=TP_DEFAULT, validator=wx.DefaultValidator, name=TimePickerCtrlNameStr):
        """
        Create(parent, id=wx.ID_ANY, dt=wx.DefaultDateTime, pos=wx.DefaultPosition, size=wx.DefaultSize, style=TP_DEFAULT, validator=wx.DefaultValidator, name=TimePickerCtrlNameStr) -> bool
        
        Create the control window.
        """

    def GetTime(self):
        """
        GetTime() -> (hour, min, sec)
        
        Returns the currently entered time as hours, minutes and seconds.
        """

    def GetValue(self):
        """
        GetValue() -> wx.DateTime
        
        Returns the currently entered time.
        """

    def SetTime(self, hour, min, sec):
        """
        SetTime(hour, min, sec) -> bool
        
        Changes the current time of the control.
        """

    def SetValue(self, dt):
        """
        SetValue(dt)
        
        Changes the current value of the control.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Value = property(None, None)
# end of class TimePickerCtrl

#-- end-timectrl --#
#-- begin-wizard --#
WIZARD_EX_HELPBUTTON = 0
WIZARD_VALIGN_TOP = 0
WIZARD_VALIGN_CENTRE = 0
WIZARD_VALIGN_BOTTOM = 0
WIZARD_HALIGN_LEFT = 0
WIZARD_HALIGN_CENTRE = 0
WIZARD_HALIGN_RIGHT = 0
WIZARD_TILE = 0
wxEVT_WIZARD_PAGE_CHANGED = 0
wxEVT_WIZARD_PAGE_CHANGING = 0
wxEVT_WIZARD_CANCEL = 0
wxEVT_WIZARD_HELP = 0
wxEVT_WIZARD_FINISHED = 0
wxEVT_WIZARD_PAGE_SHOWN = 0
wxEVT_WIZARD_BEFORE_PAGE_CHANGED = 0

class WizardPage(wx.Panel):
    """
    WizardPage()
    WizardPage(parent, bitmap=wx.BitmapBundle())
    
    wxWizardPage is one of the screens in wxWizard: it must know what are
    the following and preceding pages (which may be NULL for the
    first/last page).
    """

    def __init__(self, *args, **kw):
        """
        WizardPage()
        WizardPage(parent, bitmap=wx.BitmapBundle())
        
        wxWizardPage is one of the screens in wxWizard: it must know what are
        the following and preceding pages (which may be NULL for the
        first/last page).
        """

    def Create(self, parent, bitmap=wx.BitmapBundle()):
        """
        Create(parent, bitmap=wx.BitmapBundle()) -> bool
        
        Creates the wizard page.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> wx.Bitmap
        
        This method is called by wxWizard to get the bitmap to display
        alongside the page.
        """

    def GetNext(self):
        """
        GetNext() -> WizardPage
        
        Get the page which should be shown when the user chooses the "Next"
        button: if NULL is returned, this button will be disabled.
        """

    def GetPrev(self):
        """
        GetPrev() -> WizardPage
        
        Get the page which should be shown when the user chooses the "Back"
        button: if NULL is returned, this button will be disabled.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Bitmap = property(None, None)
    Next = property(None, None)
    Prev = property(None, None)
# end of class WizardPage


class WizardPageSimple(WizardPage):
    """
    WizardPageSimple()
    WizardPageSimple(parent, prev=None, next=None, bitmap=wx.BitmapBundle())
    
    wxWizardPageSimple is the simplest possible wxWizardPage
    implementation: it just returns the pointers given to its constructor
    from wxWizardPage::GetNext() and wxWizardPage::GetPrev() functions.
    """

    def __init__(self, *args, **kw):
        """
        WizardPageSimple()
        WizardPageSimple(parent, prev=None, next=None, bitmap=wx.BitmapBundle())
        
        wxWizardPageSimple is the simplest possible wxWizardPage
        implementation: it just returns the pointers given to its constructor
        from wxWizardPage::GetNext() and wxWizardPage::GetPrev() functions.
        """

    def Create(self, parent=None, prev=None, next=None, bitmap=wx.BitmapBundle()):
        """
        Create(parent=None, prev=None, next=None, bitmap=wx.BitmapBundle()) -> bool
        
        Creates the wizard page.
        """

    def Chain(self, *args, **kw):
        """
        Chain(next) -> WizardPageSimple
        Chain(first, second)
        
        A helper chaining this page with the next one.
        """

    def SetNext(self, next):
        """
        SetNext(next)
        
        Sets the next page.
        """

    def SetPrev(self, prev):
        """
        SetPrev(prev)
        
        Sets the previous page.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
# end of class WizardPageSimple


class Wizard(wx.Dialog):
    """
    Wizard()
    Wizard(parent, id=wx.ID_ANY, title=wx.EmptyString, bitmap=wx.BitmapBundle(), pos=wx.DefaultPosition, style=wx.DEFAULT_DIALOG_STYLE)
    
    wxWizard is the central class for implementing 'wizard-like' dialogs.
    """

    def __init__(self, *args, **kw):
        """
        Wizard()
        Wizard(parent, id=wx.ID_ANY, title=wx.EmptyString, bitmap=wx.BitmapBundle(), pos=wx.DefaultPosition, style=wx.DEFAULT_DIALOG_STYLE)
        
        wxWizard is the central class for implementing 'wizard-like' dialogs.
        """

    def Create(self, parent, id=wx.ID_ANY, title=wx.EmptyString, bitmap=wx.BitmapBundle(), pos=wx.DefaultPosition, style=wx.DEFAULT_DIALOG_STYLE):
        """
        Create(parent, id=wx.ID_ANY, title=wx.EmptyString, bitmap=wx.BitmapBundle(), pos=wx.DefaultPosition, style=wx.DEFAULT_DIALOG_STYLE) -> bool
        
        Creates the wizard dialog.
        """

    def FitToPage(self, firstPage):
        """
        FitToPage(firstPage)
        
        This method is obsolete, use GetPageAreaSizer() instead.
        """

    def GetBitmap(self):
        """
        GetBitmap() -> wx.Bitmap
        
        Returns the bitmap used for the wizard.
        """

    def GetBitmapBackgroundColour(self):
        """
        GetBitmapBackgroundColour() -> wx.Colour
        
        Returns the colour that should be used to fill the area not taken up
        by the wizard or page bitmap, if a non-zero bitmap placement flag has
        been set.
        """

    def GetBitmapPlacement(self):
        """
        GetBitmapPlacement() -> int
        
        Returns the flags indicating how the wizard or page bitmap should be
        expanded and positioned to fit the page height.
        """

    def GetCurrentPage(self):
        """
        GetCurrentPage() -> WizardPage
        
        Get the current page while the wizard is running.
        """

    def GetMinimumBitmapWidth(self):
        """
        GetMinimumBitmapWidth() -> int
        
        Returns the minimum width for the bitmap that will be constructed to
        contain the actual wizard or page bitmap if a non-zero bitmap
        placement flag has been set.
        """

    def GetPageAreaSizer(self):
        """
        GetPageAreaSizer() -> wx.Sizer
        
        Returns pointer to page area sizer.
        """

    def GetPageSize(self):
        """
        GetPageSize() -> wx.Size
        
        Returns the size available for the pages.
        """

    def HasNextPage(self, page):
        """
        HasNextPage(page) -> bool
        
        Return true if this page is not the last one in the wizard.
        """

    def HasPrevPage(self, page):
        """
        HasPrevPage(page) -> bool
        
        Returns true if this page is not the first one in the wizard.
        """

    def RunWizard(self, firstPage):
        """
        RunWizard(firstPage) -> bool
        
        Executes the wizard starting from the given page, returning true if it
        was successfully finished or false if user cancelled it.
        """

    def SetBitmap(self, bitmap):
        """
        SetBitmap(bitmap)
        
        Sets the bitmap used for the wizard.
        """

    def SetBitmapBackgroundColour(self, colour):
        """
        SetBitmapBackgroundColour(colour)
        
        Sets the colour that should be used to fill the area not taken up by
        the wizard or page bitmap, if a non-zero bitmap placement flag has
        been set.
        """

    def SetBitmapPlacement(self, placement):
        """
        SetBitmapPlacement(placement)
        
        Sets the flags indicating how the wizard or page bitmap should be
        expanded and positioned to fit the page height.
        """

    def SetBorder(self, border):
        """
        SetBorder(border)
        
        Sets width of border around page area.
        """

    def SetMinimumBitmapWidth(self, width):
        """
        SetMinimumBitmapWidth(width)
        
        Sets the minimum width for the bitmap that will be constructed to
        contain the actual wizard or page bitmap if a non-zero bitmap
        placement flag has been set.
        """

    def SetPageSize(self, sizePage):
        """
        SetPageSize(sizePage)
        
        Sets the minimal size to be made available for the wizard pages.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def ShowPage(self, page, goingForward=True):
        """
        ShowPage(page, goingForward=True) -> bool
        
        Show the given wizard page.
        """

    def IsRunning(self):
        """
        IsRunning() -> bool
        """
    Bitmap = property(None, None)
    BitmapBackgroundColour = property(None, None)
    BitmapPlacement = property(None, None)
    CurrentPage = property(None, None)
    MinimumBitmapWidth = property(None, None)
    PageAreaSizer = property(None, None)
    PageSize = property(None, None)
# end of class Wizard


class WizardEvent(wx.NotifyEvent):
    """
    WizardEvent(type=wx.wxEVT_NULL, id=wx.ID_ANY, direction=True, page=0)
    
    wxWizardEvent class represents an event generated by the wxWizard:
    this event is first sent to the page itself and, if not processed
    there, goes up the window hierarchy as usual.
    """

    def __init__(self, type=wx.wxEVT_NULL, id=wx.ID_ANY, direction=True, page=0):
        """
        WizardEvent(type=wx.wxEVT_NULL, id=wx.ID_ANY, direction=True, page=0)
        
        wxWizardEvent class represents an event generated by the wxWizard:
        this event is first sent to the page itself and, if not processed
        there, goes up the window hierarchy as usual.
        """

    def GetDirection(self):
        """
        GetDirection() -> bool
        
        Return the direction in which the page is changing: for
        EVT_WIZARD_PAGE_CHANGING, return true if we're going forward or false
        otherwise and for EVT_WIZARD_PAGE_CHANGED return true if we came from
        the previous page and false if we returned from the next one.
        """

    def GetPage(self):
        """
        GetPage() -> WizardPage
        
        Returns the wxWizardPage which was active when this event was
        generated.
        """
    Direction = property(None, None)
    Page = property(None, None)
# end of class WizardEvent


PyWizardPage = wx.deprecated(WizardPage, 'Use WizardPage instead.')

EVT_WIZARD_BEFORE_PAGE_CHANGED  = wx.PyEventBinder( wxEVT_WIZARD_BEFORE_PAGE_CHANGED, 1)
EVT_WIZARD_PAGE_CHANGED  = wx.PyEventBinder( wxEVT_WIZARD_PAGE_CHANGED, 1)
EVT_WIZARD_PAGE_CHANGING = wx.PyEventBinder( wxEVT_WIZARD_PAGE_CHANGING, 1)
EVT_WIZARD_CANCEL        = wx.PyEventBinder( wxEVT_WIZARD_CANCEL, 1)
EVT_WIZARD_HELP          = wx.PyEventBinder( wxEVT_WIZARD_HELP, 1)
EVT_WIZARD_FINISHED      = wx.PyEventBinder( wxEVT_WIZARD_FINISHED, 1)
EVT_WIZARD_PAGE_SHOWN    = wx.PyEventBinder( wxEVT_WIZARD_PAGE_SHOWN, 1)
#-- end-wizard --#
#-- begin-pseudodc --#

class PseudoDC(wx.Object):
    """
    PseudoDC()
    
    A PseudoDC is an object that can be used much like real
    :class:`wx.DC`, however it provides some additional features for
    object recording and manipulation beyond what a ``wx.DC`` can
    provide.
    
    All commands issued to the ``PseudoDC`` are stored in a list.  You
    can then play these commands back to a real DC object as often as
    needed, using the :meth:`DrawToDC` method or one of the similar
    methods.  Commands in the command list can be tagged by an ID. You
    can use this ID to clear the operations associated with a single
    ID, redraw the objects associated with that ID, grey them, adjust
    their position, etc.
    """

    def __init__(self):
        """
        PseudoDC()
        
        A PseudoDC is an object that can be used much like real
        :class:`wx.DC`, however it provides some additional features for
        object recording and manipulation beyond what a ``wx.DC`` can
        provide.
        
        All commands issued to the ``PseudoDC`` are stored in a list.  You
        can then play these commands back to a real DC object as often as
        needed, using the :meth:`DrawToDC` method or one of the similar
        methods.  Commands in the command list can be tagged by an ID. You
        can use this ID to clear the operations associated with a single
        ID, redraw the objects associated with that ID, grey them, adjust
        their position, etc.
        """

    def RemoveAll(self):
        """
        RemoveAll()
        
        Removes all objects and operations from the recorded list.
        """

    def GetLen(self):
        """
        GetLen() -> int
        
        Returns the number of operations in the recorded list.
        """

    def SetId(self, id):
        """
        SetId(id)
        
        Sets the id to be associated with subsequent operations.
        """

    def ClearId(self, id):
        """
        ClearId(id)
        
        Removes all operations associated with id so the object can be
        redrawn.
        """

    def RemoveId(self, id):
        """
        RemoveId(id)
        
        Remove the object node (and all operations) associated with an id.
        """

    def TranslateId(self, id, dx, dy):
        """
        TranslateId(id, dx, dy)
        
        Translate the position of the operations of tag `id` by (`dx`, `dy`).
        """

    def SetIdGreyedOut(self, id, greyout):
        """
        SetIdGreyedOut(id, greyout)
        
        Set whether the set of objects with tag `id` are drawn greyed out or
        not.
        """

    def GetIdGreyedOut(self, id):
        """
        GetIdGreyedOut(id) -> bool
        
        Get whether the set of objects with tag `id` are drawn greyed out or
        not.
        """

    def FindObjects(self, x, y, radius=1, bg=wx.WHITE):
        """
        FindObjects(x, y, radius=1, bg=wx.WHITE) -> PyObject
        
        Returns a list of all the id's that draw a pixel with
        color not equal to bg within radius of (x,y). Returns an
        empty list if nothing is found.  The list is in reverse
        drawing order so list[0] is the top id.
        """

    def FindObjectsByBBox(self, x, y):
        """
        FindObjectsByBBox(x, y) -> PyObject
        
        Returns a list of all the id's whose bounding boxes include (x,y).
        Returns an empty list if nothing is found.  The list is in
        reverse drawing order so list[0] is the top id.
        """

    def DrawIdToDC(self, id, dc):
        """
        DrawIdToDC(id, dc)
        
        Draw recorded operations tagged with id to dc.
        """

    def SetIdBounds(self, id, rect):
        """
        SetIdBounds(id, rect)
        
        Set the bounding rect of a given object.
        This will create an object node if one doesn't exist.
        """

    def GetIdBounds(self, id):
        """
        GetIdBounds(id) -> wx.Rect
        
        Returns the bounding rectangle previously set with `SetIdBounds`.
        If no bounds have been set, it returns wx.Rect(0,0,0,0).
        """

    def DrawToDCClipped(self, dc, rect):
        """
        DrawToDCClipped(dc, rect)
        
        Draws the recorded operations to dc,
        unless the operation is known to be outside of rect.
        """

    def DrawToDCClippedRgn(self, dc, region):
        """
        DrawToDCClippedRgn(dc, region)
        
        Draws the recorded operations to dc,
        unless the operation is known to be outside the given region.
        """

    def DrawToDC(self, dc):
        """
        DrawToDC(dc)
        
        Draws the recorded operations to dc.
        """

    def FloodFill(self, *args, **kw):
        """
        FloodFill(x, y, col, style=wx.FLOOD_SURFACE)
        FloodFill(pt, col, style=wx.FLOOD_SURFACE)
        
        Flood fills the device context starting from the given point,
        using the current brush colour, and using a style:
        
            - ``wx.FLOOD_SURFACE``: the flooding occurs until a colour other
        than the given colour is encountered.
        
            - ``wx.FLOOD_BORDER``: the area to be flooded is bounded by the
        given colour.
        """

    def DrawLine(self, *args, **kw):
        """
        DrawLine(x1, y1, x2, y2)
        DrawLine(pt1, pt2)
        
        Draws a line from the first point to the second.
        The current pen is used for drawing the line. Note that
        the second point is *not* part of the line and is not
        drawn by this function (this is consistent with the
        behaviour of many other toolkits).
        """

    def CrossHair(self, *args, **kw):
        """
        CrossHair(x, y)
        CrossHair(pt)
        
        Displays a cross hair using the current pen. This is a
        vertical and horizontal line the height and width of the
        window, centred on the given point.
        """

    def DrawArc(self, x1, y1, x2, y2, xc, yc):
        """
        DrawArc(x1, y1, x2, y2, xc, yc)
        
        Draws an arc of a circle, centred on the *center* point
        (xc, yc), from the first point to the second. The current
        pen is used for the outline and the current brush for
        filling the shape.
        
        The arc is drawn in an anticlockwise direction from the
        start point to the end point.
        """

    def DrawCheckMark(self, *args, **kw):
        """
        DrawCheckMark(x, y, width, height)
        DrawCheckMark(rect)
        
        Draws a check mark inside the given rectangle
        """

    def DrawEllipticArc(self, *args, **kw):
        """
        DrawEllipticArc(x, y, w, h, start, end)
        DrawEllipticArc(pt, sz, start, end)
        
        Draws an arc of an ellipse, with the given rectangle
        defining the bounds of the ellipse. The current pen is
        used for drawing the arc and the current brush is used for
        drawing the pie.
        
        The *start* and *end* parameters specify the start and end
        of the arc relative to the three-o'clock position from the
        center of the rectangle. Angles are specified in degrees
        (360 is a complete circle). Positive values mean
        counter-clockwise motion. If start is equal to end, a
        complete ellipse will be drawn.
        """

    def DrawPoint(self, *args, **kw):
        """
        DrawPoint(x, y)
        DrawPoint(pt)
        
        Draws a point using the current pen.
        """

    def DrawRectangle(self, *args, **kw):
        """
        DrawRectangle(x, y, width, height)
        DrawRectangle(rect)
        DrawRectangle(pt, sz)
        
        Draws a rectangle with the given top left corner, and with
        the given size. The current pen is used for the outline
        and the current brush for filling the shape.
        """

    def DrawRoundedRectangle(self, *args, **kw):
        """
        DrawRoundedRectangle(x, y, width, height, radius)
        DrawRoundedRectangle(rect, radius)
        DrawRoundedRectangle(pt, sz, radius)
        
        Draws a rectangle with the given top left corner, and with
        the given size. The current pen is used for the outline
        and the current brush for filling the shape.
        """

    def DrawCircle(self, *args, **kw):
        """
        DrawCircle(x, y, radius)
        DrawCircle(pt, radius)
        
        Draws a circle with the given center point and radius.
        The current pen is used for the outline and the current
        brush for filling the shape.
        
        :see: `DrawEllipse`
        """

    def DrawEllipse(self, *args, **kw):
        """
        DrawEllipse(x, y, width, height)
        DrawEllipse(rect)
        DrawEllipse(pt, sz)
        
        Draws an ellipse contained in the specified rectangle. The current pen
        is used for the outline and the current brush for filling the shape.",
        "
        
        :see: `DrawCircle`
        """

    def DrawIcon(self, *args, **kw):
        """
        DrawIcon(icon, x, y)
        DrawIcon(icon, pt)
        
        Draw an icon on the display at the given position.
        """

    def DrawBitmap(self, *args, **kw):
        """
        DrawBitmap(bmp, x, y, useMask=False)
        DrawBitmap(bmp, pt, useMask=False)
        
        Draw a bitmap on the device context at the specified
        point. If *useMask* is true and the bitmap has a
        transparency mask, (or alpha channel on the platforms that
        support it) then the bitmap will be drawn transparently.
        
        When drawing a mono-bitmap, the current text foreground
        colour will be used to draw the foreground of the bitmap
        (all bits set to 1), and the current text background
        colour to draw the background (all bits set to 0).
        
        :see: `SetTextForeground`, `SetTextBackground` and `wx.MemoryDC`
        """

    def DrawText(self, *args, **kw):
        """
        DrawText(text, x, y)
        DrawText(text, pt)
        
        Draws a text string at the specified point, using the
        current text font, and the current text foreground and
        background colours.
        
        The coordinates refer to the top-left corner of the
        rectangle bounding the string. See `wx.DC.GetTextExtent`
        for how to get the dimensions of a text string, which can
        be used to position the text more precisely, (you will
        need to use a real DC with GetTextExtent as wx.PseudoDC
        does not implement it.)
        
        **NOTE**: under wxGTK the current logical function is used
        *by this function but it is ignored by wxMSW. Thus, you
        *should avoid using logical functions with this function
        *in portable programs.", "
        
        :see: `DrawRotatedText`
        """

    def DrawRotatedText(self, *args, **kw):
        """
        DrawRotatedText(text, x, y, angle)
        DrawRotatedText(text, pt, angle)
        
        Draws the text rotated by *angle* degrees, if supported by the
        platform.
        """

    def DrawLabel(self, *args, **kw):
        """
        DrawLabel(text, rect, alignment=wx.ALIGN_LEFT|wx.ALIGN_TOP, indexAccel=-1)
        DrawLabel(text, image, rect, alignment=wx.ALIGN_LEFT|wx.ALIGN_TOP, indexAccel=-1)
        
        Draw *text* within the specified rectangle, abiding by the
        alignment flags.  Will additionally emphasize the
        character at *indexAccel* if it is not -1.
        """

    def Clear(self):
        """
        Clear()
        
        Clears the device context using the current background brush.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets the current font for the DC. It must be a valid font, in
        particular you should not pass ``wx.NullFont`` to this method.
        
        :see: `wx.Font`
        """

    def SetPen(self, pen):
        """
        SetPen(pen)
        
        Sets the current pen for the DC.
        
        If the argument is ``wx.NullPen``, the current pen is selected out of
        the
        device context, and the original pen restored.
        
        :see: `wx.Pen`
        """

    def SetBrush(self, brush):
        """
        SetBrush(brush)
        
        Sets the current brush for the DC.
        
        If the argument is ``wx.NullBrush``, the current brush is selected out
        of the device context, and the original brush restored, allowing the
        current brush to be destroyed safely.
        
        :see: `wx.Brush`
        """

    def SetBackground(self, brush):
        """
        SetBackground(brush)
        
        Sets the current background brush for the DC.
        """

    def SetBackgroundMode(self, mode):
        """
        SetBackgroundMode(mode)
        
        The *mode* parameter may be one of ``wx.SOLID`` and
        ``wx.TRANSPARENT``. This setting determines whether text
        will be drawn with a background colour or not.
        """

    def SetTextForeground(self, colour):
        """
        SetTextForeground(colour)
        
        Sets the current text foreground colour for the DC.
        """

    def SetTextBackground(self, colour):
        """
        SetTextBackground(colour)
        
        Sets the current text background colour for the DC.
        """

    def SetLogicalFunction(self, function):
        """
        SetLogicalFunction(function)
        
        Sets the current logical function for the device context. This
        determines how a source pixel (from a pen or brush colour, combines
        with a destination pixel in the current device context.
        
        The possible values and their meaning in terms of source and
        destination pixel values are defined in the
        :ref:`wx.RasterOperationMode`
        enumeration.
        
        The default is wx.COPY, which simply draws with the current
        colour. The others combine the current colour and the background using
        a logical operation. wx.INVERT is commonly used for drawing rubber
        bands or moving outlines, since drawing twice reverts to the original
        colour.
        """

    def DrawLines(self, points, xoffset=0, yoffset=0):
        """
        DrawLines(points, xoffset=0, yoffset=0)
        
        Draws lines using a sequence of `wx.Point` objects, adding the
        optional offset coordinate. The current pen is used for drawing the
        lines.
        """

    def DrawPolygon(self, points, xoffset=0, yoffset=0, fillStyle=wx.ODDEVEN_RULE):
        """
        DrawPolygon(points, xoffset=0, yoffset=0, fillStyle=wx.ODDEVEN_RULE)
        
        Draws a filled polygon using a sequence of `wx.Point` objects, adding
        the optional offset coordinate.  The last argument specifies the fill
        rule: ``wx.ODDEVEN_RULE`` (the default) or ``wx.WINDING_RULE``.
        
        The current pen is used for drawing the outline, and the current brush
        for filling the shape. Using a transparent brush suppresses
        filling. Note that wxWidgets automatically closes the first and last
        points.
        """

    def DrawSpline(self, points):
        """
        DrawSpline(points)
        
        Draws a spline between all given control points, (a list of `wx.Point`
        objects) using the current pen. The spline is drawn using a series of
        lines, using an algorithm taken from the X drawing program 'XFIG'.
        """

    BeginDrawing = wx.deprecated(lambda *args: None, 'BeginDrawing has been removed.')
    EndDrawing = wx.deprecated(lambda *args: None, 'EndDrawing has been removed.')
    FloodFillPoint = wx.deprecated(FloodFill, 'Use FloodFill instead.')
    DrawLinePoint = wx.deprecated(DrawLine, 'Use DrawLine instead.')
    CrossHairPoint = wx.deprecated(CrossHair, 'Use CrossHair instead.')
    DrawArcPoint = wx.deprecated(DrawArc, 'Use DrawArc instead.')
    DrawCheckMarkRect = wx.deprecated(DrawCheckMark, 'Use DrawArc instead.')
    DrawEllipticArcPointSize = wx.deprecated(DrawEllipticArc, 'Use DrawEllipticArc instead.')
    DrawPointPoint = wx.deprecated(DrawPoint, 'Use DrawPoint instead.')
    DrawRectangleRect = wx.deprecated(DrawRectangle, 'Use DrawRectangle instead.')
    DrawRectanglePointSize = wx.deprecated(DrawRectangle, 'Use DrawRectangle instead.')
    DrawRoundedRectangleRect = wx.deprecated(DrawRoundedRectangle, 'Use DrawRectangle instead.')
    DrawRoundedRectanglePointSize = wx.deprecated(DrawRoundedRectangle, 'Use DrawRectangle instead.')
    DrawCirclePoint = wx.deprecated(DrawCircle, 'Use DrawCircle instead.')
    DrawEllipseRect = wx.deprecated(DrawEllipse, 'Use DrawEllipse instead.')
    DrawEllipsePointSize = wx.deprecated(DrawEllipse, 'Use DrawEllipse instead.')
    DrawIconPoint = wx.deprecated(DrawIcon, 'Use DrawIcon instead.')
    DrawBitmapPoint = wx.deprecated(DrawBitmap, 'Use DrawBitmap instead.')
    DrawTextPoint = wx.deprecated(DrawText, 'Use DrawText instead.')
    DrawRotatedTextPoint = wx.deprecated(DrawRotatedText, 'Use DrawRotatedText instead.')
    DrawImageLabel = wx.deprecated(DrawLabel, 'Use DrawLabel instead.')
    Len = property(None, None)
# end of class PseudoDC

#-- end-pseudodc --#
#-- begin-propdlg --#
PROPSHEET_DEFAULT = 0
PROPSHEET_NOTEBOOK = 0
PROPSHEET_TOOLBOOK = 0
PROPSHEET_CHOICEBOOK = 0
PROPSHEET_LISTBOOK = 0
PROPSHEET_BUTTONTOOLBOOK = 0
PROPSHEET_TREEBOOK = 0
PROPSHEET_SHRINKTOFIT = 0

class PropertySheetDialog(wx.Dialog):
    """
    PropertySheetDialog()
    PropertySheetDialog(parent, id=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE, name=wx.DialogNameStr)
    
    This class represents a property sheet dialog: a tabbed dialog for
    showing settings.
    """

    def __init__(self, *args, **kw):
        """
        PropertySheetDialog()
        PropertySheetDialog(parent, id=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE, name=wx.DialogNameStr)
        
        This class represents a property sheet dialog: a tabbed dialog for
        showing settings.
        """

    def AddBookCtrl(self, sizer):
        """
        AddBookCtrl(sizer)
        
        Override this if you wish to add the book control in a way different
        from the standard way (for example, using different spacing).
        """

    def Create(self, parent, id=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE, name=wx.DialogNameStr):
        """
        Create(parent, id=wx.ID_ANY, title=wx.EmptyString, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.DEFAULT_DIALOG_STYLE, name=wx.DialogNameStr) -> bool
        
        Call this from your own Create function, before adding buttons and
        pages.
        """

    def CreateBookCtrl(self):
        """
        CreateBookCtrl() -> wx.BookCtrlBase
        
        Override this if you wish to create a different kind of book control;
        by default, the value passed to SetSheetStyle() is used to determine
        the control.
        """

    def CreateButtons(self, flags=wx.OK|wx.CANCEL):
        """
        CreateButtons(flags=wx.OK|wx.CANCEL)
        
        Call this to create the buttons for the dialog.
        """

    def GetBookCtrl(self):
        """
        GetBookCtrl() -> wx.BookCtrlBase
        
        Returns the book control that will contain your settings pages.
        """

    def GetInnerSizer(self):
        """
        GetInnerSizer() -> wx.Sizer
        
        Returns the inner sizer that contains the book control and button
        sizer.
        """

    def SetInnerSizer(self, sizer):
        """
        SetInnerSizer(sizer)
        
        Set the inner sizer that contains the book control and button sizer.
        """

    def GetSheetStyle(self):
        """
        GetSheetStyle() -> long
        
        Returns the sheet style.
        """

    def LayoutDialog(self, centreFlags=wx.BOTH):
        """
        LayoutDialog(centreFlags=wx.BOTH)
        
        Call this to lay out the dialog.
        """

    def SetBookCtrl(self, bookCtrl):
        """
        SetBookCtrl(bookCtrl)
        
        Sets the book control used for the dialog.
        """

    def SetSheetStyle(self, style):
        """
        SetSheetStyle(style)
        
        You can customize the look and feel of the dialog by setting the sheet
        style.
        """

    def SetSheetOuterBorder(self, border):
        """
        SetSheetOuterBorder(border)
        
        Set the border around the whole dialog.
        """

    def GetSheetOuterBorder(self):
        """
        GetSheetOuterBorder() -> int
        
        Returns the border around the whole dialog.
        """

    def SetSheetInnerBorder(self, border):
        """
        SetSheetInnerBorder(border)
        
        Set the border around the book control only.
        """

    def GetSheetInnerBorder(self):
        """
        GetSheetInnerBorder() -> int
        
        Returns the border around the book control only.
        """

    def GetContentWindow(self):
        """
        GetContentWindow() -> wx.Window
        
        Override this to return a window containing the main content of the
        dialog.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    BookCtrl = property(None, None)
    ContentWindow = property(None, None)
    InnerSizer = property(None, None)
    SheetInnerBorder = property(None, None)
    SheetOuterBorder = property(None, None)
    SheetStyle = property(None, None)
# end of class PropertySheetDialog

#-- end-propdlg --#
