/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.IamHelper;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.redshiftserverless.AWSRedshiftServerlessClient;
import com.amazonaws.services.redshiftserverless.AWSRedshiftServerlessClientBuilder;
import com.amazonaws.services.redshiftserverless.model.Endpoint;
import com.amazonaws.services.redshiftserverless.model.GetCredentialsRequest;
import com.amazonaws.services.redshiftserverless.model.GetCredentialsResult;
import com.amazonaws.services.redshiftserverless.model.GetWorkgroupRequest;
import com.amazonaws.services.redshiftserverless.model.GetWorkgroupResult;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class ServerlessIamHelper {
    private RedshiftLogger log;
    private AWSRedshiftServerlessClient client;
    private static Map<String, GetCredentialsResult> credentialsCache = new HashMap<String, GetCredentialsResult>();

    ServerlessIamHelper(RedshiftJDBCSettings settings, RedshiftLogger log, AWSCredentialsProvider credProvider) {
        this.log = log;
        AWSRedshiftServerlessClientBuilder builder = AWSRedshiftServerlessClientBuilder.standard();
        builder = (AWSRedshiftServerlessClientBuilder)IamHelper.setBuilderConfiguration(settings, log, (AwsClientBuilder)builder);
        this.client = (AWSRedshiftServerlessClient)((AWSRedshiftServerlessClientBuilder)builder.withCredentials(credProvider)).build();
    }

    synchronized void describeConfiguration(RedshiftJDBCSettings settings) {
        GetWorkgroupRequest req = new GetWorkgroupRequest();
        if (settings.m_workGroup == null || settings.m_workGroup.length() <= 0) {
            throw new AmazonClientException("Serverless workgroup is not set.");
        }
        req.setWorkgroupName(settings.m_workGroup);
        GetWorkgroupResult resp = this.client.getWorkgroup(req);
        Endpoint endpoint = resp.getWorkgroup().getEndpoint();
        if (null == endpoint) {
            throw new AmazonClientException("Serverless endpoint is not available yet.");
        }
        settings.m_host = endpoint.getAddress();
        settings.m_port = endpoint.getPort();
    }

    synchronized void getCredentialsResult(RedshiftJDBCSettings settings, IamHelper.CredentialProviderType providerType, boolean idpCredentialsRefresh) throws AmazonClientException {
        String key = null;
        GetCredentialsResult credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsCacheKey(settings, providerType, true);
            credentials = credentialsCache.get(key);
        }
        if (credentials == null || providerType == IamHelper.CredentialProviderType.PLUGIN && idpCredentialsRefresh || credentials.getExpiration().before(new Date(System.currentTimeMillis() - 300000L))) {
            if (RedshiftLogger.isEnable()) {
                this.log.logInfo("GetCredentials NOT from cache", new Object[0]);
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.remove(key);
            }
            GetCredentialsRequest request = new GetCredentialsRequest();
            if (settings.m_iamDuration > 0) {
                request.setDurationSeconds(Integer.valueOf(settings.m_iamDuration));
            }
            request.setDbName(settings.m_Schema);
            if (settings.m_workGroup != null && settings.m_workGroup.length() > 0) {
                request.setWorkgroupName(settings.m_workGroup);
            }
            if (RedshiftLogger.isEnable()) {
                this.log.logInfo(request.toString(), new Object[0]);
            }
            for (int i = 0; i < 5; ++i) {
                try {
                    credentials = this.client.getCredentials(request);
                    break;
                }
                catch (AmazonClientException ace) {
                    IamHelper.checkForApiCallRateExceedError(ace, i, "getCredentialsResult", this.log);
                    continue;
                }
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            this.log.logInfo("GetCredentials from cache", new Object[0]);
        }
        settings.m_username = credentials.getDbUser();
        settings.m_password = credentials.getDbPassword();
        if (RedshiftLogger.isEnable()) {
            Date now = new Date();
            this.log.logInfo(now + ": Using GetCredentialsResult with expiration " + credentials.getExpiration(), new Object[0]);
            this.log.logInfo(now + ": Using GetCredentialsResultV2 with TimeToRefresh " + credentials.getNextRefreshTime(), new Object[0]);
        }
    }
}

