/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.crypto.lms;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.crypto.lms.LMS;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;

public class LMSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    LMSKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (LMSKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom secureRandom = this.param.getRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = LMS.generateKeys(this.param.getParameters().getLMSigParam(), this.param.getParameters().getLMOTSParam(), 0, byArray, byArray2);
        return new AsymmetricCipherKeyPair(lMSPrivateKeyParameters.getPublicKey(), lMSPrivateKeyParameters);
    }
}

