/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.api.pathtemplate.PathTemplate;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.Notification;
import net.snowflake.client.jdbc.internal.google.common.base.Function;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;

public class NotificationInfo
implements Serializable {
    private static final long serialVersionUID = 5725883368559753810L;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/topics/{topic}");
    static final Function<Notification, NotificationInfo> FROM_PB_FUNCTION = new Function<Notification, NotificationInfo>(){

        @Override
        public NotificationInfo apply(Notification pb) {
            return NotificationInfo.fromPb(pb);
        }
    };
    static final Function<NotificationInfo, Notification> TO_PB_FUNCTION = new Function<NotificationInfo, Notification>(){

        @Override
        public Notification apply(NotificationInfo NotificationInfo2) {
            return NotificationInfo2.toPb();
        }
    };
    private final String notificationId;
    private final String topic;
    private final List<EventType> eventTypes;
    private final Map<String, String> customAttributes;
    private final PayloadFormat payloadFormat;
    private final String objectNamePrefix;
    private final String etag;
    private final String selfLink;

    NotificationInfo(BuilderImpl builder) {
        this.notificationId = builder.notificationId;
        this.etag = builder.etag;
        this.selfLink = builder.selfLink;
        this.topic = builder.topic;
        this.eventTypes = builder.eventTypes;
        this.customAttributes = builder.customAttributes;
        this.payloadFormat = builder.payloadFormat;
        this.objectNamePrefix = builder.objectNamePrefix;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public PayloadFormat getPayloadFormat() {
        return this.payloadFormat;
    }

    public String getObjectNamePrefix() {
        return this.objectNamePrefix;
    }

    public String getEtag() {
        return this.etag;
    }

    public List<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public int hashCode() {
        return this.toPb().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(NotificationInfo.class) && Objects.equals(this.toPb(), ((NotificationInfo)obj).toPb());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("topic", this.topic).toString();
    }

    Notification toPb() {
        Notification notificationPb = new Notification();
        if (this.notificationId != null) {
            notificationPb.setId(this.notificationId);
        }
        notificationPb.setEtag(this.etag);
        if (this.customAttributes != null) {
            notificationPb.setCustomAttributes(this.customAttributes);
        }
        if (this.eventTypes != null && this.eventTypes.size() > 0) {
            ArrayList<String> eventTypesPb = new ArrayList<String>();
            for (EventType eventType : this.eventTypes) {
                eventTypesPb.add(eventType.toString());
            }
            notificationPb.setEventTypes(eventTypesPb);
        }
        if (this.objectNamePrefix != null) {
            notificationPb.setObjectNamePrefix(this.objectNamePrefix);
        }
        if (this.payloadFormat != null) {
            notificationPb.setPayloadFormat(this.payloadFormat.toString());
        } else {
            notificationPb.setPayloadFormat(PayloadFormat.NONE.toString());
        }
        notificationPb.setSelfLink(this.selfLink);
        notificationPb.setTopic(this.topic);
        return notificationPb;
    }

    public static NotificationInfo of(String topic) {
        NotificationInfo.checkTopicFormat(topic);
        return NotificationInfo.newBuilder(topic).build();
    }

    public static Builder newBuilder(String topic) {
        NotificationInfo.checkTopicFormat(topic);
        return new BuilderImpl(topic);
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static NotificationInfo fromPb(Notification notificationPb) {
        BuilderImpl builder = new BuilderImpl(notificationPb.getTopic());
        if (notificationPb.getId() != null) {
            ((Builder)builder).setNotificationId(notificationPb.getId());
        }
        if (notificationPb.getEtag() != null) {
            ((Builder)builder).setEtag(notificationPb.getEtag());
        }
        if (notificationPb.getCustomAttributes() != null) {
            ((Builder)builder).setCustomAttributes(notificationPb.getCustomAttributes());
        }
        if (notificationPb.getSelfLink() != null) {
            ((Builder)builder).setSelfLink(notificationPb.getSelfLink());
        }
        if (notificationPb.getObjectNamePrefix() != null) {
            ((Builder)builder).setObjectNamePrefix(notificationPb.getObjectNamePrefix());
        }
        if (notificationPb.getEventTypes() != null) {
            List<String> eventTypesPb = notificationPb.getEventTypes();
            EventType[] eventTypes = new EventType[eventTypesPb.size()];
            for (int index = 0; index < eventTypesPb.size(); ++index) {
                eventTypes[index] = EventType.valueOf(eventTypesPb.get(index));
            }
            ((Builder)builder).setEventTypes(eventTypes);
        }
        if (notificationPb.getPayloadFormat() != null) {
            ((Builder)builder).setPayloadFormat(PayloadFormat.valueOf(notificationPb.getPayloadFormat()));
        }
        return ((Builder)builder).build();
    }

    private static void checkTopicFormat(String topic) {
        PATH_TEMPLATE.validatedMatch(topic, "topic name must be in valid format");
    }

    public static class BuilderImpl
    extends Builder {
        private String notificationId;
        private String topic;
        private List<EventType> eventTypes;
        private Map<String, String> customAttributes;
        private PayloadFormat payloadFormat;
        private String objectNamePrefix;
        private String etag;
        private String selfLink;

        BuilderImpl(String topic) {
            this.topic = topic;
        }

        BuilderImpl(NotificationInfo notificationInfo) {
            this.notificationId = notificationInfo.notificationId;
            this.etag = notificationInfo.etag;
            this.selfLink = notificationInfo.selfLink;
            this.topic = notificationInfo.topic;
            this.eventTypes = notificationInfo.eventTypes;
            this.customAttributes = notificationInfo.customAttributes;
            this.payloadFormat = notificationInfo.payloadFormat;
            this.objectNamePrefix = notificationInfo.objectNamePrefix;
        }

        @Override
        Builder setNotificationId(String notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        @Override
        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public Builder setPayloadFormat(PayloadFormat payloadFormat) {
            this.payloadFormat = payloadFormat;
            return this;
        }

        @Override
        public Builder setObjectNamePrefix(String objectNamePrefix) {
            this.objectNamePrefix = objectNamePrefix;
            return this;
        }

        @Override
        public Builder setEventTypes(EventType ... eventTypes) {
            this.eventTypes = eventTypes != null ? Arrays.asList(eventTypes) : null;
            return this;
        }

        @Override
        public Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder setCustomAttributes(Map<String, String> customAttributes) {
            this.customAttributes = customAttributes != null ? ImmutableMap.copyOf(customAttributes) : null;
            return this;
        }

        @Override
        public NotificationInfo build() {
            Preconditions.checkNotNull(this.topic);
            NotificationInfo.checkTopicFormat(this.topic);
            return new NotificationInfo(this);
        }
    }

    public static abstract class Builder {
        Builder() {
        }

        abstract Builder setNotificationId(String var1);

        public abstract Builder setSelfLink(String var1);

        public abstract Builder setTopic(String var1);

        public abstract Builder setPayloadFormat(PayloadFormat var1);

        public abstract Builder setObjectNamePrefix(String var1);

        public abstract Builder setEventTypes(EventType ... var1);

        public abstract Builder setEtag(String var1);

        public abstract Builder setCustomAttributes(Map<String, String> var1);

        public abstract NotificationInfo build();
    }

    public static enum EventType {
        OBJECT_FINALIZE,
        OBJECT_METADATA_UPDATE,
        OBJECT_DELETE,
        OBJECT_ARCHIVE;

    }

    public static enum PayloadFormat {
        JSON_API_V1,
        NONE;

    }
}

