/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal;

import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.controller.ControllerAgentImpl;
import com.ibm.db2.cmx.internal.controller.HttpControllerAgentImpl;
import com.ibm.db2.cmx.internal.controller.NPXControllerAgentImpl;
import com.ibm.db2.cmx.internal.monitor.MonitorAgent;
import com.ibm.db2.cmx.internal.monitor.MonitorAgentImpl;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcDataSource;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Service {
    private static final String CLASSNAME = Service.class.getName();
    private static Logger logger__ = Log.getCMXClientLogger();

    public static ControllerAgent getControllerAgentForRegistration(String string) {
        if (Service.getControllerType(string) == ControllerType.OCM) {
            return new HttpControllerAgentImpl(string, null);
        }
        return new ControllerAgentImpl(string, false);
    }

    public static ControllerType getControllerType(String string) {
        if (string == null) {
            return ControllerType.NPX;
        }
        if (string != null && (string.startsWith("http://") || string.startsWith("https://"))) {
            return ControllerType.OCM;
        }
        return ControllerType.OPM;
    }

    public static ControllerAgent getControllerAgent(String string, boolean bl2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, CLASSNAME, "getControllerAgent", "ENTRY " + Arrays.deepToString(new Object[]{string, bl2}));
        }
        if (Service.getControllerType(string) == ControllerType.OCM) {
            return HttpControllerAgentImpl.getInstance(string, null, bl2);
        }
        if (Service.getControllerType(string) == ControllerType.NPX) {
            return NPXControllerAgentImpl.getInstance();
        }
        return new ControllerAgentImpl(string, bl2);
    }

    public static MonitorAgent getMonitorAgent(boolean bl2, ControllerAgent controllerAgent, int n2, String string, int n3, int n4, ProxiedJdbcDataSource proxiedJdbcDataSource, String string2, String string3, String string4, String string5, String string6) throws Exception {
        if (logger__.isLoggable(Level.FINER)) {
            logger__.entering(CLASSNAME, "getMonitorAgent");
        }
        MonitorAgentImpl monitorAgentImpl = new MonitorAgentImpl(bl2, controllerAgent, n2, string, n3, n4, proxiedJdbcDataSource, string2, string3, string4, string5, string6);
        if (logger__.isLoggable(Level.FINER)) {
            logger__.exiting(CLASSNAME, "getMonitorAgent", monitorAgentImpl);
        }
        return monitorAgentImpl;
    }

    public static enum ControllerType {
        OPM,
        OCM,
        NPX;

    }
}

