/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogItem;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Format;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class CatalogItemToolTip
extends JToolTip {
    private static final int ICON_SIZE = Math.round(128.0f * SwingTools.getResolutionScale());
    private final DisplayedInformation displayedInformation;
    private final UserPreferences preferences;
    private final JLabel itemIconLabel;
    private CatalogItem catalogItem;

    public CatalogItemToolTip(boolean bl, UserPreferences userPreferences) {
        this(bl ? DisplayedInformation.ICON_NAME_AUTHOR : DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY, userPreferences);
    }

    public CatalogItemToolTip(DisplayedInformation displayedInformation, UserPreferences userPreferences) {
        this.displayedInformation = displayedInformation;
        this.preferences = userPreferences;
        this.itemIconLabel = new JLabel();
        this.itemIconLabel.setPreferredSize(new Dimension(ICON_SIZE, ICON_SIZE));
        this.itemIconLabel.setMinimumSize(this.itemIconLabel.getPreferredSize());
        this.itemIconLabel.setHorizontalAlignment(0);
        this.itemIconLabel.setVerticalAlignment(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.itemIconLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCatalogItem(CatalogItem catalogItem) {
        if (catalogItem != this.catalogItem) {
            Object object;
            String string;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (this.preferences != null) {
                string = catalogItem.getCreator();
                if (string != null && string.length() > 0) {
                    string2 = this.preferences.getLocalizedString(CatalogItemToolTip.class, "tooltipCreator", string);
                }
                Format format = this.preferences.getLengthUnit().getFormatWithUnit();
                if (catalogItem instanceof CatalogPieceOfFurniture) {
                    object = (CatalogPieceOfFurniture)catalogItem;
                    string3 = this.preferences.getLocalizedString(CatalogItemToolTip.class, "tooltipPieceOfFurnitureDimensions", format.format(Float.valueOf(((CatalogPieceOfFurniture)object).getWidth())), format.format(Float.valueOf(((CatalogPieceOfFurniture)object).getDepth())), format.format(Float.valueOf(((CatalogPieceOfFurniture)object).getHeight())));
                    if (((CatalogPieceOfFurniture)object).getModelSize() != null && ((CatalogPieceOfFurniture)object).getModelSize() > 0L) {
                        string4 = this.preferences.getLocalizedString(CatalogItemToolTip.class, "tooltipModelSize", NumberFormat.getIntegerInstance().format(Math.max(1, (int)Math.round((double)((CatalogPieceOfFurniture)object).getModelSize().longValue() / 1000.0))));
                    }
                } else if (catalogItem instanceof CatalogTexture) {
                    object = (CatalogTexture)catalogItem;
                    string3 = this.preferences.getLocalizedString(CatalogItemToolTip.class, "tooltipTextureDimensions", format.format(Float.valueOf(((CatalogTexture)object).getWidth())), format.format(Float.valueOf(((CatalogTexture)object).getHeight())));
                }
            }
            boolean bl = false;
            if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
                if (this.displayedInformation != DisplayedInformation.ICON) {
                    string = "<html><center>";
                    if (this.displayedInformation == DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY && catalogItem instanceof CatalogPieceOfFurniture) {
                        string = string + "- <b>" + ((CatalogPieceOfFurniture)catalogItem).getCategory().getName() + "</b> -<br>";
                    }
                    string = string + "<b>" + catalogItem.getName() + "</b>";
                    if (string3 != null) {
                        string = string + "<br>" + string3;
                    }
                    if (string4 != null) {
                        string = string + "<br>" + string4;
                    }
                    if (string2 != null) {
                        string = string + "<br>" + string2;
                    }
                    string = string + "</center>";
                } else {
                    string = "";
                }
            } else if (this.isTipTextComplete()) {
                bl = true;
                string = "<html><table>";
                if (this.displayedInformation != DisplayedInformation.ICON) {
                    string = string + "<tr><td align='center'>";
                    if (this.displayedInformation == DisplayedInformation.ICON_NAME_AUTHOR_CATEGORY && catalogItem instanceof CatalogPieceOfFurniture) {
                        string = string + "- <b>" + ((CatalogPieceOfFurniture)catalogItem).getCategory().getName() + "</b> -<br>";
                    }
                    string = string + "<b>" + catalogItem.getName() + "</b>";
                    if (string3 != null) {
                        string = string + "<br>" + string3;
                    }
                    if (string4 != null) {
                        string = string + "<br>" + string4;
                    }
                    if (string2 != null) {
                        string = string + "<br>" + string2;
                    }
                    string = string + "</td></tr>";
                }
            } else if (this.displayedInformation != DisplayedInformation.ICON) {
                string = catalogItem.getName();
                if (string2 != null) {
                    string = string + " " + string2;
                }
            } else {
                string = null;
            }
            this.itemIconLabel.setIcon(null);
            if (catalogItem.getIcon() instanceof URLContent) {
                object = null;
                try {
                    object = catalogItem.getIcon().openStream();
                    BufferedImage bufferedImage = ImageIO.read((InputStream)object);
                    if (bufferedImage != null) {
                        int n = Math.round((float)ICON_SIZE * Math.min(1.0f, (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight()));
                        int n2 = Math.round((float)n * (float)bufferedImage.getHeight() / (float)bufferedImage.getWidth());
                        if (bl) {
                            string = string + "<tr><td width='" + ICON_SIZE + "' height='" + ICON_SIZE + "' align='center' valign='middle'><img width='" + n + "' height='" + n2 + "' src='" + ((URLContent)catalogItem.getIcon()).getURL() + "'></td></tr>";
                        } else {
                            this.itemIconLabel.setIcon(new ImageIcon(bufferedImage.getHeight() != n2 ? bufferedImage.getScaledInstance(n, n2, 4) : bufferedImage));
                        }
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (bl) {
                string = string + "</table>";
            }
            this.setTipText(string);
            this.catalogItem = catalogItem;
        }
    }

    public boolean isTipTextComplete() {
        return !OperatingSystem.isJavaVersionGreaterOrEqual("1.6") && OperatingSystem.isMacOSX();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.itemIconLabel.getIcon() != null) {
            if (OperatingSystem.isWindows() && OperatingSystem.isJavaVersionBetween("10", "16")) {
                dimension.width += 8;
            }
            dimension.width = Math.max(dimension.width, ICON_SIZE + Math.round(8.0f * SwingTools.getResolutionScale()));
            dimension.height += ICON_SIZE + Math.round(8.0f * SwingTools.getResolutionScale());
        }
        return dimension;
    }

    public static enum DisplayedInformation {
        ICON,
        ICON_NAME_AUTHOR,
        ICON_NAME_AUTHOR_CATEGORY;

    }
}

