"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIZ_CONTAIN_XY_AXIS = exports.VALUEFIELD = exports.UNSELECTED_FIELDS = exports.UNITS_OF_MEASURE = exports.TIME_INTERVAL_OPTIONS = exports.TIME_FIELD = exports.TIMESTAMP = exports.TAB_TITLE = exports.TAB_ID_TXT_PFX = exports.TAB_EVENT_TITLE = exports.TAB_EVENT_ID_TXT_PFX = exports.TAB_EVENT_ID = exports.TAB_CREATED_TYPE = exports.TAB_CHART_TITLE = exports.TAB_CHART_ID_TXT_PFX = exports.TAB_CHART_ID = exports.SPAN = exports.SIMILAR_VIZ_TYPES = exports.SELECTED_TIMESTAMP = exports.SELECTED_QUERY_TAB = exports.SELECTED_PATTERN_FIELD = exports.SELECTED_FIELDS = exports.SELECTED_DATE_RANGE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECT_TYPE = exports.SAVED_OBJECT_ID = exports.ROW_DENSITIES = exports.REDUX_EXPL_SLICE_VISUALIZATION = exports.REDUX_EXPL_SLICE_QUERY_TABS = exports.REDUX_EXPL_SLICE_QUERY_RESULT = exports.REDUX_EXPL_SLICE_QUERIES = exports.REDUX_EXPL_SLICE_PATTERNS = exports.REDUX_EXPL_SLICE_FIELDS = exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = exports.REDIRECT_TAB = exports.RAW_QUERY = exports.QUERY_TAB_IDS = exports.QUERIED_FIELDS = exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = exports.PLOTLY_PIE_COLUMN_NUMBER = exports.PLOTLY_GAUGE_COLUMN_NUMBER = exports.PIE_YAXIS_GAP = exports.PIE_XAXIS_GAP = exports.PATTERN_REGEX = exports.PATTERNS_REGEX = exports.PATTERNS_EXTRACTOR_REGEX = exports.PARENTFIELDS = exports.PAGE_SIZE = exports.OTEL_TRACE_ID = exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = exports.NUMERICAL_TYPES = exports.NUMBER_INPUT_MIN_LIMIT = exports.NEW_TAB = exports.NEW_SELECTED_QUERY_TAB = exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = exports.METRICS_AXIS_MARGIN = exports.METRICS_ANNOTATION = exports.INDEX = exports.HEADER_HEIGHT = exports.HAS_SAVED_TIMESTAMP = exports.GROUPBY = exports.GRID_PAGE_SIZES = exports.GRID_PAGE_RANGE_DISPLAY = exports.GRID_HEADER_COLUMN_MAX_WIDTH = exports.FINAL_QUERY = exports.FILTER_OPTIONS = exports.FILTERED_PATTERN = exports.EVENT_ANALYTICS_DOCUMENTATION_URL = exports.DISABLED_COLOUR = exports.DEFAULT_PIE_CHART_PARAMETERS = exports.DEFAULT_METRICS_CHART_PARAMETERS = exports.DEFAULT_GAUGE_CHART_PARAMETERS = exports.DEFAULT_COLUMNS = exports.DEFAULT_BAR_CHART_STYLES = exports.DEFAULT_AVAILABILITY_QUERY = exports.DATE_PICKER_FORMAT = exports.DATA_CONFIG_HINTS_INFO = exports.ConfigChartOptionsEnum = exports.CUSTOM_LABEL = exports.COLUMN_DEFAULT_MIN_WIDTH = exports.CHILDFIELD = exports.BREAKDOWNS = exports.AVAILABLE_FIELDS = exports.APP_ANALYTICS_TAB_ID_REGEX = exports.AGGREGATION_OPTIONS = exports.AGGREGATIONS = exports.ADD_BUTTON_TEXT = void 0;

var _eui = require("@elastic/eui");

var _shared = require("./shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const EVENT_ANALYTICS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/event-analytics/';
exports.EVENT_ANALYTICS_DOCUMENTATION_URL = EVENT_ANALYTICS_DOCUMENTATION_URL;
const OPEN_TELEMETRY_LOG_CORRELATION_LINK = 'https://opentelemetry.io/docs/reference/specification/logs/overview/#log-correlation';
exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = OPEN_TELEMETRY_LOG_CORRELATION_LINK;
const RAW_QUERY = 'rawQuery';
exports.RAW_QUERY = RAW_QUERY;
const FINAL_QUERY = 'finalQuery';
exports.FINAL_QUERY = FINAL_QUERY;
const SELECTED_DATE_RANGE = 'selectedDateRange';
exports.SELECTED_DATE_RANGE = SELECTED_DATE_RANGE;
const INDEX = 'index';
exports.INDEX = INDEX;
const SELECTED_PATTERN_FIELD = 'selectedPatternField';
exports.SELECTED_PATTERN_FIELD = SELECTED_PATTERN_FIELD;
const PATTERN_REGEX = 'patternRegex';
exports.PATTERN_REGEX = PATTERN_REGEX;
const FILTERED_PATTERN = 'filteredPattern';
exports.FILTERED_PATTERN = FILTERED_PATTERN;
const SELECTED_TIMESTAMP = 'selectedTimestamp';
exports.SELECTED_TIMESTAMP = SELECTED_TIMESTAMP;
const SELECTED_FIELDS = 'selectedFields';
exports.SELECTED_FIELDS = SELECTED_FIELDS;
const UNSELECTED_FIELDS = 'unselectedFields';
exports.UNSELECTED_FIELDS = UNSELECTED_FIELDS;
const AVAILABLE_FIELDS = 'availableFields';
exports.AVAILABLE_FIELDS = AVAILABLE_FIELDS;
const QUERIED_FIELDS = 'queriedFields';
exports.QUERIED_FIELDS = QUERIED_FIELDS;
const TAB_ID_TXT_PFX = 'query-panel-';
exports.TAB_ID_TXT_PFX = TAB_ID_TXT_PFX;
const TAB_TITLE = 'New query';
exports.TAB_TITLE = TAB_TITLE;
const TAB_CHART_TITLE = 'Visualizations';
exports.TAB_CHART_TITLE = TAB_CHART_TITLE;
const TAB_EVENT_TITLE = 'Events';
exports.TAB_EVENT_TITLE = TAB_EVENT_TITLE;
const TAB_EVENT_ID_TXT_PFX = 'main-content-events-';
exports.TAB_EVENT_ID_TXT_PFX = TAB_EVENT_ID_TXT_PFX;
const TAB_CHART_ID_TXT_PFX = 'main-content-vis-';
exports.TAB_CHART_ID_TXT_PFX = TAB_CHART_ID_TXT_PFX;
const TAB_EVENT_ID = 'main-content-events';
exports.TAB_EVENT_ID = TAB_EVENT_ID;
const TAB_CHART_ID = 'main-content-vis';
exports.TAB_CHART_ID = TAB_CHART_ID;
const HAS_SAVED_TIMESTAMP = 'hasSavedTimestamp';
exports.HAS_SAVED_TIMESTAMP = HAS_SAVED_TIMESTAMP;
const FILTER_OPTIONS = ['Visualization', 'Query', 'Metric'];
exports.FILTER_OPTIONS = FILTER_OPTIONS;
const SAVED_QUERY = 'savedQuery';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = 'savedVisualization';
exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const SAVED_OBJECT_ID = 'savedObjectId';
exports.SAVED_OBJECT_ID = SAVED_OBJECT_ID;
const SAVED_OBJECT_TYPE = 'objectType';
exports.SAVED_OBJECT_TYPE = SAVED_OBJECT_TYPE;
const TAB_CREATED_TYPE = 'tabCreatedType';
exports.TAB_CREATED_TYPE = TAB_CREATED_TYPE;
const NEW_TAB = 'newTab';
exports.NEW_TAB = NEW_TAB;
const REDIRECT_TAB = 'redirect_tab';
exports.REDIRECT_TAB = REDIRECT_TAB;
const PAGE_SIZE = 50;
exports.PAGE_SIZE = PAGE_SIZE;
const DEFAULT_COLUMNS = ['', 'Time', '_source'];
exports.DEFAULT_COLUMNS = DEFAULT_COLUMNS;
const OTEL_TRACE_ID = 'traceId';
exports.OTEL_TRACE_ID = OTEL_TRACE_ID;
const DATE_PICKER_FORMAT = 'YYYY-MM-DD HH:mm:ss';
exports.DATE_PICKER_FORMAT = DATE_PICKER_FORMAT;
const TIME_INTERVAL_OPTIONS = [{
  text: 'Minute',
  value: 'm'
}, {
  text: 'Hour',
  value: 'h'
}, {
  text: 'Day',
  value: 'd'
}, {
  text: 'Week',
  value: 'w'
}, {
  text: 'Month',
  value: 'M'
}, {
  text: 'Year',
  value: 'y'
}]; // redux

exports.TIME_INTERVAL_OPTIONS = TIME_INTERVAL_OPTIONS;
const SELECTED_QUERY_TAB = 'selectedQueryTab';
exports.SELECTED_QUERY_TAB = SELECTED_QUERY_TAB;
const QUERY_TAB_IDS = 'queryTabIds';
exports.QUERY_TAB_IDS = QUERY_TAB_IDS;
const NEW_SELECTED_QUERY_TAB = 'newSelectedQueryTab';
exports.NEW_SELECTED_QUERY_TAB = NEW_SELECTED_QUERY_TAB;
const REDUX_EXPL_SLICE_QUERIES = 'queries';
exports.REDUX_EXPL_SLICE_QUERIES = REDUX_EXPL_SLICE_QUERIES;
const REDUX_EXPL_SLICE_QUERY_RESULT = 'queryResults';
exports.REDUX_EXPL_SLICE_QUERY_RESULT = REDUX_EXPL_SLICE_QUERY_RESULT;
const REDUX_EXPL_SLICE_FIELDS = 'fields';
exports.REDUX_EXPL_SLICE_FIELDS = REDUX_EXPL_SLICE_FIELDS;
const REDUX_EXPL_SLICE_QUERY_TABS = 'queryTabs';
exports.REDUX_EXPL_SLICE_QUERY_TABS = REDUX_EXPL_SLICE_QUERY_TABS;
const REDUX_EXPL_SLICE_VISUALIZATION = 'explorerVisualization';
exports.REDUX_EXPL_SLICE_VISUALIZATION = REDUX_EXPL_SLICE_VISUALIZATION;
const REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = 'countDistributionVisualization';
exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = REDUX_EXPL_SLICE_COUNT_DISTRIBUTION;
const REDUX_EXPL_SLICE_PATTERNS = 'patterns';
exports.REDUX_EXPL_SLICE_PATTERNS = REDUX_EXPL_SLICE_PATTERNS;
const PLOTLY_GAUGE_COLUMN_NUMBER = 4;
exports.PLOTLY_GAUGE_COLUMN_NUMBER = PLOTLY_GAUGE_COLUMN_NUMBER;
const APP_ANALYTICS_TAB_ID_REGEX = /application-analytics-tab.+/;
exports.APP_ANALYTICS_TAB_ID_REGEX = APP_ANALYTICS_TAB_ID_REGEX;
const DEFAULT_AVAILABILITY_QUERY = 'stats count() by span( timestamp, 1h )';
exports.DEFAULT_AVAILABILITY_QUERY = DEFAULT_AVAILABILITY_QUERY;
const PPL_DEFAULT_PATTERN_REGEX_FILETER = '[a-zA-Z\\d]'; // Greedily matches the longest substring for example (patterns referer | patterns pattern='[0-9]' message | where ...) used to modify the query for patterns table

exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = PPL_DEFAULT_PATTERN_REGEX_FILETER;
const PATTERNS_REGEX = /\|\s*patterns.+?\|.*\s*where\s+patterns_field\s*\=\s*'[^a-zA-Z0-9]+'/; // Used to extract the initial pattern applied

exports.PATTERNS_REGEX = PATTERNS_REGEX;
const PATTERNS_EXTRACTOR_REGEX = /patterns\s+(?<pattern>\S+)/;
exports.PATTERNS_EXTRACTOR_REGEX = PATTERNS_EXTRACTOR_REGEX;
const ADD_BUTTON_TEXT = '+ Add color theme';
exports.ADD_BUTTON_TEXT = ADD_BUTTON_TEXT;
const NUMBER_INPUT_MIN_LIMIT = 1;
exports.NUMBER_INPUT_MIN_LIMIT = NUMBER_INPUT_MIN_LIMIT;
const VIZ_CONTAIN_XY_AXIS = [_shared.VIS_CHART_TYPES.Bar, _shared.VIS_CHART_TYPES.Histogram, _shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Pie, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar]; // default ppl aggregation method options

exports.VIZ_CONTAIN_XY_AXIS = VIZ_CONTAIN_XY_AXIS;
const AGGREGATION_OPTIONS = [{
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}, {
  label: 'var_samp'
}, {
  label: 'var_pop'
}, {
  label: 'stddev_samp'
}, {
  label: 'stddev_pop'
}]; // numeric fields type for metrics

exports.AGGREGATION_OPTIONS = AGGREGATION_OPTIONS;
const NUMERICAL_TYPES = ['float', 'double', 'bigint', 'long', 'octet', 'short', 'byte', 'integer']; // Data table constants

exports.NUMERICAL_TYPES = NUMERICAL_TYPES;
const GRID_HEADER_COLUMN_MAX_WIDTH = '150px';
exports.GRID_HEADER_COLUMN_MAX_WIDTH = GRID_HEADER_COLUMN_MAX_WIDTH;
const GRID_PAGE_RANGE_DISPLAY = 5;
exports.GRID_PAGE_RANGE_DISPLAY = GRID_PAGE_RANGE_DISPLAY;
const COLUMN_DEFAULT_MIN_WIDTH = 100;
exports.COLUMN_DEFAULT_MIN_WIDTH = COLUMN_DEFAULT_MIN_WIDTH;
const GRID_PAGE_SIZES = [10, 50, 100];
exports.GRID_PAGE_SIZES = GRID_PAGE_SIZES;
const ROW_DENSITIES = [{
  icon: 'tableDensityExpanded',
  height: 55,
  selected: false
}, {
  icon: 'tableDensityNormal',
  height: 45,
  selected: false
}, {
  icon: 'tableDensityCompact',
  height: 35,
  selected: true
}];
exports.ROW_DENSITIES = ROW_DENSITIES;
const HEADER_HEIGHT = 35; // gauge chart default parameters

exports.HEADER_HEIGHT = HEADER_HEIGHT;
const DEFAULT_GAUGE_CHART_PARAMETERS = {
  GaugeTitleSize: 14,
  DisplayDefaultGauges: 1,
  OrientationDefault: 'h',
  TickLength: 5,
  LegendPlacement: 'center',
  ThresholdsMaxLimit: 1
}; // pie chart default parameters

exports.DEFAULT_GAUGE_CHART_PARAMETERS = DEFAULT_GAUGE_CHART_PARAMETERS;
const PLOTLY_PIE_COLUMN_NUMBER = 2;
exports.PLOTLY_PIE_COLUMN_NUMBER = PLOTLY_PIE_COLUMN_NUMBER;
const PIE_XAXIS_GAP = 0.2;
exports.PIE_XAXIS_GAP = PIE_XAXIS_GAP;
const PIE_YAXIS_GAP = 0.1;
exports.PIE_YAXIS_GAP = PIE_YAXIS_GAP;
const DEFAULT_PIE_CHART_PARAMETERS = {
  DefaultMode: 'pie'
};
exports.DEFAULT_PIE_CHART_PARAMETERS = DEFAULT_PIE_CHART_PARAMETERS;
const GROUPBY = 'dimensions';
exports.GROUPBY = GROUPBY;
const AGGREGATIONS = 'series';
exports.AGGREGATIONS = AGGREGATIONS;
const PARENTFIELDS = 'parentFields';
exports.PARENTFIELDS = PARENTFIELDS;
const VALUEFIELD = 'valueField';
exports.VALUEFIELD = VALUEFIELD;
const CHILDFIELD = 'childField';
exports.CHILDFIELD = CHILDFIELD;
const TIMESTAMP = 'timestamp'; // metrics constants

exports.TIMESTAMP = TIMESTAMP;
const METRICS_GRID_SPACE_BETWEEN_X_AXIS = 0.01;
exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = METRICS_GRID_SPACE_BETWEEN_X_AXIS;
const METRICS_GRID_SPACE_BETWEEN_Y_AXIS = 100;
exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = METRICS_GRID_SPACE_BETWEEN_Y_AXIS;
const METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = 0.08;
exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = METRICS_REDUCE_VALUE_SIZE_PERCENTAGE;
const METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = 0.05;
exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = METRICS_REDUCE_TITLE_SIZE_PERCENTAGE;
const METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = 0.2;
exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE;
const METRICS_SERIES_UNIT_SUBSTRING_LENGTH = 3;
exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = METRICS_SERIES_UNIT_SUBSTRING_LENGTH;
const METRICS_AXIS_MARGIN = {
  l: 0,
  r: 0,
  b: 0,
  t: 80
};
exports.METRICS_AXIS_MARGIN = METRICS_AXIS_MARGIN;
const METRICS_ANNOTATION = {
  xref: 'paper',
  yref: 'paper',
  showarrow: false
};
exports.METRICS_ANNOTATION = METRICS_ANNOTATION;
const DEFAULT_METRICS_CHART_PARAMETERS = {
  DefaultTextMode: 'auto',
  DefaultOrientation: 'auto',
  DefaultTitleSize: 30,
  DefaultValueSize: 80,
  DefaultChartType: 'auto',
  TextAlignment: 'auto',
  DefaultPrecision: 1,
  BaseThreshold: {
    thid: (0, _eui.htmlIdGenerator)('thr')(),
    name: 'Base',
    color: '#3CA1C7',
    value: 0,
    isReadOnly: true
  },
  DefaultTextColor: '#FFFFFF'
};
exports.DEFAULT_METRICS_CHART_PARAMETERS = DEFAULT_METRICS_CHART_PARAMETERS;
const DEFAULT_BAR_CHART_STYLES = {
  BarMode: 'group',
  GroupWidth: 0.7,
  BarWidth: 0.97,
  LabelSize: 12
};
exports.DEFAULT_BAR_CHART_STYLES = DEFAULT_BAR_CHART_STYLES;
const SIMILAR_VIZ_TYPES = [_shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar, _shared.VIS_CHART_TYPES.Bar];
exports.SIMILAR_VIZ_TYPES = SIMILAR_VIZ_TYPES;
let ConfigChartOptionsEnum;
exports.ConfigChartOptionsEnum = ConfigChartOptionsEnum;

(function (ConfigChartOptionsEnum) {
  ConfigChartOptionsEnum["palettePicker"] = "palettePicker";
  ConfigChartOptionsEnum["singleColorPicker"] = "singleColorPicker";
  ConfigChartOptionsEnum["colorpicker"] = "colorpicker";
  ConfigChartOptionsEnum["treemapColorPicker"] = "treemapColorPicker";
  ConfigChartOptionsEnum["input"] = "input";
  ConfigChartOptionsEnum["textInput"] = "textInput";
  ConfigChartOptionsEnum["slider"] = "slider";
  ConfigChartOptionsEnum["switchButton"] = "switchButton";
  ConfigChartOptionsEnum["buttons"] = "buttons";
})(ConfigChartOptionsEnum || (exports.ConfigChartOptionsEnum = ConfigChartOptionsEnum = {}));

const CUSTOM_LABEL = 'customLabel';
exports.CUSTOM_LABEL = CUSTOM_LABEL;
const BREAKDOWNS = 'breakdowns';
exports.BREAKDOWNS = BREAKDOWNS;
const SPAN = 'span';
exports.SPAN = SPAN;
const TIME_FIELD = 'time_field';
exports.TIME_FIELD = TIME_FIELD;
const DISABLED_COLOUR = '#fafbfd';
exports.DISABLED_COLOUR = DISABLED_COLOUR;
const DATA_CONFIG_HINTS_INFO = {
  [AGGREGATIONS]: 'Series is an aggregation function (mandatory). The argument of an aggregation must be a field.',
  [GROUPBY]: "Dimensions are 'by' clauses. They are fields or expressions like scalar and aggregation functions. Besides, the span clause for a dimension can be used to split a specific field into buckets in the same interval, the stats then does the aggregation by these span buckets.",
  [BREAKDOWNS]: "Defines how each series is broken down. Breakdowns are 'by' clauses that subdivide the existing series."
}; // Metrics constants

exports.DATA_CONFIG_HINTS_INFO = DATA_CONFIG_HINTS_INFO;
const UNITS_OF_MEASURE = ['seconds (s)', 'hours (h)', 'celsius (C)', 'farenheit (F)', 'meters (m)', 'kilometers (k)'];
exports.UNITS_OF_MEASURE = UNITS_OF_MEASURE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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