'use strict'
var refractorHaskell = require('./haskell.js')
module.exports = purescript
purescript.displayName = 'purescript'
purescript.aliases = ['purs']
function purescript(Prism) {
  Prism.register(refractorHaskell)
  Prism.languages.purescript = Prism.languages.extend('haskell', {
    keyword:
      /\b(?:ado|case|class|data|derive|do|else|forall|if|in|infixl|infixr|instance|let|module|newtype|of|primitive|then|type|where)\b/,
    'import-statement': {
      // The imported or hidden names are not included in this import
      // statement. This is because we want to highlight those exactly like
      // we do for the names in the program.
      pattern:
        /(^[\t ]*)import\s+[A-Z][\w']*(?:\.[A-Z][\w']*)*(?:\s+as\s+[A-Z][\w']*(?:\.[A-Z][\w']*)*)?(?:\s+hiding\b)?/m,
      lookbehind: true,
      inside: {
        keyword: /\b(?:import|as|hiding)\b/
      }
    },
    // These are builtin functions only. Constructors are highlighted later as a constant.
    builtin:
      /\b(?:absurd|add|ap|append|apply|between|bind|bottom|clamp|compare|comparing|compose|conj|const|degree|discard|disj|div|eq|flap|flip|gcd|identity|ifM|join|lcm|liftA1|liftM1|map|max|mempty|min|mod|mul|negate|not|notEq|one|otherwise|recip|show|sub|top|unit|unless|unlessM|void|when|whenM|zero)\b/
  })
  Prism.languages.purs = Prism.languages.purescript
}
