/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.config.overrides;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverrides;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesHelper;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class ConfigOverridesApplier {
    private static final Logger LOG = LogManager.getLogger(ConfigOverridesApplier.class);
    private long lastAppliedTimestamp;

    public void applyOverride(String overridesJson, String lastUpdatedTimestampString) {
        if (!this.valid(overridesJson, lastUpdatedTimestampString)) {
            LOG.warn("Received invalid overrides or timestamp. Overrides json: {}, last updated timestamp: {}", (Object)overridesJson, (Object)this.lastAppliedTimestamp);
            return;
        }
        try {
            long lastUpdatedTimestamp = Long.parseLong(lastUpdatedTimestampString);
            LOG.debug("Last updated(writer): {}, Last applied(reader): {}", (Object)lastUpdatedTimestamp, (Object)this.lastAppliedTimestamp);
            if (lastUpdatedTimestamp > this.lastAppliedTimestamp) {
                this.apply(ConfigOverridesHelper.deserialize(overridesJson));
            } else {
                LOG.debug("Not applying override. Last updated timestamp {} is behind last applied timestamp {}", (Object)lastUpdatedTimestamp, (Object)this.lastAppliedTimestamp);
            }
        }
        catch (IOException ioe) {
            LOG.error("Unable to deserialize overrides JSON:" + overridesJson, (Throwable)ioe);
        }
        catch (NumberFormatException nfe) {
            LOG.error("Unable to parse the lastUpdatedTimestamp {} string as a number.", (Object)lastUpdatedTimestampString, (Object)nfe);
        }
    }

    private void apply(ConfigOverrides overrides) {
        if (PerformanceAnalyzerApp.getRcaController() != null && PerformanceAnalyzerApp.getRcaController().isRcaEnabled()) {
            LOG.info("Applying overrides: {}", overrides.getEnable().getRcas());
            RcaConf rcaConf = PerformanceAnalyzerApp.getRcaController().getRcaConf();
            if (rcaConf != null) {
                HashSet<String> currentMutedRcaSet = new HashSet<String>(rcaConf.getMutedRcaList());
                HashSet<String> currentMutedDeciderSet = new HashSet<String>(rcaConf.getMutedDeciderList());
                HashSet<String> currentMutedActionSet = new HashSet<String>(rcaConf.getMutedActionList());
                if (overrides.getEnable() != null) {
                    if (overrides.getEnable().getRcas() != null) {
                        currentMutedRcaSet.removeAll(overrides.getEnable().getRcas());
                    }
                    if (overrides.getEnable().getDeciders() != null) {
                        currentMutedDeciderSet.removeAll(overrides.getEnable().getDeciders());
                    }
                    if (overrides.getEnable().getActions() != null) {
                        currentMutedActionSet.removeAll(overrides.getEnable().getActions());
                    }
                }
                if (overrides.getDisable() != null) {
                    if (overrides.getDisable().getRcas() != null) {
                        currentMutedRcaSet.addAll(overrides.getDisable().getRcas());
                    }
                    if (overrides.getDisable().getDeciders() != null) {
                        currentMutedDeciderSet.addAll(overrides.getDisable().getDeciders());
                    }
                    if (overrides.getDisable().getActions() != null) {
                        currentMutedActionSet.addAll(overrides.getDisable().getActions());
                    }
                }
                LOG.info("New set of muted rcas: {}", currentMutedRcaSet);
                LOG.info("New set of muted deciders: {}", currentMutedDeciderSet);
                LOG.info("New set of muted actions: {}", currentMutedActionSet);
                boolean updateSuccess = rcaConf.updateAllRcaConfFiles(currentMutedRcaSet, currentMutedDeciderSet, currentMutedActionSet);
                if (updateSuccess) {
                    this.lastAppliedTimestamp = System.currentTimeMillis();
                }
            }
        }
    }

    private boolean valid(String overridesJson, String timestamp) {
        if (overridesJson == null || timestamp == null) {
            return false;
        }
        if (overridesJson.isEmpty() || timestamp.isEmpty()) {
            return false;
        }
        return StringUtils.isNumeric((CharSequence)timestamp);
    }

    @VisibleForTesting
    public long getLastAppliedTimestamp() {
        return this.lastAppliedTimestamp;
    }

    @VisibleForTesting
    public void setLastAppliedTimestamp(long lastAppliedTimestamp) {
        this.lastAppliedTimestamp = lastAppliedTimestamp;
    }
}

