/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.Removable;

public class GarbageCollectorInfoSnapshot
implements Removable {
    private static final Logger LOG = LogManager.getLogger(GarbageCollectorInfoSnapshot.class);
    private final DSLContext create;
    private final Long windowStartTime;
    private final String tableName;
    private List<Field<?>> columns;

    public GarbageCollectorInfoSnapshot(Connection conn, Long windowStartTime) {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.windowStartTime = windowStartTime;
        this.tableName = "gc_info_" + windowStartTime;
        this.columns = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)Fields.MEMORY_POOL.toString()), String.class));
                this.add(DSL.field((Name)DSL.name((String)Fields.COLLECTOR_NAME.toString()), String.class));
            }
        };
        this.create.createTable(this.tableName).columns(this.columns).execute();
    }

    public BatchBindStep startBatchPut() {
        ArrayList<String> dummyValues = new ArrayList<String>();
        for (int i = 0; i < this.columns.size(); ++i) {
            dummyValues.add("");
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    @Override
    public void remove() throws Exception {
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public static enum Fields {
        MEMORY_POOL(AllMetrics.GCInfoDimension.MEMORY_POOL.toString()),
        COLLECTOR_NAME(AllMetrics.GCInfoDimension.COLLECTOR_NAME.toString());

        private final String fieldValue;

        private Fields(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        public String toString() {
            return this.fieldValue;
        }
    }
}

