/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.load;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.ml.common.MLTask;

public class LoadModelInput
implements Writeable {
    private String modelId;
    private String taskId;
    private String modelContentHash;
    private Integer nodeCount;
    private String coordinatingNodeId;
    private MLTask mlTask;

    public LoadModelInput(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.taskId = in.readString();
        this.modelContentHash = in.readOptionalString();
        this.nodeCount = in.readInt();
        this.coordinatingNodeId = in.readString();
        this.mlTask = new MLTask(in);
    }

    public LoadModelInput(String modelId, String taskId, String modelContentHash, Integer nodeCount, String coordinatingNodeId, MLTask mlTask) {
        this.modelId = modelId;
        this.taskId = taskId;
        this.modelContentHash = modelContentHash;
        this.nodeCount = nodeCount;
        this.coordinatingNodeId = coordinatingNodeId;
        this.mlTask = mlTask;
    }

    public LoadModelInput() {
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeString(this.taskId);
        out.writeOptionalString(this.modelContentHash);
        out.writeInt(this.nodeCount.intValue());
        out.writeString(this.coordinatingNodeId);
        this.mlTask.writeTo(out);
    }

    @Generated
    public static LoadModelInputBuilder builder() {
        return new LoadModelInputBuilder();
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getModelContentHash() {
        return this.modelContentHash;
    }

    @Generated
    public Integer getNodeCount() {
        return this.nodeCount;
    }

    @Generated
    public String getCoordinatingNodeId() {
        return this.coordinatingNodeId;
    }

    @Generated
    public MLTask getMlTask() {
        return this.mlTask;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setModelContentHash(String modelContentHash) {
        this.modelContentHash = modelContentHash;
    }

    @Generated
    public void setNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
    }

    @Generated
    public void setCoordinatingNodeId(String coordinatingNodeId) {
        this.coordinatingNodeId = coordinatingNodeId;
    }

    @Generated
    public void setMlTask(MLTask mlTask) {
        this.mlTask = mlTask;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadModelInput)) {
            return false;
        }
        LoadModelInput other = (LoadModelInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$nodeCount = this.getNodeCount();
        Integer other$nodeCount = other.getNodeCount();
        if (this$nodeCount == null ? other$nodeCount != null : !((Object)this$nodeCount).equals(other$nodeCount)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$modelContentHash = this.getModelContentHash();
        String other$modelContentHash = other.getModelContentHash();
        if (this$modelContentHash == null ? other$modelContentHash != null : !this$modelContentHash.equals(other$modelContentHash)) {
            return false;
        }
        String this$coordinatingNodeId = this.getCoordinatingNodeId();
        String other$coordinatingNodeId = other.getCoordinatingNodeId();
        if (this$coordinatingNodeId == null ? other$coordinatingNodeId != null : !this$coordinatingNodeId.equals(other$coordinatingNodeId)) {
            return false;
        }
        MLTask this$mlTask = this.getMlTask();
        MLTask other$mlTask = other.getMlTask();
        return !(this$mlTask == null ? other$mlTask != null : !((Object)this$mlTask).equals(other$mlTask));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoadModelInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $nodeCount = this.getNodeCount();
        result = result * 59 + ($nodeCount == null ? 43 : ((Object)$nodeCount).hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $modelContentHash = this.getModelContentHash();
        result = result * 59 + ($modelContentHash == null ? 43 : $modelContentHash.hashCode());
        String $coordinatingNodeId = this.getCoordinatingNodeId();
        result = result * 59 + ($coordinatingNodeId == null ? 43 : $coordinatingNodeId.hashCode());
        MLTask $mlTask = this.getMlTask();
        result = result * 59 + ($mlTask == null ? 43 : ((Object)$mlTask).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LoadModelInput(modelId=" + this.getModelId() + ", taskId=" + this.getTaskId() + ", modelContentHash=" + this.getModelContentHash() + ", nodeCount=" + this.getNodeCount() + ", coordinatingNodeId=" + this.getCoordinatingNodeId() + ", mlTask=" + this.getMlTask() + ")";
    }

    @Generated
    public static class LoadModelInputBuilder {
        @Generated
        private String modelId;
        @Generated
        private String taskId;
        @Generated
        private String modelContentHash;
        @Generated
        private Integer nodeCount;
        @Generated
        private String coordinatingNodeId;
        @Generated
        private MLTask mlTask;

        @Generated
        LoadModelInputBuilder() {
        }

        @Generated
        public LoadModelInputBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public LoadModelInputBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public LoadModelInputBuilder modelContentHash(String modelContentHash) {
            this.modelContentHash = modelContentHash;
            return this;
        }

        @Generated
        public LoadModelInputBuilder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        @Generated
        public LoadModelInputBuilder coordinatingNodeId(String coordinatingNodeId) {
            this.coordinatingNodeId = coordinatingNodeId;
            return this;
        }

        @Generated
        public LoadModelInputBuilder mlTask(MLTask mlTask) {
            this.mlTask = mlTask;
            return this;
        }

        @Generated
        public LoadModelInput build() {
            return new LoadModelInput(this.modelId, this.taskId, this.modelContentHash, this.nodeCount, this.coordinatingNodeId, this.mlTask);
        }

        @Generated
        public String toString() {
            return "LoadModelInput.LoadModelInputBuilder(modelId=" + this.modelId + ", taskId=" + this.taskId + ", modelContentHash=" + this.modelContentHash + ", nodeCount=" + this.nodeCount + ", coordinatingNodeId=" + this.coordinatingNodeId + ", mlTask=" + this.mlTask + ")";
        }
    }
}

