/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintSeverity;

public class LinterTableWithNoPrimaryKey
extends BaseLinter {
    public LinterTableWithNoPrimaryKey() {
        this.setSeverity(LintSeverity.high);
        this.setTableTypesFilter(new TableTypesFilter(new String[]{"TABLE"}));
    }

    @Override
    public String getSummary() {
        return "no primary key";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        if (this.hasNoPrimaryKey(table)) {
            this.addTableLint(table, this.getSummary());
        }
    }

    private boolean hasNoPrimaryKey(Table table) {
        if (table.getPrimaryKey() == null) {
            boolean hasDataColumn = false;
            for (Column column : this.getColumns(table)) {
                if (column.isPartOfForeignKey()) continue;
                hasDataColumn = true;
                break;
            }
            return hasDataColumn;
        }
        return false;
    }
}

