/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeFixedView;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.util.ClassUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.util.FixedViewColumn;

public abstract class SFBaseFileTransferAgent
implements SnowflakeFixedView {
    protected boolean compressSourceFromStream;
    protected String destStagePath;
    protected String destFileNameForStreamSource;
    protected InputStream sourceStream;
    protected boolean sourceFromStream;
    protected boolean showEncryptionParameter;
    protected List<Object> statusRows = new ArrayList<Object>();
    protected CommandType commandType = CommandType.UPLOAD;
    private int currentRowIndex;

    @Override
    public int getTotalRows() {
        return this.statusRows.size();
    }

    @Override
    public List<Object> getNextRow() throws Exception {
        if (this.currentRowIndex < this.statusRows.size()) {
            return ClassUtil.getFixedViewObjectAsRow(this.commandType == CommandType.UPLOAD ? (this.showEncryptionParameter ? UploadCommandEncryptionFacade.class : UploadCommandFacade.class) : (this.showEncryptionParameter ? DownloadCommandEncryptionFacade.class : DownloadCommandFacade.class), this.statusRows.get(this.currentRowIndex++));
        }
        return null;
    }

    @Override
    public List<SnowflakeColumnMetadata> describeColumns(SFBaseSession session) throws Exception {
        return SnowflakeUtil.describeFixedViewColumns(this.commandType == CommandType.UPLOAD ? (this.showEncryptionParameter ? UploadCommandEncryptionFacade.class : UploadCommandFacade.class) : (this.showEncryptionParameter ? DownloadCommandEncryptionFacade.class : DownloadCommandFacade.class), session);
    }

    public void setSourceStream(InputStream sourceStream) {
        this.sourceStream = sourceStream;
        this.sourceFromStream = true;
    }

    public void setDestStagePath(String destStagePath) {
        this.destStagePath = destStagePath;
    }

    public void setDestFileNameForStreamSource(String destFileNameForStreamSource) {
        this.destFileNameForStreamSource = destFileNameForStreamSource;
    }

    public void setCompressSourceFromStream(boolean compressSourceFromStream) {
        this.compressSourceFromStream = compressSourceFromStream;
    }

    public abstract boolean execute() throws SQLException;

    public abstract InputStream downloadStream(String var1) throws SnowflakeSQLException;

    public static enum CommandType {
        UPLOAD,
        DOWNLOAD;

    }

    public class DownloadCommandEncryptionFacade
    extends DownloadCommandFacade {
        @FixedViewColumn(name="encryption", ordinal=35)
        private String encryption;

        public DownloadCommandEncryptionFacade(String file, String resultStatus, String errorDetails, long size, boolean isEncrypted) {
            super(file, resultStatus, errorDetails, size);
            this.encryption = isEncrypted ? "DECRYPTED" : "";
        }
    }

    public class DownloadCommandFacade {
        @FixedViewColumn(name="file", ordinal=10)
        private String file;
        @FixedViewColumn(name="size", ordinal=20)
        private long size;
        @FixedViewColumn(name="status", ordinal=30)
        private String resultStatus;
        @FixedViewColumn(name="message", ordinal=40)
        private String errorDetails;

        public DownloadCommandFacade(String file, String resultStatus, String errorDetails, long size) {
            this.file = file;
            this.resultStatus = resultStatus;
            this.errorDetails = errorDetails;
            this.size = size;
        }

        public String getFile() {
            return this.file;
        }
    }

    public class UploadCommandEncryptionFacade
    extends UploadCommandFacade {
        @FixedViewColumn(name="encryption", ordinal=75)
        private String encryption;

        public UploadCommandEncryptionFacade(String srcFile, String destFile, String resultStatus, String errorDetails, long srcSize, long destSize, String srcCompressionType, String destCompressionType, boolean isEncrypted) {
            super(srcFile, destFile, resultStatus, errorDetails, srcSize, destSize, srcCompressionType, destCompressionType);
            this.encryption = isEncrypted ? "ENCRYPTED" : "";
        }
    }

    public class UploadCommandFacade {
        @FixedViewColumn(name="source", ordinal=10)
        private String srcFile;
        @FixedViewColumn(name="target", ordinal=20)
        private String destFile;
        @FixedViewColumn(name="source_size", ordinal=30)
        private long srcSize;
        @FixedViewColumn(name="target_size", ordinal=40)
        private long destSize = -1L;
        @FixedViewColumn(name="source_compression", ordinal=50)
        private String srcCompressionType;
        @FixedViewColumn(name="target_compression", ordinal=60)
        private String destCompressionType;
        @FixedViewColumn(name="status", ordinal=70)
        private String resultStatus;
        @FixedViewColumn(name="message", ordinal=80)
        private String errorDetails;

        public UploadCommandFacade(String srcFile, String destFile, String resultStatus, String errorDetails, long srcSize, long destSize, String srcCompressionType, String destCompressionType) {
            this.srcFile = srcFile;
            this.destFile = destFile;
            this.resultStatus = resultStatus;
            this.errorDetails = errorDetails;
            this.srcSize = srcSize;
            this.destSize = destSize;
            this.srcCompressionType = srcCompressionType;
            this.destCompressionType = destCompressionType;
        }

        public String getSrcFile() {
            return this.srcFile;
        }
    }

    public static enum UploadColumns {
        source,
        target,
        source_size,
        target_size,
        source_compression,
        target_compression,
        status,
        encryption,
        message;

    }
}

