/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.text.formatter.operation.DataTextFormatter;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public final class OperationCommand
extends BaseSchemaCrawlerCommand<OperationOptions> {
    private static final Logger LOGGER = Logger.getLogger(OperationCommand.class.getName());

    public OperationCommand(String command) {
        super(command);
    }

    @Override
    public void checkAvailability() {
    }

    @Override
    public void execute() {
        DataTraversalHandler handler;
        block32: {
            this.checkCatalog();
            if (!this.isOutputFormatSupported()) {
                LOGGER.log(Level.INFO, new StringFormat("Output format <%s> not supported for command <%s>", this.outputOptions.getOutputFormatValue(), this.getCommand()));
                return;
            }
            handler = this.getDataTraversalHandler();
            Query query = ((OperationOptions)this.commandOptions).getQuery();
            handler.begin();
            handler.handleInfoStart();
            handler.handle(this.catalog.getDatabaseInfo());
            handler.handle(this.catalog.getJdbcDriverInfo());
            handler.handleInfoEnd();
            if (query.isQueryOver()) {
                String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
                Identifiers identifiers = Identifiers.identifiers().withIdentifierQuoteString(identifierQuoteString).build();
                try (Statement statement = DatabaseUtility.createStatement(this.connection);){
                    for (Table table : this.getSortedTables(this.catalog)) {
                        boolean isAlphabeticalSortForTableColumns = ((OperationOptions)this.commandOptions).isAlphabeticalSortForTableColumns();
                        try {
                            ResultSet results = QueryUtility.executeAgainstTable(query, statement, table, isAlphabeticalSortForTableColumns, identifiers);
                            try {
                                handler.handleData(table, results);
                            }
                            finally {
                                if (results == null) continue;
                                results.close();
                            }
                        }
                        catch (SQLException e) {
                            LOGGER.log(Level.WARNING, e, new StringFormat("Bad operation for table <%s>", table));
                        }
                    }
                    break block32;
                }
                catch (SQLException e) {
                    throw new DatabaseAccessException(String.format("Could not run query %n%s%n", query), e);
                }
            }
            String sql = query.getQuery();
            try (Statement statement = DatabaseUtility.createStatement(this.connection);
                 ResultSet results = DatabaseUtility.executeSql(statement, sql);){
                handler.handleData(query, results);
            }
            catch (SQLException e) {
                throw new DatabaseAccessException(String.format("Could not run query %n%s%n", query), e);
            }
        }
        handler.end();
    }

    @Override
    public boolean usesConnection() {
        return true;
    }

    private DataTraversalHandler getDataTraversalHandler() {
        Operation operation = ((OperationOptions)this.commandOptions).getOperation();
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        DataTextFormatter formatter = new DataTextFormatter(operation, (OperationOptions)this.commandOptions, this.outputOptions, identifierQuoteString);
        return formatter;
    }

    private List<? extends Table> getSortedTables(Catalog catalog) {
        ArrayList<Table> tables = new ArrayList<Table>(catalog.getTables());
        tables.sort(NamedObjectSort.getNamedObjectSort(((OperationOptions)this.commandOptions).isAlphabeticalSortForTables()));
        return tables;
    }

    private boolean isOutputFormatSupported() {
        String outputFormatValue = this.outputOptions.getOutputFormatValue();
        boolean isOutputFormatSupported = TextOutputFormat.isSupportedFormat(outputFormatValue);
        return isOutputFormatSupported;
    }
}

