/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.SchemaCrawlerException;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.utility.SchemaCrawlerUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSources;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawlerExecutable {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerExecutable.class.getName());
    private final String command;
    private Config additionalConfig;
    private Catalog catalog;
    private DatabaseConnectionSource dataSource;
    private OutputOptions outputOptions;
    private SchemaCrawlerOptions schemaCrawlerOptions;
    private SchemaRetrievalOptions schemaRetrievalOptions;

    public SchemaCrawlerExecutable(String command) {
        this.command = Utility.requireNotBlank(command, "No command specified");
        this.schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        this.outputOptions = OutputOptionsBuilder.newOutputOptions();
        this.additionalConfig = new Config();
    }

    public void execute() {
        if (this.schemaRetrievalOptions == null) {
            this.schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(this.dataSource);
        }
        SchemaCrawlerUtility.updateConnectionDataSource(this.dataSource, this.schemaRetrievalOptions);
        try (Connection connection = (Connection)this.dataSource.get();){
            SchemaCrawlerCommand<?> scCommand = this.loadCommand();
            scCommand.setIdentifiers(this.schemaRetrievalOptions.getIdentifiers());
            scCommand.initialize();
            scCommand.checkAvailability();
            if (this.catalog == null) {
                this.loadCatalog();
            }
            scCommand.setCatalog(this.catalog);
            if (scCommand.usesConnection()) {
                scCommand.setConnection(connection);
            }
            LOGGER.log(Level.INFO, new StringFormat("Executing SchemaCrawler command <%s>", this.command));
            LOGGER.log(Level.CONFIG, new ObjectToStringFormat(scCommand.getIdentifiers()));
            LOGGER.log(Level.CONFIG, new ObjectToStringFormat(scCommand.getCommandOptions()));
            scCommand.execute();
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException(e);
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    public SchemaRetrievalOptions getSchemaRetrievalOptions() {
        return this.schemaRetrievalOptions;
    }

    public void setAdditionalConfiguration(Config additionalConfig) {
        this.additionalConfig = new Config(additionalConfig);
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Deprecated
    public void setConnection(Connection connection) {
        DatabaseConnectionSource dataSource;
        this.dataSource = dataSource = DatabaseConnectionSources.wrappedDatabaseConnectionSource(connection, conn -> {});
    }

    public void setDataSource(DatabaseConnectionSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource, "No data source provided");
    }

    public void setOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions == null ? OutputOptionsBuilder.newOutputOptions() : outputOptions;
    }

    public void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions == null ? SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions() : schemaCrawlerOptions;
    }

    public void setSchemaRetrievalOptions(SchemaRetrievalOptions schemaRetrievalOptions) {
        this.schemaRetrievalOptions = schemaRetrievalOptions;
    }

    public String toString() {
        return this.command;
    }

    private void loadCatalog() {
        this.catalog = SchemaCrawlerUtility.getCatalog(this.dataSource, this.schemaRetrievalOptions, this.schemaCrawlerOptions, this.additionalConfig);
        Objects.requireNonNull(this.catalog, "Catalog could not be retrieved");
    }

    private SchemaCrawlerCommand<?> loadCommand() {
        CommandRegistry commandRegistry = CommandRegistry.getCommandRegistry();
        SchemaCrawlerCommand<?> scCommand = commandRegistry.configureNewCommand(this.command, this.schemaCrawlerOptions, this.additionalConfig, this.outputOptions);
        return Objects.requireNonNull(scCommand, "No SchemaCrawler command instantiated");
    }
}

