/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLineCommands;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.state.StateFactory;
import schemacrawler.tools.commandline.utility.CommandLineUtility;

public final class SchemaCrawlerCommandLine {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerCommandLine.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(String[] args) {
        try (ShellState state = new ShellState();){
            Objects.requireNonNull(args, "No arguments provided");
            state.setDeferCatalogLoad(true);
            StateFactory stateFactory = new StateFactory(state);
            SchemaCrawlerCommandLineCommands commands = new SchemaCrawlerCommandLineCommands();
            CommandLine commandLine = CommandLineUtility.newCommandLine(commands, stateFactory);
            CommandLineUtility.addPluginCommands(commandLine, CommandLineUtility.catalogLoaderPluginCommands);
            CommandLineUtility.addPluginCommands(commandLine, CommandLineUtility.commandPluginCommands);
            commandLine.parseArgs(args);
            SchemaCrawlerCommandLine.executeCommandLine(commandLine);
            int n = 0;
            return n;
        }
    }

    private static void executeCommandLine(CommandLine commandLine) {
        Map subcommands = commandLine.getMixins();
        for (String commandName : new String[]{"log", "configfile", "connect", "limit", "grep", "filter", "showstate", "load", "execute"}) {
            Runnable command = (Runnable)subcommands.get(commandName);
            LOGGER.log(Level.INFO, "Running command " + command.getClass().getSimpleName());
            command.run();
        }
    }

    private SchemaCrawlerCommandLine() {
    }
}

