/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers.db2;

import com.ibm.db2.cmx.ClientDescriptor;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.LiteralsInfo;
import com.ibm.db2.cmx.runtime.internal.db.ProfileSection;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.DB2JdbcData;
import com.ibm.db2.cmx.runtime.internal.db.db2.DB2StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.PDQConnectionCallbackImpl;
import com.ibm.db2.cmx.runtime.internal.db.db2.StaticProfileSection;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.StatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2CallableStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2StatementExecutionHandler;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.jcc.DB2BaseDataSource;
import com.ibm.db2.jcc.DB2Connection;
import com.ibm.db2.jcc.DB2ResultSet;
import com.ibm.db2.jcc.DB2SystemMonitor;
import com.ibm.db2.jcc.SQLJCallableStatement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJConnection;
import com.ibm.db2.jcc.SQLJPackage;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.am.GlobalProperties;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class DB2ConnectionExecutionHandler
extends ConnectionExecutionHandler {
    protected CursorNameToResultSetMap staticCursorPositionUpdateMap_ = null;
    protected CallableStatement dummyStatementForLiteralSubstitution_ = null;
    protected ParameterMetaData dummyParameterMetaDataForLiteralSubstitution_ = null;
    protected DB2SystemMonitor monitor_ = null;
    private boolean isMonitorEnabled_ = false;
    private static Boolean isPresent_DB2BaseDataSource_getDecimalRoundingMode__;
    private static Method method_DB2BaseDataSource_getDecimalRoundingMode__;
    private static Boolean isPresent_DB2ResultSet_isClosed__;
    private static Method method_DB2ResultSet_isClosed__;

    public DB2ConnectionExecutionHandler() {
    }

    public DB2ConnectionExecutionHandler(Connection connection, DB2BaseDataSource dB2BaseDataSource, String string, String string2, String string3, int n2, int n3) throws SQLException {
        super(connection, dB2BaseDataSource, string, string2, string3, n2, n3);
        this.initializeConstructor(connection, dB2BaseDataSource);
    }

    @Override
    public void initializeDefaultConstructor(CentralStoreKey.CachedConnectionInfo cachedConnectionInfo) throws SQLException {
        super.initializeDefaultConstructor(cachedConnectionInfo);
        this.initializeConstructor(null, (DB2BaseDataSource)cachedConnectionInfo.baseDS_);
    }

    private void initializeConstructor(Connection connection, DB2BaseDataSource dB2BaseDataSource) {
        if (this.hasPhysicalConnection_) {
            Level level;
            this.setSystemMonitor();
            if (this.staticCursorPositionUpdateMap_ == null) {
                this.staticCursorPositionUpdateMap_ = new CursorNameToResultSetMap();
            }
            if (logger__.isLoggable(level = Level.FINE)) {
                DataLogger.logMonitorMessage(logger__, this, "ConnectionExecutionHandler constructor", "connection execution handler proxy created for: " + connection);
                this.logWarningSplRegWithDSApiAndJCCGlobalProp(logger__, level, this, "initializeConstructor", dB2BaseDataSource);
                if (this.getCaptureModeCEH() == 5 && dB2BaseDataSource.getDeferPrepares()) {
                    String string = Messages.getText("MSG_PROFILER_JCC_WARN_CAPTURE_WITH_DEFER_PREPARE_ON", new Object[0]);
                    logger__.logp(level, DataLogger.getShortName(this), "initializeConstructor", string);
                }
            }
        }
    }

    private void logWarningSplRegWithDSApiAndJCCGlobalProp(Logger logger, Level level, Object object, String string, DB2BaseDataSource dB2BaseDataSource) {
        if (!logger.isLoggable(level)) {
            return;
        }
        DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "currentSchema", dB2BaseDataSource.getCurrentSchema(), "CURRENT SCHEMA", true, true);
        DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "currentSQLID", dB2BaseDataSource.getCurrentSQLID(), "CURRENT SQLID", true, true);
        DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "currentFunctionPath", dB2BaseDataSource.getCurrentFunctionPath(), "CURRENT PATH", true, false);
        if (this.dbInfo_.supportsDecFloat_) {
            DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "decimalRoundingMode", DB2ConnectionExecutionHandler.getJCCDecimalRoundingModeAsString(dB2BaseDataSource, true), "CURRENT DECFLOAT ROUNDING MODE", true, true);
        }
        DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "currentPackagePath", dB2BaseDataSource.getCurrentPackagePath(), "CURRENT PACKAGE PATH", true, false);
        DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "currentPackageSet", dB2BaseDataSource.getCurrentPackageSet(), "CURRENT PACKAGESET", true, false);
        int n2 = dB2BaseDataSource.getDefaultIsolationLevel();
        String string2 = 2 == n2 ? null : StaticProfileConstants.getIsolationLevelAsString(n2, true);
        DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "defaultIsolationLevel", string2, null, false, false);
        DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "pkList", dB2BaseDataSource.getPkList(), null, true, false);
        String string3 = dB2BaseDataSource.getJdbcCollection();
        if ("NULLID".equals(string3)) {
            string3 = null;
        }
        DB2ConnectionExecutionHandler.logWarningSplRegWithDSApiAndJCCGlobalPropX(logger, level, object, string, "jdbcCollection", string3, null, true, false);
    }

    private static void logWarningSplRegWithDSApiAndJCCGlobalPropX(Logger logger, Level level, Object object, String string, String string2, String string3, String string4, boolean bl2, boolean bl3) {
        CharSequence charSequence;
        String string5 = null;
        String string6 = null;
        boolean bl4 = false;
        if (bl3 && null != (charSequence = GlobalProperties.getJccGlobalProperty(string2, true))) {
            string5 = "db2.jcc.override." + string2;
            string6 = charSequence;
            bl4 = true;
        }
        if (null == string6) {
            if (null != string3) {
                string5 = string2;
                string6 = string3;
                bl4 = false;
            } else if (bl2 && null != (charSequence = GlobalProperties.getJccGlobalProperty(string2, false))) {
                string5 = "db2.jcc." + string2;
                string6 = charSequence;
                bl4 = true;
            }
        }
        if (null != string6) {
            charSequence = new StringBuilder(DataLogger.warningMessagePrefix);
            if (bl4) {
                ((StringBuilder)charSequence).append(Messages.getText("MSG_PROFILER_JCC_WARN_NONDEFAULT_REGISTER_VALUE_GLOBAL", "IBM Data Server Driver for JDBC and SQLJ", "pureQuery Runtime"));
            } else {
                ((StringBuilder)charSequence).append(Messages.getText("MSG_PROFILER_JCC_WARN_NONDEFAULT_REGISTER_VALUE_DATASOURCE", Connection.class.getSimpleName(), ClientDescriptor.DataSource.class.getSimpleName(), "pureQuery Runtime"));
            }
            ((StringBuilder)charSequence).append("  ").append(Messages.getText("MSG_PROPERTY_NAME", string5));
            ((StringBuilder)charSequence).append("  ").append(Messages.getText("MSG_PROPERTY_VALUE", string6));
            if (null != string4) {
                ((StringBuilder)charSequence).append("  ").append(Messages.getText("MSG_CORRESPONDING_SPECIALREGISTER", string4));
            }
            logger.logp(level, DataLogger.getShortName(object), string, ((StringBuilder)charSequence).toString());
        }
    }

    private static Method getMethod_DB2BaseDataSource_getDecimalRoundingMode() {
        if (null == isPresent_DB2BaseDataSource_getDecimalRoundingMode__) {
            isPresent_DB2BaseDataSource_getDecimalRoundingMode__ = false;
            try {
                method_DB2BaseDataSource_getDecimalRoundingMode__ = DB2ConnectionExecutionHandler.getMethodForClass(DB2BaseDataSource.class, "getDecimalRoundingMode", new Class[0]);
                isPresent_DB2BaseDataSource_getDecimalRoundingMode__ = null != method_DB2BaseDataSource_getDecimalRoundingMode__;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method_DB2BaseDataSource_getDecimalRoundingMode__;
    }

    private static Method getMethod_DB2ResultSet_isClosed() {
        if (Configuration.JCCMajorVersion__ >= 4 && null == isPresent_DB2ResultSet_isClosed__) {
            isPresent_DB2ResultSet_isClosed__ = false;
            try {
                method_DB2ResultSet_isClosed__ = DB2ConnectionExecutionHandler.getMethodForClass(DB2ResultSet.class, "isClosed", new Class[0]);
                isPresent_DB2ResultSet_isClosed__ = null != method_DB2ResultSet_isClosed__;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method_DB2ResultSet_isClosed__;
    }

    private static String getJCCDecimalRoundingModeAsString(DB2BaseDataSource dB2BaseDataSource, boolean bl2) {
        Method method = DB2ConnectionExecutionHandler.getMethod_DB2BaseDataSource_getDecimalRoundingMode();
        Integer n2 = null;
        if (null != method) {
            try {
                n2 = (Integer)method.invoke((Object)dB2BaseDataSource, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != n2) {
                String string = DB2BaseDataSource.class.getCanonicalName();
                switch (n2) {
                    case 0: {
                        return string + ".ROUND_UP";
                    }
                    case 1: {
                        return string + ".ROUND_DOWN";
                    }
                    case 2: {
                        return string + ".ROUND_CEILING";
                    }
                    case 3: {
                        return string + ".ROUND_FLOOR";
                    }
                    case 4: {
                        return string + ".ROUND_HALF_UP";
                    }
                    case 5: {
                        return string + ".ROUND_HALF_DOWN";
                    }
                    case 6: {
                        return string + ".ROUND_HALF_EVEN";
                    }
                    case 7: {
                        return string + ".ROUND_UNNECESSARY";
                    }
                    case -2147483647: {
                        return bl2 ? null : string + ".ROUND_UNSET";
                    }
                }
                return Integer.toString(n2);
            }
        }
        return null;
    }

    private void setSystemMonitor() {
        block3: {
            if (this.monitor_ == null && (this.currentStates_ != null && this.currentStates_.getCaptureMode() == 5 || this.getCaptureModeCEH() == 5)) {
                try {
                    this.monitor_ = ((DB2Connection)this.physicalConnection_).getDB2SystemMonitor();
                }
                catch (SQLException sQLException) {
                    if (!logger__.isLoggable(Level.FINER)) break block3;
                    DataLogger.logThrowable(logger__, sQLException);
                }
            }
        }
    }

    @Override
    protected PreparedStatementExecutionHandler getAutoGenStaticPrepStmt(SqlStatementKey sqlStatementKey, String string, Method method, Object ... objectArray) throws SQLException {
        ProfileSection profileSection;
        SQLJPreparedStatement sQLJPreparedStatement = null;
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        if ((this.getExecutionModeCEH() == 7 || this.getExecutionModeCEH() == 20) && (profileSection = this.getProfileSectionFromMap(sqlStatementKey, this.currentStates_)) != null) {
            boolean bl2;
            String string2;
            String string3 = profileSection.getAutoGenKeySql();
            boolean bl3 = null != string3 && StaticProfileConstants.isValueSet(string3);
            String string4 = string2 = sqlStatementKey.sqlStr_;
            int n2 = 2;
            boolean bl4 = sqlStatementKey.areAutoGenKeysRequested();
            SqlStatementType sqlStatementType = profileSection.getStatementType();
            if (bl4) {
                if (bl3) {
                    string4 = string3;
                    switch (sqlStatementType) {
                        case INSERT: {
                            n2 = 576;
                            break;
                        }
                        case UPDATE: {
                            n2 = 577;
                            break;
                        }
                        case DELETE: {
                            n2 = 578;
                            break;
                        }
                        case MERGE: {
                            n2 = 579;
                            break;
                        }
                        default: {
                            n2 = 577;
                            break;
                        }
                    }
                } else if (1 == sqlStatementKey.autoGenKeyIndicator_) {
                    if (SqlStatementType.INSERT == sqlStatementType) {
                        string4 = string2;
                        n2 = 1;
                    }
                } else {
                    return this.getStaticPreparedStmt(sqlStatementKey, string, method, new Object[0]);
                }
            }
            boolean bl5 = (bl2 = ((SQLJConnection)this.physicalConnection_).enableDuplicateStaticQueries()) || bl4;
            sQLJPreparedStatement = ((SQLJConnection)this.physicalConnection_).prepareSQLJStatement(string4, n2, (StaticProfileSection)profileSection, (SQLJColumnMetaData)profileSection.getParamMetaData(), (SQLJColumnMetaData)profileSection.getResultSetMetaData(), false, true, profileSection.getResutSetType(), profileSection.getResultSetConcurrency(), profileSection.getResultSetHoldability(), bl5 ? 1 : 0);
            if (sQLJPreparedStatement != null) {
                dB2PreparedStatementExecutionHandler = new DB2PreparedStatementExecutionHandler(this, (PreparedStatement)sQLJPreparedStatement, string2, 1003, 1007, this.physicalConnection_.getHoldability(), sqlStatementKey.autoGenKeyColNames_, sqlStatementKey.autoGenKeyColIndexes_, sqlStatementKey.autoGenKeyIndicator_, (StaticProfileSection)profileSection, string, method, objectArray);
                dB2PreparedStatementExecutionHandler.setDefStackTrcCaptured(true);
                dB2PreparedStatementExecutionHandler.setIsPStmtAPI(true);
            }
        }
        return dB2PreparedStatementExecutionHandler;
    }

    @Override
    public PreparedStatementExecutionHandler prepareStatementForAGKs(int n2, String string, Method method, Object ... objectArray) throws SQLException {
        this.checkAndSetReqInfo(this.getCurrentStates());
        return super.prepareStatementForAGKs(n2, string, method, objectArray);
    }

    @Override
    protected ExecutionHandler prepareStatement(String string, int n2, int n3, int n4, String string2, Method method, Object ... objectArray) throws SQLException {
        this.checkAndSetReqInfo(this.getCurrentStates());
        LiteralsInfo literalsInfo = null;
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        if (this.getSQLLiteralSubstitutionCEH() == 22 || this.getSQLLiteralSubstitutionCEH() == 24) {
            literalsInfo = LiteralsInfo.getLiteralsInfoForClientOptimizerRuntime(string, this);
        }
        String string3 = literalsInfo != null && literalsInfo.isLiteralSubstitutionAllowed() ? literalsInfo.getLiteralReplacedSql() : null;
        SqlStatementKey sqlStatementKey = null == string3 ? null : SqlStatementKey.generateStmtKey(string3, n2, n3, n4, null, null, 0, false);
        SqlStatementKey sqlStatementKey2 = SqlStatementKey.generateStmtKey(string, n2, n3, n4, null, null, 0, false);
        if ((this.getExecutionModeCEH() == 7 || this.getExecutionModeCEH() == 20) && this.getInputCaptureKeyCEH() != null) {
            Object object;
            if (literalsInfo != null && literalsInfo.isLiteralSubstitutionAllowed() && (dB2PreparedStatementExecutionHandler = this.getStaticPreparedStmt(sqlStatementKey, string2, method, objectArray)) != null) {
                this.validatePreparedStatement(dB2PreparedStatementExecutionHandler);
                object = dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement();
                if (literalsInfo.verifyAndSetActualLiteralsDataType((PreparedStatement)object, dB2PreparedStatementExecutionHandler)) {
                    dB2PreparedStatementExecutionHandler.setLiteralsInfo(literalsInfo);
                } else {
                    dB2PreparedStatementExecutionHandler.close();
                    dB2PreparedStatementExecutionHandler = null;
                }
            }
            if (null == dB2PreparedStatementExecutionHandler) {
                dB2PreparedStatementExecutionHandler = this.getStaticPreparedStmt(sqlStatementKey2, string2, method, objectArray);
            }
            this.currentStates_.getProfilerHelperInstance().checkForStaticPreparedStatementNotFound(sqlStatementKey, sqlStatementKey2, dB2PreparedStatementExecutionHandler);
            if (dB2PreparedStatementExecutionHandler != null) {
                return this.validatePreparedStatement(dB2PreparedStatementExecutionHandler);
            }
            object = null;
            object = this.checkIfWCOStmtOnAStaticSelect(string, n2, n3, n4, string2, method, objectArray);
            if (object != null) {
                return object;
            }
            if (this.getCaptureModeCEH() != 5) {
                literalsInfo = null;
            }
        }
        return this.validatePreparedStatement((DB2PreparedStatementExecutionHandler)super.prepareStatement(string, n2, n3, n4, literalsInfo, string2, method, objectArray));
    }

    private DB2PreparedStatementExecutionHandler checkIfWCOStmtOnAStaticSelect(String string, int n2, int n3, int n4, String string2, Method method, Object ... objectArray) throws SQLException {
        String string3;
        DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler;
        Matcher matcher;
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        if (StaticProfileConstants.isStatementOfType(string, SqlStatementType.UPDATE, SqlStatementType.DELETE) && (matcher = StaticProfileConstants.WCOPat_.matcher(string)).find() && (dB2ResultSetExecutionHandler = this.getRSHandlerForStaticCursor(string3 = matcher.group(2))) != null) {
            StaticProfileSection staticProfileSection = dB2ResultSetExecutionHandler.getUnderlyingPstmtExecHandler().getStaticSectionForThisStmt();
            PreparedStatement preparedStatement = this.getDynamicPosUpdateStmtForStaticCursor(string, staticProfileSection);
            dB2PreparedStatementExecutionHandler = new DB2PreparedStatementExecutionHandler(this, preparedStatement, string, n2, n3, n4, null, null, 0, null, string2, method, objectArray);
            dB2PreparedStatementExecutionHandler.setQueryIdOnCurrentRS(dB2ResultSetExecutionHandler);
        }
        return dB2PreparedStatementExecutionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getDbNameUserAndSchema() {
        DB2JdbcData dB2JdbcData = PDQConnectionCallbackImpl.threadLocalContext_.get();
        if (dB2JdbcData != null) {
            PDQConnectionCallbackImpl.threadLocalContext_.set(null);
        }
        try {
            ResultSet resultSet = null;
            Statement statement = null;
            try {
                DatabaseMetaData databaseMetaData = this.physicalConnection_.getMetaData();
                this.saveUserName(databaseMetaData.getUserName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement = this.physicalConnection_.createStatement();
                resultSet = statement.executeQuery("select current server, current schema from sysibm.sysdummy1");
                if (!resultSet.next()) return;
                this.saveDatabaseName(resultSet.getString(1));
                this.saveSchemaName(resultSet.getString(2));
                return;
            }
            catch (SQLException sQLException) {
                return;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
                resultSet = null;
                statement = null;
            }
        }
        finally {
            if (dB2JdbcData != null) {
                PDQConnectionCallbackImpl.threadLocalContext_.set(dB2JdbcData);
            }
        }
    }

    @Override
    protected StatementExecutionHandler prepareCall(String string, int n2, int n3, int n4, String string2, Method method, Object ... objectArray) throws SQLException {
        this.checkAndSetReqInfo(this.getCurrentStates());
        if ((this.getExecutionModeCEH() == 7 || this.getExecutionModeCEH() == 20) && this.getInputCaptureKeyCEH() != null) {
            SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(string, n2, n3, n4, null, null, 0, false);
            DB2CallableStatementExecutionHandler dB2CallableStatementExecutionHandler = this.getStaticCallableStmt(sqlStatementKey, string2, method, objectArray);
            this.currentStates_.getProfilerHelperInstance().checkForStaticPreparedStatementNotFound(null, sqlStatementKey, dB2CallableStatementExecutionHandler);
            if (dB2CallableStatementExecutionHandler != null) {
                return dB2CallableStatementExecutionHandler;
            }
        }
        return super.prepareCall(string, n2, n3, n4, string2, method, objectArray);
    }

    @Override
    protected void checkForNull(Connection connection, Object object) throws SQLException {
        if (this.hasPhysicalConnection_) {
            this.driverLogWriter_ = new PrintWriter(System.out, true);
            if (connection == null) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_INVALID_OPERATION_CONNECTION_NULL", new Object[0]), null, null, 10752);
            }
            if (object == null) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_INVALID_OPERATION_DATASOURCE_NULL", new Object[0]), null, null, 10748);
            }
            if (((DB2Connection)connection).getJccLogWriter() != null) {
                this.driverTraceOn_ = true;
                this.driverLogWriter_ = ((DB2Connection)connection).getJccLogWriter();
                TimeZone timeZone = TimeZone.getDefault();
                String string = "yyyy-MM-dd-HH:mm:ss.SSS";
                this.simpleDateFormat_ = new SimpleDateFormat(string);
                this.simpleDateFormat_.setTimeZone(timeZone);
                this.calendar_ = Calendar.getInstance(timeZone);
                this.driverLogWriter_.println(this.buildDriverTraceHeader(this, "initializeConstructor") + " [Thread:" + Thread.currentThread().getName() + "] " + DataLogger.getPmrStamp());
            }
        }
    }

    @Override
    protected String getPdqPropertiesForDataSource() {
        DB2BaseDataSource dB2BaseDataSource = (DB2BaseDataSource)this.baseDS_;
        return dB2BaseDataSource.getPdqProperties();
    }

    @Override
    public String getDataSourceName() {
        if (this.dsName_ != null) {
            return this.dsName_;
        }
        DB2BaseDataSource dB2BaseDataSource = (DB2BaseDataSource)this.baseDS_;
        if (dB2BaseDataSource != null) {
            this.dsName_ = dB2BaseDataSource.getDataSourceName();
            if (this.dsName_ != null) {
                return this.dsName_;
            }
        }
        if (this.hasPhysicalConnection_) {
            try {
                String string = this.physicalConnection_.getMetaData().getURL();
                if (string != null) {
                    Integer n2 = string.hashCode();
                    String string2 = dB2BaseDataSource.getPdqProperties();
                    Integer n3 = null == string2 ? 0 : string2.hashCode();
                    this.dsName_ = "dataSource@" + Integer.toHexString(n2) + "_" + Integer.toHexString(n3);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.dsName_ == null) {
            this.dsName_ = "dataSource@" + Integer.toHexString(System.identityHashCode(this.baseDS_));
        }
        return this.dsName_;
    }

    @Override
    public void logAccessResolution(ClassLoader classLoader, String string) {
        if (logger__.isLoggable(Level.FINE) && this.getCaptureModeCEH() == 5 && this.isAccessResolutionNotLoggedCEH()) {
            String string2 = Messages.getText("MSG_PROFILER_JCC_INITIAL_ACCESS_RESOLUTION", this.getAccessResolutionStringVal(((DB2BaseDataSource)this.baseDS_).getConcurrentAccessResolution()));
            logger__.logp(Level.FINE, DataLogger.getShortName(this), "ConnectionProxyHandler", string2);
            this.setIsAccessResolutionNotLoggedCEH(false);
            ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates = (ConnectionExecutionHandler.CachedResolvedStates)appClsLoaderToResolvedStatesMap_.getValueForClsLoaderAndDS(classLoader, string);
            if (cachedResolvedStates != null) {
                cachedResolvedStates.setAccessResolutionNotLoggedCRS(false);
            }
        }
    }

    private PreparedStatement getStaticPreparedStmtForSection(String string, StaticProfileSection staticProfileSection) throws SQLException {
        boolean bl2 = ((SQLJConnection)this.physicalConnection_).enableDuplicateStaticQueries();
        int n2 = 2;
        if (staticProfileSection.getPosUpdateCursorName() != null && staticProfileSection.getPosUpdateCursorName().length() > 0) {
            n2 = 6;
        } else if (staticProfileSection.isSingleRowResult()) {
            n2 = 8;
        }
        SQLJPreparedStatement sQLJPreparedStatement = ((SQLJConnection)this.physicalConnection_).prepareSQLJStatement(string, n2, staticProfileSection, (SQLJColumnMetaData)staticProfileSection.getParamMetaData(), (SQLJColumnMetaData)staticProfileSection.getResultSetMetaData(), false, false, staticProfileSection.getResutSetType(), staticProfileSection.getResultSetConcurrency(), staticProfileSection.getResultSetHoldability(), bl2 ? 1 : 0);
        if (n2 == 8) {
            sQLJPreparedStatement.setSQLJSingletonQuery(staticProfileSection.isSingleRowResult());
        }
        return sQLJPreparedStatement;
    }

    protected PreparedStatement getStaticPreparedStmtForSectionDB2ResultSet(String string, StaticProfileSection staticProfileSection) throws SQLException {
        return this.getStaticPreparedStmtForSection(string, staticProfileSection);
    }

    private DB2PreparedStatementExecutionHandler getStaticPreparedStmt(SqlStatementKey sqlStatementKey, String string, Method method, Object ... objectArray) throws SQLException {
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        StaticProfileSection staticProfileSection = (StaticProfileSection)this.getProfileSectionFromMap(sqlStatementKey, this.currentStates_);
        PreparedStatement preparedStatement = null;
        if (staticProfileSection != null && null != (preparedStatement = this.getStaticPreparedStmtForSection(sqlStatementKey.sqlStr_, staticProfileSection))) {
            String string2;
            dB2PreparedStatementExecutionHandler = new DB2PreparedStatementExecutionHandler(this, preparedStatement, sqlStatementKey.sqlStr_, preparedStatement.getResultSetType(), preparedStatement.getResultSetConcurrency(), preparedStatement.getResultSetHoldability(), null, null, 0, staticProfileSection, string, method, objectArray);
            SqlStatementType sqlStatementType = staticProfileSection.getStatementType();
            if (sqlStatementType.equals((Object)SqlStatementType.QUERY)) {
                dB2PreparedStatementExecutionHandler.setStmtKey(sqlStatementKey);
            }
            dB2PreparedStatementExecutionHandler.setCurrentSqlType(sqlStatementType);
            if (this.isPropertyRefreshEnabledCEH() && (sqlStatementType.equals((Object)SqlStatementType.UPDATE) || sqlStatementType.equals((Object)SqlStatementType.DELETE)) && (string2 = staticProfileSection.getPosUpdateCursorName()) != null && string2.length() > 0) {
                dB2PreparedStatementExecutionHandler.isWcoWithPropertiesRefresh_ = true;
                dB2PreparedStatementExecutionHandler.posUpdateCursorName_ = string2;
            }
            dB2PreparedStatementExecutionHandler.setDefStackTrcCaptured(true);
            dB2PreparedStatementExecutionHandler.setIsPStmtAPI(true);
        }
        return dB2PreparedStatementExecutionHandler;
    }

    private PreparedStatement getDynamicPosUpdateStmtForStaticCursor(String string, StaticProfileSection staticProfileSection) throws SQLException {
        boolean bl2 = ((SQLJConnection)this.physicalConnection_).enableDuplicateStaticQueries();
        StaticProfileSection staticProfileSection2 = null;
        try {
            staticProfileSection2 = (StaticProfileSection)staticProfileSection.clone();
            staticProfileSection2.setIsStatic(false);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_GENERAL_ERROR", new Object[0]), null, cloneNotSupportedException, 10502);
        }
        String string2 = staticProfileSection2.getCursorName();
        staticProfileSection2.setCursorName(null);
        staticProfileSection2.setPosUpdateCursorName(string2);
        staticProfileSection2.setSectionNumber(staticProfileSection.getForUpdateSection());
        int n2 = 0;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) != '?') continue;
            ++n2;
        }
        SQLJColumnMetaData sQLJColumnMetaData = n2 > 0 ? new SQLJColumnMetaData(n2) : null;
        return ((SQLJConnection)this.physicalConnection_).prepareSQLJStatement(string, 6, staticProfileSection2, sQLJColumnMetaData, null, true, false, 1003, 1007, 1, bl2 ? 1 : 0);
    }

    protected PreparedStatement getDynamicPosUpdateStmtForStaticCursorDB2ResultSet(String string, StaticProfileSection staticProfileSection) throws SQLException {
        return this.getDynamicPosUpdateStmtForStaticCursor(string, staticProfileSection);
    }

    private DB2CallableStatementExecutionHandler getStaticCallableStmt(SqlStatementKey sqlStatementKey, String string, Method method, Object ... objectArray) throws SQLException {
        StaticProfileSection staticProfileSection = (StaticProfileSection)this.getProfileSectionFromMap(sqlStatementKey, this.currentStates_);
        DB2CallableStatementExecutionHandler dB2CallableStatementExecutionHandler = null;
        CallableStatement callableStatement = null;
        if (staticProfileSection != null && null != (callableStatement = this.getStaticCallableStmtForSection(sqlStatementKey.sqlStr_, staticProfileSection))) {
            dB2CallableStatementExecutionHandler = new DB2CallableStatementExecutionHandler(this, callableStatement, sqlStatementKey.sqlStr_, callableStatement.getResultSetType(), callableStatement.getResultSetConcurrency(), callableStatement.getResultSetHoldability(), staticProfileSection, string, method, objectArray);
            dB2CallableStatementExecutionHandler.setDefStackTrcCaptured(true);
            dB2CallableStatementExecutionHandler.setIsPStmtAPI(true);
        }
        return dB2CallableStatementExecutionHandler;
    }

    private CallableStatement getStaticCallableStmtForSection(String string, StaticProfileSection staticProfileSection) throws SQLException {
        boolean bl2 = ((SQLJConnection)this.physicalConnection_).enableDuplicateStaticQueries();
        StaticProfileSection staticProfileSection2 = staticProfileSection;
        string = " " + string;
        SQLJCallableStatement sQLJCallableStatement = ((SQLJConnection)this.physicalConnection_).prepareSQLJCall(string, 4, staticProfileSection2, (SQLJColumnMetaData)staticProfileSection2.getParamMetaData(), (SQLJColumnMetaData)staticProfileSection2.getResultSetMetaData(), false, false, staticProfileSection.getResutSetType(), staticProfileSection.getResultSetConcurrency(), staticProfileSection.getResultSetHoldability(), bl2 ? 1 : 0);
        return sQLJCallableStatement;
    }

    @Override
    protected PreparedStatementExecutionHandler getPrepStmtForThisStmt(String string, int n2, int n3, int n4, String string2, boolean bl2, ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates, String string3, Method method, Object ... objectArray) throws SQLException {
        Object object;
        this.checkAndSetReqInfo(cachedResolvedStates);
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = null;
        LiteralsInfo literalsInfo = null;
        if (!(cachedResolvedStates.getSqlLiteralSubstition() != 22 && cachedResolvedStates.getSqlLiteralSubstition() != 24 || bl2)) {
            literalsInfo = LiteralsInfo.getLiteralsInfoForClientOptimizerRuntime(string, this);
        }
        String string4 = literalsInfo != null && literalsInfo.isLiteralSubstitutionAllowed() ? literalsInfo.getLiteralReplacedSql() : null;
        SqlStatementKey sqlStatementKey = null == string4 ? null : SqlStatementKey.generateStmtKey(string4, n2, n3, n4, null, null, 0, false);
        SqlStatementKey sqlStatementKey2 = SqlStatementKey.generateStmtKey(string, n2, n3, n4, null, null, 0, false);
        if ((cachedResolvedStates.getExecutionMode() == 7 || cachedResolvedStates.getExecutionMode() == 20) && cachedResolvedStates.getInputCaptureKey() != null) {
            if (literalsInfo != null && literalsInfo.isLiteralSubstitutionAllowed() && (dB2PreparedStatementExecutionHandler = this.getStaticPreparedStmt(sqlStatementKey, string3, method, new Object[0])) != null) {
                object = dB2PreparedStatementExecutionHandler.getUnderlyingPreparedStatement();
                if (literalsInfo.verifyAndSetActualLiteralsDataType((PreparedStatement)object, dB2PreparedStatementExecutionHandler)) {
                    dB2PreparedStatementExecutionHandler.setLiteralsInfo(literalsInfo);
                } else {
                    dB2PreparedStatementExecutionHandler.close();
                    dB2PreparedStatementExecutionHandler = null;
                }
            }
            if (null == dB2PreparedStatementExecutionHandler) {
                dB2PreparedStatementExecutionHandler = this.getStaticPreparedStmt(sqlStatementKey2, string3, method, objectArray);
            }
            this.currentStates_.getProfilerHelperInstance().checkForStaticPreparedStatementNotFound(sqlStatementKey, sqlStatementKey2, dB2PreparedStatementExecutionHandler);
            if (dB2PreparedStatementExecutionHandler != null) {
                return this.validatePreparedStatement(dB2PreparedStatementExecutionHandler);
            }
            if (cachedResolvedStates.getCaptureMode() != 5) {
                literalsInfo = null;
            }
        }
        object = (DB2PreparedStatementExecutionHandler)super.getPrepStmtForThisStmt(string, n2, n3, n4, string2, literalsInfo, cachedResolvedStates, string3, method, objectArray);
        return this.validatePreparedStatement((DB2PreparedStatementExecutionHandler)object);
    }

    @Override
    protected ProfileSection getProfileSectionFromMap(SqlStatementKey sqlStatementKey, ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates) throws SQLException {
        Object v2;
        StaticProfileSection staticProfileSection = null;
        HashMap hashMap = (HashMap)cachedResolvedStates.getProfilerHelperInstance().getStmtDescriptorMap();
        if (hashMap != null && (v2 = hashMap.get(sqlStatementKey)) != null) {
            try {
                staticProfileSection = (StaticProfileSection)((StaticProfileSection)v2).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_GENERAL_ERROR", new Object[0]), null, cloneNotSupportedException, 10478);
            }
            String string = null;
            string = staticProfileSection.isForceSingleBindIsolation() ? staticProfileSection.getStaticProfilePackage().getRootPkgName() : staticProfileSection.getStaticProfilePackage().getRootPkgName() + SQLJPackage.getPackageIsolationNumber(this.physicalConnection_.getTransactionIsolation());
            staticProfileSection.getStaticProfilePackage().setPackageName(string);
        }
        return staticProfileSection;
    }

    @Override
    public String getDatabaseName() {
        if (this.hasPhysicalConnection_) {
            try {
                return ((SQLJConnection)this.physicalConnection_).getDatabaseName();
            }
            catch (SQLException sQLException) {
            }
        } else if (this.connInfo_ != null) {
            return this.connInfo_.databaseName_;
        }
        return null;
    }

    @Override
    public String getIpName() {
        return ((DB2BaseDataSource)this.baseDS_).getServerName();
    }

    @Override
    public int getPort() {
        return ((DB2BaseDataSource)this.baseDS_).getPortNumber();
    }

    @Override
    public String getConnectionSchema() throws SQLException {
        String string = ((DB2BaseDataSource)this.baseDS_).getCurrentSchema();
        if (string != null) {
            return string;
        }
        return super.getConnectionSchema();
    }

    @Override
    protected ExecutionHandler createStatement(String string, Method method, Object ... objectArray) throws SQLException {
        return new DB2StatementExecutionHandler(this, this.physicalConnection_.createStatement(), 1003, 1007, this.physicalConnection_.getHoldability(), null, null, 0, string, method, objectArray);
    }

    @Override
    protected ExecutionHandler createStatement(int n2, int n3, String string, Method method, Object ... objectArray) throws SQLException {
        return new DB2StatementExecutionHandler(this, this.physicalConnection_.createStatement(n2, n3), n2, n3, this.physicalConnection_.getHoldability(), null, null, 0, string, method, objectArray);
    }

    @Override
    protected ExecutionHandler createStatement(int n2, int n3, int n4, String string, Method method, Object ... objectArray) throws SQLException {
        return new DB2StatementExecutionHandler(this, this.physicalConnection_.createStatement(n2, n3, n4), n2, n3, n4, null, null, 0, string, method, objectArray);
    }

    @Override
    protected PreparedStatementExecutionHandler wrapPreparedStatementAndInitialize(PreparedStatement preparedStatement, String string, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, String string2, Method method, Object ... objectArray) throws SQLException {
        DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler = new DB2PreparedStatementExecutionHandler(this, preparedStatement, string, n2, n3, n4, stringArray, nArray, n5, null, string2, method, objectArray);
        return dB2PreparedStatementExecutionHandler;
    }

    @Override
    protected StatementExecutionHandler wrapCallableStatementAndInitialize(CallableStatement callableStatement, String string, int n2, int n3, int n4, String string2, Method method, Object ... objectArray) throws SQLException {
        DB2CallableStatementExecutionHandler dB2CallableStatementExecutionHandler = new DB2CallableStatementExecutionHandler(this, callableStatement, string, n2, n3, n4, null, string2, method, objectArray);
        return dB2CallableStatementExecutionHandler;
    }

    @Override
    protected void close() throws SQLException {
        this.staticCursorPositionUpdateMap_.clear();
        this.getCursorNameToSelectStmtMap().clear();
        super.close();
    }

    @Override
    public StaticProfileCaptureHelper createCaptureHelper() throws SQLException {
        return new DB2StaticProfileCaptureHelper(this);
    }

    @Override
    protected boolean checkIfPQStaticAndCallbackRegistered() {
        DB2JdbcData dB2JdbcData;
        boolean bl2 = false;
        if (PDQConnectionCallbackImpl.threadLocalContext_ != null && (dB2JdbcData = PDQConnectionCallbackImpl.threadLocalContext_.get()) != null && dB2JdbcData.isStaticExecution_) {
            bl2 = true;
        }
        return bl2;
    }

    @Override
    protected PreparedStatement prepareStatement_(String string, int n2, int n3, int n4) throws SQLException {
        PreparedStatement preparedStatement = this.physicalConnection_.prepareStatement(string, n2, n3, n4);
        return preparedStatement;
    }

    @Override
    protected CallableStatement prepareCall_(String string, int n2, int n3, int n4) throws SQLException {
        return this.physicalConnection_.prepareCall(string, n2, n3, n4);
    }

    @Override
    public boolean isAtomicMRIPropertySetToYES() {
        return 1 == ((DB2BaseDataSource)this.baseDS_).getAtomicMultiRowInsert();
    }

    public boolean getDeferPreparesProperty() {
        return ((DB2BaseDataSource)this.baseDS_).getDeferPrepares();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndSetReqInfo(ConnectionExecutionHandler.CachedResolvedStates cachedResolvedStates) throws SQLException {
        if (cachedResolvedStates.getProfilerHelperInstance() != null) {
            if (!(cachedResolvedStates.getProfilerHelperInstance().isDbNameSet() && cachedResolvedStates.getProfilerHelperInstance().isSchemaNameSet() && cachedResolvedStates.getProfilerHelperInstance().isUserNameSet() || cachedResolvedStates.getCaptureMode() != 5 || cachedResolvedStates.getExecutionMode() != 8)) {
                StaticProfileCaptureHelper staticProfileCaptureHelper = cachedResolvedStates.getProfilerHelperInstance();
                synchronized (staticProfileCaptureHelper) {
                    if (!(cachedResolvedStates.getProfilerHelperInstance().isDbNameSet() && cachedResolvedStates.getProfilerHelperInstance().isSchemaNameSet() && cachedResolvedStates.getProfilerHelperInstance().isUserNameSet())) {
                        this.getDbNameUserAndSchema();
                        cachedResolvedStates.getProfilerHelperInstance().setDbAndSchemaNameAndUserName(this.getSavedDatabaseName(), this.getSavedSchemaName(), this.getSavedUserName());
                    }
                }
            }
            if ((cachedResolvedStates.getExecutionMode() == 7 || cachedResolvedStates.getExecutionMode() == 20) && this.deferInitRuntimeMap_) {
                StaticProfileCaptureHelper staticProfileCaptureHelper = cachedResolvedStates.getProfilerHelperInstance();
                synchronized (staticProfileCaptureHelper) {
                    if (this.deferInitRuntimeMap_) {
                        this.getDbNameUserAndSchema();
                        cachedResolvedStates.getProfilerHelperInstance().initRuntimeMapForStaticExecution(this);
                        this.deferInitRuntimeMap_ = false;
                    }
                }
            }
        }
    }

    public boolean byteArrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null) {
            return false;
        }
        if (byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i10 = 0; i10 < byArray.length; ++i10) {
            if (byArray[i10] == byArray2[i10]) continue;
            return false;
        }
        return true;
    }

    private DB2ResultSetExecutionHandler getRSHandlerForStaticCursor(String string) {
        Iterator<WeakReference<ResultSetExecutionHandler>> iterator;
        DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = null;
        List<WeakReference<ResultSetExecutionHandler>> list = this.staticCursorPositionUpdateMap_.getAllRSProxiesForCursor(string);
        if (list != null && (iterator = list.iterator()) != null) {
            while (iterator.hasNext()) {
                WeakReference<ResultSetExecutionHandler> weakReference = iterator.next();
                DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler2 = (DB2ResultSetExecutionHandler)weakReference.get();
                if (null == dB2ResultSetExecutionHandler2 || !dB2ResultSetExecutionHandler2.isCurrentForPositionUpdate()) continue;
                dB2ResultSetExecutionHandler = dB2ResultSetExecutionHandler2;
                break;
            }
        }
        return dB2ResultSetExecutionHandler;
    }

    public DB2PreparedStatementExecutionHandler validatePreparedStatement(DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler) throws SQLException {
        if (dB2PreparedStatementExecutionHandler == null) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        if (dB2PreparedStatementExecutionHandler.isWcoWithPropertiesRefresh_) {
            boolean bl2;
            StatementExecutionHandler statementExecutionHandler = null;
            DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler2 = null;
            DB2PreparedStatementExecutionHandler dB2PreparedStatementExecutionHandler3 = dB2PreparedStatementExecutionHandler;
            DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = this.getRSHandlerForStaticCursor(dB2PreparedStatementExecutionHandler.posUpdateCursorName_);
            boolean bl3 = bl2 = dB2ResultSetExecutionHandler != null;
            if (bl2) {
                StatementExecutionHandler statementExecutionHandler2 = dB2ResultSetExecutionHandler.parent_;
                statementExecutionHandler = null;
                statementExecutionHandler = statementExecutionHandler2.prepStmtHandle_ != null ? (StatementExecutionHandler)((Object)statementExecutionHandler2.prepStmtHandle_) : statementExecutionHandler2;
                dB2PreparedStatementExecutionHandler2 = (DB2PreparedStatementExecutionHandler)statementExecutionHandler;
                if (!dB2PreparedStatementExecutionHandler3.isStaticStmt()) {
                    if (logger__.isLoggable(Level.FINER)) {
                        DataLogger.logAtLevelFiner(logger__, dB2PreparedStatementExecutionHandler3, "validatePreparedStatement", "select for update is static(" + DataLogger.getShortName(statementExecutionHandler) + ") and (this) WCO is dynamic");
                    }
                    preparedStatement = this.getDynamicPosUpdateStmtForStaticCursor(dB2PreparedStatementExecutionHandler3.getSqlString(), dB2PreparedStatementExecutionHandler2.getStaticSectionForThisStmt());
                    dB2PreparedStatementExecutionHandler3.setPhysicalPreparedStatement(preparedStatement);
                    dB2PreparedStatementExecutionHandler3.setQueryIdOnCurrentRS(dB2ResultSetExecutionHandler);
                    return dB2PreparedStatementExecutionHandler;
                }
                SQLJPackage sQLJPackage = dB2PreparedStatementExecutionHandler2.getStaticSectionForThisStmt().getPackage();
                SQLJPackage sQLJPackage2 = dB2PreparedStatementExecutionHandler3.getStaticSectionForThisStmt().getPackage();
                if (sQLJPackage.getPackageName().equals(sQLJPackage2.getPackageName()) && sQLJPackage.getCollectionName().equals(sQLJPackage2.getCollectionName()) && this.byteArrayEquals(sQLJPackage.getConsistencyToken(), sQLJPackage2.getConsistencyToken())) {
                    if (logger__.isLoggable(Level.FINER)) {
                        DataLogger.logAtLevelFiner(logger__, dB2PreparedStatementExecutionHandler3, "validatePreparedStatement", "Both select for update (" + DataLogger.getShortName(statementExecutionHandler) + ") and WCO are static and valid");
                    }
                    return dB2PreparedStatementExecutionHandler;
                }
                if (logger__.isLoggable(Level.FINER)) {
                    DataLogger.logAtLevelFiner(logger__, dB2PreparedStatementExecutionHandler3, "validatePreparedStatement", "Both select for update (" + DataLogger.getShortName(statementExecutionHandler) + ") and WCO are static but WCO has wrong package / collection name / con token");
                }
                preparedStatement = this.getDynamicPosUpdateStmtForStaticCursor(dB2PreparedStatementExecutionHandler3.getSqlString(), dB2PreparedStatementExecutionHandler2.getStaticSectionForThisStmt());
                dB2PreparedStatementExecutionHandler3.setPhysicalPreparedStatement(preparedStatement);
                return dB2PreparedStatementExecutionHandler;
            }
            if (dB2PreparedStatementExecutionHandler3.isStaticStmt()) {
                if (logger__.isLoggable(Level.FINER)) {
                    DataLogger.logAtLevelFiner(logger__, dB2PreparedStatementExecutionHandler3, "validatePreparedStatement", "Select for update is dynamic and WCO is static");
                }
                preparedStatement = this.getPhysicalConnection().prepareStatement(dB2PreparedStatementExecutionHandler3.getSqlString());
                dB2PreparedStatementExecutionHandler3.setPhysicalPreparedStatement(preparedStatement);
                return dB2PreparedStatementExecutionHandler;
            }
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, dB2PreparedStatementExecutionHandler3, "validatePreparedStatement", "Both select for update and WCO are dynamic and valid");
            }
            return dB2PreparedStatementExecutionHandler;
        }
        return dB2PreparedStatementExecutionHandler;
    }

    protected void systemMonitorStart() {
        block3: {
            this.setSystemMonitor();
            if (this.monitor_ == null || this.isNewStmts()) {
                return;
            }
            try {
                this.monitor_.enable(true);
                this.isMonitorEnabled_ = true;
                this.monitor_.start(1);
            }
            catch (SQLException sQLException) {
                if (!logger__.isLoggable(Level.FINER)) break block3;
                DataLogger.logThrowable(logger__, sQLException);
            }
        }
    }

    protected void systemMonitorStop() {
        if (this.monitor_ == null) {
            return;
        }
        try {
            if (this.isMonitorEnabled_) {
                this.monitor_.stop();
            }
        }
        catch (SQLException sQLException) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logThrowable(logger__, sQLException);
            }
        }
        finally {
            this.isMonitorEnabled_ = false;
        }
    }

    protected long getElapsedTime() {
        if (this.monitor_ == null) {
            return 0L;
        }
        try {
            return this.monitor_.getServerTimeMicros();
        }
        catch (SQLException sQLException) {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logThrowable(logger__, sQLException);
            }
            return 0L;
        }
    }

    public CursorNameToResultSetMap getCursorNameToResultSetMap() {
        return this.staticCursorPositionUpdateMap_;
    }

    private static Method getMethodForClass(Class<?> clazz, String string, Class<?> ... classArray) throws PrivilegedActionException, SecurityException, NoSuchMethodException {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(DB2ConnectionExecutionHandler.getMethodForClassPrivilegedAction(clazz, string, classArray));
        }
        return DB2ConnectionExecutionHandler.getMethodForClassNoSM(clazz, string, classArray);
    }

    private static final PrivilegedExceptionAction<Method> getMethodForClassPrivilegedAction(final Class<?> clazz, final String string, final Class<?> ... classArray) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return DB2ConnectionExecutionHandler.getMethodForClassNoSM(clazz, string, classArray);
            }
        };
    }

    static Method getMethodForClassNoSM(Class<?> clazz, String string, Class<?> ... classArray) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    public class CursorNameToResultSetMap {
        private Map<String, ArrayList<WeakReference<ResultSetExecutionHandler>>> cursorNameTable = new HashMap<String, ArrayList<WeakReference<ResultSetExecutionHandler>>>();

        public void clear() {
            this.cursorNameTable.clear();
        }

        public List<WeakReference<ResultSetExecutionHandler>> getAllRSProxiesForCursor(String string) {
            return this.cursorNameTable.get(string);
        }

        public void putRSProxyForCursor(String string, ResultSetExecutionHandler resultSetExecutionHandler) {
            ArrayList<WeakReference<ResultSetExecutionHandler>> arrayList = this.cursorNameTable.get(string);
            arrayList = arrayList == null ? new ArrayList<WeakReference<ResultSetExecutionHandler>>() : arrayList;
            arrayList.add(new WeakReference<ResultSetExecutionHandler>(resultSetExecutionHandler));
            this.cursorNameTable.put(string, arrayList);
        }

        public void removeRSProxyForCursor(String string, ResultSetExecutionHandler resultSetExecutionHandler) {
            Iterator iterator;
            List list = this.cursorNameTable.get(string);
            if (list != null && (iterator = list.iterator()) != null) {
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = (DB2ResultSetExecutionHandler)weakReference.get();
                    if (null == dB2ResultSetExecutionHandler) {
                        iterator.remove();
                        continue;
                    }
                    if (!dB2ResultSetExecutionHandler.equals(resultSetExecutionHandler)) continue;
                    iterator.remove();
                    break;
                }
                if (list.isEmpty()) {
                    this.cursorNameTable.remove(string);
                }
            }
        }

        public void removeClosedResultSetExecutionHandlers() {
            Iterator<String> iterator;
            Method method = DB2ConnectionExecutionHandler.getMethod_DB2ResultSet_isClosed();
            if (null != method && null != (iterator = this.cursorNameTable.keySet().iterator())) {
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    List list = this.cursorNameTable.get(string);
                    if (list == null) continue;
                    Iterator iterator2 = list.iterator();
                    if (iterator2 != null) {
                        while (iterator2.hasNext()) {
                            WeakReference weakReference = (WeakReference)iterator2.next();
                            DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = (DB2ResultSetExecutionHandler)weakReference.get();
                            if (null == dB2ResultSetExecutionHandler) {
                                iterator2.remove();
                                continue;
                            }
                            ResultSet resultSet = (ResultSet)dB2ResultSetExecutionHandler.getUnderlyingObject();
                            Boolean bl2 = false;
                            try {
                                bl2 = (Boolean)method.invoke((Object)resultSet, new Object[0]);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                            if (!bl2.booleanValue()) continue;
                            iterator2.remove();
                        }
                    }
                    if (!list.isEmpty()) continue;
                    iterator.remove();
                }
            }
        }
    }
}

